/*
 *  Global definitions for ivd2dvi.  Copyright 1988 by Larry Denenberg.
 *  May be freely distributed as long as this notice is retained.
 */

#define TRUE		  1
#define FALSE		  0


/*
 *  Buffer sizing and allocation is explained in io.c.
 */
#define BUFDEFAULTSIZE 1024
#define SMALLBUFDIVISOR	 16
#define MAXFILENAMESIZE 256
#define TFMAREADEFAULT	"/usr/local/lib/tex/fonts"


/*
 *  Values of /State/;  see the overview in ivd2dvi.c.
 */
#define LTYPESETTING	  0
#define RTYPESETTING	  1
#define SIMULATING	  2


/*
 *  Allocate an object of type T or a sequence of N such objects.
 */
#define OBJALLOC(T)	((T *) malloc(sizeof(T)))
#define SEQALLOC(N,T)	((T *) calloc((unsigned) N, sizeof(T)))


/*
 *  Library routines declared to avoid lint errors.
 */
extern char *calloc(), *malloc(), *rindex(), *index(), *getenv();
extern void exit();


/*
 *  Useful types.  If your compiler doesn't recognize unsigned char,
 *  you'll have to find another one-byte unsigned integer.
 */
typedef unsigned char unsigned_byte;
typedef short boolean;


/*
 *  Structure for font information.  Note that /charwidths/ is a table
 *  of length ec-bc+1 giving the width of each character;  each entry
 *  in this table is an index into the /widths/ table where the widths
 *  really reside.  Further information is in the file auxiliary.c.
 */
typedef struct font {
  long number;			/*  font number in the DVI file		*/
  char *area, *name;		/*  strings naming the associated file 	*/
  long checksum, scalefactor;   /*  you figure this one out		*/
  boolean loaded;		/*  TRUE iff we've read the TFM file	*/
  int nw;			/*  number of distinct widths		*/
  long *widths;			/*  the distinct widths 		*/
  int bc, ec;			/*  beginning and ending char numbers	*/
  unsigned_byte *charwidths;	/*  widths of the individual characters	*/
  struct font *nextfont;	/*  pointer to the next font		*/
} font;
