#include "mf2ps1.h"
#include "mf2ps2.h"


function ok (x,y : real):boolean;
{ gives back true if direction is kept by x,y values }
begin
   if direction = 'h' then 
      if x = lastx3 then ok := true
                    else ok := false
   else if direction = 'v' then
      if y = lasty3 then ok := true
                    else ok := false
        else ok := false;
end;

procedure restore (x,y : real);
{ keeps direction if deals with lines, and last point values
  for optimization on vertical and horizontal lines.            }
begin
   if x = lastx3 then direction := 'h'
   else if y = lasty3 then direction := 'v'
   else direction := 'm';
   lastx3 := x;
   lasty3 := y;
   lastwasline := true;
end;

procedure recall;
{ taking values from the buffer.             }
const WORTH = 100;
begin
   if ((lastx3-prevtox3 < WORTH) or (lasty3-prevtoy3 < WORTH)) and
      (prevtox3 <> -9999) and (prevtoy3 <> -9999) then
      writeln(psfile, ' ', lastx3-prevtox3:3:0, ' ', lasty3-prevtoy3:3:0, ' l@')
   else
      writeln(psfile,' ', lastx3:3:0,' ',lasty3:3:0,' L@');
   lastwasline := false;
   prevtox3 := lastx3;
   prevtoy3 := lasty3;
end;


function us(n: scaled;c:char): real;
{ gets a number which every unit of it is 2 in the 16 power
  and changes it to normal units.
  in addition scales and transforms the number in order to
  use it in PostScript dictionary.
  it is also determining the bounding box.                  }
const s =     2; { Scale & Translate before sending to PostScript file }
      t =   180;
var   tmp : real;
begin
   tmp := trunc(n/65536)*s+t; 
   us := tmp;
   if (c = 'x') and (tmp <> t) then 
   begin
		   if tmp>maxbox[x] then maxbox[x] := tmp
	      else if tmp<minbox[x] then minbox[x] := tmp;
		   if tmp>lmax_x then lmax_x := tmp
  	      else if tmp<lmin_x then lmin_x := tmp;
   end      
   else            if tmp>maxbox[y] then maxbox[y] := tmp
	      else if tmp<minbox[y] then minbox[y] := tmp;
end; { unscaled }


procedure send_p_s;
{ creates the PostScript file, by sending lines and curves, 
  using the optimization ability on lines.                 }
const WORTH=100;

var x0_,x1_,x2_,x3_,y0_,y1_,y2_,y3_:real;
begin
   x0_ := us(x0,'x');
   x1_ := us(x1,'x');
   x2_ := us(x2,'x');
   x3_ := us(x3,'x');
   y0_ := us(y0,'y');
   y1_ := us(y1,'y');
   y2_ := us(y2,'y');
   y3_ := us(y3,'y');

   if (x0_<>lastx0) or (y0_<>lasty0) then
   begin
       if new then 
       begin
          writeln(psfile,' ', x0_:3:0,' ',y0_:3:0,' M@');
          new := false;
	  lastwasline := false;
	  prevtox3 := x0_;
	  prevtoy3 := y0_;
	  lastx3 := x0_; lasty3 := y0_;
       end
       else begin
	  if (lastwasline) and (not ok(x0_,y0_)) then 
	  begin
	     recall;
          end;
          restore(x0_,y0_);
       end;
   end;
   if (x3=0) and (x2=0) and (y3=0) and (y2=0) then  { line }
   begin
      if (x0_<>x1_) or (y0_<>y1_) then 
      begin
	  if (lastwasline) and (not ok(x1_,y1_)) then 
	  begin
	     recall;
          end;
	  restore(x1_,y1_);
      end;
      lastx0 := x1_;  lasty0 := y1_;
   end
   else begin
      if ((x0_=x1_) and (x1_=x2_) and (x2_=x3_)) or 
    	 ((y0_=y1_) and (y1_=y2_) and (y2_=y3_)) then 
      begin
         if (x0_<>x3_) or (y0_<>y3_) then
	 begin
	    if (lastwasline) and (not ok(x3_,y3_)) then 
	    begin
	       recall;
            end;
	    restore(x3_,y3_);
         end;
      end
      else begin
	 if lastwasline then recall;
	 if ((x1_-lastx3<WORTH) or (x2_-lastx3<WORTH) or (x3_-lastx3<WORTH) or (y1_-lasty3<WORTH) or (y2_-lasty3<WORTH) or (y3_-lasty3<WORTH)) and 
	 (prevtox3 <> -9999) and (prevtoy3 <> -9999) then
	    writeln(psfile,' ', x1_-lastx3:3:0,' ',y1_-lasty3:3:0,' ',x2_-lastx3:3:0,' ',y2_-lasty3:3:0,' ',x3_-lastx3:3:0,' ',y3_-lasty3:3:0,' c@')
	 else
	    writeln(psfile,' ', x1_:3:0,' ',y1_:3:0,' ',x2_:3:0,' ',y2_:3:0,' ',x3_:3:0,' ',y3_:3:0,' C@');
         prevtox3 := x3_;
	 prevtoy3 := y3_;
	 lastx3 := x3_; lasty3 := y3_;
      end;
      lastx0 := x3_;  lasty0 := y3_;
   end; { else curve }
end; { send_p_s }
 

