---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              tableau de variation, TikZ, PSTricks
---

# Comment tracer un tableau de variation ?

## Avec les commandes de base

Pour un tableau simple, l'environnement `array` du mode mathématique standard
de LaTeX peut donner une réponse appropriée. En voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
$
\begin{array}{|c|ccccr|}
  \hline
  x     & -\infty &         & 0  &         & +\infty    \\ \hline
  f'(x) & 5       & +       & 0  & -       & -10        \\ \hline
        &         &         & 10 &         &            \\ % ligne des "max"
  f(x)  &         &\nearrow &    &\searrow & \\ % flèches
        & -\infty &         &    &         & -10        \\ % ligne des "min"
  \hline
\end{array}
$
\end{document}
```

Les flèches sont nommées d'après les points cardinaux : `\nearrow` désigne 
la direction *north-east*, `\searrow` *south-east* :

| Commande   | Résultat   |
| ---------- | ---------- |
| `\nearrow` | $\nearrow$ |
| `\searrow` | $\searrow$ |
| `\nwarrow` | $\nwarrow$ |
| `\swarrow` | $\swarrow$ |

De plus jolies flèches (redimensonnables) peuvent être obtenues
avec les commandes graphiques, mais le code est moins lisible.
Pour cela, il faut choisir une unité de longueur avant par exemple 

```{noedit}
\unitlength=1cm
```

Il faut ensuite remplacer par exemple `nearrow` par des flèches de 2cm
de large et de haut, comme dans cet exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\unitlength=1cm
$
\begin{array}{|c|ccccr|}
  \hline
  x     & -\infty &    & 0  &    & +\infty \\ \hline
  f'(x) & 5       & +  & 0  & -  & -10     \\ \hline
        &         &    & 10 &    &         \\ % ligne des valeurs "max"
  f(x) & &
  \begin{minipage}{1cm}
    \begin{picture}(1,1)
      \put(0,0){\vector(1,1){1}}
    \end{picture}
  \end{minipage}
  & &
  \begin{minipage}{1cm}
    \begin{picture}(1,1)
      \put(0,1){\vector(1,-1){1}}
    \end{picture}
  \end{minipage}
  & \\                                        % flèches
  & -\infty &    &    &    & -10           \\ % ligne des valeurs "min"
  \hline
\end{array}
$
\end{document}
```


## Avec l'extension <ctanpkg:tkz-tab>

La méthode actuellement conseillée utilise l'extension <ctanpkg:tkz-tab>, 
écrite par Alain Matthes et basée sur Ti*k*Z, pour composer tableaux de signes
et tableaux de variations. La richesse de sa syntaxe permet 
toutes les fantaisies (utilisation de la couleur, par exemple) 
et sa [documentation](texdoc:tkz-tab), très complète, est écrite en français.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tkz-tab}

\begin{document}
\begin{tikzpicture}
  \tikzset{h style/.style = {pattern=north west lines}}
  \tkzTabInit[lgt=1,espcl=2]{$x$ /1,  $f$ /2}{$0$,$1$,$2$,$3$}%
  \tkzTabVar{+/ $1$  / , -CH/ $-2$ / , +C/  $5$, -/ $0$  /  }
\end{tikzpicture}
\end{document}
```


## Avec l'extension <ctanpkg:tableaux>

L'extension <ctanpkg:tableaux>, de Nicolas Kisselhoff, permet également 
d'effectuer des mises en page grâce à [PSTricks](ctanpkg:pstricks). 
Par exemple :

```{noedit}
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{ifthen,minimum,tableau}

  \newpsstyle{hachured}
             {fillstyle=hlines,
              hatchwidth=0.2pt,
              hatchsep=2pt}

\begin{document}
\setlength{\TabTitreL}{1cm}
\begin{MonTableau}{1}{9}{1.5}
  \psframe[style=hachured, linestyle=none](.3,1)(.45,0)

  \TabNewCol{0}
  \rTabPut{Br}{-.15}{.25}{$x$}
  \rTabPut{Br}{-.15}{.40}{$f(x)$}

  \TabNewCol{0}
  \rTabPut{Bl}{.15}{.25}{$0$}
  \rTabPut{Bl}{.15}{.60}{$\frac{3}{2}$}

  \TabNewCol{.30}
  \rTabPut{B}{0}{.25}{$1$}
  \rTabPut{Br}{-.15}{.80}{$+\infty$}
  \psline[style=TabDblBarre](.3,0)(.3,1)

  \TabNewCol{.45}
  \rTabPut{B}{0}{.25}{$\frac{3}{2}$}
  \rTabPut[2]{B}{0}{.10}{\TabZ}

  \TabNewCol{1}
  \rTabPut{Br}{-.15}{.25}{$+\infty$}
  \rTabPut{Br}{-.15}{.40}{$1$}

  \TabFleche{B1}{C1}
  \TabFleche{D1}{E1}
\end{MonTableau}
\end{document}
```

:::{todo} Revoir cet exemple qui n'est plus fonctionnel.
:::