---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, quotidien, calendrier annuel, 
              calendrier mensuel, agenda, planning
---

# Comment mettre en forme un calendrier ?

## Avec l'extension <ctanpkg:termcal>

L'extension <ctanpkg:termcal> permet de mettre en page un calendrier. Il permet
de préciser quels jours doivent apparaître et d'insérer du texte 
soit régulièrement à certaines dates, soit à des dates particulières.


## Avec l'extension <ctanpkg:calendar>

L'extension <ctanpkg:calendar> est également faite pour ça.


## Avec l'extension <ctanpkg:yplan>

:::{todo} Ajouter des exemples pour cette extension et les précédentes.
:::


## Avec l'extension <ctanpkg:tikz>

L'extension <ctanpkg:tikz> propose une librairie `calendar` dédiée à la mise
en forme de petits calendriers. L'exemple ci-dessous, légèrement adapté
de la [documentation](texdoc:tikz) de l'extension montre quelques possibilités
de configuration et la façon d'obtenir des présentations dépendant de 
conditions. Il illustre également le rôle intéressant de l'extension 
<ctanpkg:translator> pour franciser les noms des mois (par défaut en anglais 
dans <ctanpkg:tikz>), cette dernière récupérant l'option `french` déclarée
avec la classe de l'exemple.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \usepackage{translator}     % Traduction des noms des mois de TikZ
  \usepackage{tikz}
  \usetikzlibrary {calendar,shapes.misc}

\begin{document}
Voici à peu près où vous en êtes.
\begin{figure}[h!]
\centering
\begin{tikzpicture}
\calendar
  [
  dates=\year-\month-\day+-20 to \year-\month-\day+20,
  week list,inner sep=2pt,month label above centered,
  month text=\textit{\%mt \%y0}
  ]
if (at least=\year-\month-\day) {} else [nodes={strike out,draw}]
if (at most=\year-\month-\day+7) [green!50!black]
if (between=\year-\month-\day+8 and \year-\month-\day+10) [red]
if (Sunday) [gray,nodes={draw=none}]
;
\end{tikzpicture}
\caption{De 20 jours avant jusqu'à 20 jours après}
\end{figure}
\end{document}
```


### Avec la classe <ctanpkg:tikz-kalender>

La classe <ctanpkg:tikz-kalender>, de Rolf Niepraschk, permet de générer 
un calendrier recto-verso en se basant sur <ctanpkg:tikz>. L'exemple ci-dessous
illustre un cas très simple.

``` 
\documentclass{tikz-kalender}
  \setup{%
  ,lang=french
  ,year=2024
  }

\begin{document}
  \makeKalender
\end{document} 
```

L'extension permet de gérer des comportements particuliers pour des plages
de date particuliers (permettant de définir des jours fériés, 
des anniversaires, des congés ou bien encore des vacances scolaires).


### Un exemple avancé

David Alberto propose sur le site [](https://www.astrolabe-science.fr/) 
un [calendrier scolaire](https://www.astrolabe-science.fr/calendrier-scolaire-latex/)
très esthétique basé sur les fonctionnalités de l'extension <ctanpkg:tikz>.