---
myst:
  html_meta:
    keywords: LaTeX, informatique, verbatim, écrire du code, inclure du code, programmation
---

# Comment écrire en mode verbatim ?

Dans certains domaines, notamment en informatique, on a besoin de citer du texte comportant beaucoup de [caractères spéciaux pour LaTeX](/3_composition/texte/symboles/caracteres/caracteres_reserves) (`&`, `_`, `\`...). Le cas extrême se présentera si vous écrivez un document **sur** LaTeX **en** LaTeX. Vous aurez besoin de citer des noms de commandes, de donner des bouts de code...

Dans le jargon LaTeX, citer du texte sans interpréter ce qu'il contient se dit « écrire en verbatim », ce qui veut dire [mot pour mot](wpfr:Verbatim) en latin.

- Les environnements `verbatim` et `verbatim*` de LaTeX permettent de réaliser cela. Cependant, ils sont assez limités, en particulier sur la taille de ce que peuvent contenir ces environnements, et de nombreuses extensions ont été proposées.
- Le package <ctanpkg:verbatim> redéfinit les environnements `verbatim` et `verbatim*`, afin de ne plus être limité par la taille du contenu. Il fournit également la commande `\verbatiminput`, qui prend en argument un nom de fichier, et inclut ce fichier en mode verbatim.
- L'environnement `alltt` du package du même nom <ctanpkg:alltt> (package dû à Johannes Braams) est une autre solution. À l'intérieur de cet environnement, le caractère `\` et les accolades conservent leur signification, et il est donc possible d'inclure des commandes LaTeX dans un environnement `alltt`. Cela permet en particulier d'inclure un fichier en verbatim, à condition qu'il ne contienne pas d'accolades.

Exemple d'utilisation de <ctanpkg:alltt> :

```
\documentclass{article}
\usepackage[T1]{fontenc}
  \usepackage{alltt}
  \usepackage[french]{babel}
  \pagestyle{empty}

\begin{document}
\begin{alltt}
 Notez la différence subtile entre
 $f(x)$ et \(f(x)\) grâce à
 l'utilisation de la \og{}contre-oblique\fg.
\end{alltt}
\end{document}
```

- L'extension <ctanpkg:moreverb> va un peu plus loin, en permettant notamment de numéroter les lignes de l'environnement `verbatim`. Elle permet aussi d'inclure un fichier, bien sûr, mais aussi et surtout d'écrire dans un fichier.

Pour inclure un fichier, on saisira par exemple :

```{noedit}
{ \small \listinginput[5]{10}{totor.c} }
```

Les paramètres `5` et `10` indiquent que la numérotation des lignes doit se faire de 5 en 5 en commençant à 10.

- L'extension <ctanpkg:fancyvrb> permet d'écrire du texte verbatim encadré, en couleur et même dans lequel certaines commandes sont interprétées.
- L'extension <ctanpkg:sverb> de Mark Wooding, propose un environnement `listing`.
- L'extension <ctanpkg:verbtext>, permet de numéroter les lignes d'un texte verbatim, et d'interpréter certaines commandes.
- On peut aussi essayer l'extension <ctanpkg:verbasef> (*verbatim automatic segmentation of external files*). Il utilise l'environnement `figure`.


:::{todo} Ce qui suit est tiré d'une autre question traitant du verbatim. Tout est à regrouper et reformuler ici.
:::

L'environnement `verbatim` permet d'insérer un texte tel quel sans que LaTeX ne le traite. 
Il permet notamment de faire apparaître des commandes LaTeX. 
Il est cependant fragile et peut produire des résultats très bizarres, par exemple, 
il vaut mieux éviter de l'utiliser de manière inconsidérée dans des contextes curieux comme les tableaux, 
en argument à une autre commande, etc.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
  \usepackage{lmodern}  % Caractères plus lisibles
  \usepackage{babel}    % Réglages linguistiques (avec french)
  \pagestyle{empty}     % N'affiche pas de numéro de page

\begin{document}
\begin{verbatim}
 La commande \LaTeX{} permet d'imprimer le logo
 LaTeX.
\end{verbatim}
\end{document}
```

La commande `\verb` permet de faire la même chose localement. 
Le premier caractère après la commande permet de marquer le début du mode `verbatim` 
et la prochaine occurrence de ce caractère en marque la fin. 
Ce peut être n'importe quel autre caractère sauf un espace, 
qui est ignoré après un nom de commande, une lettre, qui ferait partie du nom de commande 
(LaTeX croirait alors lire un appel, par exemple, à `verbX`) ou une étoile. 
En complément, la commande `\verb*` fonctionne comme `\verb` mais rend les espaces visibles. 
L'exemple suivant illustre les deux cas :

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
  \usepackage{lmodern}  % Caractères plus lisibles
  \usepackage{babel}    % Réglages linguistiques (avec french)
  \pagestyle{empty}     % N'affiche pas de numéro de page

\begin{document}
La commande \verb+\verb+ permet de taper ce
qu'on veut sans l'interpréter. Par exemple
\verb,ceci cela,. On peut également
matérialiser les blancs dans la commande
\verb+\verb*+ \verb*+comme illustré ici+.
\end{document}
```


## Avec l'extension <ctanpkg:fancyvrb>

L'extension <ctanpkg:fancyvrb> permet d'écrire du texte `verbatim` encadré, en couleur... 
et même dans lequel certaines commandes sont interprétées. 
Il propose également une solution pour inclure du verbatim dans l'argument d'une commande 
comme le montre la question "[](composer_en_verbatim_dans_une_note_de_bas_de_page)".
L'exemple suivant en montre le fonctionnement.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
  \usepackage{lmodern}  % Caractères plus lisibles
  \usepackage{babel}    % Réglages linguistiques (avec french)
  \pagestyle{empty}     % N'affiche pas de numéro de page
  \usepackage{fancyvrb}

\begin{document}
\fvset{frame=single,numbers=left,numbersep=3pt,
  commandchars=\\\{\},label=Exemple}
\begin{Verbatim}
Ici, je mets mon programme.
Avec des maths : \(a, b, \alpha, \beta,\ldots\)
ou de l'\textit{italique}.

\large{Pratique, non ?}
\end{Verbatim}
\end{document}
```


## Avec l'extension [fancyvrb-ex](ctanpkg:fancyvrb)

L'extension [fancyvrb-ex](ctanpkg:fancyvrb), incluse dans <ctanpkg:fancyvrb>, 
permet de mettre côte à côte ou l'un au-dessous de l'autre un passage verbatim et son aspect final.

Voici un exemple illustrant l'environnement `SideBySideExample` de cette extension 
(avec une option pour donner plus de place à l'aspect final du code en verbatim).

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
  \usepackage{lmodern}  % Caractères plus lisibles
  \usepackage{babel}    % Réglages linguistiques (avec french)
  \pagestyle{empty}     % N'affiche pas de numéro de page

  \usepackage{fancyvrb-ex}

\begin{document}
\begin{SideBySideExample}[xrightmargin=6cm]
Ceci est un \textit{pourcentage} : \%.
\end{SideBySideExample}
\end{document}
```


## Avec l'extension <ctanpkg:alltt>

:::{todo} Ajouter un exemple.
:::

L'extension <ctanpkg:alltt> définit un environnement `alltt` qui ressemble à `verbatim` 
parce que tous les caractère particuliers de LaTeX 
(les accolades, les esperluettes, les pourcents, etc.) sont désactivés. 
Cet environnement permet donc de montrer quelque chose qui ressemble à un source, 
comme par exemple du code informatique, 
mais en le mettant en forme un minimum grâce à l'appel de certaines commandes 
(gras, mathématiques, symboles, etc.).
