---
myst:
  html_meta:
    keywords: LaTeX, lualatex, système solaire, physique
---
# Comment représenter le système solaire ?


Le package <ctanpkg:pst-solarsystem> permet de représenter la position des planètes du
  système solaire dans le plan de l'écliptique à une date donnée.
  <!-- Par exemple: -->

<!-- - Le package <ctanpkg:tikz-planets> permet de représenter le système solaire de manière -->
<!-- simplifiée.  -->


## Avec pst-solarsystem
```
%!TEX engine=lualatex
\documentclass{article}
\usepackage{pst-solarsystem}
\begin{document}

\SolarSystem[Day=31,Month=06,Year=2001,Hour=23,Minute=59,Second=59]

\end{document}
```

:::{attention}
Comme tout package basé sur [PSTricks](ctanpkg:pstricks),
<ctanpkg:pst-solarsystem>  ne fonctionne pas avec le moteur `pdflatex`. En
revanche, il fonctionne avec le moteur `lualatex`.
:::

<!-- ## Avec tikz-planets -->
<!-- Un bug empêche visiblement ce package de fonctionner. Suivre une éventuelle évolution de -->
<!-- ce ticket:  https://framagit.org/Moutmout/tikz-planets/-/issues/16 -->
<!--  -->
<!-- ``` -->
<!-- \documentclass{article} -->
<!-- \usepackage{planets} -->
<!-- \begin{document} -->
<!-- \begin{tikzpicture} -->
<!-- \planet[surface=sun] -->
<!-- \planet[surface=earth, phase = first half, rotation, tilt=23.5, centerx=-5] -->
<!-- \planet[surface=earth, phase = last half, rotation, tilt=23.5, centerx=5] -->
<!-- \planet[surface=earth, phase = new, rotation, tilt=23.5, centery=-3] -->
<!-- \planet[surface=earth, phase = full, rotation, tilt=23.5, centery=3] -->
<!-- \end{tikzpicture} -->
<!-- \end{document} -->
<!-- ``` -->
<!--  -->
