#!/usr/bin/env bash

cd codedir

i=0
j=0
k=0
l=0
m=0
n=0
for fichier in *.tex
do
    basefichier=$(basename "$fichier" .tex)
    if [ -f "${basefichier}.latexmkopt" ]; then
        ((i=i+1))
	if [ ../FAQLaTeXGUTenberg.tex -nt "$fichier" ]; then
	    ((l=l+1))
	    rm -f ${basefichier}*
	    echo ""
	    echo "supprimés : ${basefichier}{.tex,.aux,...,-crop.pdf}"
	fi
    else
	((j=j+1))
	echo ""
	echo "$fichier n'a pas de .latexmkopt, il s'agit probablement"
	echo "d'un fichier extrait lors des compilations précédentes."
	echo "Voici les fichiers associés de même base:"
	ls -l ${basefichier}.*
    fi
done

if [ "$l" -gt 0 ]; then
    echo ""
    echo "$i fichiers .tex avec .latexmkopt étaient présents."
    echo "$l d'entre eux ont été supprimés ainsi que leurs fichiers auxiliaires."
    echo "Ils provenaient d'un état antérieur des sources et ont été modifiés"
    echo "(donc ont changé de noms à cause du hachage) ou supprimés depuis."
fi

if [ "$j" -gt 0 ]; then
    echo ""
    echo "Il existe $j fichiers .tex (voir ci-dessus) dans codedir/ qui sont"
    echo "probablement le produit de filecontents dans les exemples.  Nous ne"
    echo "pouvons pas déterminer s'ils sont issus d'exemples aujourd'hui"
    echo "absents de codedir/.  Vous pouvez les supprimer manuellement sans"
    echo "crainte."
fi

((i=i-l))
echo ""
echo "Il y a $i exemples extraits du FAQLaTeXGUTenberg.tex actuel."

FICHIERS_EN_ECHEC=""
# il y a donc au moins $i exemples .tex avec .latexmkopt.
# Si un fichier .latexmkopt n'a pas de .tex associé, il devrait
# y avoir une erreur dans la boucle qui suit, mais le message
# signalera seulement une erreur avec fichier.tex sans vérifier
# si ce fichier existe.

echo ""
echo "L'output des latexmk's dans codedir est redirigé vers codedir/latexmklogs."
echo "" >latexmklogs
for file in *.latexmkopt
do
    ((k=k+1))
    base="$(basename "$file" .latexmkopt)"
    read -r lmkopt<"$file"
    commande() {
    case "$lmkopt" in
	"-pdf" )
            latexmk -pdf -silent --halt-on-error -pdflatex="pdflatex-dev" "$1" >>latexmklogs 2>&1
            ;;
	"-lualatex" )
            latexmk -pdflua -silent --halt-on-error -lualatex="lualatex-dev" "$1" >>latexmklogs 2>&1
            ;;
	"-xelatex" )
            latexmk -pdfxe -silent --halt-on-error -xelatex="xelatex-dev" "$1" >>latexmklogs 2>&1
            ;;
	* )
            echo "**ATTENTION** $file douteux"; exit 1 ;
            ;;
    esac
    }
    commande "$base.tex" && { [ "$base.pdf" -nt "$base-crop.pdf" ]  && pdfcrop "$base" || echo -n ". "; ((m=m+1)); } \
                         || { rm -f "$base-crop.pdf" ; echo -e "\033[1;31mERREUR AVEC $base.tex\033[0m" ; \
	                      FICHIERS_EN_ECHEC="${FICHIERS_EN_ECHEC}$base.tex\n" ; ((n=n+1)); }
done

echo ""
echo "$m exemples compilés dans codedir."

if [ "$n" -gt 0 ]; then
    echo "$n fichiers en échec.  Leur liste est donnée ci-dessous."
fi

if [ "$k" -ne "$i" ]; then
    echo ""
    echo "Allô Trifouilly-les-Oies, nous avons un problème !"
    echo "$k n'est pas égal à $i, ce qui est grave."
    echo "Il y a plus de .latexmkopt que de .tex extraits !"
fi

cd ..
echo "$k" >FAQ.nbexemples

if [ -z "$FICHIERS_EN_ECHEC" ]; then
    :
else
    echo ""
    echo -e "\033[1;31mERREURS AVEC\n$FICHIERS_EN_ECHEC\033[0m"
    echo -e "\033[1;31mARRÊT À CAUSE D'ERREURS DANS LES EXEMPLES\033[0m"
    exit 1
fi
