---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              flottant perdu, problème avec les flottants, 
              flottant dans une note de bas de page
---

# Que signifie l'erreur : "Float(s) lost" ?

- **Message** : `Float(s) lost`

Cette erreur se produit rarement mais elle paraît toujours incroyablement 
mystérieure quand elle survient.

Le message indique pourtant bien ce qui se passe : un ou plusieurs flottants
n'ont pas été composés, que ce soient des figures, des tables... 
ou même des notes marginales (avec `\marginpar`). Les notes marginales sont
en effet traitées par les outils comme des flottants, ce qui explique 
pourquoi elles se retrouvent associées à ce message d'erreur.

La raison la plus fréquente est d'avoir placé un environnement flottant 
ou une note marginale à l'intérieur d'un `\marginpar`, d'un environnement 
`minipage`, d'un autre flottant, d'une `\parbox` ou d'une `\footnote`.
LaTeX détecte ce problème très tardivement, lorsqu'il a terminé le document.
Cela peut rendre difficile la localisation de l'emplacement fautif.

Ainsi, les techniques de pistage des erreurs vues à la question
"[](/2_programmation/erreurs/interpreter_les_messages_d_erreur2)" sont 
largement recommandées.

Si un emboîtement incorrect n'est pas la cause principale, l'erreur peut 
survenir du fait d'un sérieux problème de codage de l'algorithme des flottants, 
probablement dû au chargement de certaines extensions.


:::{sources}
- [Float(s) lost](faquk:FAQ-fllost)
- [FAQ erreurs - Lettre F](https://latex.developpez.com/faq/erreurs?page=F), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::