---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              fichier non trouvé
---

# Que signifie l'erreur : "I can't find file ‘⟨nom⟩’" ?

- **Message** : ```` I can't find file `⟨nom⟩' ````
- **Origine** : TeX

Il s'agit d'une erreur TeX de bas niveau qui a lieu lorsque TeX ne peut pas
trouver un fichier qui doit être chargé. Cette erreur ne peut être levée qu'en
fournissant à TeX un fichier qu'il est capable de trouver, ou en stoppant la
compilation (si le système d'exploitation le permet). Pour passer cette erreur,
de nombreuses installations fournissent un fichier `null.tex` qui permet de
répondre `null` à cette erreur. LaTeX utilise habituellement le message 
d'erreur "`File ‘⟨nom⟩’ not found`" qui permet d'autres actions de la part 
de l'utilisateur. Cependant, selon le codage de l'extension, vous pouvez 
obtenir cette erreur au lieu de l'erreur LaTeX.


:::{sources}
- [FAQ erreurs - Lettre I](https://latex.developpez.com/faq/erreurs?page=I), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::