-- counts the frequency of the words in a document recursively
-- and prints the results to stdout
-- adapted from an example in the pandoc documentation

words = 0

list = {}

wordcount = {
  Str = function(el)
    -- we don't count a word if it's entirely punctuation
    if el.text:match("%P") then
        words = words + 1
        word = el.text
        if list[word] == nil then
            -- add new key to the list
            list[word] = 1
        else
            list[word] = list[word] + 1
        end
    end
  end,

  -- do we need this?
  Code = function(el)
    _,n = el.text:gsub("%S+","")
    words = words + n
  end,

  -- do we need this?
  CodeBlock = function(el)
    _,n = el.text:gsub("%S+","")
    words = words + n
  end
}

function Pandoc(el)
    -- skip metadata, just count body:
    el.blocks:walk(wordcount)
    -- print(words .. " words in body")

    -- cannot use the hash list to sort
    -- copy to other list
    local sorted = {}
    for k, v in pairs(list) do
        table.insert(sorted, {key = k, value = v})
    end

    table.sort(sorted, function(a, b)
        return a.value > b.value
    end)

    for _, entity in ipairs(sorted) do
        print(tostring(entity.key) .. ', ' .. tostring(entity.value))
    end
    os.exit(0)
end
