/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFParser;
import de.tu_darmstadt.sp.paul.PDFReference;
import de.tu_darmstadt.sp.paul.PDFReferenceContainer;
import de.tu_darmstadt.sp.paul.PDFStreamException;
import de.tu_darmstadt.sp.paul.PDFWriter;
import de.tu_darmstadt.sp.paul.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class PDFStream
extends PDFReferenceContainer {
    PDFDictionary dictionary;
    boolean resolved = false;

    protected PDFStream() {
        this.setIndirect();
    }

    public void changeFilters(List filters) throws PDFStreamException {
        this.changeFilters(filters, null);
    }

    public abstract void changeFilters(List var1, List var2) throws PDFStreamException;

    public PDFDictionary getDictionary() {
        return this.dictionary;
    }

    public List getFilters() {
        ArrayList<PDFObject> result = new ArrayList<PDFObject>();
        if (!this.dictionary.containsKey(PDFName.FILTER)) {
            return result;
        }
        PDFObject filterEntry = this.dictionary.get(PDFName.FILTER);
        if (filterEntry instanceof PDFName) {
            result.add(filterEntry);
            return result;
        }
        if (filterEntry instanceof PDFArray) {
            int len = ((PDFArray)filterEntry).size();
            int i = 0;
            while (i < len) {
                result.add(((PDFArray)filterEntry).get(i));
                ++i;
            }
            return result;
        }
        throw new PDFStreamException("invalid Filter entry");
    }

    public int getLength() {
        PDFObject lengthEntry;
        if (!this.dictionary.containsKey(PDFName.LENGTH)) {
            this.dictionary.put(PDFName.LENGTH, (PDFObject)PDFInteger.forInt(32));
        }
        return (lengthEntry = this.dictionary.get(PDFName.LENGTH)) instanceof PDFReference ? ((PDFInteger)((PDFReference)lengthEntry).getContent()).intValue() : ((PDFInteger)lengthEntry).intValue();
    }

    public List getParms() {
        ArrayList<PDFObject> result = new ArrayList<PDFObject>();
        if (!this.dictionary.containsKey(PDFName.DECODEPARMS)) {
            List filters = this.getFilters();
            int len = filters.size();
            int i = 0;
            while (i < len) {
                result.add(PDFObject.NULL);
                ++i;
            }
            return result;
        }
        PDFObject parmsEntry = this.dictionary.get(PDFName.DECODEPARMS);
        if (parmsEntry instanceof PDFArray) {
            int len = ((PDFArray)parmsEntry).size();
            int i = 0;
            while (i < len) {
                result.add(((PDFArray)parmsEntry).get(i));
                ++i;
            }
            return result;
        }
        result.add(parmsEntry);
        return result;
    }

    void getReferenced(PDFWriter writer) {
        writer.markVisited(this);
        if (!this.dictionary.isDirect()) {
            throw new RuntimeException("Indirect dictionary in stream found.");
        }
        if (!writer.isVisited(this.dictionary)) {
            this.dictionary.getReferenced(writer);
        }
    }

    void removeReferences(PDFWriter writer) {
        writer.markVisited(this);
        this.dictionary.removeReferences(writer);
    }

    void resolveReferences(PDFParser parser) throws ParseException, IOException {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.dictionary.resolveReferences(parser);
    }

    public String toString() {
        return "Stream of length " + this.getLength() + "\n";
    }
}

