// Name of a group of files
[groupname]
/l50009/l

// This section contains extensions of files belonging to the group.
// If one extenstion belongs to more than one group, definitions from all the
// groups are applied
[extensions]
tex, sty, cls, lof, lot, toc, idx, glo, aux, bbl, clo

// Access type to the files from the group
[access]
// level    = (0-readonly, 1-ask before edit, 2-fullaccess}
// question = {nicetext shown to ask the file should be edited}
// exec     = {file name to execute when a file is opened}
level=2

// Defines if the group of files is enabled by default
[default]
yes

// Hilight commands
// Predefined groups:
// [hilight\keys]     - keywords
// [hilight\symbols]  - special symbols
// [hilight\types]    - types
// [hilight\comments] - comments
[hilight\LaTeXKeys]
// 100500 - Commands to work in math and text mode
\$
\P
\S
\_
\copyright
\dag
\ddag
\dots
\pounds
\{
\}

// 101000 - Predefined LaTeX2e Text-Mode Comands
\textasciicircum
\textasciitilde
\textasteriskcentered
\textbackslash
\textbar
\textbraceleft
\textbraceright
\textbullet
\textcopyright
\textdagger
\textdaggerdbl
\textdollar
\textellipsis
\textemdash
\textendash
\textexclamdown
\textgreater
\textless
\textordfeminine
\textordmasculine
\textparagraph
\textperiodcentered
\textquestiondown
\textquotedblleft
\textquotedblright
\textquoteleft
\textquoteright
\textregistered
\textsection
\textsterling
\texttrademark
\textunderscore
\textvisiblespace

// 101500 - Non-ASCI Letters (Excluding Accented Letters)
\aa
\AA
\AE
\ae
\DH
\dh
\DJ
\dj
\L
\l
\NG
\ng
\o
\O
\OE
\oe
\ss
\SS
\TH
\th

// 102000 - Letters Used to Typeset Affrican Languages
\B{D}
\B{d}
\B{H}
\B{h}
\B{t}
\B{T}
\m{b}
\m{B}
\m{C}
\m{c}
\m{D}
\M{d}
\M{D}
\m{d}
\m{E}
\m{e}
\M{E}
\M{e}
\m{f}
\m{F}
\m{G}
\m{g}
\m{I}
\m{i}
\m{J}
\m{j}
\m{K}
\m{k}
\m{N}
\m{n}
\m{o}
\m{O}
\m{P}
\m{p}
\m{s}
\m{S}
\M{t}
\M{T}
\m{t}
\m{T}
\m{u}
\m{U}
\m{Y}
\m{y}
\m{z}
\m{Z}
\T{E}
\T{e}
\T{O}
\T{o}

// 102500 - Punctuation Marks Not Found in OT1
\guillemotleft
\guillemotright
\guilsinglleft
\guilsinglright
\quotedblbase
\quotesinglbase
\textquotedbl

// 103000 - pifont Decorative Punctuation Marks
\ding{123}
\ding{124}
\ding{125}
\ding{126}
\ding{161}
\ding{162}
\ding{163}

// 103500 - Text-Mode Accents
\"{A}
\"{a}
\{A}
\{a}
\.{A}
\.{a}
\={A}
\={a}
\^{A}
\^{a}
\newtie{A}
\newtie{a}
\{A}
\{a}
\b{A}
\b{a}
\c{A}
\c{a}
\d{A}
\d{a}
\G{A}
\G{a}
\H{A}
\H{a}
\k{A}
\k{a}
\r{A}
\r{a}
\t{A}
\t{a}
\U{A}
\U{a}
\u{A}
\u{a}
\v{A}
\v{a}
\~{A}
\~{a}

// 104000 - tipa Text-Mode Accents
\textacutemacron{A}
\textacutemacron{a}
\textacutewedge{A}
\textacutewedge{a}
\textadvancing{A}
\textadvancing{A}
\textbottomtiebar{A}
\textbottomtiebar{a}
\textbrevemacron{A}
\textbrevemacron{a}
\textcircumacute{A}
\textcircumacute{a}
\textcircumdot{A}
\textcircumdot{a}
\textdotacute{A}
\textdotacute{a}
\textdotbreve{A}
\textdotbreve{a}
\textdoublegrave{A}
\textdoublegrave{a}
\textdoublevbaraccent{A}
\textdoublevbaraccent{a}
\textgravecircum{A}
\textgravecircum{a}
\textgravedot{A}
\textgravedot{a}
\textgravemid{A}
\textgravemid{a}
\textinvsubbridge{A}
\textinvsubbridge{a}
\textlowering{A}
\textlowering{a}
\textmidacute{A}
\textmidacute{a}
\textovercross{A}
\textovercross{a}
\textoverw{A}
\textoverw{a}
\textpolhook{A}
\textpolhook{a}
\textraising{A}
\textraising{a}
\textretracting{A}
\textretracting{a}
\textringmacron{A}
\textringmacron{a}
\textroundcap{A}
\textroundcap{a}
\textseagull{A}
\textseagull{a}
\textsubarch{A}
\textsubarch{a}
\textsubbar{A}
\textsubbar{a}
\textsubbridge{A}
\textsubbridge{a}
\textsubdot{A}
\textsubdot{a}
\textsublhalfring{A}
\textsublhalfring{a}
\textsubplus{A}
\textsubplus{a}
\textsubrhalfring{A}
\textsubrhalfring{a}
\textsubring{A}
\textsubring{a}
\textsubsquare{A}
\textsubsquare{a}
\textsubtilde{A}
\textsubtilde{a}
\textsubumlaut{A}
\textsubumlaut{a}
\textsubw{A}
\textsubw{a}
\textsubwedge{A}
\textsubwedge{a}
\textsuperimposetilde{A}
\textsuperimposetilde{a}
\textsyllabic{A}
\textsyllabic{a}
\texttildedot{A}
\texttildedot{a}
\texttoptiebar{A}
\texttoptiebar{a}
\textvbaraccent{A}
\textvbaraccent{a}

// 104500 - wsuipa Text-Mode Accents
\dental{A}
\dental{a}
\underarch{A}
\underarch{a}

// 105000 - wsuipa Diacritics
\ain
\corner
\downp
\downp
\halflength
\leftp
\leftt
\length
\midtilde
\open
\overring
\polishhook
\rightp
\rightt
\secstress
\stress
\syllabic
\underdots
\underring
\undertilde
\underwedge
\upp
\upt

// 105500 - textcomp Diacritics
\textacutedbl
\textasciiacute
\textasciibreve
\textasciicaron
\textasciidieresis
\textasciigrave
\textasciimacron
\textgravedbl
\texttildelow

// 106000 - textcomp Currency Symbols
\textbaht
\textcent
\textcentoldstyle
\textcolonmonetary
\textcurrency
\textdollar
\textdollaroldstyle
\textdong
\texteuro
\textflorin
\textguarani
\textlira
\textnaira
\textpeso
\textsterling
\textwon
\textyen

// 106500 - marvosym Currency Symbols
\Denarius
\Ecommerce
\EUR
\EURcr
\EURdig
\EURhv
\EURtm
\EyesDollar
\Pfund
\Shilling

// 107000 - textcomp Legal Symbols
\textcircledP
\textcopyleft
\textcopyright
\textregistered
\textservicemark
\texttrademark

// 107500 - textcomp Old-Style Numerals
\textzerooldstyle
\textoneoldstyle
\texttwooldstyle
\textthreeoldstyle
\textfouroldstyle
\textfiveoldstyle
\textsixoldstyle
\textsevenoldstyle
\texteightoldstyle
\textnineoldstyle

// 108000 - wasysym Phonetic Symbols
\DH
\Thorn
\dh
\inve
\openo

// 108500 - tipa Phonetic Symbols
\textbabygamma
\textbarb
\textbarc
\textbard
\textbardotlessj
\textbarg
\textglotstop
\texthalflength
\texthardsign
\texthooktop
\texthtb
\texthtbardotlessj
\textrtaill
\textrtailn
\textrtailr
\textrtails
\textrtailt
\textrtailz
\textbarglotstop
\textbari
\textbarl
\textbaro
\textbarrevglotstop
\textbaru
\textbeltl
\textbeta
\textbullseye
\textceltpal
\textchi
\textcloseepsilon
\textcloseomega
\textcloserevepsilon
\textcommatailz
\textcorner
\textcrb
\textcrd
\textcrg
\textcrh
\textcrinvglotstop
\textcrlambda
\textcrtwo
\textctc
\textctd
\textctdctzlig
\textctesh
\textctj
\textctn
\textctt
\textcttctclig
\textctyogh
\textctz
\textdctzlig
\textdoublebaresh
\textdoublebarpipe
\textdoublebarslash
\textdoublepipe
\textdoublevertline
\textdownstep
\textdyoghlig
\textdzlig
\textepsilon
\textesh
\textfishhookr
\textg
\textgamma
\textglobfall
\textglobrise
\texthtc
\texthtd
\texthtg
\texthth
\texthtk
\texthtp
\texthtq
\texthtscg
\texthtt
\texthvlig
\textinvglotstop
\textinvscr
\textiota
\textlambda
\textlengthmark
\textlhookt
\textlhti
\textlhtlongi
\textlonglegr
\textlptr
\textltailm
\textltailn
\textltilde
\textlyoghlig
\textnrleg
\textObardotlessj
\textOlyoghlig
\textomega
\textopencorner
\textopeno
\textpalhook
\textphi
\textpipe
\textprimstress
\textraiseglotstop
\textraisevibyi
\textramshorns
\textrectangle
\textrevapostrophe
\textreve
\textrevepsilon
\textrevglotstop
\textrevyogh
\textrhookrevepsilon
\textrhookschwa
\textrhoticity
\textrptr
\textrtaild
\textrthook
\textsca
\textscb
\textsce
\textscg
\textsch
\textschwa
\textsci
\textscj
\textscl
\textscn
\textscoelig
\textscomega
\textscq
\textscr
\textscripta
\textscriptv
\textscu
\textscy
\textsecstress
\textsoftsign
\textstretchc
\texttctclig
\textteshlig
\texttheta
\textthorn
\texttslig
\textturna
\textturncelig
\textturnh
\textturnk
\textturnlonglegr
\textturnm
\textturnmrleg
\textturnr
\textturnrrtail
\textturnscripta
\textturnt
\textturnv
\textturnw
\textturny
\textupsilon
\textupstep
\textvertline
\textvibyi
\textvibyy
\textwynn
\textyogh

// 109000 - wsuipa Phonetic Symbols
\babygamma
\barb
\bard
\bari
\barl
\baro
\barp
\barsci
\barscu
\baru
\clickb
\clickc
\clickt
\closedniomega
\closedrevepsilon
\crossb
\crossd
\crossh
\crossnilambda
\curlyc
\curlyesh
\curlyyogh
\curlyz
\dlbari
\dz
\ejective
\eng
\er
\esh
\eth
\flapr
\glotstop
\hookb
\hookg
\hookh
\hookheng
\hookrevepsilon
\hv
\inva
\invf
\invglotstop
\invh
\invlegr
\invm
\invr
\invscr
\invscripta
\invv
\invw
\invy
\ipagamma
\labdentalnas
\latfric
\legm
\legr
\lz
\nialpha
\nibeta
\nichi
\niepsilon
\nigamma
\niiota
\nilambda
\niomega
\niphi
\nisigma
\nitheta
\niupsilon
\nj
\oo
\openo
\reve
\reveject
\revepsilon
\revglotstop
\scd
\scg
\schwa
\sci
\scn
\scr
\scripta
\scriptg
\scriptv
\scu
\scy
\slashb
\slashc
\slashd
\slashu
\taild
\tailinvr
\taill
\tailn
\tailr
\tails
\tailt
\tailz
\tesh
\thorn
\tildel
\yogh

// 109500 - Miscellaneous textcomp Symbols
\textasteriskcentered
\textbardbl
\textbigcircle
\textblank
\textbrokenbar
\textbullet
\textdagger
\textdaggerdbl
\textdblhyphen
\textdblhyphenchar
\textdiscount
\textestimated
\textinterrobang
\textinterrobangdown
\textmusicalnote
\textnumero
\textopenbullet
\textordfeminine
\textordmasculine
\textparagraph
\textperiodcentered
\textpertenthousand
\textperthousand
\textpilcrow
\textquotesingle
\textquotestraightbase
\textquotestraightdblbase
\textrecipe
\textreferencemark
\textsection
\textthreequartersemdash
\texttwelveudash

// 110000 - stmaryrd Binary Operators
\baro
\bbslash
\binampersand
\bindnasrepma
\boxast
\boxbar
\boxbox
\boxbslash
\boxcircle
\boxdot
\boxempty
\boxslash
\curlyveedownarrow
\curlyveeuparrow
\curlywedgedownarrow
\curlywedgeuparrow
\fatbslash
\fatsemi
\fatslash
\interleave
\leftslice
\merge
\minuso
\moo
\nplus
\obar
\oblong
\obslash
\ogreaterthan
\olessthan
\ovee
\owedge
\rightslice
\sslash
\talloblong
\varbigcirc
\varcurlyvee
\varcurlywedge
\varoast
\varobar
\varobslash
\varocircle
\varodot
\varogreaterthan
\varolessthan
\varominus
\varoplus
\varoslash
\varotimes
\varovee
\varowedge
\vartimes
\Ydown
\Yleft
\Yright
\Yup

// 110500 - Variable-sized stmaryrd Math Operators
\bigbox
\bigcurlyvee
\bigcurlywedge
\biginterleave
\bignplus
\bigparallel
\bigsqcap
\bigtriangledown
\bigtriangleup

// 111000 - Binary Operators
\amalg
\ast
\bigcirc
\bigtriangledown
\bigtriangleup
\bullet
\cap
\cdot
\circ
\cup
\dagger
\ddagger
\diamond
\div
\lhd
\mp
\odot
\ominus
\oplus
\oslash
\otimes
\pm
\rhd
\setminus
\sqcap
\sqcup
\star
\times
\triangleleft
\triangleright
\unlhd
\unrhd
\uplus
\vee
\wedge
\wr

// 111500 - Variable-sized Math Operators
\bigcap
\bigcup
\bigodot
\bigoplus
\bigotimes
\bigsqcup
\biguplus
\bigvee
\bigwedge
\coprod
\int
\prod
\sum

// 112000 - AMS Binary Operators
\barwedge
\boxdot
\boxminus
\boxplus
\boxtimes
\Cap
\centerdot
\circledast
\circledcirc
\circleddash
\Cup
\curlyvee
\curlywedge
\divideontimes
\dotplus
\doublebarwedge
\intercal
\leftthreetimes
\ltimes
\rightthreetimes
\rtimes
\smallsetminus
\veebar

// 112500 - Variable-sized wasysym Math Operators
\iiint
\iint
\oiint
\varint
\varoint

// 113000 - txfonts/pxfonts Binary Operators
\circledbar
\circledbslash
\circledvee
\circledwedge
\invamp
\medbullet
\medcirc
\sqcapplus
\sqcupplus

// 113500 - Variable-sized txfonts/pxfonts Math Operators
\bigsqcapplus
\bigsqcupplus
\fint
\idotsint
\iiiint
\iiint
\iint
\oiiintclockwise
\oiiintctrclockwise
\oiiint
\oiintclockwise
\oiintctrclockwise
\oiint
\ointclockwise
\ointctrclockwise
\sqiiint
\sqiint
\sqint
\varoiiintclockwise
\varoiiintctrclockwise
\varoiintclockwise
\varoiintctrclockwise
\varointclockwise
\varointctrclockwise
\varprod

// 114000 - Relation Symbols 
\approx
\asymp
\bowtie
\cong
\dashv
\doteq
\equiv
\frown
\geq
\gg
\in
\Join
\leq
\ll
\mid
\models
\neq
\ni
\parallel
\perp
\prec
\preceq
\propto
\sim
\simeq
\smile
\sqsubset
\sqsubseteq
\sqsupset
\sqsupseteq
\subset
\subseteq
\succ
\succeq
\supset
\supseteq
\vdash

// 114500 - AMS Binary Relations
\approxeq
\backepsilon
\backsim
\backsimeq
\because
\between
\blacktriangleleft
\blacktriangleright
\Bumpeq
\bumpeq
\circeq
\curlyeqprec
\curlyeqsucc
\doteqdot
\eqcirc
\eqslantgtr
\eqslantless
\fallingdotseq
\geqq
\geqslant
\ggg
\gtrapprox
\gtrdot
\gtreqless
\gtreqqless
\gtrless
\gtrsim
\leqq
\leqslant
\lessapprox
\lessdot
\lesseqgtr
\lesseqqgtr
\lessgtr
\lesssim
\lll
\pitchfork
\precapprox
\preccurlyeq
\precsim
\risingdotseq
\shortmid
\shortparallel
\smallfrown
\sqsubset
\sqsupset
\Subset
\subseteqq
\succapprox
\succcurlyeq
\succsim
\Supset
\supseteqq
\therefore
\thickapprox
\thicksim
\trianglelefteq
\triangleq
\trianglerighteq
\varpropto
\vartriangleleft
\vartriangleright
\Vdash
\vDash
\Vvdash

// 115000 - AMS Negated Binary Relations
\gnapprox
\gneq
\gneqq
\gnsim
\gvertneqq
\lnapprox
\lneq
\lneqq
\lnsim
\lvertneqq
\ncong
\ngeq
\ngeqq
\ngeqslant
\ngtr
\nleq
\nleqq
\nleqslant
\nless
\nmid
\nparallel
\nprec
\npreceq
\nshortmid
\nshortparallel
\nsim
\nsubseteq
\nsucc
\nsucceq
\nsupseteq
\nsupseteqq
\ntriangleleft
\ntrianglelefteq
\ntriangleright
\ntrianglerighteq
\nvdash
\nvDash
\nVDash
\precnapprox
\precnsim
\subsetneq
\subsetneqq
\succnapprox
\succnsim
\supsetneq
\supsetneqq
\varsubsetneq
\varsubsetneqq
\varsupsetneq
\varsupsetneqq

// 115500 - atmaryrd Binary Relations
\inplus
\niplus
\subsetplus
\subsetpluseq
\supsetplus
\supsetpluseq
\trianglelefteqslant
\trianglerighteqslant

// 116000 - stmaryrd Negated Binary Relations
\ntrianglelefteqslant
\ntrianglerighteqslant

// 116500 - txfonts/pxfonts Binary Relations
\boxdotLeft
\boxdotleft
\boxdotright
\boxdotRight
\boxleft
\boxLeft
\boxRight
\boxright
\circleddotleft
\circleddotright
\circledgtr
\circledless
\circleleft
\circleright
\colonapprox
\Colonapprox
\coloneq
\Coloneq
\coloneqq
\Coloneqq
\colonsim
\Colonsim
\dashleftrightarrow
\Diamonddotleft
\DiamonddotLeft
\Diamonddotright
\DiamonddotRight
\Diamondleft
\DiamondLeft
\Diamondright
\DiamondRight
\Eqcolon
\eqcolon
\Eqqcolon
\eqqcolon
\eqsim
\lJoin
\lrtimes
\Mappedfromchar
\mappedfromchar
\mmappedfromchar
\Mmappedfromchar
\mmapstochar
\Mmapstochar
\multimapboth
\multimapbothvert
\multimapbothvert
\multimapdotboth
\multimapdotbothA
\multimapdotbothAvert
\multimapdotbothB
\multimapdotbothBvert
\multimapdotbothvert
\multimapdotinv
\multimapinv
\napproxeq
\nasymp
\nbacksim
\nbacksimeq
\nBumpeq
\nbumpeq
\Nearrow
\nequiv
\ngg
\ngtrapprox
\ngtrless
\ngtrsim
\nlessapprox
\nlessgtr
\nlesssim
\nll
\notin
\notni
\nprecapprox
\npreccurlyeq
\npreceqq
\nprecsim
\nsimeq
\nsqsubset
\nsqsubseteq
\nsqsupset
\nsqsupseteq
\nSubset
\nsubseteqq
\nsuccapprox
\nsucccurlyeq
\nsucceqq
\nsuccsim
\nSupset
\nthickapprox
\ntwoheadleftarrow
\ntwoheadrightarrow
\nvarparallel
\nvarparallelinv
\nVdash
\Nwarrow
\openJoin
\opentimes
\Perp
\preceqq
\precneqq
\rJoin
\Rrightarrow
\Searrow
\strictfi
\strictif
\strictiff
\succeqq
\succneqq
\Swarrow
\varparallel
\varparallelinv
\VvDash

// 117000 - Arrow Symbols
\Downarrow
\downarrow
\hookleftarrow
\hookrightarrow
\leadsto
\Leftarrow
\leftarrow
\leftharpoondown
\leftharpoonup
\Leftrightarrow
\leftrightarrow
\longleftarrow
\Longleftarrow
\longleftrightarrow
\Longleftrightarrow
\longmapsto
\longrightarrow
\Longrightarrow
\mapsto
\nearrow
\nwarrow
\rightarrow
\Rightarrow
\rightharpoondown
\rightharpoonup
\rightleftharpoons
\searrow
\swarrow
\uparrow
\Uparrow
\Updownarrow
\updownarrow

// 117500 - AMS Arrows
\circlearrowleft
\circlearrowright
\curvearrowleft
\curvearrowright
\dashleftarrow
\dashrightarrow
\downdownarrows
\downharpoonleft
\downharpoonright
\leftarrowtail
\leftleftarrows
\leftrightarrows
\leftrightharpoons
\leftrightsquigarrow
\Lleftarrow
\looparrowleft
\looparrowright
\Lsh
\multimap
\rightarrowtail
\rightleftarrows
\rightleftharpoons
\rightrightarrows
\rightsquigarrow
\Rsh
\twoheadleftarrow
\twoheadrightarrow
\upharpoonleft
\upharpoonright
\upuparrows

// 118000 - AMS Negated Arrows
\nLeftarrow
\nleftarrow
\nLeftrightarrow
\nleftrightarrow
\nRightarrow
\nrightarrow

// 118500 - stmaryrd Arrows
\leftarrowtriangle
\leftrightarroweq
\leftrightarrowtriangle
\lightning
\Longmapsfrom
\longmapsfrom
\Longmapsto
\Mapsfrom
\mapsfrom
\Mapsto
\nnearrow
\nnwarrow
\rightarrowtriangle
\rrparenthesis
\shortdownarrow
\shortleftarrow
\shortuparrow
\shortrightarrow
\shortuparrow
\ssearrow
\sswarrow

// 119000 - Log-like Symbols
\arccos
\arcsin
\arctan
\arg
\cos
\cosh
\cot
\coth
\csc
\deg
\det
\dim
\exp
\gcd
\hom
\inf
\ker
\lg
\lim
\liminf
\limsup
\ln
\log
\max
\min
\Pr
\sec
\sin
\sinh
\sup
\tan
\tanh

// 119500 - AMS Log-like Symbols
\injlim
\projlim
\varinjlim
\varliminf
\varlimsup
\varprojlim

// 120000 - Greek Letters
\alpha
\beta
\gamma
\delta
\epsilon
\varepsilon
\zeta
\eta
\theta
\vartheta
\iota
\kappa
\lambda
\mu
\nu
\xi
\pi
\varpi
\rho
\varrho
\sigma
\varsigma
\tau
\upsilon
\phi
\varphi
\chi
\psi
\omega
\Gamma
\Delta
\Theta
\Lambda
\Xi
\Pi
\Sigma
\Upsilon
\Phi
\Psi
\Omega

// 120500 - AMS Greek Letters
\digamma
\varkappa

// 121000 - txfonts/pxfonts Upright Greek Letters
\alphaup
\betaup
\gammaup
\deltaup
\epsilonup
\varepsilonup
\zetaup
\etaup
\thetaup
\varthetaup
\iotaup
\kappaup
\lambdaup
\muup
\muup
\nuup
\xiup
\piup
\varpiup
\rhoup
\varrhoup
\sigmaup
\varsigmaup
\tauup
\upsilonup
\phiup
\varphiup
\chiup
\psiup
\omegaup

// 121500 - txfonts/pxfonts Variant Latin Letters
\varg
\varv
\varw
\vary

// 122000 - AMS Hebrew Letters
\beth
\daleth
\gimel

// 122500 - Variable-sized Delimiters
(
[
\{
\lfloor
\langle
|
)
]
\}
\rfloor
\rangle
\|
\uparrow
\downarrow
\updownarrow
\lceil
/
\Uparrow
\Downarrow
\Updownarrow
\rceil
\backslash

// 123000 - Large, Variable-sized Delimiters
\rmoustache
\arrowvert
\lmoustache
\Arrowvert
\rgroup
\bracevert
\lgroup

// 123500 - AMS Delimiters
\ulcorner
\urcorner
\llcorner
\lrcorner

// 124000 - stmaryrd Delimiters
\Lbag
\llceil
\llparenthesis
\Rbag
\rrceil
\rrparenthesis
\lbag
\llfloor
\rbag
\rrfloor

// 124500 - Variable-sized stmaryrd Delimiters
\llbracket
\rrbracket

// 125000 - textcomp Text-Mode Delimiters
\textlangle
\textlbrackdbl
\textlquill
\textrangle
\textrbrackdbl
\textrquill

// 125500 - Math-Mode Accents
\acute
\bar
\breve
\check
\ddot
\dot
\grave
\hat
\tilde
\vec

// 126000 - Some Other Constructions
\widetilde
\overleftarrow
\overline
\overbrace
\sqrt
f
\widehat
\overrightarrow
\underline
\underbrace
\sqrt
\frac

// 126500 - AMS Extensible Arrow Accents
\overleftarrow
\underleftarrow
\overrightarrow
\underrightarrow
\overleftrightarrow
\underleftrightarrow

// 127000 - Punctuation Symbols (Math Mode)
,
;
\colon
\ldotp
\cdotp

// 127500 - Miscellaneous LaTeX2e Symbols
\aleph
\angle
\backslash
\bot
\Box
\cdots
\clubsuit
\ddots
\Diamond
\diamondsuit
\ell
\emptyset
\exists
\flat
\forall
\hbar
\heartsuit
\Im
\imath
\infty
\jmath
\ldots
\mho
\nabla
\natural
\neg
\partial
\prime
\Re
\sharp
\spadesuit
\surd
\top
\triangle
\vdots
\wp

// 128000 - Miscellaneous AMS Symbols
\angle
\backprime
\Bbbk
\bigstar
\blacklozenge
\blacksquare
\blacktriangle
\blacktriangledown
\circledS
\complement
\diagdown
\diagup
\eth
\Finv
\Game
\hbar
\hslash
\lozenge
\measuredangle
\mho
\nexists
\sphericalangle
\square
\triangledown
\varnothing
\vartriangle

// 128500 - AMS Commands Defined to Work in Both Math and Text Mode
\checkmark
\circledR
\maltese

// 129000 - stmaryrd Extensiton Characters
\Arrownot
\arrownot
\Mapsfromchar
\mapsfromchar
\Mapstochar

// 129500 - Other wasysym Math-Mode Symbols
\apprge
\apprle
\Box
\Diamond
\invneg
\Join
\leadsto
\lhd
\LHD
\logof
\mho
\ocircle
\rhd
\RHD
\sqsubset
\sqsupset
\unlhd
\unrhd
\wasypropto

// 130000 - Miscellaneous txfonts/pxfonts Symbols
\Diamondblack
\Diamonddot
\lambdabar
\lambdaslash
\mathcent
\mathsterling
\varclubsuit
\vardiamondsuit
\varheartsuit
\varspadesuit

// 130500 - textcomp Text-Mode Math and Science Symbols
\textcelsius
\textdegree
\textdiv
\textdownarrow
\textfractionsolidus
\textleftarrow
\textlnot
\textmho
\textminus
\textmu
\textohm
\textonehalf
\textonequarter
\textonesuperior
\textpm
\textrightarrow
\textsurd
\textthreequarters
\textthreesuperior
\texttimes
\texttwosuperior
\textuparrow

// 131000 - marvosym Math Symbols
\MVZero
\MVOne
\MVTwo
\MVThree
\MVFour
\MVFive
\MVSix
\MVSeven
\MVEight
\MVNine
\Anglesign
\Corresponds
\Squaredot
\Vectorarrow
\Vectorarrowhigh

// 131500 - ar Aspect Ratio Symbol
\AR

// 132000 - ulsy Contradiction and Other Symbols
\blitza
\blitzb
\blitzc
\blitzd
\blitze
\odplus

// 132500 - Math Alphabets
\mathrm
\mathit
\mathnormal
\mathcal
\mathscr
\mathcal
\mathpzc
\mathbb
\varmathbb
\mathbb
\mathbbm
\mathbbmss
\mathbbmtt
\mathds
\mathds
\mathfrak
\textfrak
\textswab

// 133000 - wasysym Electrical and Physical Symbols
\AC
\VHF
\photon
\HF
\gluon

// 133500 - ifsym Pulse Diagram Symbols
\FallingEdge
\LongPulseHigh
\LongPulseLow
\PulseHigh
\PulseLow
\RaisingEdge
\ShortPulseHigh
\ShortPulseLow

// 134000 - wasysym Astronomical Symbols
\ascnode
\astrosun
\descnode
\earth
\fullmoon
\jupiter
\leftmoon
\mars
\mercury
\neptune
\newmoon
\pluto
\rightmoon
\saturn
\uranus
\venus
\vernal

// 134500 - marvosym Astronomical Symbols
\Mercury
\Venus
\Earth
\Mars
\Jupiter
\Saturn
\Uranus
\Neptune
\Pluto
\Sun
\Moon

// 135000 - wasysym Astrological Symbols
\aries
\taurus
\gemini
\cancer
\leo
\virgo
\libra
\scorpio
\sagittarius
\capricornus
\aquarius
\pisces
\conjunction
\opposition

// 135500 - marvosym Astrological Symbols
\Aries
\Taurus
\Gemini
\Cancer
\Leo
\Virgo
\Libra
\Scorpio
\Sagittarius
\Capricorn
\Aquarius
\Pisces

// 136000 - wasysym APL Symbols
\APLbox
\APLcomment
\APLdown
\APLdownarrowbox
\APLinput
\APLinv
\APLleftarrowbox
\APLlog
\APLminus
\APLrightarrowbox
\APLstar
\APLup
\APLuparrowbox
\notbackslash
\notslash

// 136500 - wasysym APL Modifiers
\APLcirc{}
\APLnot{}
\APLvert{}

// 137000 - marvosym Computer Hardware Symbols
\ComputerMouse
\Keyboard
\ParallelPort
\Printer
\SerialInterface
\SerialPort

// 137500 - ASCII COntrol Characters (IBM)
\SOH
\STX
\ETX
\EOT
\ENQ
\ACK
\BEL
\BS
\HT
\LF
\VT
\FF
\CR
\SO
\SI
\DLE
\DCa
\DCb
\DCc
\DCd
\NAK
\SYN
\ETB
\CAN
\EM
\SUB
\ESC
\FS
\GS
\RS
\US
\splitvert
\DEL

// 138000 - marvosym Communication Symbols
\Email
\Emailct
\fax
\FAX
\Faxmachine
\Letter
\Lightning
\Mobilefone
\Pickup
\Telefon

// 138500 - marvosym Engineering Symbols
\Beam
\Bearing
\Circpipe
\Circsteel
\Fixedbearing
\Flatsteel
\Force
\Hexasteel
\Lefttorque
\Lineload
\Loosebearing
\Lsteel
\Octosteel
\Rectpipe
\Rectsteel
\Righttorque
\RoundedLsteel
\RoundedTsteel
\RoundedTTsteel
\Squarepipe
\Squaresteel
\Tsteel
\TTsteel

// 139000 - marvosym Biological Symbols
\Female
\FEMALE
\FemaleFemale
\FemaleMale
\Hermaphrodite
\HERMAPHRODITE
\MALE
\Male
\MaleMale
\Neutral

// 139500 - marvosym Safety-Related Symbols
\Biohazard
\BSEfree
\CEsign
\Estatically
\Explosionsafe
\Laserbeam
\Radioactivity
\Stopsign

// 140000 - bbding Arrows
\ArrowBoldDownRight
\ArrowBoldRightCircled
\ArrowBoldRightShort
\ArrowBoldRightStrobe
\ArrowBoldUpRight

// 140500 - pifont Arrows
\ding{212}
\ding{213}
\ding{214}
\ding{215}
\ding{216}
\ding{217}
\ding{218}
\ding{219}
\ding{220}
\ding{221}
\ding{222}
\ding{223}
\ding{224}
\ding{225}
\ding{226}
\ding{227}
\ding{228}
\ding{229}
\ding{230}
\ding{231}
\ding{232}
\ding{233}
\ding{234}
\ding{235}
\ding{236}
\ding{237}
\ding{238}
\ding{239}
\ding{241}
\ding{242}
\ding{243}
\ding{244}
\ding{245}
\ding{246}
\ding{247}
\ding{248}
\ding{249}
\ding{250}
\ding{251}
\ding{252}
\ding{253}
\ding{254}

// 141000 - marvosym Scissors
\Cutleft
\Cutline
\Cutright
\Kutline
\Leftscissors
\Rightscissors

// 141500 - bbding Scissors
\ScissorHollowLeft
\ScissorHollowRight
\ScissorLeft
\ScissorLeftBrokenBottom
\ScissorLeftBrokenTop
\ScissorRight
\ScissorRightBrokenBottom
\ScissorRightBrokenTop

// 142000 - pifont Scissors
\ding{33}
\ding{34}
\ding{35}
\ding{36}

// 142500 - dingbat Pencils
\largepencil
\smallpencil

// 143000 - bbding Pencils and Nibs
\NibLeft
\NibRight
\NibSolidLeft
\NibSolidRight
\PencilLeft
\PencilLeftDown
\PencilLeftUp
\PencilRight
\PencilRightDown
\PencilRightUp

// 143500 - pifont Pencils and Nibs
\ding{46}
\ding{47}
\ding{48}
\ding{49}
\ding{50}

// 144000 - dingbat Hands
\leftpointright
\leftthumbsdown
\leftthumbsup
\rightpointleft
\rightthumbsdown
\rightthumbsup
\rightpointright

// 144500 - bbding Hands
\HandCuffLeft
\HandCuffLeftUp
\HandCuffRight
\HandCuffRightUp
\HandLeft
\HandLeftUp
\HandPencilLeft
\HandRight
\HandRightUp

// 145000 - pifont Hands
\ding{42}
\ding{43}
\ding{44}
\ding{45}

// 145500 - bbding Crosses and Plusses
\Cross
\CrossBoldOutline
\CrossClowerTips
\CrossMaltese
\CrossOpenShadow
\CrossOutline
\Plus
\PlusCenterOpen
\PlusOutline
\PlusThinCenterOpen

// 146000 - pifont Crosses and Plusses 
\ding{57}
\ding{58}
\ding{59}
\ding{60}
\ding{61}
\ding{62}
\ding{63}
\ding{64}

// 146500 - bbding Xs and Check Marks
\Checkmark
\CheckmarkBold
\XSolid
\XSolidBold
\XSolidBrush

// 147000 - pifont Xs and Check Marks
\ding{51}
\ding{52}
\ding{53}
\ding{54}
\ding{55}
\ding{56}

// 147500 - wasysym Xs and Check Marks
\CheckedBox
\Square
\XBox

// 148000 - pifont Circled Numbers
\ding{172}
\ding{173}
\ding{174}
\ding{175}
\ding{176}
\ding{177}
\ding{178}
\ding{179}
\ding{180}
\ding{181}
\ding{182}
\ding{183}
\ding{184}
\ding{185}
\ding{186}
\ding{187}
\ding{188}
\ding{189}
\ding{190}
\ding{191}
\ding{192}
\ding{193}
\ding{194}
\ding{195}
\ding{196}
\ding{197}
\ding{198}
\ding{199}
\ding{200}
\ding{201}
\ding{202}
\ding{203}
\ding{204}
\ding{205}
\ding{206}
\ding{207}
\ding{208}
\ding{209}
\ding{210}
\ding{211}

// 148500 - wasysym Stars
\davidsstar
\hexstar
\varhexstar

// 149000 - bbding Stars, Flowers, and Similar Shapes
\Asterisk
\AsteriskBold
\AsteriskCenterOpen
\AsteriskRoundedEnds
\AsteriskThin
\AsteriskThinCenterOpen
\DavidStar
\DavidStarSolid
\EightAsterisk
\EightFlowerPetal
\EightFlowerPetalRemoved
\EightStar
\EightStarBold
\EightStarConvex
\EightStarTaper
\FiveFlowerOpen
\FiveFlowerPetal
\FiveStar
\FiveStarCenterOpen
\FiveStarConvex
\FiveStarLines
\FiveStarOpen
\FiveStarOpenCircled
\FiveStarOpenDotted
\FiveStarOutline
\FiveStarOutlineHeavy
\FiveStarShadow
\FourAsterisk
\FourClowerOpen
\FourClowerSolid
\FourStar
\FourStarOpen
\JackStar
\JackStarBold
\SixFlowerAlternate
\SixFlowerAltPetal
\SixFlowerOpenCenter
\SixFlowerPetalDotted
\SixFlowerPetalRemoved
\SixFlowerRemovedOpenPetal
\SixStar
\SixteenStarLight
\Snowflake
\SnowflakeChevron
\SnowflakeChevronBold
\Sparkle
\SparkleBold
\TwelweStar

// 149500 - pifont Stars, Flowers, and Similar Shapes
\ding{65}
\ding{66}
\ding{67}
\ding{68}
\ding{69}
\ding{70}
\ding{71}
\ding{72}
\ding{73}
\ding{74}
\ding{75}
\ding{76}
\ding{77}
\ding{78}
\ding{79}
\ding{80}
\ding{81}
\ding{82}
\ding{83}
\ding{84}
\ding{85}
\ding{86}
\ding{87}
\ding{88}
\ding{89}
\ding{90}
\ding{91}
\ding{92}
\ding{93}
\ding{94}
\ding{95}
\ding{96}
\ding{97}
\ding{98}
\ding{99}
\ding{100}
\ding{101}
\ding{102}
\ding{103}
\ding{104}
\ding{105}
\ding{106}
\ding{107}

// 150000 - wasysym Geometric Shapes
\hexagon
\octagon
\pentagon
\varhexagon

// 150500 - ifsym Geometric Shapes
\BigCircle
\BigCross
\BigDiamondshape
\BigHBar
\BigLowerDiamond
\BigRightDiamond
\BigSquare
\BigTriangleDown
\BigTriangleLeft
\BigTriangleRight
\BigTriangleUp
\BigVBar
\Circle
\Cross
\DiamondShadowA
\DiamondShadowB
\DiamondShadowC
\Diamondshape
\FilledBigCircle
\FilledBigDiamondshape
\FilledBigSquare
\FilledBigTriangleDown
\FilledBigTriangleLeft
\FilledBigTriangleRight
\FilledBigTriangleUp
\FilledCircle
\FilledDiamondShadowA
\FilledDiamondShadowC
\FilledDiamondshape
\FilledSmallCircle
\FilledSmallDiamondshape
\FilledSmallSquare
\FilledSmallTriangleDown
\FilledSmallTriangleLeft
\FilledSmallTriangleRight
\FilledSmallTriangleUp
\FilledSquare
\FilledSquareShadowA
\FilledSquareShadowC
\FilledTriangleDown
\FilledTriangleLeft
\FilledTriangleRight
\FilledTriangleUp
\HBar
\LowerDiamond
\RightDiamond
\SmallCircle
\SmallCross
\SmallDiamondshape
\SmallHBar
\SmallLowerDiamond
\SmallRightDiamond
\SmallSquare
\SmallTriangleDown
\SmallTriangleLeft
\SmallTriangleRight
\SmallTriangleUp
\SmallVBar
\SpinDown
\SpinUp
\Square
\SquareShadowA
\SquareShadowB
\SquareShadowC
\TriangleDown
\TriangleLeft
\TriangleRight
\TriangleUp
\VBar

// 151000 - bbding Geometric Shapes
\CircleShadow
\CircleSolid
\DiamondSolid
\Ellipse
\EllipseShadow
\EllipseSolid
\HalfCircleLeft
\HalfCircleRight
\Rectangle
\RectangleBold
\RectangleThin
\Square
\SquareCastShadowBottomRight
\SquareCastShadowTopLeft
\SquareCastShadowTopRight
\SquareShadowBottomRight
\SquareShadowTopLeft
\SquareShadowTopRight
\SquareSolid
\TriangleDown
\TriangleUp

// 151500 - pifont Geometric Shapes
\ding{108}
\ding{109}
\ding{110}
\ding{111}
\ding{112}
\ding{113}
\ding{114}
\ding{115}
\ding{116}
\ding{117}
\ding{119}
\ding{120}
\ding{121}
\ding{122}

// 152000 - manfnt Dangerous Bend Symbols
\dbend
\lhdbend
\reversedvideodbend

// 152500 - marvosym Information Symbols
\Bicycle
\Checkedbox
\Clocklogo
\Coffeecup
\Crossedbox
\Football
\Gentsroom
\Industry
\Info
\Ladiesroom
\Pointinghand
\Wheelchair
\Writinghand

// 153000 - Miscellaneous dingbat Dingbats
\anchor
\carriagereturn
\checkmark
\eye
\filledsquarewithdots
\satellitedish
\Sborder
\squarewithdots
\Zborder

// 153500 - Miscellaneous bbding Dingbats
\Envelope
\OrnamentDiamondSolid
\Peace
\Phone
\PhoneHandset
\Plane
\SunshineOpenCircled
\Tape

// 154000 - Miscellaneous pifont Dingbats
\ding{37}
\ding{38}
\ding{39}
\ding{40}
\ding{41}
\ding{118}
\ding{164}
\ding{165}
\ding{166}
\ding{167}
\ding{168}
\ding{170}
\ding{171}
\ding{169}

// 154500 - textcomp Genealogical Symbols
\textborn
\textdied
\textdivorced
\textleaf
\textmarried

// 155000 - wasysym General Symbols
\agemO
\ataribox
\bell
\blacksmiley
\Bowtie
\brokenvert
\cent
\checked
\clock
\currency
\diameter
\DOWNarrow
\female
\frownie
\invdiameter
\kreuz
\LEFTarrow
\lightning
\male
\permil
\phone
\pointer
\recorder
\RIGHTarrow
\smiley
\sun
\UParrow
\varangle
\wasylozenge
\wasytherefore

// 155500 - wasysym Musical Notes
\eighthnote
\halfnote
\twonotes
\fullnote
\quarternote

// 156000 - wasysym Circles
\CIRCLE
\Circle
\LEFTCIRCLE
\LEFTcircle
\Leftcircle
\RIGHTCIRCLE
\RIGHTcircle
\Rightcircle
\leftturn
\rightturn

// 156500 - Miscellaneous manfnt Symbols
\manboldkidney
\manconcentriccircles
\manconcentricdiamond
\mancone
\mancube
\manerrarrow
\manfilledquartercircle
\manhpennib
\manimpossiblecube
\mankidney
\manlhpenkidney
\manpenkidney
\manquadrifolium
\manquartercircle
\manrotatedquadrifolium
\manrotatedquartercircle
\manstar
\mantiltpennib
\mantriangledown
\mantriangleright
\mantriangleup
\manvpennib

// 157000 - marvosym Navigation Symbols
\Forward
\ForwardToEnd
\ForwardToIndex
\MoveDown
\MoveUp
\Rewind
\RewindToIndex
\RewindToStart
\ToBottom
\ToTop

// 157500 - marvosym Laundry Symbols
\AtForty
\AtNinetyFive
\AtSixty
\Bleech
\CleaningA
\CleaningF
\CleaningFF
\CleaningP
\CleaningPP
\Dontwash
\Handwash
\IroningI
\IroningII
\IroningIII
\NoBleech
\NoChemicalCleaning
\NoIroning
\NoTumbler
\ShortFifty
\ShortForty
\ShortNinetyFive
\ShortSixty
\ShortThirty
\SpecialForty
\Tumbler
\WashCotton
\WashSynthetics
\WashWool

// 158000 - Other marvosym Symbols
\Ankh
\Bat
\Bouquet
\Celtcross
\CircledA
\Cross
\FHBOlogo
\FHBOLOGO
\Frowny
\FullFHBO
\Heart
\MartinVogel
\Mundus
\MVAt
\Rightarrow
\Smiley
\Womanface
\Yinyang

// 158500 - ifsym Weather Symbols
\Blitz
\Cloud
\FilledCloud
\FilledRainCloud
\FilledSnowCloud
\FilledSunCloud
\FilledWeakRainCloud
\Fog
\Graupel
\Hagel
\HalfSun
\NoSun
\Rain
\RainCloud
\Snow
\SnowCloud
\Sun
\SunCloud
\ThinFog
\WeakRain
\WeakRainCloud
\Thermo{}

// 159000 - ifsym Alpine Symbols
\FilledHut
\Flag
\HalfFilledHut
\Hut
\IceMountain
\Joch
\Mountain
\StoneMan
\Summit
\SummitSign
\Tent
\VarFlag
\VarIceMountain
\VarMountain
\VarSummit
\Vermessung
\Village

// 159500 - ifsym Clocks
\Interval
\StopWatchEnd
\StopWatchStart
\Taschenuhr
\VarClock
\VarTaschenuhr
\Wecker
\showclock{}{}

// 160000 - Other ifsym Symbols
\FilledSectioningDiamond
\Fire
\Irritant
\Letter
\PaperLandscape
\PaperPortrait
\Radiation
\SectioningDiamond
\Telephone
\StrokeOne
\StrokeTwo
\StrokeThree
\StrokeFour
\StrokeFive
\Cube{1}
\Cube{2}
\Cube{3}
\Cube{4}
\Cube{5}
\Cube{6}


// [hints] - sekcja okrela hinty dla danych sw kluczowych, oczywicie hint to dowolny multitext
// kada linia ma postac 'name=hint' gdzie 'name' to sowo dla ktrego definiujemy hint.
// No a 'hint' to hint, czyli dowolny multitext.
[hints]
// 100500 - Commands to work in math and text mode
\$=/l100501/l
\P=/l100502/l
\S=/l100503/l
\_=/l100504/l
\copyright=/l100505/l
\dag=/l100506/l
\ddag=/l100507/l
\dots=/l100508/l
\pounds=/l100509/l
\{=/l100510/l
\}=/l100511/l

// 101000 - Predefined LaTeX2e Text-Mode Comands
\textasciicircum=/l101001/l
\textasciitilde=/l101002/l
\textasteriskcentered=/l101003/l
\textbackslash=/l101004/l
\textbar=/l101005/l
\textbraceleft=/l101006/l
\textbraceright=/l101007/l
\textbullet=/l101008/l
\textcopyright=/l101009/l
\textdagger=/l101010/l
\textdaggerdbl=/l101011/l
\textdollar=/l101012/l
\textellipsis=/l101013/l
\textemdash=/l101014/l
\textendash=/l101015/l
\textexclamdown=/l101016/l
\textgreater=/l101017/l
\textless=/l101018/l
\textordfeminine=/l101019/l
\textordmasculine=/l101020/l
\textparagraph=/l101021/l
\textperiodcentered=/l101022/l
\textquestiondown=/l101023/l
\textquotedblleft=/l101024/l
\textquotedblright=/l101025/l
\textquoteleft=/l101026/l
\textquoteright=/l101027/l
\textregistered=/l101028/l
\textsection=/l101029/l
\textsterling=/l101030/l
\texttrademark=/l101031/l
\textunderscore=/l101032/l
\textvisiblespace=/l101033/l

// 101500 - Non-ASCII Letters (Excluding Accented Letters)
\aa=/l101501/l
\AA=/l101502/l
\AE=/l101503/l
\ae=/l101504/l
\DH=/l101505/l
\dh=/l101506/l
\DJ=/l101507/l
\dj=/l101508/l
\L=/l101509/l
\l=/l101510/l
\NG=/l101511/l
\ng=/l101512/l
\o=/l101513/l
\O=/l101514/l
\OE=/l101515/l
\oe=/l101516/l
\ss=/l101517/l
\SS=/l101518/l
\TH=/l101519/l
\th=/l101520/l

// 102000 - Letters Used to Typeset Affrican Languages
\B{D}=/l102001/l
\B{d}=/l102002/l
\B{H}=/l102003/l
\B{h}=/l102004/l
\B{t}=/l102005/l
\B{T}=/l102006/l
\m{b}=/l102007/l
\m{B}=/l102008/l
\m{C}=/l102009/l
\m{c}=/l102010/l
\m{D}=/l102011/l
\M{d}=/l102012/l
\M{D}=/l102013/l
\m{d}=/l102014/l
\m{E}=/l102015/l
\m{e}=/l102016/l
\M{E}=/l102017/l
\M{e}=/l102018/l
\m{f}=/l102019/l
\m{F}=/l102020/l
\m{G}=/l102021/l
\m{g}=/l102022/l
\m{I}=/l102023/l
\m{i}=/l102024/l
\m{J}=/l102025/l
\m{j}=/l102026/l
\m{K}=/l102027/l
\m{k}=/l102028/l
\m{N}=/l102029/l
\m{n}=/l102030/l
\m{o}=/l102031/l
\m{O}=/l102032/l
\m{P}=/l102033/l
\m{p}=/l102034/l
\m{s}=/l102035/l
\m{S}=/l102036/l
\M{t}=/l102037/l
\M{T}=/l102038/l
\m{t}=/l102039/l
\m{T}=/l102040/l
\m{u}=/l102041/l
\m{U}=/l102042/l
\m{Y}=/l102043/l
\m{y}=/l102044/l
\m{z}=/l102045/l
\m{Z}=/l102046/l
\T{E}=/l102047/l
\T{e}=/l102048/l
\T{O}=/l102049/l
\T{o}=/l102050/l

// 102500 - Punctuation Marks Not Found in OT1
\guillemotleft=/l102501/l
\guillemotright=/l102502/l
\guilsinglleft=/l102503/l
\guilsinglright=/l102504/l
\quotedblbase=/l102505/l
\quotesinglbase=/l102506/l
\textquotedbl=/l102507/l

// 103000 - pifont Decorative Punctuation Marks
\ding{123}=/l103001/l
\ding{124}=/l103002/l
\ding{125}=/l103003/l
\ding{126}=/l103004/l
\ding{161}=/l103005/l
\ding{162}=/l103006/l
\ding{163}=/l103007/l

// 103500 - Text-Mode Accents
\"=/l103501/l
\"=/l103502/l
\=/l103503/l
\=/l103504/l
\.=/l103505/l
\.=/l103506/l
\/==/l103507/l
\/==/l103508/l
\^=/l103509/l
\^=/l103510/l
\newtie=/l103511/l
\newtie=/l103512/l
\=/l103513/l
\=/l103514/l
\b=/l103515/l
\b=/l103516/l
\c=/l103517/l
\c=/l103518/l
\d=/l103519/l
\d=/l103520/l
\G=/l103521/l
\G=/l103522/l
\H=/l103523/l
\H=/l103524/l
\k=/l103525/l
\k=/l103526/l
\r=/l103527/l
\r=/l103528/l
\t=/l103529/l
\t=/l103530/l
\U=/l103531/l
\U=/l103532/l
\u=/l103533/l
\u=/l103534/l
\v=/l103535/l
\v=/l103536/l
\~=/l103537/l
\~=/l103538/l

// 104000 - tipa Text-Mode Accents
\textacutemacron{A}=/l104001/l
\textacutemacron{a}=/l104002/l
\textacutewedge{A}=/l104003/l
\textacutewedge{a}=/l104004/l
\textadvancing{A}=/l104005/l
\textadvancing{A}=/l104006/l
\textbottomtiebar{A}=/l104007/l
\textbottomtiebar{a}=/l104008/l
\textbrevemacron{A}=/l104009/l
\textbrevemacron{a}=/l104010/l
\textcircumacute{A}=/l104011/l
\textcircumacute{a}=/l104012/l
\textcircumdot{A}=/l104013/l
\textcircumdot{a}=/l104014/l
\textdotacute{A}=/l104015/l
\textdotacute{a}=/l104016/l
\textdotbreve{A}=/l104017/l
\textdotbreve{a}=/l104018/l
\textdoublegrave{A}=/l104019/l
\textdoublegrave{a}=/l104020/l
\textdoublevbaraccent{A}=/l104021/l
\textdoublevbaraccent{a}=/l104022/l
\textgravecircum{A}=/l104023/l
\textgravecircum{a}=/l104024/l
\textgravedot{A}=/l104025/l
\textgravedot{a}=/l104026/l
\textgravemid{A}=/l104027/l
\textgravemid{a}=/l104028/l
\textinvsubbridge{A}=/l104029/l
\textinvsubbridge{a}=/l104030/l
\textlowering{A}=/l104031/l
\textlowering{a}=/l104032/l
\textmidacute{A}=/l104033/l
\textmidacute{a}=/l104034/l
\textovercross{A}=/l104035/l
\textovercross{a}=/l104036/l
\textoverw{A}=/l104037/l
\textoverw{a}=/l104038/l
\textpolhook{A}=/l104039/l
\textpolhook{a}=/l104040/l
\textraising{A}=/l104041/l
\textraising{a}=/l104042/l
\textretracting{A}=/l104043/l
\textretracting{a}=/l104044/l
\textringmacron{A}=/l104045/l
\textringmacron{a}=/l104046/l
\textroundcap{A}=/l104047/l
\textroundcap{a}=/l104048/l
\textseagull{A}=/l104049/l
\textseagull{a}=/l104050/l
\textsubarch{A}=/l104051/l
\textsubarch{a}=/l104052/l
\textsubbar{A}=/l104053/l
\textsubbar{a}=/l104054/l
\textsubbridge{A}=/l104055/l
\textsubbridge{a}=/l104056/l
\textsubdot{A}=/l104057/l
\textsubdot{a}=/l104058/l
\textsublhalfring{A}=/l104059/l
\textsublhalfring{a}=/l104060/l
\textsubplus{A}=/l104061/l
\textsubplus{a}=/l104062/l
\textsubrhalfring{A}=/l104063/l
\textsubrhalfring{a}=/l104064/l
\textsubring{A}=/l104065/l
\textsubring{a}=/l104066/l
\textsubsquare{A}=/l104067/l
\textsubsquare{a}=/l104068/l
\textsubtilde{A}=/l104069/l
\textsubtilde{a}=/l104070/l
\textsubumlaut{A}=/l104071/l
\textsubumlaut{a}=/l104072/l
\textsubw{A}=/l104073/l
\textsubw{a}=/l104074/l
\textsubwedge{A}=/l104075/l
\textsubwedge{a}=/l104076/l
\textsuperimposetilde{A}=/l104077/l
\textsuperimposetilde{a}=/l104078/l
\textsyllabic{A}=/l104079/l
\textsyllabic{a}=/l104080/l
\texttildedot{A}=/l104081/l
\texttildedot{a}=/l104082/l
\texttoptiebar{A}=/l104083/l
\texttoptiebar{a}=/l104084/l
\textvbaraccent{A}=/l104085/l
\textvbaraccent{a}=/l104086/l

// 104500 - wsuipa Text-Mode Accents
\dental{A}=/l104501/l
\dental{a}=/l104502/l
\underarch{A}=/l104503/l
\underarch{a}=/l104504/l

// 105000 - wsuipa Diacritics
\ain=/l105001/l
\corner=/l105002/l
\downp=/l105003/l
\downp=/l105004/l
\halflength=/l105005/l
\leftp=/l105006/l
\leftt=/l105007/l
\length=/l105008/l
\midtilde=/l105009/l
\open=/l105010/l
\overring=/l105011/l
\polishhook=/l105012/l
\rightp=/l105013/l
\rightt=/l105014/l
\secstress=/l105015/l
\stress=/l105016/l
\syllabic=/l105017/l
\underdots=/l105018/l
\underring=/l105019/l
\undertilde=/l105020/l
\underwedge=/l105021/l
\upp=/l105022/l
\upt=/l105023/l

// 105500 - textcomp Diacritics
\textacutedbl=/l105501/l
\textasciiacute=/l105502/l
\textasciibreve=/l105503/l
\textasciicaron=/l105504/l
\textasciidieresis=/l105505/l
\textasciigrave=/l105506/l
\textasciimacron=/l105507/l
\textgravedbl=/l105508/l
\texttildelow=/l105509/l

// 106000 - textcomp Currency Symbols
\textbaht=/l106001/l
\textcent=/l106002/l
\textcentoldstyle=/l106003/l
\textcolonmonetary=/l106004/l
\textcurrency=/l106005/l
\textdollar=/l106006/l
\textdollaroldstyle=/l106007/l
\textdong=/l106008/l
\texteuro=/l106009/l
\textflorin=/l106010/l
\textguarani=/l106011/l
\textlira=/l106012/l
\textnaira=/l106013/l
\textpeso=/l106014/l
\textsterling=/l106015/l
\textwon=/l106016/l
\textyen=/l106017/l

// 106500 - marvosym Currency Symbols
\Denarius=/l106501/l
\Ecommerce=/l106502/l
\EUR=/l106503/l
\EURcr=/l106504/l
\EURdig=/l106505/l
\EURhv=/l106506/l
\EURtm=/l106507/l
\EyesDollar=/l106508/l
\Pfund=/l106509/l
\Shilling=/l106510/l

// 107000 - textcomp Legal Symbols
\textcircledP=/l107001/l
\textcopyleft=/l107002/l
\textcopyright=/l107003/l
\textregistered=/l107004/l
\textservicemark=/l107005/l
\texttrademark=/l107006/l

// 107500 - textcomp Old-Style Numerals
\textzerooldstyle=/l107501/l
\textoneoldstyle=/l107502/l
\texttwooldstyle=/l107503/l
\textthreeoldstyle=/l107504/l
\textfouroldstyle=/l107505/l
\textfiveoldstyle=/l107506/l
\textsixoldstyle=/l107507/l
\textsevenoldstyle=/l107508/l
\texteightoldstyle=/l107509/l
\textnineoldstyle=/l107510/l

// 108000 - wasysym Phonetic Symbols
\DH=/l108001/l
\Thorn=/l108002/l
\dh=/l108003/l
\inve=/l108004/l
\openo=/l108005/l

// 108500 - tipa Phonetic Symbols
\textbabygamma=/l108501/l
\textbarb=/l108502/l
\textbarc=/l108503/l
\textbard=/l108504/l
\textbardotlessj=/l108505/l
\textbarg=/l108506/l
\textglotstop=/l108507/l
\texthalflength=/l108508/l
\texthardsign=/l108509/l
\texthooktop=/l108510/l
\texthtb=/l108511/l
\texthtbardotlessj=/l108512/l
\textrtaill=/l108513/l
\textrtailn=/l108514/l
\textrtailr=/l108515/l
\textrtails=/l108516/l
\textrtailt=/l108517/l
\textrtailz=/l108518/l
\textbarglotstop=/l108519/l
\textbari=/l108520/l
\textbarl=/l108521/l
\textbaro=/l108522/l
\textbarrevglotstop=/l108523/l
\textbaru=/l108524/l
\textbeltl=/l108525/l
\textbeta=/l108526/l
\textbullseye=/l108527/l
\textceltpal=/l108528/l
\textchi=/l108529/l
\textcloseepsilon=/l108530/l
\textcloseomega=/l108531/l
\textcloserevepsilon=/l108532/l
\textcommatailz=/l108533/l
\textcorner=/l108534/l
\textcrb=/l108535/l
\textcrd=/l108536/l
\textcrg=/l108537/l
\textcrh=/l108538/l
\textcrinvglotstop=/l108539/l
\textcrlambda=/l108540/l
\textcrtwo=/l108541/l
\textctc=/l108542/l
\textctd=/l108543/l
\textctdctzlig=/l108544/l
\textctesh=/l108545/l
\textctj=/l108546/l
\textctn=/l108547/l
\textctt=/l108548/l
\textcttctclig=/l108549/l
\textctyogh=/l108550/l
\textctz=/l108551/l
\textdctzlig=/l108552/l
\textdoublebaresh=/l108553/l
\textdoublebarpipe=/l108554/l
\textdoublebarslash=/l108555/l
\textdoublepipe=/l108556/l
\textdoublevertline=/l108557/l
\textdownstep=/l108558/l
\textdyoghlig=/l108559/l
\textdzlig=/l108560/l
\textepsilon=/l108561/l
\textesh=/l108562/l
\textfishhookr=/l108563/l
\textg=/l108564/l
\textgamma=/l108565/l
\textglobfall=/l108566/l
\textglobrise=/l108567/l
\texthtc=/l108568/l
\texthtd=/l108569/l
\texthtg=/l108570/l
\texthth=/l108571/l
\texthtk=/l108572/l
\texthtp=/l108573/l
\texthtq=/l108574/l
\texthtscg=/l108575/l
\texthtt=/l108576/l
\texthvlig=/l108577/l
\textinvglotstop=/l108578/l
\textinvscr=/l108579/l
\textiota=/l108580/l
\textlambda=/l108581/l
\textlengthmark=/l108582/l
\textlhookt=/l108583/l
\textlhti=/l108584/l
\textlhtlongi=/l108585/l
\textlonglegr=/l108586/l
\textlptr=/l108587/l
\textltailm=/l108588/l
\textltailn=/l108589/l
\textltilde=/l108590/l
\textlyoghlig=/l108591/l
\textnrleg=/l108592/l
\textObardotlessj=/l108593/l
\textOlyoghlig=/l108594/l
\textomega=/l108595/l
\textopencorner=/l108596/l
\textopeno=/l108597/l
\textpalhook=/l108598/l
\textphi=/l108599/l
\textpipe=/l108600/l
\textprimstress=/l108601/l
\textraiseglotstop=/l108602/l
\textraisevibyi=/l108603/l
\textramshorns=/l108604/l
\textrectangle=/l108605/l
\textrevapostrophe=/l108606/l
\textreve=/l108607/l
\textrevepsilon=/l108608/l
\textrevglotstop=/l108609/l
\textrevyogh=/l108610/l
\textrhookrevepsilon=/l108611/l
\textrhookschwa=/l108612/l
\textrhoticity=/l108613/l
\textrptr=/l108614/l
\textrtaild=/l108615/l
\textrthook=/l108616/l
\textsca=/l108617/l
\textscb=/l108618/l
\textsce=/l108619/l
\textscg=/l108620/l
\textsch=/l108621/l
\textschwa=/l108622/l
\textsci=/l108623/l
\textscj=/l108624/l
\textscl=/l108625/l
\textscn=/l108626/l
\textscoelig=/l108627/l
\textscomega=/l108628/l
\textscq=/l108629/l
\textscr=/l108630/l
\textscripta=/l108631/l
\textscriptv=/l108632/l
\textscu=/l108633/l
\textscy=/l108634/l
\textsecstress=/l108635/l
\textsoftsign=/l108636/l
\textstretchc=/l108637/l
\texttctclig=/l108638/l
\textteshlig=/l108639/l
\texttheta=/l108640/l
\textthorn=/l108641/l
\texttslig=/l108642/l
\textturna=/l108643/l
\textturncelig=/l108644/l
\textturnh=/l108645/l
\textturnk=/l108646/l
\textturnlonglegr=/l108647/l
\textturnm=/l108648/l
\textturnmrleg=/l108649/l
\textturnr=/l108650/l
\textturnrrtail=/l108651/l
\textturnscripta=/l108652/l
\textturnt=/l108653/l
\textturnv=/l108654/l
\textturnw=/l108655/l
\textturny=/l108656/l
\textupsilon=/l108657/l
\textupstep=/l108658/l
\textvertline=/l108659/l
\textvibyi=/l108660/l
\textvibyy=/l108661/l
\textwynn=/l108662/l
\textyogh=/l108663/l

// 109000 - wsuipa Phonetic Symbols
\babygamma=/l109001/l
\barb=/l109002/l
\bard=/l109003/l
\bari=/l109004/l
\barl=/l109005/l
\baro=/l109006/l
\barp=/l109007/l
\barsci=/l109008/l
\barscu=/l109009/l
\baru=/l109010/l
\clickb=/l109011/l
\clickc=/l109012/l
\clickt=/l109013/l
\closedniomega=/l109014/l
\closedrevepsilon=/l109015/l
\crossb=/l109016/l
\crossd=/l109017/l
\crossh=/l109018/l
\crossnilambda=/l109019/l
\curlyc=/l109020/l
\curlyesh=/l109021/l
\curlyyogh=/l109022/l
\curlyz=/l109023/l
\dlbari=/l109024/l
\dz=/l109025/l
\ejective=/l109026/l
\eng=/l109027/l
\er=/l109028/l
\esh=/l109029/l
\eth=/l109030/l
\flapr=/l109031/l
\glotstop=/l109032/l
\hookb=/l109033/l
\hookg=/l109034/l
\hookh=/l109035/l
\hookheng=/l109036/l
\hookrevepsilon=/l109037/l
\hv=/l109038/l
\inva=/l109039/l
\invf=/l109040/l
\invglotstop=/l109041/l
\invh=/l109042/l
\invlegr=/l109043/l
\invm=/l109044/l
\invr=/l109045/l
\invscr=/l109046/l
\invscripta=/l109047/l
\invv=/l109048/l
\invw=/l109049/l
\invy=/l109050/l
\ipagamma=/l109051/l
\labdentalnas=/l109052/l
\latfric=/l109053/l
\legm=/l109054/l
\legr=/l109055/l
\lz=/l109056/l
\nialpha=/l109057/l
\nibeta=/l109058/l
\nichi=/l109059/l
\niepsilon=/l109060/l
\nigamma=/l109061/l
\niiota=/l109062/l
\nilambda=/l109063/l
\niomega=/l109064/l
\niphi=/l109065/l
\nisigma=/l109066/l
\nitheta=/l109067/l
\niupsilon=/l109068/l
\nj=/l109069/l
\oo=/l109070/l
\openo=/l109071/l
\reve=/l109072/l
\reveject=/l109073/l
\revepsilon=/l109074/l
\revglotstop=/l109075/l
\scd=/l109076/l
\scg=/l109077/l
\schwa=/l109078/l
\sci=/l109079/l
\scn=/l109080/l
\scr=/l109081/l
\scripta=/l109082/l
\scriptg=/l109083/l
\scriptv=/l109084/l
\scu=/l109085/l
\scy=/l109086/l
\slashb=/l109087/l
\slashc=/l109088/l
\slashd=/l109089/l
\slashu=/l109090/l
\taild=/l109091/l
\tailinvr=/l109092/l
\taill=/l109093/l
\tailn=/l109094/l
\tailr=/l109095/l
\tails=/l109096/l
\tailt=/l109097/l
\tailz=/l109098/l
\tesh=/l109099/l
\thorn=/l109100/l
\tildel=/l109101/l
\yogh=/l109102/l

// 109500 - Miscellaneous textcomp Symbols
\textasteriskcentered=/l109501/l
\textbardbl=/l109502/l
\textbigcircle=/l109503/l
\textblank=/l109504/l
\textbrokenbar=/l109505/l
\textbullet=/l109506/l
\textdagger=/l109507/l
\textdaggerdbl=/l109508/l
\textdblhyphen=/l109509/l
\textdblhyphenchar=/l109510/l
\textdiscount=/l109511/l
\textestimated=/l109512/l
\textinterrobang=/l109513/l
\textinterrobangdown=/l109514/l
\textmusicalnote=/l109515/l
\textnumero=/l109516/l
\textopenbullet=/l109517/l
\textordfeminine=/l109518/l
\textordmasculine=/l109519/l
\textparagraph=/l109520/l
\textperiodcentered=/l109521/l
\textpertenthousand=/l109522/l
\textperthousand=/l109523/l
\textpilcrow=/l109524/l
\textquotesingle=/l109525/l
\textquotestraightbase=/l109526/l
\textquotestraightdblbase=/l109527/l
\textrecipe=/l109528/l
\textreferencemark=/l109529/l
\textsection=/l109530/l
\textthreequartersemdash=/l109531/l
\texttwelveudash=/l109532/l

// 110000 - stmaryrd Binary Operators 
\baro=/l110001/l
\bbslash=/l110002/l
\binampersand=/l110003/l
\bindnasrepma=/l110004/l
\boxast=/l110005/l
\boxbar=/l110006/l
\boxbox=/l110007/l
\boxbslash=/l110008/l
\boxcircle=/l110009/l
\boxdot=/l110010/l
\boxempty=/l110011/l
\boxslash=/l110012/l
\curlyveedownarrow=/l110013/l
\curlyveeuparrow=/l110014/l
\curlywedgedownarrow=/l110015/l
\curlywedgeuparrow=/l110016/l
\fatbslash=/l110017/l
\fatsemi=/l110018/l
\fatslash=/l110019/l
\interleave=/l110020/l
\leftslice=/l110021/l
\merge=/l110022/l
\minuso=/l110023/l
\moo=/l110024/l
\nplus=/l110025/l
\obar=/l110026/l
\oblong=/l110027/l
\obslash=/l110028/l
\ogreaterthan=/l110029/l
\olessthan=/l110030/l
\ovee=/l110031/l
\owedge=/l110032/l
\rightslice=/l110033/l
\sslash=/l110034/l
\talloblong=/l110035/l
\varbigcirc=/l110036/l
\varcurlyvee=/l110037/l
\varcurlywedge=/l110038/l
\varoast=/l110039/l
\varobar=/l110040/l
\varobslash=/l110041/l
\varocircle=/l110042/l
\varodot=/l110043/l
\varogreaterthan=/l110044/l
\varolessthan=/l110045/l
\varominus=/l110046/l
\varoplus=/l110047/l
\varoslash=/l110048/l
\varotimes=/l110049/l
\varovee=/l110050/l
\varowedge=/l110051/l
\vartimes=/l110052/l
\Ydown=/l110053/l
\Yleft=/l110054/l
\Yright=/l110055/l
\Yup=/l110056/l

// 110500 - Variable-sized stmaryrd Math Operators
\bigbox=/l110501/l
\bigcurlyvee=/l110502/l
\bigcurlywedge=/l110503/l
\biginterleave=/l110504/l
\bignplus=/l110505/l
\bigparallel=/l110506/l
\bigsqcap=/l110507/l
\bigtriangledown=/l110508/l
\bigtriangleup=/l110509/l

// 111000 - Binary Operators
\amalg=/l111001/l
\ast=/l111002/l
\bigcirc=/l111003/l
\bigtriangledown=/l111004/l
\bigtriangleup=/l111005/l
\bullet=/l111006/l
\cap=/l111007/l
\cdot=/l111008/l
\circ=/l111009/l
\cup=/l111010/l
\dagger=/l111011/l
\ddagger=/l111012/l
\diamond=/l111013/l
\div=/l111014/l
\lhd=/l111015/l
\mp=/l111016/l
\odot=/l111017/l
\ominus=/l111018/l
\oplus=/l111019/l
\oslash=/l111020/l
\otimes=/l111021/l
\pm=/l111022/l
\rhd=/l111023/l
\setminus=/l111024/l
\sqcap=/l111025/l
\sqcup=/l111026/l
\star=/l111027/l
\times=/l111028/l
\triangleleft=/l111029/l
\triangleright=/l111030/l
\unlhd=/l111031/l
\unrhd=/l111032/l
\uplus=/l111033/l
\vee=/l111034/l
\wedge=/l111035/l
\wr=/l111036/l

// 111500 - Variable-sized Math Operators
\bigcap=/l111501/l
\bigcup=/l111502/l
\bigodot=/l111503/l
\bigoplus=/l111504/l
\bigotimes=/l111505/l
\bigsqcup=/l111506/l
\biguplus=/l111507/l
\bigvee=/l111508/l
\bigwedge=/l111509/l
\coprod=/l111510/l
\int=/l111511/l
\prod=/l111512/l
\sum=/l111513/l

// 112000 - AMS Binary Operators
\barwedge=/l112001/l
\boxdot=/l112002/l
\boxminus=/l112003/l
\boxplus=/l112004/l
\boxtimes=/l112005/l
\Cap=/l112006/l
\centerdot=/l112007/l
\circledast=/l112008/l
\circledcirc=/l112009/l
\circleddash=/l112010/l
\Cup=/l112011/l
\curlyvee=/l112012/l
\curlywedge=/l112013/l
\divideontimes=/l112014/l
\dotplus=/l112015/l
\doublebarwedge=/l112016/l
\intercal=/l112017/l
\leftthreetimes=/l112018/l
\ltimes=/l112019/l
\rightthreetimes=/l112020/l
\rtimes=/l112021/l
\smallsetminus=/l112022/l
\veebar=/l112023/l

// 112500 - Variable-sized wasysym Math Operators
\iiint=/l112501/l
\iint=/l112502/l
\oiint=/l112503/l
\varint=/l112504/l
\varoint=/l112505/l

// 113000 - txfonts/pxfonts Binary Operators
\circledbar=/l113001/l
\circledbslash=/l113002/l
\circledvee=/l113003/l
\circledwedge=/l113004/l
\invamp=/l113005/l
\medbullet=/l113006/l
\medcirc=/l113007/l
\sqcapplus=/l113008/l
\sqcupplus=/l113009/l

// 113500 - Variable-sized txfonts/pxfonts Math Operators
\bigsqcapplus=/l113501/l
\bigsqcupplus=/l113502/l
\fint=/l113503/l
\idotsint=/l113504/l
\iiiint=/l113505/l
\iiint=/l113506/l
\iint=/l113507/l
\oiiintclockwise=/l113508/l
\oiiintctrclockwise=/l113509/l
\oiiint=/l113510/l
\oiintclockwise=/l113511/l
\oiintctrclockwise=/l113512/l
\oiint=/l113513/l
\ointclockwise=/l113514/l
\ointctrclockwise=/l113515/l
\sqiiint=/l113516/l
\sqiint=/l113517/l
\sqint=/l113518/l
\varoiiintclockwise=/l113519/l
\varoiiintctrclockwise=/l113520/l
\varoiintclockwise=/l113521/l
\varoiintctrclockwise=/l113522/l
\varointclockwise=/l113523/l
\varointctrclockwise=/l113524/l
\varprod=/l113525/l

// 114000 - Relation Symbols
\approx=/l114001/l
\asymp=/l114002/l
\bowtie=/l114003/l
\cong=/l114004/l
\dashv=/l114005/l
\doteq=/l114006/l
\equiv=/l114007/l
\frown=/l114008/l
\geq=/l114009/l
\gg=/l114010/l
\in=/l114011/l
\Join=/l114012/l
\leq=/l114013/l
\ll=/l114014/l
\mid=/l114015/l
\models=/l114016/l
\neq=/l114017/l
\ni=/l114018/l
\parallel=/l114019/l
\perp=/l114020/l
\prec=/l114021/l
\preceq=/l114022/l
\propto=/l114023/l
\sim=/l114024/l
\simeq=/l114025/l
\smile=/l114026/l
\sqsubset=/l114027/l
\sqsubseteq=/l114028/l
\sqsupset=/l114029/l
\sqsupseteq=/l114030/l
\subset=/l114031/l
\subseteq=/l114032/l
\succ=/l114033/l
\succeq=/l114034/l
\supset=/l114035/l
\supseteq=/l114036/l
\vdash=/l114037/l

// 114500 - AMS Binary Relations
\approxeq=/l114501/l
\backepsilon=/l114502/l
\backsim=/l114503/l
\backsimeq=/l114504/l
\because=/l114505/l
\between=/l114506/l
\blacktriangleleft=/l114507/l
\blacktriangleright=/l114508/l
\Bumpeq=/l114509/l
\bumpeq=/l114510/l
\circeq=/l114511/l
\curlyeqprec=/l114512/l
\curlyeqsucc=/l114513/l
\doteqdot=/l114514/l
\eqcirc=/l114515/l
\eqslantgtr=/l114516/l
\eqslantless=/l114517/l
\fallingdotseq=/l114518/l
\geqq=/l114519/l
\geqslant=/l114520/l
\ggg=/l114521/l
\gtrapprox=/l114522/l
\gtrdot=/l114523/l
\gtreqless=/l114524/l
\gtreqqless=/l114525/l
\gtrless=/l114526/l
\gtrsim=/l114527/l
\leqq=/l114528/l
\leqslant=/l114529/l
\lessapprox=/l114530/l
\lessdot=/l114531/l
\lesseqgtr=/l114532/l
\lesseqqgtr=/l114533/l
\lessgtr=/l114534/l
\lesssim=/l114535/l
\lll=/l114536/l
\pitchfork=/l114537/l
\precapprox=/l114538/l
\preccurlyeq=/l114539/l
\precsim=/l114540/l
\risingdotseq=/l114541/l
\shortmid=/l114542/l
\shortparallel=/l114543/l
\smallfrown=/l114544/l
\sqsubset=/l114545/l
\sqsupset=/l114546/l
\Subset=/l114547/l
\subseteqq=/l114548/l
\succapprox=/l114549/l
\succcurlyeq=/l114550/l
\succsim=/l114551/l
\Supset=/l114552/l
\supseteqq=/l114553/l
\therefore=/l114554/l
\thickapprox=/l114555/l
\thicksim=/l114556/l
\trianglelefteq=/l114557/l
\triangleq=/l114558/l
\trianglerighteq=/l114559/l
\varpropto=/l114560/l
\vartriangleleft=/l114561/l
\vartriangleright=/l114562/l
\Vdash=/l114563/l
\vDash=/l114564/l
\Vvdash=/l114565/l

// 115000 - AMS Negated Binary Relations
\gnapprox=/l115001/l
\gneq=/l115002/l
\gneqq=/l115003/l
\gnsim=/l115004/l
\gvertneqq=/l115005/l
\lnapprox=/l115006/l
\lneq=/l115007/l
\lneqq=/l115008/l
\lnsim=/l115009/l
\lvertneqq=/l115010/l
\ncong=/l115011/l
\ngeq=/l115012/l
\ngeqq=/l115013/l
\ngeqslant=/l115014/l
\ngtr=/l115015/l
\nleq=/l115016/l
\nleqq=/l115017/l
\nleqslant=/l115018/l
\nless=/l115019/l
\nmid=/l115020/l
\nparallel=/l115021/l
\nprec=/l115022/l
\npreceq=/l115023/l
\nshortmid=/l115024/l
\nshortparallel=/l115025/l
\nsim=/l115026/l
\nsubseteq=/l115027/l
\nsucc=/l115028/l
\nsucceq=/l115029/l
\nsupseteq=/l115030/l
\nsupseteqq=/l115031/l
\ntriangleleft=/l115032/l
\ntrianglelefteq=/l115033/l
\ntriangleright=/l115034/l
\ntrianglerighteq=/l115035/l
\nvdash=/l115036/l
\nvDash=/l115037/l
\nVDash=/l115038/l
\precnapprox=/l115039/l
\precnsim=/l115040/l
\subsetneq=/l115041/l
\subsetneqq=/l115042/l
\succnapprox=/l115043/l
\succnsim=/l115044/l
\supsetneq=/l115045/l
\supsetneqq=/l115046/l
\varsubsetneq=/l115047/l
\varsubsetneqq=/l115048/l
\varsupsetneq=/l115049/l
\varsupsetneqq=/l115050/l

// 115500 - atmaryrd Binary Relations
\inplus=/l115501/l
\niplus=/l115502/l
\subsetplus=/l115503/l
\subsetpluseq=/l115504/l
\supsetplus=/l115505/l
\supsetpluseq=/l115506/l
\trianglelefteqslant=/l115507/l
\trianglerighteqslant=/l115508/l

// 116000 - stmaryrd Negated Binary Relations
\ntrianglelefteqslant=/l116001/l
\ntrianglerighteqslant=/l116002/l

// 116500 - txfonts/pxfonts Binary Relations
\boxdotLeft=/l116501/l
\boxdotleft=/l116502/l
\boxdotright=/l116503/l
\boxdotRight=/l116504/l
\boxleft=/l116505/l
\boxLeft=/l116506/l
\boxRight=/l116507/l
\boxright=/l116508/l
\circleddotleft=/l116509/l
\circleddotright=/l116510/l
\circledgtr=/l116511/l
\circledless=/l116512/l
\circleleft=/l116513/l
\circleright=/l116514/l
\colonapprox=/l116515/l
\Colonapprox=/l116516/l
\coloneq=/l116517/l
\Coloneq=/l116518/l
\coloneqq=/l116519/l
\Coloneqq=/l116520/l
\colonsim=/l116521/l
\Colonsim=/l116522/l
\dashleftrightarrow=/l116523/l
\Diamonddotleft=/l116524/l
\DiamonddotLeft=/l116525/l
\Diamonddotright=/l116526/l
\DiamonddotRight=/l116527/l
\Diamondleft=/l116528/l
\DiamondLeft=/l116529/l
\Diamondright=/l116530/l
\DiamondRight=/l116531/l
\Eqcolon=/l116532/l
\eqcolon=/l116533/l
\Eqqcolon=/l116534/l
\eqqcolon=/l116535/l
\eqsim=/l116536/l
\lJoin=/l116537/l
\lrtimes=/l116538/l
\Mappedfromchar=/l116539/l
\mappedfromchar=/l116540/l
\mmappedfromchar=/l116541/l
\Mmappedfromchar=/l116542/l
\mmapstochar=/l116543/l
\Mmapstochar=/l116544/l
\multimapboth=/l116545/l
\multimapbothvert=/l116546/l
\multimapbothvert=/l116547/l
\multimapdotboth=/l116548/l
\multimapdotbothA=/l116549/l
\multimapdotbothAvert=/l116550/l
\multimapdotbothB=/l116551/l
\multimapdotbothBvert=/l116552/l
\multimapdotbothvert=/l116553/l
\multimapdotinv=/l116554/l
\multimapinv=/l116555/l
\napproxeq=/l116556/l
\nasymp=/l116557/l
\nbacksim=/l116558/l
\nbacksimeq=/l116559/l
\nBumpeq=/l116560/l
\nbumpeq=/l116561/l
\Nearrow=/l116562/l
\nequiv=/l116563/l
\ngg=/l116564/l
\ngtrapprox=/l116565/l
\ngtrless=/l116566/l
\ngtrsim=/l116567/l
\nlessapprox=/l116568/l
\nlessgtr=/l116569/l
\nlesssim=/l116570/l
\nll=/l116571/l
\notin=/l116572/l
\notni=/l116573/l
\nprecapprox=/l116574/l
\npreccurlyeq=/l116575/l
\npreceqq=/l116576/l
\nprecsim=/l116577/l
\nsimeq=/l116578/l
\nsqsubset=/l116579/l
\nsqsubseteq=/l116580/l
\nsqsupset=/l116581/l
\nsqsupseteq=/l116582/l
\nSubset=/l116583/l
\nsubseteqq=/l116584/l
\nsuccapprox=/l116585/l
\nsucccurlyeq=/l116586/l
\nsucceqq=/l116587/l
\nsuccsim=/l116588/l
\nSupset=/l116589/l
\nthickapprox=/l116590/l
\ntwoheadleftarrow=/l116591/l
\ntwoheadrightarrow=/l116592/l
\nvarparallel=/l116593/l
\nvarparallelinv=/l116594/l
\nVdash=/l116595/l
\Nwarrow=/l116596/l
\openJoin=/l116597/l
\opentimes=/l116598/l
\Perp=/l116599/l
\preceqq=/l116600/l
\precneqq=/l116601/l
\rJoin=/l116602/l
\Rrightarrow=/l116603/l
\Searrow=/l116604/l
\strictfi=/l116605/l
\strictif=/l116606/l
\strictiff=/l116607/l
\succeqq=/l116608/l
\succneqq=/l116609/l
\Swarrow=/l116610/l
\varparallel=/l116611/l
\varparallelinv=/l116612/l
\VvDash=/l116613/l

// 117000 - Arrow Symbols
\Downarrow=/l117001/l
\downarrow=/l117002/l
\hookleftarrow=/l117003/l
\hookrightarrow=/l117004/l
\leadsto=/l117005/l
\Leftarrow=/l117006/l
\leftarrow=/l117007/l
\leftharpoondown=/l117008/l
\leftharpoonup=/l117009/l
\Leftrightarrow=/l117010/l
\leftrightarrow=/l117011/l
\longleftarrow=/l117012/l
\Longleftarrow=/l117013/l
\longleftrightarrow=/l117014/l
\Longleftrightarrow=/l117015/l
\longmapsto=/l117016/l
\longrightarrow=/l117017/l
\Longrightarrow=/l117018/l
\mapsto=/l117019/l
\nearrow=/l117020/l
\nwarrow=/l117021/l
\rightarrow=/l117022/l
\Rightarrow=/l117023/l
\rightharpoondown=/l117024/l
\rightharpoonup=/l117025/l
\rightleftharpoons=/l117026/l
\searrow=/l117027/l
\swarrow=/l117028/l
\uparrow=/l117029/l
\Uparrow=/l117030/l
\Updownarrow=/l117031/l
\updownarrow=/l117032/l

// 117500 - AMS Arrows
\circlearrowleft=/l117501/l
\circlearrowright=/l117502/l
\curvearrowleft=/l117503/l
\curvearrowright=/l117504/l
\dashleftarrow=/l117505/l
\dashrightarrow=/l117506/l
\downdownarrows=/l117507/l
\downharpoonleft=/l117508/l
\downharpoonright=/l117509/l
\leftarrowtail=/l117510/l
\leftleftarrows=/l117511/l
\leftrightarrows=/l117512/l
\leftrightharpoons=/l117513/l
\leftrightsquigarrow=/l117514/l
\Lleftarrow=/l117515/l
\looparrowleft=/l117516/l
\looparrowright=/l117517/l
\Lsh=/l117518/l
\multimap=/l117519/l
\rightarrowtail=/l117520/l
\rightleftarrows=/l117521/l
\rightleftharpoons=/l117522/l
\rightrightarrows=/l117523/l
\rightsquigarrow=/l117524/l
\Rsh=/l117525/l
\twoheadleftarrow=/l117526/l
\twoheadrightarrow=/l117527/l
\upharpoonleft=/l117528/l
\upharpoonright=/l117529/l
\upuparrows=/l117530/l

// 118000 - AMS Negated Arrows
\nLeftarrow=/l118001/l
\nleftarrow=/l118002/l
\nLeftrightarrow=/l118003/l
\nleftrightarrow=/l118004/l
\nRightarrow=/l118005/l
\nrightarrow=/l118006/l

// 118500 - stmaryrd Arrows
\leftarrowtriangle=/l118501/l
\leftrightarroweq=/l118502/l
\leftrightarrowtriangle=/l118503/l
\lightning=/l118504/l
\Longmapsfrom=/l118505/l
\longmapsfrom=/l118506/l
\Longmapsto=/l118507/l
\Mapsfrom=/l118508/l
\mapsfrom=/l118509/l
\Mapsto=/l118510/l
\nnearrow=/l118511/l
\nnwarrow=/l118512/l
\rightarrowtriangle=/l118513/l
\rrparenthesis=/l118514/l
\shortdownarrow=/l118515/l
\shortuparrow=/l118516/l
\shortleftarrow=/l118517/l
\shortrightarrow=/l118518/l
\shortuparrow=/l118519/l
\ssearrow=/l118520/l
\sswarrow=/l118521/l

// 119000 - Log-like Symbols
\arccos=/l119001/l
\arcsin=/l119002/l
\arctan=/l119003/l
\arg=/l119004/l
\cos=/l119005/l
\cosh=/l119006/l
\cot=/l119007/l
\coth=/l119008/l
\csc=/l119009/l
\deg=/l119010/l
\det=/l119011/l
\dim=/l119012/l
\exp=/l119013/l
\gcd=/l119014/l
\hom=/l119015/l
\inf=/l119016/l
\ker=/l119017/l
\lg=/l119018/l
\lim=/l119019/l
\liminf=/l119020/l
\limsup=/l119021/l
\ln=/l119022/l
\log=/l119023/l
\max=/l119024/l
\min=/l119025/l
\Pr=/l119026/l
\sec=/l119027/l
\sin=/l119028/l
\sinh=/l119029/l
\sup=/l119030/l
\tan=/l119031/l
\tanh=/l119032/l

// 119500 - AMS Log-like Symbols
\injlim=/l119501/l
\projlim=/l119502/l
\varinjlim=/l119503/l
\varliminf=/l119504/l
\varlimsup=/l119505/l
\varprojlim=/l119506/l

// 120000 - Greek Letters
\alpha=/l120001/l
\beta=/l120002/l
\gamma=/l120003/l
\delta=/l120004/l
\epsilon=/l120005/l
\varepsilon=/l120006/l
\zeta=/l120007/l
\eta=/l120008/l
\theta=/l120009/l
\vartheta=/l120010/l
\iota=/l120011/l
\kappa=/l120012/l
\lambda=/l120013/l
\mu=/l120014/l
\nu=/l120015/l
\xi=/l120016/l
\pi=/l120018/l
\varpi=/l120019/l
\rho=/l120020/l
\varrho=/l120021/l
\sigma=/l120022/l
\varsigma=/l120023/l
\tau=/l120024/l
\upsilon=/l120025/l
\phi=/l120026/l
\varphi=/l120027/l
\chi=/l120028/l
\psi=/l120029/l
\omega=/l120030/l
\Gamma=/l120031/l
\Delta=/l120032/l
\Theta=/l120033/l
\Lambda=/l120034/l
\Xi=/l120035/l
\Pi=/l120036/l
\Sigma=/l120037/l
\Upsilon=/l120038/l
\Phi=/l120039/l
\Psi=/l120040/l
\Omega=/l120041/l

// 120500 - AMS Greek Letters
\digamma=/l120501/l
\varkappa=/l120502/l

// 121000 - txfonts/pxfonts Upright Greek Letters
\alphaup=/l121001/l
\betaup=/l121002/l
\gammaup=/l121003/l
\deltaup=/l121004/l
\epsilonup=/l121005/l
\varepsilonup=/l121006/l
\zetaup=/l121007/l
\etaup=/l121008/l
\thetaup=/l121009/l
\varthetaup=/l121010/l
\iotaup=/l121011/l
\kappaup=/l121012/l
\lambdaup=/l121013/l
\muup=/l121014/l
\muup=/l121015/l
\nuup=/l121016/l
\xiup=/l121017/l
\piup=/l121018/l
\varpiup=/l121019/l
\rhoup=/l121020/l
\varrhoup=/l121021/l
\sigmaup=/l121022/l
\varsigmaup=/l121023/l
\tauup=/l121024/l
\upsilonup=/l121025/l
\phiup=/l121026/l
\varphiup=/l121027/l
\chiup=/l121028/l
\psiup=/l121029/l
\omegaup=/l121030/l

// 121500 - txfonts/pxfonts Variant Latin Letters
\varg=/l121501/l
\varv=/l121502/l
\varw=/l121503/l
\vary=/l121504/l

// 122000 - AMS Hebrew Letters
\beth=/l122001/l
\daleth=/l122002/l
\gimel=/l122003/l

// 122500 - Variable-sized Delimiters
(=/l122501/l
[=/l122502/l
\{=/l122503/l
\lfloor=/l122504/l
\langle=/l122505/l
|=/l122506/l
)=/l122507/l
]=/l122508/l
\}=/l122509/l
\rfloor=/l122510/l
\rangle=/l122511/l
\|=/l122512/l
\uparrow=/l122513/l
\downarrow=/l122514/l
\updownarrow=/l122515/l
\lceil=/l122516/l
/=/l122517/l
\Uparrow=/l122518/l
\Downarrow=/l122519/l
\Updownarrow=/l122520/l
\rceil=/l122521/l
\backslash=/l122522/l

// 123000 - Large, Variable-sized Delimiters
\rmoustache=/l123001/l
\arrowvert=/l123002/l
\lmoustache=/l123003/l
\Arrowvert=/l123004/l
\rgroup=/l123005/l
\bracevert=/l123006/l
\lgroup=/l123007/l

// 123500 - AMS Delimiters
\ulcorner=/l123501/l
\urcorner=/l123502/l
\llcorner=/l123503/l
\lrcorner=/l123504/l

// 124000 - stmaryrd Delimiters
\Lbag=/l124001/l
\llceil=/l124002/l
\llparenthesis=/l124003/l
\Rbag=/l124004/l
\rrceil=/l124005/l
\rrparenthesis=/l124006/l
\lbag=/l124007/l
\llfloor=/l124008/l
\rbag=/l124009/l
\rrfloor=/l124010/l

// 124500 - Variable-sized stmaryrd Delimiters
\llbracket=/l124501/l
\rrbracket=/l124502/l

// 125000 - textcomp Text-Mode Delimiters
\textlangle=/l125001/l
\textlbrackdbl=/l125002/l
\textlquill=/l125003/l
\textrangle=/l125004/l
\textrbrackdbl=/l125005/l
\textrquill=/l125006/l

// 125500 - Math-Mode Accents
\acute=/l125501/l
\bar=/l125502/l
\breve=/l125503/l
\check=/l125504/l
\ddot=/l125505/l
\dot=/l125506/l
\grave=/l125507/l
\hat=/l125508/l
\tilde=/l125509/l
\vec=/l125510/l

// 126000 - Some Other Constructions
\widetilde=/l126001/l
\overleftarrow=/l126002/l
\overline=/l126003/l
\overbrace=/l126004/l
\sqrt=/l126005/l
f=/l126006/l
\widehat=/l126007/l
\overrightarrow=/l126008/l
\underline=/l126009/l
\underbrace=/l126010/l
\sqrt=/l126011/l
\frac=/l126012/l

// 126500 - AMS Extensible Arrow Accents
\overleftarrow=/l126501/l
\underleftarrow=/l126502/l
\overrightarrow=/l126503/l
\underrightarrow=/l126504/l
\overleftrightarrow=/l126505/l
\underleftrightarrow=/l126506/l

// 127000 - Punctuation Symbols (Math Mode)
,=/l127001/l
;=/l127002/l
\colon=/l127003/l
\ldotp=/l127004/l
\cdotp=/l127005/l

// 127500 - Miscellaneous LaTeX2e Symbols
\aleph=/l127501/l
\angle=/l127502/l
\backslash=/l127503/l
\bot=/l127504/l
\Box=/l127505/l
\cdots=/l127506/l
\clubsuit=/l127507/l
\ddots=/l127508/l
\Diamond=/l127509/l
\diamondsuit=/l127510/l
\ell=/l127511/l
\emptyset=/l127512/l
\exists=/l127513/l
\flat=/l127514/l
\forall=/l127515/l
\hbar=/l127516/l
\heartsuit=/l127517/l
\Im=/l127518/l
\imath=/l127519/l
\infty=/l127520/l
\jmath=/l127521/l
\ldots=/l127522/l
\mho=/l127523/l
\nabla=/l127524/l
\natural=/l127525/l
\neg=/l127526/l
\partial=/l127527/l
\prime=/l127528/l
\Re=/l127529/l
\sharp=/l127530/l
\spadesuit=/l127531/l
\surd=/l127532/l
\top=/l127533/l
\triangle=/l127534/l
\vdots=/l127535/l
\wp=/l127536/l

// 128000 - Miscellaneous AMS Symbols
\angle=/l128001/l
\backprime=/l128002/l
\Bbbk=/l128003/l
\bigstar=/l128004/l
\blacklozenge=/l128005/l
\blacksquare=/l128006/l
\blacktriangle=/l128007/l
\blacktriangledown=/l128008/l
\circledS=/l128009/l
\complement=/l128010/l
\diagdown=/l128011/l
\diagup=/l128012/l
\eth=/l128013/l
\Finv=/l128014/l
\Game=/l128015/l
\hbar=/l128016/l
\hslash=/l128017/l
\lozenge=/l128018/l
\measuredangle=/l128019/l
\mho=/l128020/l
\nexists=/l128021/l
\sphericalangle=/l128022/l
\square=/l128023/l
\triangledown=/l128024/l
\varnothing=/l128025/l
\vartriangle=/l128026/l

// 128500 - AMS Commands Defined to Work in Both Math and Text Mode
\checkmark=/l128501/l
\circledR=/l128502/l
\maltese=/l128503/l

// 129000 - stmaryrd Extensiton Characters
\Arrownot=/l129001/l
\arrownot=/l129002/l
\Mapsfromchar=/l129003/l
\mapsfromchar=/l129004/l
\Mapstochar=/l129005/l

// 129500 - Other wasysym Math-Mode Symbols
\apprge=/l129501/l
\apprle=/l129502/l
\Box=/l129503/l
\Diamond=/l129504/l
\invneg=/l129505/l
\Join=/l129506/l
\leadsto=/l129507/l
\lhd=/l129508/l
\LHD=/l129509/l
\logof=/l129510/l
\mho=/l129511/l
\ocircle=/l129512/l
\rhd=/l129513/l
\RHD=/l129514/l
\sqsubset=/l129515/l
\sqsupset=/l129516/l
\unlhd=/l129517/l
\unrhd=/l129518/l
\wasypropto=/l129519/l

// 130000 - Miscellaneous txfonts/pxfonts Symbols
\Diamondblack=/l130001/l
\Diamonddot=/l130002/l
\lambdabar=/l130003/l
\lambdaslash=/l130004/l
\mathcent=/l130005/l
\mathsterling=/l130006/l
\varclubsuit=/l130007/l
\vardiamondsuit=/l130008/l
\varheartsuit=/l130009/l
\varspadesuit=/l130010/l

// 130500 - textcomp Text-Mode Math and Science Symbols
\textcelsius=/l130501/l
\textdegree=/l130502/l
\textdiv=/l130503/l
\textdownarrow=/l130504/l
\textfractionsolidus=/l130505/l
\textleftarrow=/l130506/l
\textlnot=/l130507/l
\textmho=/l130508/l
\textminus=/l130509/l
\textmu=/l130510/l
\textohm=/l130511/l
\textonehalf=/l130512/l
\textonequarter=/l130513/l
\textonesuperior=/l130514/l
\textpm=/l130515/l
\textrightarrow=/l130516/l
\textsurd=/l130517/l
\textthreequarters=/l130518/l
\textthreesuperior=/l130519/l
\texttimes=/l130520/l
\texttwosuperior=/l130521/l
\textuparrow=/l130522/l

// 131000 - marvosym Math Symbols
\MVZero=/l131001/l
\MVOne=/l131002/l
\MVTwo=/l131003/l
\MVThree=/l131004/l
\MVFour=/l131005/l
\MVFive=/l131006/l
\MVSix=/l131007/l
\MVSeven=/l131008/l
\MVEight=/l131009/l
\MVNine=/l131010/l
\Anglesign=/l131011/l
\Corresponds=/l131012/l
\Squaredot=/l131013/l
\Vectorarrow=/l131014/l
\Vectorarrowhigh=/l131015/l

// 131500 - ar Aspect Ratio Symbol
\AR=/l131501/l

// 132000 - ulsy Contradiction and Other Symbols
\blitza=/l132001/l
\blitzb=/l132002/l
\blitzc=/l132003/l
\blitzd=/l132004/l
\blitze=/l132005/l
\odplus=/l132006/l

// 132500 - Math Alphabets
\mathrm=/l132501/l
\mathit=/l132502/l
\mathnormal=/l132503/l
\mathcal=/l132504/l
\mathscr=/l132505/l
\mathcal=/l132506/l
\mathpzc=/l132507/l
\mathbb=/l132508/l
\varmathbb=/l132509/l
\mathbb=/l132510/l
\mathbbm=/l132511/l
\mathbbmss=/l132512/l
\mathbbmtt=/l132513/l
\mathds=/l132514/l
\mathds=/l132515/l
\mathfrak=/l132516/l
\textfrak=/l132517/l
\textswab=/l132518/l

// 133000 - wasysym Electrical and Physical Symbols
\AC=/l133001/l
\VHF=/l133002/l
\photon=/l133003/l
\HF=/l133004/l
\gluon=/l133005/l

// 133500 - ifsym Pulse Diagram Symbols
\FallingEdge=/l133501/l
\LongPulseHigh=/l133502/l
\LongPulseLow=/l133503/l
\PulseHigh=/l133504/l
\PulseLow=/l133505/l
\RaisingEdge=/l133506/l
\ShortPulseHigh=/l133507/l
\ShortPulseLow=/l133508/l

// 134000 - wasysym Astronomical Symbols
\ascnode=/l134001/l
\astrosun=/l134002/l
\descnode=/l134003/l
\earth=/l134004/l
\fullmoon=/l134005/l
\jupiter=/l134006/l
\leftmoon=/l134007/l
\mars=/l134008/l
\mercury=/l134009/l
\neptune=/l134010/l
\newmoon=/l134011/l
\pluto=/l134012/l
\rightmoon=/l134013/l
\saturn=/l134014/l
\uranus=/l134015/l
\venus=/l134016/l
\vernal=/l134017/l

// 134500 - marvosym Astronomical Symbols
\Mercury=/l134501/l
\Venus=/l134502/l
\Earth=/l134503/l
\Mars=/l134504/l
\Jupiter=/l134505/l
\Saturn=/l134506/l
\Uranus=/l134507/l
\Neptune=/l134508/l
\Pluto=/l134509/l
\Sun=/l134510/l
\Moon=/l134511/l

// 135000 - wasysym Astrological Symbols
\aries=/l135001/l
\taurus=/l135002/l
\gemini=/l135003/l
\cancer=/l135004/l
\leo=/l135005/l
\virgo=/l135006/l
\libra=/l135007/l
\scorpio=/l135008/l
\sagittarius=/l135009/l
\capricornus=/l135010/l
\aquarius=/l135011/l
\pisces=/l135012/l
\conjunction=/l135013/l
\opposition=/l135014/l

// 135500 - marvosym Astrological Symbols
\Aries=/l135501/l
\Taurus=/l135502/l
\Gemini=/l135503/l
\Cancer=/l135504/l
\Leo=/l135505/l
\Virgo=/l135506/l
\Libra=/l135507/l
\Scorpio=/l135508/l
\Sagittarius=/l135509/l
\Capricorn=/l135510/l
\Aquarius=/l135511/l
\Pisces=/l135512/l

// 136000 - wasysym APL Symbols
\APLbox=/l136001/l
\APLcomment=/l136002/l
\APLdown=/l136003/l
\APLdownarrowbox=/l136004/l
\APLinput=/l136005/l
\APLinv=/l136006/l
\APLleftarrowbox=/l136007/l
\APLlog=/l136008/l
\APLminus=/l136009/l
\APLrightarrowbox=/l136010/l
\APLstar=/l136011/l
\APLup=/l136012/l
\APLuparrowbox=/l136013/l
\notbackslash=/l136014/l
\notslash=/l136015/l

// 136500 - wasysym APL Modifiers
\APLcirc{}=/l136501/l
\APLnot{}=/l136502/l
\APLvert{}=/l136503/l

// 137000 - marvosym Computer Hardware Symbols
\ComputerMouse=/l137001/l
\Keyboard=/l137002/l
\ParallelPort=/l137003/l
\Printer=/l137004/l
\SerialInterface=/l137005/l
\SerialPort=/l137006/l

// 137500 - ASCII COntrol Characters (IBM)
\SOH=/l137501/l
\STX=/l137502/l
\ETX=/l137503/l
\EOT=/l137504/l
\ENQ=/l137505/l
\ACK=/l137506/l
\BEL=/l137507/l
\BS=/l137508/l
\HT=/l137509/l
\LF=/l137510/l
\VT=/l137511/l
\FF=/l137512/l
\CR=/l137513/l
\SO=/l137514/l
\SI=/l137515/l
\DLE=/l137516/l
\DCa=/l137517/l
\DCb=/l137518/l
\DCc=/l137519/l
\DCd=/l137520/l
\NAK=/l137521/l
\SYN=/l137522/l
\ETB=/l137523/l
\CAN=/l137524/l
\EM=/l137525/l
\SUB=/l137526/l
\ESC=/l137527/l
\FS=/l137528/l
\GS=/l137529/l
\RS=/l137530/l
\US=/l137531/l
\splitvert=/l137532/l
\DEL=/l137533/l

// 138000 - marvosym Communication Symbols
\Email=/l138001/l
\Emailct=/l138002/l
\fax=/l138003/l
\FAX=/l138004/l
\Faxmachine=/l138005/l
\Letter=/l138006/l
\Lightning=/l138007/l
\Mobilefone=/l138008/l
\Pickup=/l138009/l
\Telefon=/l138010/l

// 138500 - marvosym Engineering Symbols
\Beam=/l138501/l
\Bearing=/l138502/l
\Circpipe=/l138503/l
\Circsteel=/l138504/l
\Fixedbearing=/l138505/l
\Flatsteel=/l138506/l
\Force=/l138507/l
\Hexasteel=/l138508/l
\Lefttorque=/l138509/l
\Lineload=/l138510/l
\Loosebearing=/l138511/l
\Lsteel=/l138512/l
\Octosteel=/l138513/l
\Rectpipe=/l138514/l
\Rectsteel=/l138515/l
\Righttorque=/l138516/l
\RoundedLsteel=/l138517/l
\RoundedTsteel=/l138518/l
\RoundedTTsteel=/l138519/l
\Squarepipe=/l138520/l
\Squaresteel=/l138521/l
\Tsteel=/l138522/l
\TTsteel=/l138523/l

// 139000 - marvosym Biological Symbols
\Female=/l139001/l
\FEMALE=/l139002/l
\FemaleFemale=/l139003/l
\FemaleMale=/l139004/l
\Hermaphrodite=/l139005/l
\HERMAPHRODITE=/l139006/l
\MALE=/l139007/l
\Male=/l139008/l
\MaleMale=/l139009/l
\Neutral=/l139010/l

// 139500 - marvosym Safety-Related Symbols
\Biohazard=/l139501/l
\BSEfree=/l139502/l
\CEsign=/l139503/l
\Estatically=/l139504/l
\Explosionsafe=/l139505/l
\Laserbeam=/l139506/l
\Radioactivity=/l139507/l
\Stopsign=/l139508/l

// 140000 - bbding Arrows
\ArrowBoldDownRight=/l140001/l
\ArrowBoldRightCircled=/l140002/l
\ArrowBoldRightShort=/l140003/l
\ArrowBoldRightStrobe=/l140004/l
\ArrowBoldUpRight=/l140005/l

// 140500 - pifont Arrows
\ding{212}=/l140501/l
\ding{213}=/l140502/l
\ding{214}=/l140503/l
\ding{215}=/l140504/l
\ding{216}=/l140505/l
\ding{217}=/l140506/l
\ding{218}=/l140507/l
\ding{219}=/l140508/l
\ding{220}=/l140509/l
\ding{221}=/l140510/l
\ding{222}=/l140511/l
\ding{223}=/l140512/l
\ding{224}=/l140513/l
\ding{225}=/l140514/l
\ding{226}=/l140515/l
\ding{227}=/l140516/l
\ding{228}=/l140517/l
\ding{229}=/l140518/l
\ding{230}=/l140519/l
\ding{231}=/l140520/l
\ding{232}=/l140521/l
\ding{233}=/l140522/l
\ding{234}=/l140523/l
\ding{235}=/l140524/l
\ding{236}=/l140525/l
\ding{237}=/l140526/l
\ding{238}=/l140527/l
\ding{239}=/l140528/l
\ding{241}=/l140529/l
\ding{242}=/l140530/l
\ding{243}=/l140531/l
\ding{244}=/l140532/l
\ding{245}=/l140533/l
\ding{246}=/l140534/l
\ding{247}=/l140535/l
\ding{248}=/l140536/l
\ding{249}=/l140537/l
\ding{250}=/l140538/l
\ding{251}=/l140539/l
\ding{252}=/l140540/l
\ding{253}=/l140541/l
\ding{254}=/l140542/l

// 141000 - marvosym Scissors
\Cutleft=/l141001/l
\Cutline=/l141002/l
\Cutright=/l141003/l
\Kutline=/l141004/l
\Leftscissors=/l141005/l
\Rightscissors=/l141006/l

// 141500 - bbding Scissors
\ScissorHollowLeft=/l141501/l
\ScissorHollowRight=/l141502/l
\ScissorLeft=/l141503/l
\ScissorLeftBrokenBottom=/l141504/l
\ScissorLeftBrokenTop=/l141505/l
\ScissorRight=/l141506/l
\ScissorRightBrokenBottom=/l141507/l
\ScissorRightBrokenTop=/l141508/l

// 142000 - pifont Scissors
\ding{33}=/l142001/l
\ding{34}=/l142002/l
\ding{35}=/l142003/l
\ding{36}=/l142004/l

// 142500 - dingbat Pencils
\largepencil=/l142501/l
\smallpencil=/l142502/l

// 143000 - bbding Pencils and Nibs
\NibLeft=/l143001/l
\NibRight=/l143002/l
\NibSolidLeft=/l143003/l
\NibSolidRight=/l143004/l
\PencilLeft=/l143005/l
\PencilLeftDown=/l143006/l
\PencilLeftUp=/l143007/l
\PencilRight=/l143008/l
\PencilRightDown=/l143009/l
\PencilRightUp=/l143010/l

// 143500 - pifont Pencils and Nibs
\ding{46}=/l143501/l
\ding{47}=/l143502/l
\ding{48}=/l143503/l
\ding{49}=/l143504/l
\ding{50}=/l143505/l

// 144000 - dingbat Hands
\leftpointright=/l144001/l
\leftthumbsdown=/l144002/l
\leftthumbsup=/l144003/l
\rightpointleft=/l144004/l
\rightthumbsdown=/l144005/l
\rightthumbsup=/l144006/l
\rightpointright=/l144007/l

// 144500 - bbding Hands
\HandCuffLeft=/l144501/l
\HandCuffLeftUp=/l144502/l
\HandCuffRight=/l144503/l
\HandCuffRightUp=/l144504/l
\HandLeft=/l144505/l
\HandLeftUp=/l144506/l
\HandPencilLeft=/l144507/l
\HandRight=/l144508/l
\HandRightUp=/l144509/l

// 145000 - pifont Hands
\ding{42}=/l145001/l
\ding{43}=/l145002/l
\ding{44}=/l145003/l
\ding{45}=/l145004/l

// 145500 - bbding Crosses and Plusses
\Cross=/l145501/l
\CrossBoldOutline=/l145502/l
\CrossClowerTips=/l145503/l
\CrossMaltese=/l145504/l
\CrossOpenShadow=/l145505/l
\CrossOutline=/l145506/l
\Plus=/l145507/l
\PlusCenterOpen=/l145508/l
\PlusOutline=/l145509/l
\PlusThinCenterOpen=/l145510/l

// 146000 - pifont Crosses and Plusses
\ding{57}=/l146001/l
\ding{58}=/l146002/l
\ding{59}=/l146003/l
\ding{60}=/l146004/l
\ding{61}=/l146005/l
\ding{62}=/l146006/l
\ding{63}=/l146007/l
\ding{64}=/l146008/l

// 146500 - bbding Xs and Check Marks
\Checkmark=/l146501/l
\CheckmarkBold=/l146502/l
\XSolid=/l146503/l
\XSolidBold=/l146504/l
\XSolidBrush=/l146505/l

// 147000 - pifont Xs and Check Marks
\ding{51}=/l147001/l
\ding{52}=/l147002/l
\ding{53}=/l147003/l
\ding{54}=/l147004/l
\ding{55}=/l147005/l
\ding{56}=/l147006/l

// 147500 - wasysym Xs and Check Marks
\CheckedBox=/l147501/l
\Square=/l147502/l
\XBox=/l147503/l

// 148000 - pifont Circled Numbers
\ding{172}=/l148001/l
\ding{173}=/l148002/l
\ding{174}=/l148003/l
\ding{175}=/l148004/l
\ding{176}=/l148005/l
\ding{177}=/l148006/l
\ding{178}=/l148007/l
\ding{179}=/l148008/l
\ding{180}=/l148009/l
\ding{181}=/l148010/l
\ding{182}=/l148011/l
\ding{183}=/l148012/l
\ding{184}=/l148013/l
\ding{185}=/l148014/l
\ding{186}=/l148015/l
\ding{187}=/l148016/l
\ding{188}=/l148017/l
\ding{189}=/l148018/l
\ding{190}=/l148019/l
\ding{191}=/l148020/l
\ding{192}=/l148021/l
\ding{193}=/l148022/l
\ding{194}=/l148023/l
\ding{195}=/l148024/l
\ding{196}=/l148025/l
\ding{197}=/l148026/l
\ding{198}=/l148027/l
\ding{199}=/l148028/l
\ding{200}=/l148029/l
\ding{201}=/l148030/l
\ding{202}=/l148031/l
\ding{203}=/l148032/l
\ding{204}=/l148033/l
\ding{205}=/l148034/l
\ding{206}=/l148035/l
\ding{207}=/l148036/l
\ding{208}=/l148037/l
\ding{209}=/l148038/l
\ding{210}=/l148039/l
\ding{211}=/l148040/l

// 148500 - wasysym Stars
\davidsstar=/l148501/l
\hexstar=/l148502/l
\varhexstar=/l148503/l

// 149000 - bbding Stars, Flowers, and Similar Shapes
\Asterisk=/l149001/l
\AsteriskBold=/l149002/l
\AsteriskCenterOpen=/l149003/l
\AsteriskRoundedEnds=/l149004/l
\AsteriskThin=/l149005/l
\AsteriskThinCenterOpen=/l149006/l
\DavidStar=/l149007/l
\DavidStarSolid=/l149008/l
\EightAsterisk=/l149009/l
\EightFlowerPetal=/l149010/l
\EightFlowerPetalRemoved=/l149011/l
\EightStar=/l149012/l
\EightStarBold=/l149013/l
\EightStarConvex=/l149014/l
\EightStarTaper=/l149015/l
\FiveFlowerOpen=/l149016/l
\FiveFlowerPetal=/l149017/l
\FiveStar=/l149018/l
\FiveStarCenterOpen=/l149019/l
\FiveStarConvex=/l149020/l
\FiveStarLines=/l149021/l
\FiveStarOpen=/l149022/l
\FiveStarOpenCircled=/l149023/l
\FiveStarOpenDotted=/l149024/l
\FiveStarOutline=/l149025/l
\FiveStarOutlineHeavy=/l149026/l
\FiveStarShadow=/l149027/l
\FourAsterisk=/l149028/l
\FourClowerOpen=/l149029/l
\FourClowerSolid=/l149030/l
\FourStar=/l149031/l
\FourStarOpen=/l149032/l
\JackStar=/l149033/l
\JackStarBold=/l149034/l
\SixFlowerAlternate=/l149035/l
\SixFlowerAltPetal=/l149036/l
\SixFlowerOpenCenter=/l149037/l
\SixFlowerPetalDotted=/l149038/l
\SixFlowerPetalRemoved=/l149039/l
\SixFlowerRemovedOpenPetal=/l149040/l
\SixStar=/l149041/l
\SixteenStarLight=/l149042/l
\Snowflake=/l149043/l
\SnowflakeChevron=/l149044/l
\SnowflakeChevronBold=/l149045/l
\Sparkle=/l149046/l
\SparkleBold=/l149047/l
\TwelweStar=/l149048/l

// 149500 - pifont Stars, Flowers, and Similar Shapes
\ding{65}=/l149501/l
\ding{66}=/l149502/l
\ding{67}=/l149503/l
\ding{68}=/l149504/l
\ding{69}=/l149505/l
\ding{70}=/l149506/l
\ding{71}=/l149507/l
\ding{72}=/l149508/l
\ding{73}=/l149509/l
\ding{74}=/l149510/l
\ding{75}=/l149511/l
\ding{76}=/l149512/l
\ding{77}=/l149513/l
\ding{78}=/l149514/l
\ding{79}=/l149515/l
\ding{80}=/l149516/l
\ding{81}=/l149517/l
\ding{82}=/l149518/l
\ding{83}=/l149519/l
\ding{84}=/l149520/l
\ding{85}=/l149521/l
\ding{86}=/l149522/l
\ding{87}=/l149523/l
\ding{88}=/l149524/l
\ding{89}=/l149525/l
\ding{90}=/l149526/l
\ding{91}=/l149527/l
\ding{92}=/l149528/l
\ding{93}=/l149529/l
\ding{94}=/l149530/l
\ding{95}=/l149531/l
\ding{96}=/l149532/l
\ding{97}=/l149533/l
\ding{98}=/l149534/l
\ding{99}=/l149535/l
\ding{100}=/l149536/l
\ding{101}=/l149537/l
\ding{102}=/l149538/l
\ding{103}=/l149539/l
\ding{104}=/l149540/l
\ding{105}=/l149541/l
\ding{106}=/l149542/l
\ding{107}=/l149543/l

// 150000 - wasysym Geometric Shapes
\hexagon=/l150001/l
\octagon=/l150002/l
\pentagon=/l150003/l
\varhexagon=/l150004/l

// 150500 - ifsym Geometric Shapes
\BigCircle=/l150501/l
\BigCross=/l150502/l
\BigDiamondshape=/l150503/l
\BigHBar=/l150504/l
\BigLowerDiamond=/l150505/l
\BigRightDiamond=/l150506/l
\BigSquare=/l150507/l
\BigTriangleDown=/l150508/l
\BigTriangleLeft=/l150509/l
\BigTriangleRight=/l150510/l
\BigTriangleUp=/l150511/l
\BigVBar=/l150512/l
\Circle=/l150513/l
\Cross=/l150514/l
\DiamondShadowA=/l150515/l
\DiamondShadowB=/l150516/l
\DiamondShadowC=/l150517/l
\Diamondshape=/l150518/l
\FilledBigCircle=/l150519/l
\FilledBigDiamondshape=/l150520/l
\FilledBigSquare=/l150521/l
\FilledBigTriangleDown=/l150522/l
\FilledBigTriangleLeft=/l150523/l
\FilledBigTriangleRight=/l150524/l
\FilledBigTriangleUp=/l150525/l
\FilledCircle=/l150526/l
\FilledDiamondShadowA=/l150527/l
\FilledDiamondShadowC=/l150528/l
\FilledDiamondshape=/l150529/l
\FilledSmallCircle=/l150530/l
\FilledSmallDiamondshape=/l150531/l
\FilledSmallSquare=/l150532/l
\FilledSmallTriangleDown=/l150533/l
\FilledSmallTriangleLeft=/l150534/l
\FilledSmallTriangleRight=/l150535/l
\FilledSmallTriangleUp=/l150536/l
\FilledSquare=/l150537/l
\FilledSquareShadowA=/l150538/l
\FilledSquareShadowC=/l150539/l
\FilledTriangleDown=/l150540/l
\FilledTriangleLeft=/l150541/l
\FilledTriangleRight=/l150542/l
\FilledTriangleUp=/l150543/l
\HBar=/l150544/l
\LowerDiamond=/l150545/l
\RightDiamond=/l150546/l
\SmallCircle=/l150547/l
\SmallCross=/l150548/l
\SmallDiamondshape=/l150549/l
\SmallHBar=/l150550/l
\SmallLowerDiamond=/l150551/l
\SmallRightDiamond=/l150552/l
\SmallSquare=/l150553/l
\SmallTriangleDown=/l150554/l
\SmallTriangleLeft=/l150555/l
\SmallTriangleRight=/l150556/l
\SmallTriangleUp=/l150557/l
\SmallVBar=/l150558/l
\SpinDown=/l150559/l
\SpinUp=/l150560/l
\Square=/l150561/l
\SquareShadowA=/l150562/l
\SquareShadowB=/l150563/l
\SquareShadowC=/l150564/l
\TriangleDown=/l150565/l
\TriangleLeft=/l150566/l
\TriangleRight=/l150567/l
\TriangleUp=/l150568/l
\VBar=/l150569/l

// 151000 - bbding Geometric Shapes
\CircleShadow=/l151001/l
\CircleSolid=/l151002/l
\DiamondSolid=/l151003/l
\Ellipse=/l151004/l
\EllipseShadow=/l151005/l
\EllipseSolid=/l151006/l
\HalfCircleLeft=/l151007/l
\HalfCircleRight=/l151008/l
\Rectangle=/l151009/l
\RectangleBold=/l151010/l
\RectangleThin=/l151011/l
\Square=/l151012/l
\SquareCastShadowBottomRight=/l151013/l
\SquareCastShadowTopLeft=/l151014/l
\SquareCastShadowTopRight=/l151015/l
\SquareShadowBottomRight=/l151016/l
\SquareShadowTopLeft=/l151017/l
\SquareShadowTopRight=/l151018/l
\SquareSolid=/l151019/l
\TriangleDown=/l151020/l
\TriangleUp=/l151021/l

// 151500 - pifont Geometric Shapes
\ding{108}=/l151501/l
\ding{109}=/l151502/l
\ding{110}=/l151503/l
\ding{111}=/l151504/l
\ding{112}=/l151505/l
\ding{113}=/l151506/l
\ding{114}=/l151507/l
\ding{115}=/l151508/l
\ding{116}=/l151509/l
\ding{117}=/l151510/l
\ding{119}=/l151511/l
\ding{120}=/l151512/l
\ding{121}=/l151513/l
\ding{122}=/l151514/l

// 152000 - manfnt Dangerous Bend Symbols
\dbend=/l152001/l
\lhdbend=/l152002/l
\reversedvideodbend=/l152003/l

// 152500 - marvosym Information Symbols
\Bicycle=/l152501/l
\Checkedbox=/l152502/l
\Clocklogo=/l152503/l
\Coffeecup=/l152504/l
\Crossedbox=/l152505/l
\Football=/l152506/l
\Gentsroom=/l152507/l
\Industry=/l152508/l
\Info=/l152509/l
\Ladiesroom=/l152510/l
\Pointinghand=/l152511/l
\Wheelchair=/l152512/l
\Writinghand=/l152513/l

// 153000 - Miscellaneous dingbat Dingbats
\anchor=/l153001/l
\carriagereturn=/l153002/l
\checkmark=/l153003/l
\eye=/l153004/l
\filledsquarewithdots=/l153005/l
\satellitedish=/l153006/l
\Sborder=/l153007/l
\squarewithdots=/l153008/l
\Zborder=/l153009/l

// 153500 - Miscellaneous bbding Dingbats
\Envelope=/l153501/l
\OrnamentDiamondSolid=/l153502/l
\Peace=/l153503/l
\Phone=/l153504/l
\PhoneHandset=/l153505/l
\Plane=/l153506/l
\SunshineOpenCircled=/l153507/l
\Tape=/l153508/l

// 154000 - Miscellaneous pifont Dingbats
\ding{37}=/l154001/l
\ding{38}=/l154002/l
\ding{39}=/l154003/l
\ding{40}=/l154004/l
\ding{41}=/l154005/l
\ding{118}=/l154006/l
\ding{164}=/l154007/l
\ding{165}=/l154008/l
\ding{166}=/l154009/l
\ding{167}=/l154010/l
\ding{168}=/l154011/l
\ding{170}=/l154012/l
\ding{171}=/l154013/l
\ding{169}=/l154014/l

// 154500 - textcomp Genealogical Symbols
\textborn=/l154501/l
\textdied=/l154502/l
\textdivorced=/l154503/l
\textleaf=/l154504/l
\textmarried=/l154505/l

// 155000 - wasysym General Symbols
\agemO=/l155001/l
\ataribox=/l155002/l
\bell=/l155003/l
\blacksmiley=/l155004/l
\Bowtie=/l155005/l
\brokenvert=/l155006/l
\cent=/l155007/l
\checked=/l155008/l
\clock=/l155009/l
\currency=/l155010/l
\diameter=/l155011/l
\DOWNarrow=/l155012/l
\female=/l155013/l
\frownie=/l155014/l
\invdiameter=/l155015/l
\kreuz=/l155016/l
\LEFTarrow=/l155017/l
\lightning=/l155018/l
\male=/l155019/l
\permil=/l155020/l
\phone=/l155021/l
\pointer=/l155022/l
\recorder=/l155023/l
\RIGHTarrow=/l155024/l
\smiley=/l155025/l
\sun=/l155026/l
\UParrow=/l155027/l
\varangle=/l155028/l
\wasylozenge=/l155029/l
\wasytherefore=/l155030/l

// 155500 - wasysym Musical Notes
\eighthnote=/l155501/l
\halfnote=/l155502/l
\twonotes=/l155503/l
\fullnote=/l155504/l
\quarternote=/l155505/l

// 156000 - wasysym Circles
\CIRCLE=/l156001/l
\Circle=/l156002/l
\LEFTCIRCLE=/l156003/l
\LEFTcircle=/l156004/l
\Leftcircle=/l156005/l
\RIGHTCIRCLE=/l156006/l
\RIGHTcircle=/l156007/l
\Rightcircle=/l156008/l
\leftturn=/l156009/l
\rightturn=/l156010/l

// 156500 - Miscellaneous manfnt Symbols
\manboldkidney=/l156501/l
\manconcentriccircles=/l156502/l
\manconcentricdiamond=/l156503/l
\mancone=/l156504/l
\mancube=/l156505/l
\manerrarrow=/l156506/l
\manfilledquartercircle=/l156507/l
\manhpennib=/l156508/l
\manimpossiblecube=/l156509/l
\mankidney=/l156510/l
\manlhpenkidney=/l156511/l
\manpenkidney=/l156512/l
\manquadrifolium=/l156513/l
\manquartercircle=/l156514/l
\manrotatedquadrifolium=/l156515/l
\manrotatedquartercircle=/l156516/l
\manstar=/l156517/l
\mantiltpennib=/l156518/l
\mantriangledown=/l156519/l
\mantriangleright=/l156520/l
\mantriangleup=/l156521/l
\manvpennib=/l156522/l

// 157000 - marvosym Navigation Symbols
\Forward=/l157001/l
\ForwardToEnd=/l157002/l
\ForwardToIndex=/l157003/l
\MoveDown=/l157004/l
\MoveUp=/l157005/l
\Rewind=/l157006/l
\RewindToIndex=/l157007/l
\RewindToStart=/l157008/l
\ToBottom=/l157009/l
\ToTop=/l157010/l

// 157500 - marvosym Laundry Symbols
\AtForty=/l157501/l
\AtNinetyFive=/l157502/l
\AtSixty=/l157503/l
\Bleech=/l157504/l
\CleaningA=/l157505/l
\CleaningF=/l157506/l
\CleaningFF=/l157507/l
\CleaningP=/l157508/l
\CleaningPP=/l157509/l
\Dontwash=/l157510/l
\Handwash=/l157511/l
\IroningI=/l157512/l
\IroningII=/l157513/l
\IroningIII=/l157514/l
\NoBleech=/l157515/l
\NoChemicalCleaning=/l157516/l
\NoIroning=/l157517/l
\NoTumbler=/l157518/l
\ShortFifty=/l157519/l
\ShortForty=/l157520/l
\ShortNinetyFive=/l157521/l
\ShortSixty=/l157522/l
\ShortThirty=/l157523/l
\SpecialForty=/l157524/l
\Tumbler=/l157525/l
\WashCotton=/l157526/l
\WashSynthetics=/l157527/l
\WashWool=/l157528/l

// 158000 - Other marvosym Symbols
\Ankh=/l158001/l
\Bat=/l158002/l
\Bouquet=/l158003/l
\Celtcross=/l158004/l
\CircledA=/l158005/l
\Cross=/l158006/l
\FHBOlogo=/l158007/l
\FHBOLOGO=/l158008/l
\Frowny=/l158009/l
\FullFHBO=/l158010/l
\Heart=/l158011/l
\MartinVogel=/l158012/l
\Mundus=/l158013/l
\MVAt=/l158014/l
\Rightarrow=/l158015/l
\Smiley=/l158016/l
\Womanface=/l158017/l
\Yinyang=/l158018/l

// 158500 - ifsym Weather Symbols
\Blitz=/l158501/l
\Cloud=/l158502/l
\FilledCloud=/l158503/l
\FilledRainCloud=/l158504/l
\FilledSnowCloud=/l158505/l
\FilledSunCloud=/l158506/l
\FilledWeakRainCloud=/l158507/l
\Fog=/l158508/l
\Graupel=/l158509/l
\Hagel=/l158510/l
\HalfSun=/l158511/l
\NoSun=/l158512/l
\Rain=/l158513/l
\RainCloud=/l158514/l
\Snow=/l158515/l
\SnowCloud=/l158516/l
\Sun=/l158517/l
\SunCloud=/l158518/l
\ThinFog=/l158519/l
\WeakRain=/l158520/l
\WeakRainCloud=/l158521/l
\Thermo{}=/l158522/l

// 159000 - ifsym Alpine Symbols
\FilledHut=/l159001/l
\Flag=/l159002/l
\HalfFilledHut=/l159003/l
\Hut=/l159004/l
\IceMountain=/l159005/l
\Joch=/l159006/l
\Mountain=/l159007/l
\StoneMan=/l159008/l
\Summit=/l159009/l
\SummitSign=/l159010/l
\Tent=/l159011/l
\VarFlag=/l159012/l
\VarIceMountain=/l159013/l
\VarMountain=/l159014/l
\VarSummit=/l159015/l
\Vermessung=/l159016/l
\Village=/l159017/l

// 159500 - ifsym Clocks
\Interval=/l159501/l
\StopWatchEnd=/l159502/l
\StopWatchStart=/l159503/l
\Taschenuhr=/l159504/l
\VarClock=/l159505/l
\VarTaschenuhr=/l159506/l
\Wecker=/l159507/l
\showclock{}{}=/l159508/l

// 160000 - Other ifsym Symbols
\FilledSectioningDiamond=/l160001/l
\Fire=/l160002/l
\Irritant=/l160003/l
\Letter=/l160004/l
\PaperLandscape=/l160005/l
\PaperPortrait=/l160006/l
\Radiation=/l160007/l
\SectioningDiamond=/l160008/l
\Telephone=/l160009/l
\StrokeOne=/l160010/l
\StrokeTwo=/l160011/l
\StrokeThree=/l160012/l
\StrokeFour=/l160013/l
\StrokeFive=/l160014/l
\Cube{1}=/l160015/l
\Cube{2}=/l160016/l
\Cube{3}=/l160017/l
\Cube{4}=/l160018/l
\Cube{5}=/l160019/l
\Cube{6}=/l160020/l


// This section defines commands related to the group of files
// Syntaxt of the row:
//     name     - command name (nicetext)
//     bitmap   - bitmap code from resources
//     shortcut - hotkey 
//     label    - (nicetext)
//     hint     - (nicetext)
//     command  - command to execute
//
// Command syntax:
//     exec:nicetext - execute nicetext
//     ins:nicetext' - insert nicetext to the editor window (_ denotes cursor position)
//
// Predefined constants:
//     <PROGRAMDIR>       - LEd directory
//     <PROJECT>          - full path of the project, e.g., C:\Papers\Newest.lpr
//     <PROJECTDIR>       - project directory, e.g., C:\Papers
//     <PROJECTNAME>      - project name, e.g., Newest
//     <PROJECTNAMEEXT>   - project name with extension, e.g., Newest.lpr
//     <MAINFILE>         - full path to the main project file, e.g., C:\Papers\Main.tex
//     <MAINFILEDIR>      - directory name of the main project file, e.g., C:\Papers
//     <MAINFILENAME>     - main file name, e.g., Main
//     <MAINFILENAMEEXT>  - main file name with extension, e.g., Main.tex
//     <FILE>             - full path to the selected file
//     <FILEDIR>          - directory of the selected file
//     <FILENAME>         - selected file name
//     <FILENAMEEXT>      - selected file name with extension
//     <BatchesDir>       - directory with LEd batches
//     <DefinitionsDir>   - directory with LEd definitions
//     <DictionariesDir>  - directory with LEd dictionaries
//     <LanguagesDir>     - directory with LEd language resources
//     <ProjectsDir>      - default LEd directory for projects
//     <TemplatesDir>     - directory with LEd templates
//     <ResourcesDir>     - directory with LEd resources
// Commands to work in math and text mode
[commands\/bLaTeX - /l100999/l\/l100500/l]
100501=100501==/l90001/l\$=/l200501/l=ins:\$
100502=100502==/l90001/l\P=/l200502/l=ins:\P
100503=100503==/l90001/l\S=/l200503/l=ins:\S
100504=100504==/l90001/l\_=/l200504/l=ins:\_
100505=100505==/l90001/l\copyright=/l200505/l=ins:\copyright
100506=100506==/l90001/l\dag=/l200506/l=ins:\dag
100507=100507==/l90001/l\ddag=/l200507/l=ins:\ddag
100508=100508==/l90001/l\dots=/l200508/l=ins:\dots
100509=100509==/l90001/l\pounds=/l200509/l=ins:\pounds
100510=100510==/l90001/l\{=/l200510/l=ins:\{
100511=100511==/l90001/l\}=/l200511/l=ins:\}

// Predefined LaTeX2e Text-Mode Comands
[commands\/bLaTeX - /l101499\/l101000/l]
101001=101001==/l90001/l\textasciicircum=/l201001/l=ins:\textasciicircum
101002=101002==/l90001/l\textasciitilde=/l201002/l=ins:\textasciitilde
101003=101003==/l90001/l\textasteriskcentered=/l201003/l=ins:\textasteriskcentered
101004=101004==/l90001/l\textbackslash=/l201004/l=ins:\textbackslash
101005=101005==/l90001/l\textbar=/l201005/l=ins:\textbar
101006=101006==/l90001/l\textbraceleft=/l201006/l=ins:\textbraceleft
101007=101007==/l90001/l\textbraceright=/l201007/l=ins:\textbraceright
101008=101008==/l90001/l\textbullet=/l201008/l=ins:\textbullet
101009=101009==/l90001/l\textcopyright=/l201009/l=ins:\textcopyright
101010=101010==/l90001/l\textdagger=/l201010/l=ins:\textdagger
101011=101011==/l90001/l\textdaggerdbl=/l201011/l=ins:\textdaggerdbl
101012=101012==/l90001/l\textdollar=/l201012/l=ins:\textdollar
101013=101013==/l90001/l\textellipsis=/l201013/l=ins:\textellipsis
101014=101014==/l90001/l\textemdash=/l201014/l=ins:\textemdash
101015=101015==/l90001/l\textendash=/l201015/l=ins:\textendash
101016=101016==/l90001/l\textexclamdown=/l201016/l=ins:\textexclamdown
101017=101017==/l90001/l\textgreater=/l201017/l=ins:\textgreater
101018=101018==/l90001/l\textless=/l201018/l=ins:\textless
101019=101019==/l90001/l\textordfeminine=/l201019/l=ins:\textordfeminine
101020=101020==/l90001/l\textordmasculine=/l201020/l=ins:\textordmasculine
101021=101021==/l90001/l\textparagraph=/l201021/l=ins:\textparagraph
101022=101022==/l90001/l\textperiodcentered=/l201022/l=ins:\textperiodcentered
101023=101023==/l90001/l\textquestiondown=/l201023/l=ins:\textquestiondown
101024=101024==/l90001/l\textquotedblleft=/l201024/l=ins:\textquotedblleft
101025=101025==/l90001/l\textquotedblright=/l201025/l=ins:\textquotedblright
101026=101026==/l90001/l\textquoteleft=/l201026/l=ins:\textquoteleft
101027=101027==/l90001/l\textquoteright=/l201027/l=ins:\textquoteright
101028=101028==/l90001/l\textregistered=/l201028/l=ins:\textregistered
101029=101029==/l90001/l\textsection=/l201029/l=ins:\textsection
101030=101030==/l90001/l\textsterling=/l201030/l=ins:\textsterling
101031=101031==/l90001/l\texttrademark=/l201031/l=ins:\texttrademark
101032=101032==/l90001/l\textunderscore=/l201032/l=ins:\textunderscore
101033=101033==/l90001/l\textvisiblespace=/l201033/l=ins:\textvisiblespace

// Non-ASCI Letters (Excluding Accented Letters)
[commands\/bLaTeX - /l101999/l\/l101500/l]
101501=101501==/l90001/l\aa=/l201501/l=ins:\aa
101502=101502==/l90001/l\AA=/l201502/l=ins:\AA
101503=101503==/l90001/l\AE=/l201503/l=ins:\AE
101504=101504==/l90001/l\ae=/l201504/l=ins:\ae
101505=101505==/l90001/l\DH=/l201505/l=ins:\DH
101506=101506==/l90001/l\dh=/l201506/l=ins:\dh
101507=101507==/l90001/l\DJ=/l201507/l=ins:\DJ
101508=101508==/l90001/l\dj=/l201508/l=ins:\dj
101509=101509==/l90001/l\L=/l201509/l=ins:\L
101510=101510==/l90001/l\l=/l201510/l=ins:\l
101511=101511==/l90001/l\NG=/l201511/l=ins:\NG
101512=101512==/l90001/l\ng=/l201512/l=ins:\ng
101513=101513==/l90001/l\o=/l201513/l=ins:\o
101514=101514==/l90001/l\O=/l201514/l=ins:\O
101515=101515==/l90001/l\OE=/l201515/l=ins:\OE
101516=101516==/l90001/l\oe=/l201516/l=ins:\oe
101517=101517==/l90001/l\ss=/l201517/l=ins:\ss
101518=101518==/l90001/l\SS=/l201518/l=ins:\SS
101519=101519==/l90001/l\TH=/l201519/l=ins:\TH
101520=101520==/l90001/l\th=/l201520/l=ins:\th

// Letters Used to Typeset Affrican Languages
[commands\/bLaTeX - /l102499/l\/l102000/l]
102001=102001==/l90001/l\B{D}=/l202001/l=ins:\B{D}
102002=102002==/l90001/l\B{d}=/l202002/l=ins:\B{d}
102003=102003==/l90001/l\B{H}=/l202003/l=ins:\B{H}
102004=102004==/l90001/l\B{h}=/l202004/l=ins:\B{h}
102005=102005==/l90001/l\B{t}=/l202005/l=ins:\B{t}
102006=102006==/l90001/l\B{T}=/l202006/l=ins:\B{T}
102007=102007==/l90001/l\m{b}=/l202007/l=ins:\m{b}
102008=102008==/l90001/l\m{B}=/l202008/l=ins:\m{B}
102009=102009==/l90001/l\m{C}=/l202009/l=ins:\m{C}
102010=102010==/l90001/l\m{c}=/l202010/l=ins:\m{c}
102011=102011==/l90001/l\m{D}=/l202011/l=ins:\m{D}
102012=102012==/l90001/l\M{d}=/l202012/l=ins:\M{d}
102013=102013==/l90001/l\M{D}=/l202013/l=ins:\M{D}
102014=102014==/l90001/l\m{d}=/l202014/l=ins:\m{d}
102015=102015==/l90001/l\m{E}=/l202015/l=ins:\m{E}
102016=102016==/l90001/l\m{e}=/l202016/l=ins:\m{e}
102017=102017==/l90001/l\M{E}=/l202017/l=ins:\M{E}
102018=102018==/l90001/l\M{e}=/l202018/l=ins:\M{e}
102019=102019==/l90001/l\m{f}=/l202019/l=ins:\m{f}
102020=102020==/l90001/l\m{F}=/l202020/l=ins:\m{F}
102021=102021==/l90001/l\m{G}=/l202021/l=ins:\m{G}
102022=102022==/l90001/l\m{g}=/l202022/l=ins:\m{g}
102023=102023==/l90001/l\m{I}=/l202023/l=ins:\m{I}
102024=102024==/l90001/l\m{i}=/l202024/l=ins:\m{i}
102025=102025==/l90001/l\m{J}=/l202025/l=ins:\m{J}
102026=102026==/l90001/l\m{j}=/l202026/l=ins:\m{j}
102027=102027==/l90001/l\m{K}=/l202027/l=ins:\m{K}
102028=102028==/l90001/l\m{k}=/l202028/l=ins:\m{k}
102029=102029==/l90001/l\m{N}=/l202029/l=ins:\m{N}
102030=102030==/l90001/l\m{n}=/l202030/l=ins:\m{n}
102031=102031==/l90001/l\m{o}=/l202031/l=ins:\m{o}
102032=102032==/l90001/l\m{O}=/l202032/l=ins:\m{O}
102033=102033==/l90001/l\m{P}=/l202033/l=ins:\m{P}
102034=102034==/l90001/l\m{p}=/l202034/l=ins:\m{p}
102035=102035==/l90001/l\m{s}=/l202035/l=ins:\m{s}
102036=102036==/l90001/l\m{S}=/l202036/l=ins:\m{S}
102037=102037==/l90001/l\M{t}=/l202037/l=ins:\M{t}
102038=102038==/l90001/l\M{T}=/l202038/l=ins:\M{T}
102039=102039==/l90001/l\m{t}=/l202039/l=ins:\m{t}
102040=102040==/l90001/l\m{T}=/l202040/l=ins:\m{T}
102041=102041==/l90001/l\m{u}=/l202041/l=ins:\m{u}
102042=102042==/l90001/l\m{U}=/l202042/l=ins:\m{U}
102043=102043==/l90001/l\m{Y}=/l202043/l=ins:\m{Y}
102044=102044==/l90001/l\m{y}=/l202044/l=ins:\m{y}
102045=102045==/l90001/l\m{z}=/l202045/l=ins:\m{z}
102046=102046==/l90001/l\m{Z}=/l202046/l=ins:\m{Z}
102047=102047==/l90001/l\T{E}=/l202047/l=ins:\T{E}
102048=102048==/l90001/l\T{e}=/l202048/l=ins:\T{e}
102049=102049==/l90001/l\T{O}=/l202049/l=ins:\T{O}
102050=102050==/l90001/l\T{o}=/l202050/l=ins:\T{o}

// 102500 - Punctuation Marks Not Found in OT1
[commands\/bLaTeX - /l102999/l\/l102500/l]
102501=102501==/l90001/l\guillemotleft=/l202501/l=ins:\guillemotleft
102502=102502==/l90001/l\guillemotright=/l202502/l=ins:\guillemotright
102503=102503==/l90001/l\guilsinglleft=/l202503/l=ins:\guilsinglleft
102504=102504==/l90001/l\guilsinglright=/l202504/l=ins:\guilsinglright
102505=102505==/l90001/l\quotedblbase=/l202505/l=ins:\quotedblbase
102506=102506==/l90001/l\quotesinglbase=/l202506/l=ins:\quotesinglbase
102507=102507==/l90001/l\textquotedbl=/l202507/l=ins:\textquotedbl

// 103000 - pifont Decorative Punctuation Marks
103001=103001==/l90001/l\ding{123}=/l203001/l=ins:\ding{123}
103002=103002==/l90001/l\ding{124}=/l203002/l=ins:\ding{124}
103003=103003==/l90001/l\ding{125}=/l203003/l=ins:\ding{125}
103004=103004==/l90001/l\ding{126}=/l203004/l=ins:\ding{126}
103005=103005==/l90001/l\ding{161}=/l203005/l=ins:\ding{161}
103006=103006==/l90001/l\ding{162}=/l203006/l=ins:\ding{162}
103007=103007==/l90001/l\ding{163}=/l203007/l=ins:\ding{163}

// 103500 - Text-Mode Accents
103501=103501==/l90001/l\"{A}=/l203501/l=ins:\"{A}
103502=103502==/l90001/l\"{a}=/l203502/l=ins:\"{a}
103503=103503==/l90001/l\{A}=/l203503/l=ins:\{A}
103504=103504==/l90001/l\{a}=/l203504/l=ins:\{a}
103505=103505==/l90001/l\.{A}=/l203505/l=ins:\.{A}
103506=103506==/l90001/l\.{a}=/l203506/l=ins:\.{a}
103507=103507==/l90001/l\/={A}=/l203507/l=ins:\/={A}
103508=103508==/l90001/l\/={a}=/l203508/l=ins:\/={a}
103509=103509==/l90001/l\^{A}=/l203509/l=ins:\^{A}
103510=103510==/l90001/l\^{a}=/l203510/l=ins:\^{a}
103511=103511==/l90001/l\newtie{A}=/l203511/l=ins:\newtie{A}
103512=103512==/l90001/l\newtie{a}=/l203512/l=ins:\newtie{a}
103513=103513==/l90001/l\{A}=/l203513/l=ins:\{A}
103514=103514==/l90001/l\{a}=/l203514/l=ins:\{a}
103515=103515==/l90001/l\b{A}=/l203515/l=ins:\b{A}
103516=103516==/l90001/l\b{a}=/l203516/l=ins:\b{a}
103517=103517==/l90001/l\c{A}=/l203517/l=ins:\c{A}
103518=103518==/l90001/l\c{a}=/l203518/l=ins:\c{a}
103519=103519==/l90001/l\d{A}=/l203519/l=ins:\d{A}
103520=103520==/l90001/l\d{a}=/l203520/l=ins:\d{a}
103521=103521==/l90001/l\G{A}=/l203521/l=ins:\G{A}
103522=103522==/l90001/l\G{a}=/l203522/l=ins:\G{a}
103523=103523==/l90001/l\H{A}=/l203523/l=ins:\H{A}
103524=103524==/l90001/l\H{a}=/l203524/l=ins:\H{a}
103525=103525==/l90001/l\k{A}=/l203525/l=ins:\k{A}
103526=103526==/l90001/l\k{a}=/l203526/l=ins:\k{a}
103527=103527==/l90001/l\r{A}=/l203527/l=ins:\r{A}
103528=103528==/l90001/l\r{a}=/l203528/l=ins:\r{a}
103529=103529==/l90001/l\t{A}=/l203529/l=ins:\t{A}
103530=103530==/l90001/l\t{a}=/l203530/l=ins:\t{a}
103531=103531==/l90001/l\U{A}=/l203531/l=ins:\U{A}
103532=103532==/l90001/l\U{a}=/l203532/l=ins:\U{a}
103533=103533==/l90001/l\u{A}=/l203533/l=ins:\u{A}
103534=103534==/l90001/l\u{a}=/l203534/l=ins:\u{a}
103535=103535==/l90001/l\v{A}=/l203535/l=ins:\v{A}
103536=103536==/l90001/l\v{a}=/l203536/l=ins:\v{a}
103537=103537==/l90001/l\~{A}=/l203537/l=ins:\~{A}
103538=103538==/l90001/l\~{a}=/l203538/l=ins:\~{a}

// 104000 - tipa Text-Mode Accents
104001=104001==/l90001/l\textacutemacron{A}=/l204001/l=ins:\textacutemacron{A}
104002=104002==/l90001/l\textacutemacron{a}=/l204002/l=ins:\textacutemacron{a}
104003=104003==/l90001/l\textacutewedge{A}=/l204003/l=ins:\textacutewedge{A}
104004=104004==/l90001/l\textacutewedge{a}=/l204004/l=ins:\textacutewedge{a}
104005=104005==/l90001/l\textadvancing{A}=/l204005/l=ins:\textadvancing{A}
104006=104006==/l90001/l\textadvancing{A}=/l204006/l=ins:\textadvancing{A}
104007=104007==/l90001/l\textbottomtiebar{A}=/l204007/l=ins:\textbottomtiebar{A}
104008=104008==/l90001/l\textbottomtiebar{a}=/l204008/l=ins:\textbottomtiebar{a}
104009=104009==/l90001/l\textbrevemacron{A}=/l204009/l=ins:\textbrevemacron{A}
104010=104010==/l90001/l\textbrevemacron{a}=/l204010/l=ins:\textbrevemacron{a}
104011=104011==/l90001/l\textcircumacute{A}=/l204011/l=ins:\textcircumacute{A}
104012=104012==/l90001/l\textcircumacute{a}=/l204012/l=ins:\textcircumacute{a}
104013=104013==/l90001/l\textcircumdot{A}=/l204013/l=ins:\textcircumdot{A}
104014=104014==/l90001/l\textcircumdot{a}=/l204014/l=ins:\textcircumdot{a}
104015=104015==/l90001/l\textdotacute{A}=/l204015/l=ins:\textdotacute{A}
104016=104016==/l90001/l\textdotacute{a}=/l204016/l=ins:\textdotacute{a}
104017=104017==/l90001/l\textdotbreve{A}=/l204017/l=ins:\textdotbreve{A}
104018=104018==/l90001/l\textdotbreve{a}=/l204018/l=ins:\textdotbreve{a}
104019=104019==/l90001/l\textdoublegrave{A}=/l204019/l=ins:\textdoublegrave{A}
104020=104020==/l90001/l\textdoublegrave{a}=/l204020/l=ins:\textdoublegrave{a}
104021=104021==/l90001/l\textdoublevbaraccent{A}=/l204021/l=ins:\textdoublevbaraccent{A}
104022=104022==/l90001/l\textdoublevbaraccent{a}=/l204022/l=ins:\textdoublevbaraccent{a}
104023=104023==/l90001/l\textgravecircum{A}=/l204023/l=ins:\textgravecircum{A}
104024=104024==/l90001/l\textgravecircum{a}=/l204024/l=ins:\textgravecircum{a}
104025=104025==/l90001/l\textgravedot{A}=/l204025/l=ins:\textgravedot{A}
104026=104026==/l90001/l\textgravedot{a}=/l204026/l=ins:\textgravedot{a}
104027=104027==/l90001/l\textgravemid{A}=/l204027/l=ins:\textgravemid{A}
104028=104028==/l90001/l\textgravemid{a}=/l204028/l=ins:\textgravemid{a}
104029=104029==/l90001/l\textinvsubbridge{A}=/l204029/l=ins:\textinvsubbridge{A}
104030=104030==/l90001/l\textinvsubbridge{a}=/l204030/l=ins:\textinvsubbridge{a}
104031=104031==/l90001/l\textlowering{A}=/l204031/l=ins:\textlowering{A}
104032=104032==/l90001/l\textlowering{a}=/l204032/l=ins:\textlowering{a}
104033=104033==/l90001/l\textmidacute{A}=/l204033/l=ins:\textmidacute{A}
104034=104034==/l90001/l\textmidacute{a}=/l204034/l=ins:\textmidacute{a}
104035=104035==/l90001/l\textovercross{A}=/l204035/l=ins:\textovercross{A}
104036=104036==/l90001/l\textovercross{a}=/l204036/l=ins:\textovercross{a}
104037=104037==/l90001/l\textoverw{A}=/l204037/l=ins:\textoverw{A}
104038=104038==/l90001/l\textoverw{a}=/l204038/l=ins:\textoverw{a}
104039=104039==/l90001/l\textpolhook{A}=/l204039/l=ins:\textpolhook{A}
104040=104040==/l90001/l\textpolhook{a}=/l204040/l=ins:\textpolhook{a}
104041=104041==/l90001/l\textraising{A}=/l204041/l=ins:\textraising{A}
104042=104042==/l90001/l\textraising{a}=/l204042/l=ins:\textraising{a}
104043=104043==/l90001/l\textretracting{A}=/l204043/l=ins:\textretracting{A}
104044=104044==/l90001/l\textretracting{a}=/l204044/l=ins:\textretracting{a}
104045=104045==/l90001/l\textringmacron{A}=/l204045/l=ins:\textringmacron{A}
104046=104046==/l90001/l\textringmacron{a}=/l204046/l=ins:\textringmacron{a}
104047=104047==/l90001/l\textroundcap{A}=/l204047/l=ins:\textroundcap{A}
104048=104048==/l90001/l\textroundcap{a}=/l204048/l=ins:\textroundcap{a}
104049=104049==/l90001/l\textseagull{A}=/l204049/l=ins:\textseagull{A}
104050=104050==/l90001/l\textseagull{a}=/l204050/l=ins:\textseagull{a}
104051=104051==/l90001/l\textsubarch{A}=/l204051/l=ins:\textsubarch{A}
104052=104052==/l90001/l\textsubarch{a}=/l204052/l=ins:\textsubarch{a}
104053=104053==/l90001/l\textsubbar{A}=/l204053/l=ins:\textsubbar{A}
104054=104054==/l90001/l\textsubbar{a}=/l204054/l=ins:\textsubbar{a}
104055=104055==/l90001/l\textsubbridge{A}=/l204055/l=ins:\textsubbridge{A}
104056=104056==/l90001/l\textsubbridge{a}=/l204056/l=ins:\textsubbridge{a}
104057=104057==/l90001/l\textsubdot{A}=/l204057/l=ins:\textsubdot{A}
104058=104058==/l90001/l\textsubdot{a}=/l204058/l=ins:\textsubdot{a}
104059=104059==/l90001/l\textsublhalfring{A}=/l204059/l=ins:\textsublhalfring{A}
104060=104060==/l90001/l\textsublhalfring{a}=/l204060/l=ins:\textsublhalfring{a}
104061=104061==/l90001/l\textsubplus{A}=/l204061/l=ins:\textsubplus{A}
104062=104062==/l90001/l\textsubplus{a}=/l204062/l=ins:\textsubplus{a}
104063=104063==/l90001/l\textsubrhalfring{A}=/l204063/l=ins:\textsubrhalfring{A}
104064=104064==/l90001/l\textsubrhalfring{a}=/l204064/l=ins:\textsubrhalfring{a}
104065=104065==/l90001/l\textsubring{A}=/l204065/l=ins:\textsubring{A}
104066=104066==/l90001/l\textsubring{a}=/l204066/l=ins:\textsubring{a}
104067=104067==/l90001/l\textsubsquare{A}=/l204067/l=ins:\textsubsquare{A}
104068=104068==/l90001/l\textsubsquare{a}=/l204068/l=ins:\textsubsquare{a}
104069=104069==/l90001/l\textsubtilde{A}=/l204069/l=ins:\textsubtilde{A}
104070=104070==/l90001/l\textsubtilde{a}=/l204070/l=ins:\textsubtilde{a}
104071=104071==/l90001/l\textsubumlaut{A}=/l204071/l=ins:\textsubumlaut{A}
104072=104072==/l90001/l\textsubumlaut{a}=/l204072/l=ins:\textsubumlaut{a}
104073=104073==/l90001/l\textsubw{A}=/l204073/l=ins:\textsubw{A}
104074=104074==/l90001/l\textsubw{a}=/l204074/l=ins:\textsubw{a}
104075=104075==/l90001/l\textsubwedge{A}=/l204075/l=ins:\textsubwedge{A}
104076=104076==/l90001/l\textsubwedge{a}=/l204076/l=ins:\textsubwedge{a}
104077=104077==/l90001/l\textsuperimposetilde{A}=/l204077/l=ins:\textsuperimposetilde{A}
104078=104078==/l90001/l\textsuperimposetilde{a}=/l204078/l=ins:\textsuperimposetilde{a}
104079=104079==/l90001/l\textsyllabic{A}=/l204079/l=ins:\textsyllabic{A}
104080=104080==/l90001/l\textsyllabic{a}=/l204080/l=ins:\textsyllabic{a}
104081=104081==/l90001/l\texttildedot{A}=/l204081/l=ins:\texttildedot{A}
104082=104082==/l90001/l\texttildedot{a}=/l204082/l=ins:\texttildedot{a}
104083=104083==/l90001/l\texttoptiebar{A}=/l204083/l=ins:\texttoptiebar{A}
104084=104084==/l90001/l\texttoptiebar{a}=/l204084/l=ins:\texttoptiebar{a}
104085=104085==/l90001/l\textvbaraccent{A}=/l204085/l=ins:\textvbaraccent{A}
104086=104086==/l90001/l\textvbaraccent{a}=/l204086/l=ins:\textvbaraccent{a}

// 104500 - wsuipa Text-Mode Accents
104501=104501==/l90001/l\dental{A}=/l204501/l=ins:\dental{A}
104502=104502==/l90001/l\dental{a}=/l204502/l=ins:\dental{a}
104503=104503==/l90001/l\underarch{A}=/l204503/l=ins:\underarch{A}
104504=104504==/l90001/l\underarch{a}=/l204504/l=ins:\underarch{a}

// 105000 - wsuipa Diacritics
105001=105001==/l90001/l\ain=/l205001/l=ins:\ain
105002=105002==/l90001/l\corner=/l205002/l=ins:\corner
105003=105003==/l90001/l\downp=/l205003/l=ins:\downp
105004=105004==/l90001/l\downp=/l205004/l=ins:\downp
105005=105005==/l90001/l\halflength=/l205005/l=ins:\halflength
105006=105006==/l90001/l\leftp=/l205006/l=ins:\leftp
105007=105007==/l90001/l\leftt=/l205007/l=ins:\leftt
105008=105008==/l90001/l\length=/l205008/l=ins:\length
105009=105009==/l90001/l\midtilde=/l205009/l=ins:\midtilde
105010=105010==/l90001/l\open=/l205010/l=ins:\open
105011=105011==/l90001/l\overring=/l205011/l=ins:\overring
105012=105012==/l90001/l\polishhook=/l205012/l=ins:\polishhook
105013=105013==/l90001/l\rightp=/l205013/l=ins:\rightp
105014=105014==/l90001/l\rightt=/l205014/l=ins:\rightt
105015=105015==/l90001/l\secstress=/l205015/l=ins:\secstress
105016=105016==/l90001/l\stress=/l205016/l=ins:\stress
105017=105017==/l90001/l\syllabic=/l205017/l=ins:\syllabic
105018=105018==/l90001/l\underdots=/l205018/l=ins:\underdots
105019=105019==/l90001/l\underring=/l205019/l=ins:\underring
105020=105020==/l90001/l\undertilde=/l205020/l=ins:\undertilde
105021=105021==/l90001/l\underwedge=/l205021/l=ins:\underwedge
105022=105022==/l90001/l\upp=/l205022/l=ins:\upp
105023=105023==/l90001/l\upt=/l205023/l=ins:\upt

// 105500 - textcomp Diacritics
105501=105501==/l90001/l\textacutedbl=/l205501/l=ins:\textacutedbl
105502=105502==/l90001/l\textasciiacute=/l205502/l=ins:\textasciiacute
105503=105503==/l90001/l\textasciibreve=/l205503/l=ins:\textasciibreve
105504=105504==/l90001/l\textasciicaron=/l205504/l=ins:\textasciicaron
105505=105505==/l90001/l\textasciidieresis=/l205505/l=ins:\textasciidieresis
105506=105506==/l90001/l\textasciigrave=/l205506/l=ins:\textasciigrave
105507=105507==/l90001/l\textasciimacron=/l205507/l=ins:\textasciimacron
105508=105508==/l90001/l\textgravedbl=/l205508/l=ins:\textgravedbl
105509=105509==/l90001/l\texttildelow=/l205509/l=ins:\texttildelow

// 106000 - textcomp Currency Symbols
106001=106001==/l90001/l\textbaht=/l206001/l=ins:\textbaht
106002=106002==/l90001/l\textcent=/l206002/l=ins:\textcent
106003=106003==/l90001/l\textcentoldstyle=/l206003/l=ins:\textcentoldstyle
106004=106004==/l90001/l\textcolonmonetary=/l206004/l=ins:\textcolonmonetary
106005=106005==/l90001/l\textcurrency=/l206005/l=ins:\textcurrency
106006=106006==/l90001/l\textdollar=/l206006/l=ins:\textdollar
106007=106007==/l90001/l\textdollaroldstyle=/l206007/l=ins:\textdollaroldstyle
106008=106008==/l90001/l\textdong=/l206008/l=ins:\textdong
106009=106009==/l90001/l\texteuro=/l206009/l=ins:\texteuro
106010=106010==/l90001/l\textflorin=/l206010/l=ins:\textflorin
106011=106011==/l90001/l\textguarani=/l206011/l=ins:\textguarani
106012=106012==/l90001/l\textlira=/l206012/l=ins:\textlira
106013=106013==/l90001/l\textnaira=/l206013/l=ins:\textnaira
106014=106014==/l90001/l\textpeso=/l206014/l=ins:\textpeso
106015=106015==/l90001/l\textsterling=/l206015/l=ins:\textsterling
106016=106016==/l90001/l\textwon=/l206016/l=ins:\textwon
106017=106017==/l90001/l\textyen=/l206017/l=ins:\textyen

// 106500 - marvosym Currency Symbols
106501=106501==/l90001/l\Denarius=/l206501/l=ins:\Denarius
106502=106502==/l90001/l\Ecommerce=/l206502/l=ins:\Ecommerce
106503=106503==/l90001/l\EUR=/l206503/l=ins:\EUR
106504=106504==/l90001/l\EURcr=/l206504/l=ins:\EURcr
106505=106505==/l90001/l\EURdig=/l206505/l=ins:\EURdig
106506=106506==/l90001/l\EURhv=/l206506/l=ins:\EURhv
106507=106507==/l90001/l\EURtm=/l206507/l=ins:\EURtm
106508=106508==/l90001/l\EyesDollar=/l206508/l=ins:\EyesDollar
106509=106509==/l90001/l\Pfund=/l206509/l=ins:\Pfund
106510=106510==/l90001/l\Shilling=/l206510/l=ins:\Shilling

// 107000 - textcomp Legal Symbols
107001=107001==/l90001/l\textcircledP=/l207001/l=ins:\textcircledP
107002=107002==/l90001/l\textcopyleft=/l207002/l=ins:\textcopyleft
107003=107003==/l90001/l\textcopyright=/l207003/l=ins:\textcopyright
107004=107004==/l90001/l\textregistered=/l207004/l=ins:\textregistered
107005=107005==/l90001/l\textservicemark=/l207005/l=ins:\textservicemark
107006=107006==/l90001/l\texttrademark=/l207006/l=ins:\texttrademark

// 107500 - textcomp Old-Style Numerals
107501=107501==/l90001/l\textzerooldstyle=/l207501/l=ins:\textzerooldstyle
107502=107502==/l90001/l\textoneoldstyle=/l207502/l=ins:\textoneoldstyle
107503=107503==/l90001/l\texttwooldstyle=/l207503/l=ins:\texttwooldstyle
107504=107504==/l90001/l\textthreeoldstyle=/l207504/l=ins:\textthreeoldstyle
107505=107505==/l90001/l\textfouroldstyle=/l207505/l=ins:\textfouroldstyle
107506=107506==/l90001/l\textfiveoldstyle=/l207506/l=ins:\textfiveoldstyle
107507=107507==/l90001/l\textsixoldstyle=/l207507/l=ins:\textsixoldstyle
107508=107508==/l90001/l\textsevenoldstyle=/l207508/l=ins:\textsevenoldstyle
107509=107509==/l90001/l\texteightoldstyle=/l207509/l=ins:\texteightoldstyle
107510=107510==/l90001/l\textnineoldstyle=/l207510/l=ins:\textnineoldstyle

// 108000 - wasysym Phonetic Symbols
108001=108001==/l90001/l\DH=/l208001/l=ins:\DH
108002=108002==/l90001/l\Thorn=/l208002/l=ins:\Thorn
108003=108003==/l90001/l\dh=/l208003/l=ins:\dh
108004=108004==/l90001/l\inve=/l208004/l=ins:\inve
108005=108005==/l90001/l\openo=/l208005/l=ins:\openo

// 108500 - tipa Phonetic Symbols
108501=108501==/l90001/l\textbabygamma=/l208501/l=ins:\textbabygamma
108502=108502==/l90001/l\textbarb=/l208502/l=ins:\textbarb
108503=108503==/l90001/l\textbarc=/l208503/l=ins:\textbarc
108504=108504==/l90001/l\textbard=/l208504/l=ins:\textbard
108505=108505==/l90001/l\textbardotlessj=/l208505/l=ins:\textbardotlessj
108506=108506==/l90001/l\textbarg=/l208506/l=ins:\textbarg
108507=108507==/l90001/l\textglotstop=/l208507/l=ins:\textglotstop
108508=108508==/l90001/l\texthalflength=/l208508/l=ins:\texthalflength
108509=108509==/l90001/l\texthardsign=/l208509/l=ins:\texthardsign
108510=108510==/l90001/l\texthooktop=/l208510/l=ins:\texthooktop
108511=108511==/l90001/l\texthtb=/l208511/l=ins:\texthtb
108512=108512==/l90001/l\texthtbardotlessj=/l208512/l=ins:\texthtbardotlessj
108513=108513==/l90001/l\textrtaill=/l208513/l=ins:\textrtaill
108514=108514==/l90001/l\textrtailn=/l208514/l=ins:\textrtailn
108515=108515==/l90001/l\textrtailr=/l208515/l=ins:\textrtailr
108516=108516==/l90001/l\textrtails=/l208516/l=ins:\textrtails
108517=108517==/l90001/l\textrtailt=/l208517/l=ins:\textrtailt
108518=108518==/l90001/l\textrtailz=/l208518/l=ins:\textrtailz
108519=108519==/l90001/l\textbarglotstop=/l208519/l=ins:\textbarglotstop
108520=108520==/l90001/l\textbari=/l208520/l=ins:\textbari
108521=108521==/l90001/l\textbarl=/l208521/l=ins:\textbarl
108522=108522==/l90001/l\textbaro=/l208522/l=ins:\textbaro
108523=108523==/l90001/l\textbarrevglotstop=/l208523/l=ins:\textbarrevglotstop
108524=108524==/l90001/l\textbaru=/l208524/l=ins:\textbaru
108525=108525==/l90001/l\textbeltl=/l208525/l=ins:\textbeltl
108526=108526==/l90001/l\textbeta=/l208526/l=ins:\textbeta
108527=108527==/l90001/l\textbullseye=/l208527/l=ins:\textbullseye
108528=108528==/l90001/l\textceltpal=/l208528/l=ins:\textceltpal
108529=108529==/l90001/l\textchi=/l208529/l=ins:\textchi
108530=108530==/l90001/l\textcloseepsilon=/l208530/l=ins:\textcloseepsilon
108531=108531==/l90001/l\textcloseomega=/l208531/l=ins:\textcloseomega
108532=108532==/l90001/l\textcloserevepsilon=/l208532/l=ins:\textcloserevepsilon
108533=108533==/l90001/l\textcommatailz=/l208533/l=ins:\textcommatailz
108534=108534==/l90001/l\textcorner=/l208534/l=ins:\textcorner
108535=108535==/l90001/l\textcrb=/l208535/l=ins:\textcrb
108536=108536==/l90001/l\textcrd=/l208536/l=ins:\textcrd
108537=108537==/l90001/l\textcrg=/l208537/l=ins:\textcrg
108538=108538==/l90001/l\textcrh=/l208538/l=ins:\textcrh
108539=108539==/l90001/l\textcrinvglotstop=/l208539/l=ins:\textcrinvglotstop
108540=108540==/l90001/l\textcrlambda=/l208540/l=ins:\textcrlambda
108541=108541==/l90001/l\textcrtwo=/l208541/l=ins:\textcrtwo
108542=108542==/l90001/l\textctc=/l208542/l=ins:\textctc
108543=108543==/l90001/l\textctd=/l208543/l=ins:\textctd
108544=108544==/l90001/l\textctdctzlig=/l208544/l=ins:\textctdctzlig
108545=108545==/l90001/l\textctesh=/l208545/l=ins:\textctesh
108546=108546==/l90001/l\textctj=/l208546/l=ins:\textctj
108547=108547==/l90001/l\textctn=/l208547/l=ins:\textctn
108548=108548==/l90001/l\textctt=/l208548/l=ins:\textctt
108549=108549==/l90001/l\textcttctclig=/l208549/l=ins:\textcttctclig
108550=108550==/l90001/l\textctyogh=/l208550/l=ins:\textctyogh
108551=108551==/l90001/l\textctz=/l208551/l=ins:\textctz
108552=108552==/l90001/l\textdctzlig=/l208552/l=ins:\textdctzlig
108553=108553==/l90001/l\textdoublebaresh=/l208553/l=ins:\textdoublebaresh
108554=108554==/l90001/l\textdoublebarpipe=/l208554/l=ins:\textdoublebarpipe
108555=108555==/l90001/l\textdoublebarslash=/l208555/l=ins:\textdoublebarslash
108556=108556==/l90001/l\textdoublepipe=/l208556/l=ins:\textdoublepipe
108557=108557==/l90001/l\textdoublevertline=/l208557/l=ins:\textdoublevertline
108558=108558==/l90001/l\textdownstep=/l208558/l=ins:\textdownstep
108559=108559==/l90001/l\textdyoghlig=/l208559/l=ins:\textdyoghlig
108560=108560==/l90001/l\textdzlig=/l208560/l=ins:\textdzlig
108561=108561==/l90001/l\textepsilon=/l208561/l=ins:\textepsilon
108562=108562==/l90001/l\textesh=/l208562/l=ins:\textesh
108563=108563==/l90001/l\textfishhookr=/l208563/l=ins:\textfishhookr
108564=108564==/l90001/l\textg=/l208564/l=ins:\textg
108565=108565==/l90001/l\textgamma=/l208565/l=ins:\textgamma
108566=108566==/l90001/l\textglobfall=/l208566/l=ins:\textglobfall
108567=108567==/l90001/l\textglobrise=/l208567/l=ins:\textglobrise
108568=108568==/l90001/l\texthtc=/l208568/l=ins:\texthtc
108569=108569==/l90001/l\texthtd=/l208569/l=ins:\texthtd
108570=108570==/l90001/l\texthtg=/l208570/l=ins:\texthtg
108571=108571==/l90001/l\texthth=/l208571/l=ins:\texthth
108572=108572==/l90001/l\texthtk=/l208572/l=ins:\texthtk
108573=108573==/l90001/l\texthtp=/l208573/l=ins:\texthtp
108574=108574==/l90001/l\texthtq=/l208574/l=ins:\texthtq
108575=108575==/l90001/l\texthtscg=/l208575/l=ins:\texthtscg
108576=108576==/l90001/l\texthtt=/l208576/l=ins:\texthtt
108577=108577==/l90001/l\texthvlig=/l208577/l=ins:\texthvlig
108578=108578==/l90001/l\textinvglotstop=/l208578/l=ins:\textinvglotstop
108579=108579==/l90001/l\textinvscr=/l208579/l=ins:\textinvscr
108580=108580==/l90001/l\textiota=/l208580/l=ins:\textiota
108581=108581==/l90001/l\textlambda=/l208581/l=ins:\textlambda
108582=108582==/l90001/l\textlengthmark=/l208582/l=ins:\textlengthmark
108583=108583==/l90001/l\textlhookt=/l208583/l=ins:\textlhookt
108584=108584==/l90001/l\textlhti=/l208584/l=ins:\textlhti
108585=108585==/l90001/l\textlhtlongi=/l208585/l=ins:\textlhtlongi
108586=108586==/l90001/l\textlonglegr=/l208586/l=ins:\textlonglegr
108587=108587==/l90001/l\textlptr=/l208587/l=ins:\textlptr
108588=108588==/l90001/l\textltailm=/l208588/l=ins:\textltailm
108589=108589==/l90001/l\textltailn=/l208589/l=ins:\textltailn
108590=108590==/l90001/l\textltilde=/l208590/l=ins:\textltilde
108591=108591==/l90001/l\textlyoghlig=/l208591/l=ins:\textlyoghlig
108592=108592==/l90001/l\textnrleg=/l208592/l=ins:\textnrleg
108593=108593==/l90001/l\textObardotlessj=/l208593/l=ins:\textObardotlessj
108594=108594==/l90001/l\textOlyoghlig=/l208594/l=ins:\textOlyoghlig
108595=108595==/l90001/l\textomega=/l208595/l=ins:\textomega
108596=108596==/l90001/l\textopencorner=/l208596/l=ins:\textopencorner
108597=108597==/l90001/l\textopeno=/l208597/l=ins:\textopeno
108598=108598==/l90001/l\textpalhook=/l208598/l=ins:\textpalhook
108599=108599==/l90001/l\textphi=/l208599/l=ins:\textphi
108600=108600==/l90001/l\textpipe=/l208600/l=ins:\textpipe
108601=108601==/l90001/l\textprimstress=/l208601/l=ins:\textprimstress
108602=108602==/l90001/l\textraiseglotstop=/l208602/l=ins:\textraiseglotstop
108603=108603==/l90001/l\textraisevibyi=/l208603/l=ins:\textraisevibyi
108604=108604==/l90001/l\textramshorns=/l208604/l=ins:\textramshorns
108605=108605==/l90001/l\textrectangle=/l208605/l=ins:\textrectangle
108606=108606==/l90001/l\textrevapostrophe=/l208606/l=ins:\textrevapostrophe
108607=108607==/l90001/l\textreve=/l208607/l=ins:\textreve
108608=108608==/l90001/l\textrevepsilon=/l208608/l=ins:\textrevepsilon
108609=108609==/l90001/l\textrevglotstop=/l208609/l=ins:\textrevglotstop
108610=108610==/l90001/l\textrevyogh=/l208610/l=ins:\textrevyogh
108611=108611==/l90001/l\textrhookrevepsilon=/l208611/l=ins:\textrhookrevepsilon
108612=108612==/l90001/l\textrhookschwa=/l208612/l=ins:\textrhookschwa
108613=108613==/l90001/l\textrhoticity=/l208613/l=ins:\textrhoticity
108614=108614==/l90001/l\textrptr=/l208614/l=ins:\textrptr
108615=108615==/l90001/l\textrtaild=/l208615/l=ins:\textrtaild
108616=108616==/l90001/l\textrthook=/l208616/l=ins:\textrthook
108617=108617==/l90001/l\textsca=/l208617/l=ins:\textsca
108618=108618==/l90001/l\textscb=/l208618/l=ins:\textscb
108619=108619==/l90001/l\textsce=/l208619/l=ins:\textsce
108620=108620==/l90001/l\textscg=/l208620/l=ins:\textscg
108621=108621==/l90001/l\textsch=/l208621/l=ins:\textsch
108622=108622==/l90001/l\textschwa=/l208622/l=ins:\textschwa
108623=108623==/l90001/l\textsci=/l208623/l=ins:\textsci
108624=108624==/l90001/l\textscj=/l208624/l=ins:\textscj
108625=108625==/l90001/l\textscl=/l208625/l=ins:\textscl
108626=108626==/l90001/l\textscn=/l208626/l=ins:\textscn
108627=108627==/l90001/l\textscoelig=/l208627/l=ins:\textscoelig
108628=108628==/l90001/l\textscomega=/l208628/l=ins:\textscomega
108629=108629==/l90001/l\textscq=/l208629/l=ins:\textscq
108630=108630==/l90001/l\textscr=/l208630/l=ins:\textscr
108631=108631==/l90001/l\textscripta=/l208631/l=ins:\textscripta
108632=108632==/l90001/l\textscriptv=/l208632/l=ins:\textscriptv
108633=108633==/l90001/l\textscu=/l208633/l=ins:\textscu
108634=108634==/l90001/l\textscy=/l208634/l=ins:\textscy
108635=108635==/l90001/l\textsecstress=/l208635/l=ins:\textsecstress
108636=108636==/l90001/l\textsoftsign=/l208636/l=ins:\textsoftsign
108637=108637==/l90001/l\textstretchc=/l208637/l=ins:\textstretchc
108638=108638==/l90001/l\texttctclig=/l208638/l=ins:\texttctclig
108639=108639==/l90001/l\textteshlig=/l208639/l=ins:\textteshlig
108640=108640==/l90001/l\texttheta=/l208640/l=ins:\texttheta
108641=108641==/l90001/l\textthorn=/l208641/l=ins:\textthorn
108642=108642==/l90001/l\texttslig=/l208642/l=ins:\texttslig
108643=108643==/l90001/l\textturna=/l208643/l=ins:\textturna
108644=108644==/l90001/l\textturncelig=/l208644/l=ins:\textturncelig
108645=108645==/l90001/l\textturnh=/l208645/l=ins:\textturnh
108646=108646==/l90001/l\textturnk=/l208646/l=ins:\textturnk
108647=108647==/l90001/l\textturnlonglegr=/l208647/l=ins:\textturnlonglegr
108648=108648==/l90001/l\textturnm=/l208648/l=ins:\textturnm
108649=108649==/l90001/l\textturnmrleg=/l208649/l=ins:\textturnmrleg
108650=108650==/l90001/l\textturnr=/l208650/l=ins:\textturnr
108651=108651==/l90001/l\textturnrrtail=/l208651/l=ins:\textturnrrtail
108652=108652==/l90001/l\textturnscripta=/l208652/l=ins:\textturnscripta
108653=108653==/l90001/l\textturnt=/l208653/l=ins:\textturnt
108654=108654==/l90001/l\textturnv=/l208654/l=ins:\textturnv
108655=108655==/l90001/l\textturnw=/l208655/l=ins:\textturnw
108656=108656==/l90001/l\textturny=/l208656/l=ins:\textturny
108657=108657==/l90001/l\textupsilon=/l208657/l=ins:\textupsilon
108658=108658==/l90001/l\textupstep=/l208658/l=ins:\textupstep
108659=108659==/l90001/l\textvertline=/l208659/l=ins:\textvertline
108660=108660==/l90001/l\textvibyi=/l208660/l=ins:\textvibyi
108661=108661==/l90001/l\textvibyy=/l208661/l=ins:\textvibyy
108662=108662==/l90001/l\textwynn=/l208662/l=ins:\textwynn
108663=108663==/l90001/l\textyogh=/l208663/l=ins:\textyogh

// 109000 - wsuipa Phonetic Symbols
109001=109001==/l90001/l\babygamma=/l209001/l=ins:\babygamma
109002=109002==/l90001/l\barb=/l209002/l=ins:\barb
109003=109003==/l90001/l\bard=/l209003/l=ins:\bard
109004=109004==/l90001/l\bari=/l209004/l=ins:\bari
109005=109005==/l90001/l\barl=/l209005/l=ins:\barl
109006=109006==/l90001/l\baro=/l209006/l=ins:\baro
109007=109007==/l90001/l\barp=/l209007/l=ins:\barp
109008=109008==/l90001/l\barsci=/l209008/l=ins:\barsci
109009=109009==/l90001/l\barscu=/l209009/l=ins:\barscu
109010=109010==/l90001/l\baru=/l209010/l=ins:\baru
109011=109011==/l90001/l\clickb=/l209011/l=ins:\clickb
109012=109012==/l90001/l\clickc=/l209012/l=ins:\clickc
109013=109013==/l90001/l\clickt=/l209013/l=ins:\clickt
109014=109014==/l90001/l\closedniomega=/l209014/l=ins:\closedniomega
109015=109015==/l90001/l\closedrevepsilon=/l209015/l=ins:\closedrevepsilon
109016=109016==/l90001/l\crossb=/l209016/l=ins:\crossb
109017=109017==/l90001/l\crossd=/l209017/l=ins:\crossd
109018=109018==/l90001/l\crossh=/l209018/l=ins:\crossh
109019=109019==/l90001/l\crossnilambda=/l209019/l=ins:\crossnilambda
109020=109020==/l90001/l\curlyc=/l209020/l=ins:\curlyc
109021=109021==/l90001/l\curlyesh=/l209021/l=ins:\curlyesh
109022=109022==/l90001/l\curlyyogh=/l209022/l=ins:\curlyyogh
109023=109023==/l90001/l\curlyz=/l209023/l=ins:\curlyz
109024=109024==/l90001/l\dlbari=/l209024/l=ins:\dlbari
109025=109025==/l90001/l\dz=/l209025/l=ins:\dz
109026=109026==/l90001/l\ejective=/l209026/l=ins:\ejective
109027=109027==/l90001/l\eng=/l209027/l=ins:\eng
109028=109028==/l90001/l\er=/l209028/l=ins:\er
109029=109029==/l90001/l\esh=/l209029/l=ins:\esh
109030=109030==/l90001/l\eth=/l209030/l=ins:\eth
109031=109031==/l90001/l\flapr=/l209031/l=ins:\flapr
109032=109032==/l90001/l\glotstop=/l209032/l=ins:\glotstop
109033=109033==/l90001/l\hookb=/l209033/l=ins:\hookb
109034=109034==/l90001/l\hookg=/l209034/l=ins:\hookg
109035=109035==/l90001/l\hookh=/l209035/l=ins:\hookh
109036=109036==/l90001/l\hookheng=/l209036/l=ins:\hookheng
109037=109037==/l90001/l\hookrevepsilon=/l209037/l=ins:\hookrevepsilon
109038=109038==/l90001/l\hv=/l209038/l=ins:\hv
109039=109039==/l90001/l\inva=/l209039/l=ins:\inva
109040=109040==/l90001/l\invf=/l209040/l=ins:\invf
109041=109041==/l90001/l\invglotstop=/l209041/l=ins:\invglotstop
109042=109042==/l90001/l\invh=/l209042/l=ins:\invh
109043=109043==/l90001/l\invlegr=/l209043/l=ins:\invlegr
109044=109044==/l90001/l\invm=/l209044/l=ins:\invm
109045=109045==/l90001/l\invr=/l209045/l=ins:\invr
109046=109046==/l90001/l\invscr=/l209046/l=ins:\invscr
109047=109047==/l90001/l\invscripta=/l209047/l=ins:\invscripta
109048=109048==/l90001/l\invv=/l209048/l=ins:\invv
109049=109049==/l90001/l\invw=/l209049/l=ins:\invw
109050=109050==/l90001/l\invy=/l209050/l=ins:\invy
109051=109051==/l90001/l\ipagamma=/l209051/l=ins:\ipagamma
109052=109052==/l90001/l\labdentalnas=/l209052/l=ins:\labdentalnas
109053=109053==/l90001/l\latfric=/l209053/l=ins:\latfric
109054=109054==/l90001/l\legm=/l209054/l=ins:\legm
109055=109055==/l90001/l\legr=/l209055/l=ins:\legr
109056=109056==/l90001/l\lz=/l209056/l=ins:\lz
109057=109057==/l90001/l\nialpha=/l209057/l=ins:\nialpha
109058=109058==/l90001/l\nibeta=/l209058/l=ins:\nibeta
109059=109059==/l90001/l\nichi=/l209059/l=ins:\nichi
109060=109060==/l90001/l\niepsilon=/l209060/l=ins:\niepsilon
109061=109061==/l90001/l\nigamma=/l209061/l=ins:\nigamma
109062=109062==/l90001/l\niiota=/l209062/l=ins:\niiota
109063=109063==/l90001/l\nilambda=/l209063/l=ins:\nilambda
109064=109064==/l90001/l\niomega=/l209064/l=ins:\niomega
109065=109065==/l90001/l\niphi=/l209065/l=ins:\niphi
109066=109066==/l90001/l\nisigma=/l209066/l=ins:\nisigma
109067=109067==/l90001/l\nitheta=/l209067/l=ins:\nitheta
109068=109068==/l90001/l\niupsilon=/l209068/l=ins:\niupsilon
109069=109069==/l90001/l\nj=/l209069/l=ins:\nj
109070=109070==/l90001/l\oo=/l209070/l=ins:\oo
109071=109071==/l90001/l\openo=/l209071/l=ins:\openo
109072=109072==/l90001/l\reve=/l209072/l=ins:\reve
109073=109073==/l90001/l\reveject=/l209073/l=ins:\reveject
109074=109074==/l90001/l\revepsilon=/l209074/l=ins:\revepsilon
109075=109075==/l90001/l\revglotstop=/l209075/l=ins:\revglotstop
109076=109076==/l90001/l\scd=/l209076/l=ins:\scd
109077=109077==/l90001/l\scg=/l209077/l=ins:\scg
109078=109078==/l90001/l\schwa=/l209078/l=ins:\schwa
109079=109079==/l90001/l\sci=/l209079/l=ins:\sci
109080=109080==/l90001/l\scn=/l209080/l=ins:\scn
109081=109081==/l90001/l\scr=/l209081/l=ins:\scr
109082=109082==/l90001/l\scripta=/l209082/l=ins:\scripta
109083=109083==/l90001/l\scriptg=/l209083/l=ins:\scriptg
109084=109084==/l90001/l\scriptv=/l209084/l=ins:\scriptv
109085=109085==/l90001/l\scu=/l209085/l=ins:\scu
109086=109086==/l90001/l\scy=/l209086/l=ins:\scy
109087=109087==/l90001/l\slashb=/l209087/l=ins:\slashb
109088=109088==/l90001/l\slashc=/l209088/l=ins:\slashc
109089=109089==/l90001/l\slashd=/l209089/l=ins:\slashd
109090=109090==/l90001/l\slashu=/l209090/l=ins:\slashu
109091=109091==/l90001/l\taild=/l209091/l=ins:\taild
109092=109092==/l90001/l\tailinvr=/l209092/l=ins:\tailinvr
109093=109093==/l90001/l\taill=/l209093/l=ins:\taill
109094=109094==/l90001/l\tailn=/l209094/l=ins:\tailn
109095=109095==/l90001/l\tailr=/l209095/l=ins:\tailr
109096=109096==/l90001/l\tails=/l209096/l=ins:\tails
109097=109097==/l90001/l\tailt=/l209097/l=ins:\tailt
109098=109098==/l90001/l\tailz=/l209098/l=ins:\tailz
109099=109099==/l90001/l\tesh=/l209099/l=ins:\tesh
109100=109100==/l90001/l\thorn=/l209100/l=ins:\thorn
109101=109101==/l90001/l\tildel=/l209101/l=ins:\tildel
109102=109102==/l90001/l\yogh=/l209102/l=ins:\yogh

// 109500 - Miscellaneous textcomp Symbols
109501=109501==/l90001/l\textasteriskcentered=/l209501/l=ins:\textasteriskcentered
109502=109502==/l90001/l\textbardbl=/l209502/l=ins:\textbardbl
109503=109503==/l90001/l\textbigcircle=/l209503/l=ins:\textbigcircle
109504=109504==/l90001/l\textblank=/l209504/l=ins:\textblank
109505=109505==/l90001/l\textbrokenbar=/l209505/l=ins:\textbrokenbar
109506=109506==/l90001/l\textbullet=/l209506/l=ins:\textbullet
109507=109507==/l90001/l\textdagger=/l209507/l=ins:\textdagger
109508=109508==/l90001/l\textdaggerdbl=/l209508/l=ins:\textdaggerdbl
109509=109509==/l90001/l\textdblhyphen=/l209509/l=ins:\textdblhyphen
109510=109510==/l90001/l\textdblhyphenchar=/l209510/l=ins:\textdblhyphenchar
109511=109511==/l90001/l\textdiscount=/l209511/l=ins:\textdiscount
109512=109512==/l90001/l\textestimated=/l209512/l=ins:\textestimated
109513=109513==/l90001/l\textinterrobang=/l209513/l=ins:\textinterrobang
109514=109514==/l90001/l\textinterrobangdown=/l209514/l=ins:\textinterrobangdown
109515=109515==/l90001/l\textmusicalnote=/l209515/l=ins:\textmusicalnote
109516=109516==/l90001/l\textnumero=/l209516/l=ins:\textnumero
109517=109517==/l90001/l\textopenbullet=/l209517/l=ins:\textopenbullet
109518=109518==/l90001/l\textordfeminine=/l209518/l=ins:\textordfeminine
109519=109519==/l90001/l\textordmasculine=/l209519/l=ins:\textordmasculine
109520=109520==/l90001/l\textparagraph=/l209520/l=ins:\textparagraph
109521=109521==/l90001/l\textperiodcentered=/l209521/l=ins:\textperiodcentered
109522=109522==/l90001/l\textpertenthousand=/l209522/l=ins:\textpertenthousand
109523=109523==/l90001/l\textperthousand=/l209523/l=ins:\textperthousand
109524=109524==/l90001/l\textpilcrow=/l209524/l=ins:\textpilcrow
109525=109525==/l90001/l\textquotesingle=/l209525/l=ins:\textquotesingle
109526=109526==/l90001/l\textquotestraightbase=/l209526/l=ins:\textquotestraightbase
109527=109527==/l90001/l\textquotestraightdblbase=/l209527/l=ins:\textquotestraightdblbase
109528=109528==/l90001/l\textrecipe=/l209528/l=ins:\textrecipe
109529=109529==/l90001/l\textreferencemark=/l209529/l=ins:\textreferencemark
109530=109530==/l90001/l\textsection=/l209530/l=ins:\textsection
109531=109531==/l90001/l\textthreequartersemdash=/l209531/l=ins:\textthreequartersemdash
109532=109532==/l90001/l\texttwelveudash=/l209532/l=ins:\texttwelveudash

// 110000 - stmaryrd Binary Operators
110001=110001==/l90001/l\baro=/l210001/l=ins:\baro
110002=110002==/l90001/l\bbslash=/l210002/l=ins:\bbslash
110003=110003==/l90001/l\binampersand=/l210003/l=ins:\binampersand
110004=110004==/l90001/l\bindnasrepma=/l210004/l=ins:\bindnasrepma
110005=110005==/l90001/l\boxast=/l210005/l=ins:\boxast
110006=110006==/l90001/l\boxbar=/l210006/l=ins:\boxbar
110007=110007==/l90001/l\boxbox=/l210007/l=ins:\boxbox
110008=110008==/l90001/l\boxbslash=/l210008/l=ins:\boxbslash
110009=110009==/l90001/l\boxcircle=/l210009/l=ins:\boxcircle
110010=110010==/l90001/l\boxdot=/l210010/l=ins:\boxdot
110011=110011==/l90001/l\boxempty=/l210011/l=ins:\boxempty
110012=110012==/l90001/l\boxslash=/l210012/l=ins:\boxslash
110013=110013==/l90001/l\curlyveedownarrow=/l210013/l=ins:\curlyveedownarrow
110014=110014==/l90001/l\curlyveeuparrow=/l210014/l=ins:\curlyveeuparrow
110015=110015==/l90001/l\curlywedgedownarrow=/l210015/l=ins:\curlywedgedownarrow
110016=110016==/l90001/l\curlywedgeuparrow=/l210016/l=ins:\curlywedgeuparrow
110017=110017==/l90001/l\fatbslash=/l210017/l=ins:\fatbslash
110018=110018==/l90001/l\fatsemi=/l210018/l=ins:\fatsemi
110019=110019==/l90001/l\fatslash=/l210019/l=ins:\fatslash
110020=110020==/l90001/l\interleave=/l210020/l=ins:\interleave
110021=110021==/l90001/l\leftslice=/l210021/l=ins:\leftslice
110022=110022==/l90001/l\merge=/l210022/l=ins:\merge
110023=110023==/l90001/l\minuso=/l210023/l=ins:\minuso
110024=110024==/l90001/l\moo=/l210024/l=ins:\moo
110025=110025==/l90001/l\nplus=/l210025/l=ins:\nplus
110026=110026==/l90001/l\obar=/l210026/l=ins:\obar
110027=110027==/l90001/l\oblong=/l210027/l=ins:\oblong
110028=110028==/l90001/l\obslash=/l210028/l=ins:\obslash
110029=110029==/l90001/l\ogreaterthan=/l210029/l=ins:\ogreaterthan
110030=110030==/l90001/l\olessthan=/l210030/l=ins:\olessthan
110031=110031==/l90001/l\ovee=/l210031/l=ins:\ovee
110032=110032==/l90001/l\owedge=/l210032/l=ins:\owedge
110033=110033==/l90001/l\rightslice=/l210033/l=ins:\rightslice
110034=110034==/l90001/l\sslash=/l210034/l=ins:\sslash
110035=110035==/l90001/l\talloblong=/l210035/l=ins:\talloblong
110036=110036==/l90001/l\varbigcirc=/l210036/l=ins:\varbigcirc
110037=110037==/l90001/l\varcurlyvee=/l210037/l=ins:\varcurlyvee
110038=110038==/l90001/l\varcurlywedge=/l210038/l=ins:\varcurlywedge
110039=110039==/l90001/l\varoast=/l210039/l=ins:\varoast
110040=110040==/l90001/l\varobar=/l210040/l=ins:\varobar
110041=110041==/l90001/l\varobslash=/l210041/l=ins:\varobslash
110042=110042==/l90001/l\varocircle=/l210042/l=ins:\varocircle
110043=110043==/l90001/l\varodot=/l210043/l=ins:\varodot
110044=110044==/l90001/l\varogreaterthan=/l210044/l=ins:\varogreaterthan
110045=110045==/l90001/l\varolessthan=/l210045/l=ins:\varolessthan
110046=110046==/l90001/l\varominus=/l210046/l=ins:\varominus
110047=110047==/l90001/l\varoplus=/l210047/l=ins:\varoplus
110048=110048==/l90001/l\varoslash=/l210048/l=ins:\varoslash
110049=110049==/l90001/l\varotimes=/l210049/l=ins:\varotimes
110050=110050==/l90001/l\varovee=/l210050/l=ins:\varovee
110051=110051==/l90001/l\varowedge=/l210051/l=ins:\varowedge
110052=110052==/l90001/l\vartimes=/l210052/l=ins:\vartimes
110053=110053==/l90001/l\Ydown=/l210053/l=ins:\Ydown
110054=110054==/l90001/l\Yleft=/l210054/l=ins:\Yleft
110055=110055==/l90001/l\Yright=/l210055/l=ins:\Yright
110056=110056==/l90001/l\Yup=/l210056/l=ins:\Yup

// 110500 - Variable-sized stmaryrd Math Operators
110501=110501==/l90001/l\bigbox=/l210501/l=ins:\bigbox
110502=110502==/l90001/l\bigcurlyvee=/l210502/l=ins:\bigcurlyvee
110503=110503==/l90001/l\bigcurlywedge=/l210503/l=ins:\bigcurlywedge
110504=110504==/l90001/l\biginterleave=/l210504/l=ins:\biginterleave
110505=110505==/l90001/l\bignplus=/l210505/l=ins:\bignplus
110506=110506==/l90001/l\bigparallel=/l210506/l=ins:\bigparallel
110507=110507==/l90001/l\bigsqcap=/l210507/l=ins:\bigsqcap
110508=110508==/l90001/l\bigtriangledown=/l210508/l=ins:\bigtriangledown
110509=110509==/l90001/l\bigtriangleup=/l210509/l=ins:\bigtriangleup

// 111000 - Binary Operators
111001=111001==/l90001/l\amalg=/l211001/l=ins:\amalg
111002=111002==/l90001/l\ast=/l211002/l=ins:\ast
111003=111003==/l90001/l\bigcirc=/l211003/l=ins:\bigcirc
111004=111004==/l90001/l\bigtriangledown=/l211004/l=ins:\bigtriangledown
111005=111005==/l90001/l\bigtriangleup=/l211005/l=ins:\bigtriangleup
111006=111006==/l90001/l\bullet=/l211006/l=ins:\bullet
111007=111007==/l90001/l\cap=/l211007/l=ins:\cap
111008=111008==/l90001/l\cdot=/l211008/l=ins:\cdot
111009=111009==/l90001/l\circ=/l211009/l=ins:\circ
111010=111010==/l90001/l\cup=/l211010/l=ins:\cup
111011=111011==/l90001/l\dagger=/l211011/l=ins:\dagger
111012=111012==/l90001/l\ddagger=/l211012/l=ins:\ddagger
111013=111013==/l90001/l\diamond=/l211013/l=ins:\diamond
111014=111014==/l90001/l\div=/l211014/l=ins:\div
111015=111015==/l90001/l\lhd=/l211015/l=ins:\lhd
111016=111016==/l90001/l\mp=/l211016/l=ins:\mp
111017=111017==/l90001/l\odot=/l211017/l=ins:\odot
111018=111018==/l90001/l\ominus=/l211018/l=ins:\ominus
111019=111019==/l90001/l\oplus=/l211019/l=ins:\oplus
111020=111020==/l90001/l\oslash=/l211020/l=ins:\oslash
111021=111021==/l90001/l\otimes=/l211021/l=ins:\otimes
111022=111022==/l90001/l\pm=/l211022/l=ins:\pm
111023=111023==/l90001/l\rhd=/l211023/l=ins:\rhd
111024=111024==/l90001/l\setminus=/l211024/l=ins:\setminus
111025=111025==/l90001/l\sqcap=/l211025/l=ins:\sqcap
111026=111026==/l90001/l\sqcup=/l211026/l=ins:\sqcup
111027=111027==/l90001/l\star=/l211027/l=ins:\star
111028=111028==/l90001/l\times=/l211028/l=ins:\times
111029=111029==/l90001/l\triangleleft=/l211029/l=ins:\triangleleft
111030=111030==/l90001/l\triangleright=/l211030/l=ins:\triangleright
111031=111031==/l90001/l\unlhd=/l211031/l=ins:\unlhd
111032=111032==/l90001/l\unrhd=/l211032/l=ins:\unrhd
111033=111033==/l90001/l\uplus=/l211033/l=ins:\uplus
111034=111034==/l90001/l\vee=/l211034/l=ins:\vee
111035=111035==/l90001/l\wedge=/l211035/l=ins:\wedge
111036=111036==/l90001/l\wr=/l211036/l=ins:\wr

// 111500 - Variable-sized Math Operators
111501=111501==/l90001/l\bigcap=/l211501/l=ins:\bigcap
111502=111502==/l90001/l\bigcup=/l211502/l=ins:\bigcup
111503=111503==/l90001/l\bigodot=/l211503/l=ins:\bigodot
111504=111504==/l90001/l\bigoplus=/l211504/l=ins:\bigoplus
111505=111505==/l90001/l\bigotimes=/l211505/l=ins:\bigotimes
111506=111506==/l90001/l\bigsqcup=/l211506/l=ins:\bigsqcup
111507=111507==/l90001/l\biguplus=/l211507/l=ins:\biguplus
111508=111508==/l90001/l\bigvee=/l211508/l=ins:\bigvee
111509=111509==/l90001/l\bigwedge=/l211509/l=ins:\bigwedge
111510=111510==/l90001/l\coprod=/l211510/l=ins:\coprod
111511=111511==/l90001/l\int=/l211511/l=ins:\int
111512=111512==/l90001/l\prod=/l211512/l=ins:\prod
111513=111513==/l90001/l\sum=/l211513/l=ins:\sum

// 112000 - AMS Binary Operators
112001=112001==/l90001/l\barwedge=/l212001/l=ins:\barwedge
112002=112002==/l90001/l\boxdot=/l212002/l=ins:\boxdot
112003=112003==/l90001/l\boxminus=/l212003/l=ins:\boxminus
112004=112004==/l90001/l\boxplus=/l212004/l=ins:\boxplus
112005=112005==/l90001/l\boxtimes=/l212005/l=ins:\boxtimes
112006=112006==/l90001/l\Cap=/l212006/l=ins:\Cap
112007=112007==/l90001/l\centerdot=/l212007/l=ins:\centerdot
112008=112008==/l90001/l\circledast=/l212008/l=ins:\circledast
112009=112009==/l90001/l\circledcirc=/l212009/l=ins:\circledcirc
112010=112010==/l90001/l\circleddash=/l212010/l=ins:\circleddash
112011=112011==/l90001/l\Cup=/l212011/l=ins:\Cup
112012=112012==/l90001/l\curlyvee=/l212012/l=ins:\curlyvee
112013=112013==/l90001/l\curlywedge=/l212013/l=ins:\curlywedge
112014=112014==/l90001/l\divideontimes=/l212014/l=ins:\divideontimes
112015=112015==/l90001/l\dotplus=/l212015/l=ins:\dotplus
112016=112016==/l90001/l\doublebarwedge=/l212016/l=ins:\doublebarwedge
112017=112017==/l90001/l\intercal=/l212017/l=ins:\intercal
112018=112018==/l90001/l\leftthreetimes=/l212018/l=ins:\leftthreetimes
112019=112019==/l90001/l\ltimes=/l212019/l=ins:\ltimes
112020=112020==/l90001/l\rightthreetimes=/l212020/l=ins:\rightthreetimes
112021=112021==/l90001/l\rtimes=/l212021/l=ins:\rtimes
112022=112022==/l90001/l\smallsetminus=/l212022/l=ins:\smallsetminus
112023=112023==/l90001/l\veebar=/l212023/l=ins:\veebar

// 112500 - Variable-sized wasysym Math Operators
112501=112501==/l90001/l\iiint=/l212501/l=ins:\iiint
112502=112502==/l90001/l\iint=/l212502/l=ins:\iint
112503=112503==/l90001/l\oiint=/l212503/l=ins:\oiint
112504=112504==/l90001/l\varint=/l212504/l=ins:\varint
112505=112505==/l90001/l\varoint=/l212505/l=ins:\varoint

// 113000 - txfonts/pxfonts Binary Operators
113001=113001==/l90001/l\circledbar=/l213001/l=ins:\circledbar
113002=113002==/l90001/l\circledbslash=/l213002/l=ins:\circledbslash
113003=113003==/l90001/l\circledvee=/l213003/l=ins:\circledvee
113004=113004==/l90001/l\circledwedge=/l213004/l=ins:\circledwedge
113005=113005==/l90001/l\invamp=/l213005/l=ins:\invamp
113006=113006==/l90001/l\medbullet=/l213006/l=ins:\medbullet
113007=113007==/l90001/l\medcirc=/l213007/l=ins:\medcirc
113008=113008==/l90001/l\sqcapplus=/l213008/l=ins:\sqcapplus
113009=113009==/l90001/l\sqcupplus=/l213009/l=ins:\sqcupplus

// 113500 - Variable-sized txfonts/pxfonts Math Operators
113501=113501==/l90001/l\bigsqcapplus=/l213501/l=ins:\bigsqcapplus
113502=113502==/l90001/l\bigsqcupplus=/l213502/l=ins:\bigsqcupplus
113503=113503==/l90001/l\fint=/l213503/l=ins:\fint
113504=113504==/l90001/l\idotsint=/l213504/l=ins:\idotsint
113505=113505==/l90001/l\iiiint=/l213505/l=ins:\iiiint
113506=113506==/l90001/l\iiint=/l213506/l=ins:\iiint
113507=113507==/l90001/l\iint=/l213507/l=ins:\iint
113508=113508==/l90001/l\oiiintclockwise=/l213508/l=ins:\oiiintclockwise
113509=113509==/l90001/l\oiiintctrclockwise=/l213509/l=ins:\oiiintctrclockwise
113510=113510==/l90001/l\oiiint=/l213510/l=ins:\oiiint
113511=113511==/l90001/l\oiintclockwise=/l213511/l=ins:\oiintclockwise
113512=113512==/l90001/l\oiintctrclockwise=/l213512/l=ins:\oiintctrclockwise
113513=113513==/l90001/l\oiint=/l213513/l=ins:\oiint
113514=113514==/l90001/l\ointclockwise=/l213514/l=ins:\ointclockwise
113515=113515==/l90001/l\ointctrclockwise=/l213515/l=ins:\ointctrclockwise
113516=113516==/l90001/l\sqiiint=/l213516/l=ins:\sqiiint
113517=113517==/l90001/l\sqiint=/l213517/l=ins:\sqiint
113518=113518==/l90001/l\sqint=/l213518/l=ins:\sqint
113519=113519==/l90001/l\varoiiintclockwise=/l213519/l=ins:\varoiiintclockwise
113520=113520==/l90001/l\varoiiintctrclockwise=/l213520/l=ins:\varoiiintctrclockwise
113521=113521==/l90001/l\varoiintclockwise=/l213521/l=ins:\varoiintclockwise
113522=113522==/l90001/l\varoiintctrclockwise=/l213522/l=ins:\varoiintctrclockwise
113523=113523==/l90001/l\varointclockwise=/l213523/l=ins:\varointclockwise
113524=113524==/l90001/l\varointctrclockwise=/l213524/l=ins:\varointctrclockwise
113525=113525==/l90001/l\varprod=/l213525/l=ins:\varprod

// 114000 - Relation Symbols
114001=114001==/l90001/l\approx=/l214001/l=ins:\approx
114002=114002==/l90001/l\asymp=/l214002/l=ins:\asymp
114003=114003==/l90001/l\bowtie=/l214003/l=ins:\bowtie
114004=114004==/l90001/l\cong=/l214004/l=ins:\cong
114005=114005==/l90001/l\dashv=/l214005/l=ins:\dashv
114006=114006==/l90001/l\doteq=/l214006/l=ins:\doteq
114007=114007==/l90001/l\equiv=/l214007/l=ins:\equiv
114008=114008==/l90001/l\frown=/l214008/l=ins:\frown
114009=114009==/l90001/l\geq=/l214009/l=ins:\geq
114010=114010==/l90001/l\gg=/l214010/l=ins:\gg
114011=114011==/l90001/l\in=/l214011/l=ins:\in
114012=114012==/l90001/l\Join=/l214012/l=ins:\Join
114013=114013==/l90001/l\leq=/l214013/l=ins:\leq
114014=114014==/l90001/l\ll=/l214014/l=ins:\ll
114015=114015==/l90001/l\mid=/l214015/l=ins:\mid
114016=114016==/l90001/l\models=/l214016/l=ins:\models
114017=114017==/l90001/l\neq=/l214017/l=ins:\neq
114018=114018==/l90001/l\ni=/l214018/l=ins:\ni
114019=114019==/l90001/l\parallel=/l214019/l=ins:\parallel
114020=114020==/l90001/l\perp=/l214020/l=ins:\perp
114021=114021==/l90001/l\prec=/l214021/l=ins:\prec
114022=114022==/l90001/l\preceq=/l214022/l=ins:\preceq
114023=114023==/l90001/l\propto=/l214023/l=ins:\propto
114024=114024==/l90001/l\sim=/l214024/l=ins:\sim
114025=114025==/l90001/l\simeq=/l214025/l=ins:\simeq
114026=114026==/l90001/l\smile=/l214026/l=ins:\smile
114027=114027==/l90001/l\sqsubset=/l214027/l=ins:\sqsubset
114028=114028==/l90001/l\sqsubseteq=/l214028/l=ins:\sqsubseteq
114029=114029==/l90001/l\sqsupset=/l214029/l=ins:\sqsupset
114030=114030==/l90001/l\sqsupseteq=/l214030/l=ins:\sqsupseteq
114031=114031==/l90001/l\subset=/l214031/l=ins:\subset
114032=114032==/l90001/l\subseteq=/l214032/l=ins:\subseteq
114033=114033==/l90001/l\succ=/l214033/l=ins:\succ
114034=114034==/l90001/l\succeq=/l214034/l=ins:\succeq
114035=114035==/l90001/l\supset=/l214035/l=ins:\supset
114036=114036==/l90001/l\supseteq=/l214036/l=ins:\supseteq
114037=114037==/l90001/l\vdash=/l214037/l=ins:\vdash

// 114500 - AMS Binary Relations
114501=114501==/l90001/l\approxeq=/l214501/l=ins:\approxeq
114502=114502==/l90001/l\backepsilon=/l214502/l=ins:\backepsilon
114503=114503==/l90001/l\backsim=/l214503/l=ins:\backsim
114504=114504==/l90001/l\backsimeq=/l214504/l=ins:\backsimeq
114505=114505==/l90001/l\because=/l214505/l=ins:\because
114506=114506==/l90001/l\between=/l214506/l=ins:\between
114507=114507==/l90001/l\blacktriangleleft=/l214507/l=ins:\blacktriangleleft
114508=114508==/l90001/l\blacktriangleright=/l214508/l=ins:\blacktriangleright
114509=114509==/l90001/l\Bumpeq=/l214509/l=ins:\Bumpeq
114510=114510==/l90001/l\bumpeq=/l214510/l=ins:\bumpeq
114511=114511==/l90001/l\circeq=/l214511/l=ins:\circeq
114512=114512==/l90001/l\curlyeqprec=/l214512/l=ins:\curlyeqprec
114513=114513==/l90001/l\curlyeqsucc=/l214513/l=ins:\curlyeqsucc
114514=114514==/l90001/l\doteqdot=/l214514/l=ins:\doteqdot
114515=114515==/l90001/l\eqcirc=/l214515/l=ins:\eqcirc
114516=114516==/l90001/l\eqslantgtr=/l214516/l=ins:\eqslantgtr
114517=114517==/l90001/l\eqslantless=/l214517/l=ins:\eqslantless
114518=114518==/l90001/l\fallingdotseq=/l214518/l=ins:\fallingdotseq
114519=114519==/l90001/l\geqq=/l214519/l=ins:\geqq
114520=114520==/l90001/l\geqslant=/l214520/l=ins:\geqslant
114521=114521==/l90001/l\ggg=/l214521/l=ins:\ggg
114522=114522==/l90001/l\gtrapprox=/l214522/l=ins:\gtrapprox
114523=114523==/l90001/l\gtrdot=/l214523/l=ins:\gtrdot
114524=114524==/l90001/l\gtreqless=/l214524/l=ins:\gtreqless
114525=114525==/l90001/l\gtreqqless=/l214525/l=ins:\gtreqqless
114526=114526==/l90001/l\gtrless=/l214526/l=ins:\gtrless
114527=114527==/l90001/l\gtrsim=/l214527/l=ins:\gtrsim
114528=114528==/l90001/l\leqq=/l214528/l=ins:\leqq
114529=114529==/l90001/l\leqslant=/l214529/l=ins:\leqslant
114530=114530==/l90001/l\lessapprox=/l214530/l=ins:\lessapprox
114531=114531==/l90001/l\lessdot=/l214531/l=ins:\lessdot
114532=114532==/l90001/l\lesseqgtr=/l214532/l=ins:\lesseqgtr
114533=114533==/l90001/l\lesseqqgtr=/l214533/l=ins:\lesseqqgtr
114534=114534==/l90001/l\lessgtr=/l214534/l=ins:\lessgtr
114535=114535==/l90001/l\lesssim=/l214535/l=ins:\lesssim
114536=114536==/l90001/l\lll=/l214536/l=ins:\lll
114537=114537==/l90001/l\pitchfork=/l214537/l=ins:\pitchfork
114538=114538==/l90001/l\precapprox=/l214538/l=ins:\precapprox
114539=114539==/l90001/l\preccurlyeq=/l214539/l=ins:\preccurlyeq
114540=114540==/l90001/l\precsim=/l214540/l=ins:\precsim
114541=114541==/l90001/l\risingdotseq=/l214541/l=ins:\risingdotseq
114542=114542==/l90001/l\shortmid=/l214542/l=ins:\shortmid
114543=114543==/l90001/l\shortparallel=/l214543/l=ins:\shortparallel
114544=114544==/l90001/l\smallfrown=/l214544/l=ins:\smallfrown
114545=114545==/l90001/l\sqsubset=/l214545/l=ins:\sqsubset
114546=114546==/l90001/l\sqsupset=/l214546/l=ins:\sqsupset
114547=114547==/l90001/l\Subset=/l214547/l=ins:\Subset
114548=114548==/l90001/l\subseteqq=/l214548/l=ins:\subseteqq
114549=114549==/l90001/l\succapprox=/l214549/l=ins:\succapprox
114550=114550==/l90001/l\succcurlyeq=/l214550/l=ins:\succcurlyeq
114551=114551==/l90001/l\succsim=/l214551/l=ins:\succsim
114552=114552==/l90001/l\Supset=/l214552/l=ins:\Supset
114553=114553==/l90001/l\supseteqq=/l214553/l=ins:\supseteqq
114554=114554==/l90001/l\therefore=/l214554/l=ins:\therefore
114555=114555==/l90001/l\thickapprox=/l214555/l=ins:\thickapprox
114556=114556==/l90001/l\thicksim=/l214556/l=ins:\thicksim
114557=114557==/l90001/l\trianglelefteq=/l214557/l=ins:\trianglelefteq
114558=114558==/l90001/l\triangleq=/l214558/l=ins:\triangleq
114559=114559==/l90001/l\trianglerighteq=/l214559/l=ins:\trianglerighteq
114560=114560==/l90001/l\varpropto=/l214560/l=ins:\varpropto
114561=114561==/l90001/l\vartriangleleft=/l214561/l=ins:\vartriangleleft
114562=114562==/l90001/l\vartriangleright=/l214562/l=ins:\vartriangleright
114563=114563==/l90001/l\Vdash=/l214563/l=ins:\Vdash
114564=114564==/l90001/l\vDash=/l214564/l=ins:\vDash
114565=114565==/l90001/l\Vvdash=/l214565/l=ins:\Vvdash

// 115000 - AMS Negated Binary Relations
115001=115001==/l90001/l\gnapprox=/l215001/l=ins:\gnapprox
115002=115002==/l90001/l\gneq=/l215002/l=ins:\gneq
115003=115003==/l90001/l\gneqq=/l215003/l=ins:\gneqq
115004=115004==/l90001/l\gnsim=/l215004/l=ins:\gnsim
115005=115005==/l90001/l\gvertneqq=/l215005/l=ins:\gvertneqq
115006=115006==/l90001/l\lnapprox=/l215006/l=ins:\lnapprox
115007=115007==/l90001/l\lneq=/l215007/l=ins:\lneq
115008=115008==/l90001/l\lneqq=/l215008/l=ins:\lneqq
115009=115009==/l90001/l\lnsim=/l215009/l=ins:\lnsim
115010=115010==/l90001/l\lvertneqq=/l215010/l=ins:\lvertneqq
115011=115011==/l90001/l\ncong=/l215011/l=ins:\ncong
115012=115012==/l90001/l\ngeq=/l215012/l=ins:\ngeq
115013=115013==/l90001/l\ngeqq=/l215013/l=ins:\ngeqq
115014=115014==/l90001/l\ngeqslant=/l215014/l=ins:\ngeqslant
115015=115015==/l90001/l\ngtr=/l215015/l=ins:\ngtr
115016=115016==/l90001/l\nleq=/l215016/l=ins:\nleq
115017=115017==/l90001/l\nleqq=/l215017/l=ins:\nleqq
115018=115018==/l90001/l\nleqslant=/l215018/l=ins:\nleqslant
115019=115019==/l90001/l\nless=/l215019/l=ins:\nless
115020=115020==/l90001/l\nmid=/l215020/l=ins:\nmid
115021=115021==/l90001/l\nparallel=/l215021/l=ins:\nparallel
115022=115022==/l90001/l\nprec=/l215022/l=ins:\nprec
115023=115023==/l90001/l\npreceq=/l215023/l=ins:\npreceq
115024=115024==/l90001/l\nshortmid=/l215024/l=ins:\nshortmid
115025=115025==/l90001/l\nshortparallel=/l215025/l=ins:\nshortparallel
115026=115026==/l90001/l\nsim=/l215026/l=ins:\nsim
115027=115027==/l90001/l\nsubseteq=/l215027/l=ins:\nsubseteq
115028=115028==/l90001/l\nsucc=/l215028/l=ins:\nsucc
115029=115029==/l90001/l\nsucceq=/l215029/l=ins:\nsucceq
115030=115030==/l90001/l\nsupseteq=/l215030/l=ins:\nsupseteq
115031=115031==/l90001/l\nsupseteqq=/l215031/l=ins:\nsupseteqq
115032=115032==/l90001/l\ntriangleleft=/l215032/l=ins:\ntriangleleft
115033=115033==/l90001/l\ntrianglelefteq=/l215033/l=ins:\ntrianglelefteq
115034=115034==/l90001/l\ntriangleright=/l215034/l=ins:\ntriangleright
115035=115035==/l90001/l\ntrianglerighteq=/l215035/l=ins:\ntrianglerighteq
115036=115036==/l90001/l\nvdash=/l215036/l=ins:\nvdash
115037=115037==/l90001/l\nvDash=/l215037/l=ins:\nvDash
115038=115038==/l90001/l\nVDash=/l215038/l=ins:\nVDash
115039=115039==/l90001/l\precnapprox=/l215039/l=ins:\precnapprox
115040=115040==/l90001/l\precnsim=/l215040/l=ins:\precnsim
115041=115041==/l90001/l\subsetneq=/l215041/l=ins:\subsetneq
115042=115042==/l90001/l\subsetneqq=/l215042/l=ins:\subsetneqq
115043=115043==/l90001/l\succnapprox=/l215043/l=ins:\succnapprox
115044=115044==/l90001/l\succnsim=/l215044/l=ins:\succnsim
115045=115045==/l90001/l\supsetneq=/l215045/l=ins:\supsetneq
115046=115046==/l90001/l\supsetneqq=/l215046/l=ins:\supsetneqq
115047=115047==/l90001/l\varsubsetneq=/l215047/l=ins:\varsubsetneq
115048=115048==/l90001/l\varsubsetneqq=/l215048/l=ins:\varsubsetneqq
115049=115049==/l90001/l\varsupsetneq=/l215049/l=ins:\varsupsetneq
115050=115050==/l90001/l\varsupsetneqq=/l215050/l=ins:\varsupsetneqq

// 115500 - atmaryrd Binary Relations
115501=115501==/l90001/l\inplus=/l215501/l=ins:\inplus
115502=115502==/l90001/l\niplus=/l215502/l=ins:\niplus
115503=115503==/l90001/l\subsetplus=/l215503/l=ins:\subsetplus
115504=115504==/l90001/l\subsetpluseq=/l215504/l=ins:\subsetpluseq
115505=115505==/l90001/l\supsetplus=/l215505/l=ins:\supsetplus
115506=115506==/l90001/l\supsetpluseq=/l215506/l=ins:\supsetpluseq
115507=115507==/l90001/l\trianglelefteqslant=/l215507/l=ins:\trianglelefteqslant
115508=115508==/l90001/l\trianglerighteqslant=/l215508/l=ins:\trianglerighteqslant

// 116000 - stmaryrd Negated Binary Relations
116001=116001==/l90001/l\ntrianglelefteqslant=/l216001/l=ins:\ntrianglelefteqslant
116002=116002==/l90001/l\ntrianglerighteqslant=/l216002/l=ins:\ntrianglerighteqslant

// 116500 - txfonts/pxfonts Binary Relations
116501=116501==/l90001/l\boxdotLeft=/l216501/l=ins:\boxdotLeft
116502=116502==/l90001/l\boxdotleft=/l216502/l=ins:\boxdotleft
116503=116503==/l90001/l\boxdotright=/l216503/l=ins:\boxdotright
116504=116504==/l90001/l\boxdotRight=/l216504/l=ins:\boxdotRight
116505=116505==/l90001/l\boxleft=/l216505/l=ins:\boxleft
116506=116506==/l90001/l\boxLeft=/l216506/l=ins:\boxLeft
116507=116507==/l90001/l\boxRight=/l216507/l=ins:\boxRight
116508=116508==/l90001/l\boxright=/l216508/l=ins:\boxright
116509=116509==/l90001/l\circleddotleft=/l216509/l=ins:\circleddotleft
116510=116510==/l90001/l\circleddotright=/l216510/l=ins:\circleddotright
116511=116511==/l90001/l\circledgtr=/l216511/l=ins:\circledgtr
116512=116512==/l90001/l\circledless=/l216512/l=ins:\circledless
116513=116513==/l90001/l\circleleft=/l216513/l=ins:\circleleft
116514=116514==/l90001/l\circleright=/l216514/l=ins:\circleright
116515=116515==/l90001/l\colonapprox=/l216515/l=ins:\colonapprox
116516=116516==/l90001/l\Colonapprox=/l216516/l=ins:\Colonapprox
116517=116517==/l90001/l\coloneq=/l216517/l=ins:\coloneq
116518=116518==/l90001/l\Coloneq=/l216518/l=ins:\Coloneq
116519=116519==/l90001/l\coloneqq=/l216519/l=ins:\coloneqq
116520=116520==/l90001/l\Coloneqq=/l216520/l=ins:\Coloneqq
116521=116521==/l90001/l\colonsim=/l216521/l=ins:\colonsim
116522=116522==/l90001/l\Colonsim=/l216522/l=ins:\Colonsim
116523=116523==/l90001/l\dashleftrightarrow=/l216523/l=ins:\dashleftrightarrow
116524=116524==/l90001/l\Diamonddotleft=/l216524/l=ins:\Diamonddotleft
116525=116525==/l90001/l\DiamonddotLeft=/l216525/l=ins:\DiamonddotLeft
116526=116526==/l90001/l\Diamonddotright=/l216526/l=ins:\Diamonddotright
116527=116527==/l90001/l\DiamonddotRight=/l216527/l=ins:\DiamonddotRight
116528=116528==/l90001/l\Diamondleft=/l216528/l=ins:\Diamondleft
116529=116529==/l90001/l\DiamondLeft=/l216529/l=ins:\DiamondLeft
116530=116530==/l90001/l\Diamondright=/l216530/l=ins:\Diamondright
116531=116531==/l90001/l\DiamondRight=/l216531/l=ins:\DiamondRight
116532=116532==/l90001/l\Eqcolon=/l216532/l=ins:\Eqcolon
116533=116533==/l90001/l\eqcolon=/l216533/l=ins:\eqcolon
116534=116534==/l90001/l\Eqqcolon=/l216534/l=ins:\Eqqcolon
116535=116535==/l90001/l\eqqcolon=/l216535/l=ins:\eqqcolon
116536=116536==/l90001/l\eqsim=/l216536/l=ins:\eqsim
116537=116537==/l90001/l\lJoin=/l216537/l=ins:\lJoin
116538=116538==/l90001/l\lrtimes=/l216538/l=ins:\lrtimes
116539=116539==/l90001/l\Mappedfromchar=/l216539/l=ins:\Mappedfromchar
116540=116540==/l90001/l\mappedfromchar=/l216540/l=ins:\mappedfromchar
116541=116541==/l90001/l\mmappedfromchar=/l216541/l=ins:\mmappedfromchar
116542=116542==/l90001/l\Mmappedfromchar=/l216542/l=ins:\Mmappedfromchar
116543=116543==/l90001/l\mmapstochar=/l216543/l=ins:\mmapstochar
116544=116544==/l90001/l\Mmapstochar=/l216544/l=ins:\Mmapstochar
116545=116545==/l90001/l\multimapboth=/l216545/l=ins:\multimapboth
116546=116546==/l90001/l\multimapbothvert=/l216546/l=ins:\multimapbothvert
116547=116547==/l90001/l\multimapbothvert=/l216547/l=ins:\multimapbothvert
116548=116548==/l90001/l\multimapdotboth=/l216548/l=ins:\multimapdotboth
116549=116549==/l90001/l\multimapdotbothA=/l216549/l=ins:\multimapdotbothA
116550=116550==/l90001/l\multimapdotbothAvert=/l216550/l=ins:\multimapdotbothAvert
116551=116551==/l90001/l\multimapdotbothB=/l216551/l=ins:\multimapdotbothB
116552=116552==/l90001/l\multimapdotbothBvert=/l216552/l=ins:\multimapdotbothBvert
116553=116553==/l90001/l\multimapdotbothvert=/l216553/l=ins:\multimapdotbothvert
116554=116554==/l90001/l\multimapdotinv=/l216554/l=ins:\multimapdotinv
116555=116555==/l90001/l\multimapinv=/l216555/l=ins:\multimapinv
116556=116556==/l90001/l\napproxeq=/l216556/l=ins:\napproxeq
116557=116557==/l90001/l\nasymp=/l216557/l=ins:\nasymp
116558=116558==/l90001/l\nbacksim=/l216558/l=ins:\nbacksim
116559=116559==/l90001/l\nbacksimeq=/l216559/l=ins:\nbacksimeq
116560=116560==/l90001/l\nBumpeq=/l216560/l=ins:\nBumpeq
116561=116561==/l90001/l\nbumpeq=/l216561/l=ins:\nbumpeq
116562=116562==/l90001/l\Nearrow=/l216562/l=ins:\Nearrow
116563=116563==/l90001/l\nequiv=/l216563/l=ins:\nequiv
116564=116564==/l90001/l\ngg=/l216564/l=ins:\ngg
116565=116565==/l90001/l\ngtrapprox=/l216565/l=ins:\ngtrapprox
116566=116566==/l90001/l\ngtrless=/l216566/l=ins:\ngtrless
116567=116567==/l90001/l\ngtrsim=/l216567/l=ins:\ngtrsim
116568=116568==/l90001/l\nlessapprox=/l216568/l=ins:\nlessapprox
116569=116569==/l90001/l\nlessgtr=/l216569/l=ins:\nlessgtr
116570=116570==/l90001/l\nlesssim=/l216570/l=ins:\nlesssim
116571=116571==/l90001/l\nll=/l216571/l=ins:\nll
116572=116572==/l90001/l\notin=/l216572/l=ins:\notin
116573=116573==/l90001/l\notni=/l216573/l=ins:\notni
116574=116574==/l90001/l\nprecapprox=/l216574/l=ins:\nprecapprox
116575=116575==/l90001/l\npreccurlyeq=/l216575/l=ins:\npreccurlyeq
116576=116576==/l90001/l\npreceqq=/l216576/l=ins:\npreceqq
116577=116577==/l90001/l\nprecsim=/l216577/l=ins:\nprecsim
116578=116578==/l90001/l\nsimeq=/l216578/l=ins:\nsimeq
116579=116579==/l90001/l\nsqsubset=/l216579/l=ins:\nsqsubset
116580=116580==/l90001/l\nsqsubseteq=/l216580/l=ins:\nsqsubseteq
116581=116581==/l90001/l\nsqsupset=/l216581/l=ins:\nsqsupset
116582=116582==/l90001/l\nsqsupseteq=/l216582/l=ins:\nsqsupseteq
116583=116583==/l90001/l\nSubset=/l216583/l=ins:\nSubset
116584=116584==/l90001/l\nsubseteqq=/l216584/l=ins:\nsubseteqq
116585=116585==/l90001/l\nsuccapprox=/l216585/l=ins:\nsuccapprox
116586=116586==/l90001/l\nsucccurlyeq=/l216586/l=ins:\nsucccurlyeq
116587=116587==/l90001/l\nsucceqq=/l216587/l=ins:\nsucceqq
116588=116588==/l90001/l\nsuccsim=/l216588/l=ins:\nsuccsim
116589=116589==/l90001/l\nSupset=/l216589/l=ins:\nSupset
116590=116590==/l90001/l\nthickapprox=/l216590/l=ins:\nthickapprox
116591=116591==/l90001/l\ntwoheadleftarrow=/l216591/l=ins:\ntwoheadleftarrow
116592=116592==/l90001/l\ntwoheadrightarrow=/l216592/l=ins:\ntwoheadrightarrow
116593=116593==/l90001/l\nvarparallel=/l216593/l=ins:\nvarparallel
116594=116594==/l90001/l\nvarparallelinv=/l216594/l=ins:\nvarparallelinv
116595=116595==/l90001/l\nVdash=/l216595/l=ins:\nVdash
116596=116596==/l90001/l\Nwarrow=/l216596/l=ins:\Nwarrow
116597=116597==/l90001/l\openJoin=/l216597/l=ins:\openJoin
116598=116598==/l90001/l\opentimes=/l216598/l=ins:\opentimes
116599=116599==/l90001/l\Perp=/l216599/l=ins:\Perp
116600=116600==/l90001/l\preceqq=/l216600/l=ins:\preceqq
116601=116601==/l90001/l\precneqq=/l216601/l=ins:\precneqq
116602=116602==/l90001/l\rJoin=/l216602/l=ins:\rJoin
116603=116603==/l90001/l\Rrightarrow=/l216603/l=ins:\Rrightarrow
116604=116604==/l90001/l\Searrow=/l216604/l=ins:\Searrow
116605=116605==/l90001/l\strictfi=/l216605/l=ins:\strictfi
116606=116606==/l90001/l\strictif=/l216606/l=ins:\strictif
116607=116607==/l90001/l\strictiff=/l216607/l=ins:\strictiff
116608=116608==/l90001/l\succeqq=/l216608/l=ins:\succeqq
116609=116609==/l90001/l\succneqq=/l216609/l=ins:\succneqq
116610=116610==/l90001/l\Swarrow=/l216610/l=ins:\Swarrow
116611=116611==/l90001/l\varparallel=/l216611/l=ins:\varparallel
116612=116612==/l90001/l\varparallelinv=/l216612/l=ins:\varparallelinv
116613=116613==/l90001/l\VvDash=/l216613/l=ins:\VvDash

// 117000 - Arrow Symbols
117001=117001==/l90001/l\Downarrow=/l217001/l=ins:\Downarrow
117002=117002==/l90001/l\downarrow=/l217002/l=ins:\downarrow
117003=117003==/l90001/l\hookleftarrow=/l217003/l=ins:\hookleftarrow
117004=117004==/l90001/l\hookrightarrow=/l217004/l=ins:\hookrightarrow
117005=117005==/l90001/l\leadsto=/l217005/l=ins:\leadsto
117006=117006==/l90001/l\Leftarrow=/l217006/l=ins:\Leftarrow
117007=117007==/l90001/l\leftarrow=/l217007/l=ins:\leftarrow
117008=117008==/l90001/l\leftharpoondown=/l217008/l=ins:\leftharpoondown
117009=117009==/l90001/l\leftharpoonup=/l217009/l=ins:\leftharpoonup
117010=117010==/l90001/l\Leftrightarrow=/l217010/l=ins:\Leftrightarrow
117011=117011==/l90001/l\leftrightarrow=/l217011/l=ins:\leftrightarrow
117012=117012==/l90001/l\longleftarrow=/l217012/l=ins:\longleftarrow
117013=117013==/l90001/l\Longleftarrow=/l217013/l=ins:\Longleftarrow
117014=117014==/l90001/l\longleftrightarrow=/l217014/l=ins:\longleftrightarrow
117015=117015==/l90001/l\Longleftrightarrow=/l217015/l=ins:\Longleftrightarrow
117016=117016==/l90001/l\longmapsto=/l217016/l=ins:\longmapsto
117017=117017==/l90001/l\longrightarrow=/l217017/l=ins:\longrightarrow
117018=117018==/l90001/l\Longrightarrow=/l217018/l=ins:\Longrightarrow
117019=117019==/l90001/l\mapsto=/l217019/l=ins:\mapsto
117020=117020==/l90001/l\nearrow=/l217020/l=ins:\nearrow
117021=117021==/l90001/l\nwarrow=/l217021/l=ins:\nwarrow
117022=117022==/l90001/l\rightarrow=/l217022/l=ins:\rightarrow
117023=117023==/l90001/l\Rightarrow=/l217023/l=ins:\Rightarrow
117024=117024==/l90001/l\rightharpoondown=/l217024/l=ins:\rightharpoondown
117025=117025==/l90001/l\rightharpoonup=/l217025/l=ins:\rightharpoonup
117026=117026==/l90001/l\rightleftharpoons=/l217026/l=ins:\rightleftharpoons
117027=117027==/l90001/l\searrow=/l217027/l=ins:\searrow
117028=117028==/l90001/l\swarrow=/l217028/l=ins:\swarrow
117029=117029==/l90001/l\uparrow=/l217029/l=ins:\uparrow
117030=117030==/l90001/l\Uparrow=/l217030/l=ins:\Uparrow
117031=117031==/l90001/l\Updownarrow=/l217031/l=ins:\Updownarrow
117032=117032==/l90001/l\updownarrow=/l217032/l=ins:\updownarrow

// 117500 - AMS Arrows
117501=117501==/l90001/l\circlearrowleft=/l217501/l=ins:\circlearrowleft
117502=117502==/l90001/l\circlearrowright=/l217502/l=ins:\circlearrowright
117503=117503==/l90001/l\curvearrowleft=/l217503/l=ins:\curvearrowleft
117504=117504==/l90001/l\curvearrowright=/l217504/l=ins:\curvearrowright
117505=117505==/l90001/l\dashleftarrow=/l217505/l=ins:\dashleftarrow
117506=117506==/l90001/l\dashrightarrow=/l217506/l=ins:\dashrightarrow
117507=117507==/l90001/l\downdownarrows=/l217507/l=ins:\downdownarrows
117508=117508==/l90001/l\downharpoonleft=/l217508/l=ins:\downharpoonleft
117509=117509==/l90001/l\downharpoonright=/l217509/l=ins:\downharpoonright
117510=117510==/l90001/l\leftarrowtail=/l217510/l=ins:\leftarrowtail
117511=117511==/l90001/l\leftleftarrows=/l217511/l=ins:\leftleftarrows
117512=117512==/l90001/l\leftrightarrows=/l217512/l=ins:\leftrightarrows
117513=117513==/l90001/l\leftrightharpoons=/l217513/l=ins:\leftrightharpoons
117514=117514==/l90001/l\leftrightsquigarrow=/l217514/l=ins:\leftrightsquigarrow
117515=117515==/l90001/l\Lleftarrow=/l217515/l=ins:\Lleftarrow
117516=117516==/l90001/l\looparrowleft=/l217516/l=ins:\looparrowleft
117517=117517==/l90001/l\looparrowright=/l217517/l=ins:\looparrowright
117518=117518==/l90001/l\Lsh=/l217518/l=ins:\Lsh
117519=117519==/l90001/l\multimap=/l217519/l=ins:\multimap
117520=117520==/l90001/l\rightarrowtail=/l217520/l=ins:\rightarrowtail
117521=117521==/l90001/l\rightleftarrows=/l217521/l=ins:\rightleftarrows
117522=117522==/l90001/l\rightleftharpoons=/l217522/l=ins:\rightleftharpoons
117523=117523==/l90001/l\rightrightarrows=/l217523/l=ins:\rightrightarrows
117524=117524==/l90001/l\rightsquigarrow=/l217524/l=ins:\rightsquigarrow
117525=117525==/l90001/l\Rsh=/l217525/l=ins:\Rsh
117526=117526==/l90001/l\twoheadleftarrow=/l217526/l=ins:\twoheadleftarrow
117527=117527==/l90001/l\twoheadrightarrow=/l217527/l=ins:\twoheadrightarrow
117528=117528==/l90001/l\upharpoonleft=/l217528/l=ins:\upharpoonleft
117529=117529==/l90001/l\upharpoonright=/l217529/l=ins:\upharpoonright
117530=117530==/l90001/l\upuparrows=/l217530/l=ins:\upuparrows

// 118000 - AMS Negated Arrows
118001=118001==/l90001/l\nLeftarrow=/l218001/l=ins:\nLeftarrow
118002=118002==/l90001/l\nleftarrow=/l218002/l=ins:\nleftarrow
118003=118003==/l90001/l\nLeftrightarrow=/l218003/l=ins:\nLeftrightarrow
118004=118004==/l90001/l\nleftrightarrow=/l218004/l=ins:\nleftrightarrow
118005=118005==/l90001/l\nRightarrow=/l218005/l=ins:\nRightarrow
118006=118006==/l90001/l\nrightarrow=/l218006/l=ins:\nrightarrow

// 118500 - stmaryrd Arrows
118501=118501==/l90001/l\leftarrowtriangle=/l218501/l=ins:\leftarrowtriangle
118502=118502==/l90001/l\leftrightarroweq=/l218502/l=ins:\leftrightarroweq
118503=118503==/l90001/l\leftrightarrowtriangle=/l218503/l=ins:\leftrightarrowtriangle
118504=118504==/l90001/l\lightning=/l218504/l=ins:\lightning
118505=118505==/l90001/l\Longmapsfrom=/l218505/l=ins:\Longmapsfrom
118506=118506==/l90001/l\longmapsfrom=/l218506/l=ins:\longmapsfrom
118507=118507==/l90001/l\Longmapsto=/l218507/l=ins:\Longmapsto
118508=118508==/l90001/l\Mapsfrom=/l218508/l=ins:\Mapsfrom
118509=118509==/l90001/l\mapsfrom=/l218509/l=ins:\mapsfrom
118510=118510==/l90001/l\Mapsto=/l218510/l=ins:\Mapsto
118511=118511==/l90001/l\nnearrow=/l218511/l=ins:\nnearrow
118512=118512==/l90001/l\nnwarrow=/l218512/l=ins:\nnwarrow
118513=118513==/l90001/l\rightarrowtriangle=/l218513/l=ins:\rightarrowtriangle
118514=118514==/l90001/l\rrparenthesis=/l218514/l=ins:\rrparenthesis
118515=118515==/l90001/l\shortdownarrow=/l218515/l=ins:\shortdownarrow
118516=118516==/l90001/l\shortuparrow=/l218516/l=ins:\shortuparrow
118517=118517==/l90001/l\shortleftarrow=/l218517/l=ins:\shortleftarrow
118518=118518==/l90001/l\shortrightarrow=/l218518/l=ins:\shortrightarrow
118519=118519==/l90001/l\shortuparrow=/l218519/l=ins:\shortuparrow
118520=118520==/l90001/l\ssearrow=/l218520/l=ins:\ssearrow
118521=118521==/l90001/l\sswarrow=/l218521/l=ins:\sswarrow

// 119000 - Log-like Symbols
119001=119001==/l90001/l\arccos=/l219001/l=ins:\arccos
119002=119002==/l90001/l\arcsin=/l219002/l=ins:\arcsin
119003=119003==/l90001/l\arctan=/l219003/l=ins:\arctan
119004=119004==/l90001/l\arg=/l219004/l=ins:\arg
119005=119005==/l90001/l\cos=/l219005/l=ins:\cos
119006=119006==/l90001/l\cosh=/l219006/l=ins:\cosh
119007=119007==/l90001/l\cot=/l219007/l=ins:\cot
119008=119008==/l90001/l\coth=/l219008/l=ins:\coth
119009=119009==/l90001/l\csc=/l219009/l=ins:\csc
119010=119010==/l90001/l\deg=/l219010/l=ins:\deg
119011=119011==/l90001/l\det=/l219011/l=ins:\det
119012=119012==/l90001/l\dim=/l219012/l=ins:\dim
119013=119013==/l90001/l\exp=/l219013/l=ins:\exp
119014=119014==/l90001/l\gcd=/l219014/l=ins:\gcd
119015=119015==/l90001/l\hom=/l219015/l=ins:\hom
119016=119016==/l90001/l\inf=/l219016/l=ins:\inf
119017=119017==/l90001/l\ker=/l219017/l=ins:\ker
119018=119018==/l90001/l\lg=/l219018/l=ins:\lg
119019=119019==/l90001/l\lim=/l219019/l=ins:\lim
119020=119020==/l90001/l\liminf=/l219020/l=ins:\liminf
119021=119021==/l90001/l\limsup=/l219021/l=ins:\limsup
119022=119022==/l90001/l\ln=/l219022/l=ins:\ln
119023=119023==/l90001/l\log=/l219023/l=ins:\log
119024=119024==/l90001/l\max=/l219024/l=ins:\max
119025=119025==/l90001/l\min=/l219025/l=ins:\min
119026=119026==/l90001/l\Pr=/l219026/l=ins:\Pr
119027=119027==/l90001/l\sec=/l219027/l=ins:\sec
119028=119028==/l90001/l\sin=/l219028/l=ins:\sin
119029=119029==/l90001/l\sinh=/l219029/l=ins:\sinh
119030=119030==/l90001/l\sup=/l219030/l=ins:\sup
119031=119031==/l90001/l\tan=/l219031/l=ins:\tan
119032=119032==/l90001/l\tanh=/l219032/l=ins:\tanh

// 119500 - AMS Log-like Symbols
119501=119501==/l90001/l\injlim=/l219501/l=ins:\injlim
119502=119502==/l90001/l\projlim=/l219502/l=ins:\projlim
119503=119503==/l90001/l\varinjlim=/l219503/l=ins:\varinjlim
119504=119504==/l90001/l\varliminf=/l219504/l=ins:\varliminf
119505=119505==/l90001/l\varlimsup=/l219505/l=ins:\varlimsup
119506=119506==/l90001/l\varprojlim=/l219506/l=ins:\varprojlim

// 120000 - Greek Letters
120001=120001==/l90001/l\alpha=/l220001/l=ins:\alpha
120002=120002==/l90001/l\beta=/l220002/l=ins:\beta
120003=120003==/l90001/l\gamma=/l220003/l=ins:\gamma
120004=120004==/l90001/l\delta=/l220004/l=ins:\delta
120005=120005==/l90001/l\epsilon=/l220005/l=ins:\epsilon
120006=120006==/l90001/l\varepsilon=/l220006/l=ins:\varepsilon
120007=120007==/l90001/l\zeta=/l220007/l=ins:\zeta
120008=120008==/l90001/l\eta=/l220008/l=ins:\eta
120009=120009==/l90001/l\theta=/l220009/l=ins:\theta
120010=120010==/l90001/l\vartheta=/l220010/l=ins:\vartheta
120011=120011==/l90001/l\iota=/l220011/l=ins:\iota
120012=120012==/l90001/l\kappa=/l220012/l=ins:\kappa
120013=120013==/l90001/l\lambda=/l220013/l=ins:\lambda
120014=120014==/l90001/l\mu=/l220014/l=ins:\mu
120015=120015==/l90001/l\nu=/l220015/l=ins:\nu
120016=120016==/l90001/l\xi=/l220016/l=ins:\xi
120017=120017==/l90001/lo=/l220017/l=ins:o
120018=120018==/l90001/l\pi=/l220018/l=ins:\pi
120019=120019==/l90001/l\varpi=/l220019/l=ins:\varpi
120020=120020==/l90001/l\rho=/l220020/l=ins:\rho
120021=120021==/l90001/l\varrho=/l220021/l=ins:\varrho
120022=120022==/l90001/l\sigma=/l220022/l=ins:\sigma
120023=120023==/l90001/l\varsigma=/l220023/l=ins:\varsigma
120024=120024==/l90001/l\tau=/l220024/l=ins:\tau
120025=120025==/l90001/l\upsilon=/l220025/l=ins:\upsilon
120026=120026==/l90001/l\phi=/l220026/l=ins:\phi
120027=120027==/l90001/l\varphi=/l220027/l=ins:\varphi
120028=120028==/l90001/l\chi=/l220028/l=ins:\chi
120029=120029==/l90001/l\psi=/l220029/l=ins:\psi
120030=120030==/l90001/l\omega=/l220030/l=ins:\omega
120031=120031==/l90001/l\Gamma=/l220031/l=ins:\Gamma
120032=120032==/l90001/l\Delta=/l220032/l=ins:\Delta
120033=120033==/l90001/l\Theta=/l220033/l=ins:\Theta
120034=120034==/l90001/l\Lambda=/l220034/l=ins:\Lambda
120035=120035==/l90001/l\Xi=/l220035/l=ins:\Xi
120036=120036==/l90001/l\Pi=/l220036/l=ins:\Pi
120037=120037==/l90001/l\Sigma=/l220037/l=ins:\Sigma
120038=120038==/l90001/l\Upsilon=/l220038/l=ins:\Upsilon
120039=120039==/l90001/l\Phi=/l220039/l=ins:\Phi
120040=120040==/l90001/l\Psi=/l220040/l=ins:\Psi
120041=120041==/l90001/l\Omega=/l220041/l=ins:\Omega

// 120500 - AMS Greek Letters
120501=120501==/l90001/l\digamma=/l220501/l=ins:\digamma
120502=120502==/l90001/l\varkappa=/l220502/l=ins:\varkappa

// 121000 - txfonts/pxfonts Upright Greek Letters
121001=121001==/l90001/l\alphaup=/l221001/l=ins:\alphaup
121002=121002==/l90001/l\betaup=/l221002/l=ins:\betaup
121003=121003==/l90001/l\gammaup=/l221003/l=ins:\gammaup
121004=121004==/l90001/l\deltaup=/l221004/l=ins:\deltaup
121005=121005==/l90001/l\epsilonup=/l221005/l=ins:\epsilonup
121006=121006==/l90001/l\varepsilonup=/l221006/l=ins:\varepsilonup
121007=121007==/l90001/l\zetaup=/l221007/l=ins:\zetaup
121008=121008==/l90001/l\etaup=/l221008/l=ins:\etaup
121009=121009==/l90001/l\thetaup=/l221009/l=ins:\thetaup
121010=121010==/l90001/l\varthetaup=/l221010/l=ins:\varthetaup
121011=121011==/l90001/l\iotaup=/l221011/l=ins:\iotaup
121012=121012==/l90001/l\kappaup=/l221012/l=ins:\kappaup
121013=121013==/l90001/l\lambdaup=/l221013/l=ins:\lambdaup
121014=121014==/l90001/l\muup=/l221014/l=ins:\muup
121015=121015==/l90001/l\muup=/l221015/l=ins:\muup
121016=121016==/l90001/l\nuup=/l221016/l=ins:\nuup
121017=121017==/l90001/l\xiup=/l221017/l=ins:\xiup
121018=121018==/l90001/l\piup=/l221018/l=ins:\piup
121019=121019==/l90001/l\varpiup=/l221019/l=ins:\varpiup
121020=121020==/l90001/l\rhoup=/l221020/l=ins:\rhoup
121021=121021==/l90001/l\varrhoup=/l221021/l=ins:\varrhoup
121022=121022==/l90001/l\sigmaup=/l221022/l=ins:\sigmaup
121023=121023==/l90001/l\varsigmaup=/l221023/l=ins:\varsigmaup
121024=121024==/l90001/l\tauup=/l221024/l=ins:\tauup
121025=121025==/l90001/l\upsilonup=/l221025/l=ins:\upsilonup
121026=121026==/l90001/l\phiup=/l221026/l=ins:\phiup
121027=121027==/l90001/l\varphiup=/l221027/l=ins:\varphiup
121028=121028==/l90001/l\chiup=/l221028/l=ins:\chiup
121029=121029==/l90001/l\psiup=/l221029/l=ins:\psiup
121030=121030==/l90001/l\omegaup=/l221030/l=ins:\omegaup

// 121500 - txfonts/pxfonts Variant Latin Letters
121501=121501==/l90001/l\varg=/l221501/l=ins:\varg
121502=121502==/l90001/l\varv=/l221502/l=ins:\varv
121503=121503==/l90001/l\varw=/l221503/l=ins:\varw
121504=121504==/l90001/l\vary=/l221504/l=ins:\vary

// 122000 - AMS Hebrew Letters
122001=122001==/l90001/l\beth=/l222001/l=ins:\beth
122002=122002==/l90001/l\daleth=/l222002/l=ins:\daleth
122003=122003==/l90001/l\gimel=/l222003/l=ins:\gimel

// 122500 - Variable-sized Delimiters
122501=122501==/l90001/l(=/l222501/l=ins:(
122502=122502==/l90001/l[=/l222502/l=ins:[
122503=122503==/l90001/l\{=/l222503/l=ins:\{
122504=122504==/l90001/l\lfloor=/l222504/l=ins:\lfloor
122505=122505==/l90001/l\langle=/l222505/l=ins:\langle
122506=122506==/l90001/l|=/l222506/l=ins:|
122507=122507==/l90001/l)=/l222507/l=ins:)
122508=122508==/l90001/l]=/l222508/l=ins:]
122509=122509==/l90001/l\}=/l222509/l=ins:\}
122510=122510==/l90001/l\rfloor=/l222510/l=ins:\rfloor
122511=122511==/l90001/l\rangle=/l222511/l=ins:\rangle
122512=122512==/l90001/l\|=/l222512/l=ins:\|
122513=122513==/l90001/l\uparrow=/l222513/l=ins:\uparrow
122514=122514==/l90001/l\downarrow=/l222514/l=ins:\downarrow
122515=122515==/l90001/l\updownarrow=/l222515/l=ins:\updownarrow
122516=122516==/l90001/l\lceil=/l222516/l=ins:\lceil
122517=122517==/l90001/l/=/l222517/l=ins:/
122518=122518==/l90001/l\Uparrow=/l222518/l=ins:\Uparrow
122519=122519==/l90001/l\Downarrow=/l222519/l=ins:\Downarrow
122520=122520==/l90001/l\Updownarrow=/l222520/l=ins:\Updownarrow
122521=122521==/l90001/l\rceil=/l222521/l=ins:\rceil
122522=122522==/l90001/l\backslash=/l222522/l=ins:\backslash

// 123000 - Large, Variable-sized Delimiters
123001=123001==/l90001/l\rmoustache=/l223001/l=ins:\rmoustache
123002=123002==/l90001/l\arrowvert=/l223002/l=ins:\arrowvert
123003=123003==/l90001/l\lmoustache=/l223003/l=ins:\lmoustache
123004=123004==/l90001/l\Arrowvert=/l223004/l=ins:\Arrowvert
123005=123005==/l90001/l\rgroup=/l223005/l=ins:\rgroup
123006=123006==/l90001/l\bracevert=/l223006/l=ins:\bracevert
123007=123007==/l90001/l\lgroup=/l223007/l=ins:\lgroup

// 123500 - AMS Delimiters
123501=123501==/l90001/l\ulcorner=/l223501/l=ins:\ulcorner
123502=123502==/l90001/l\urcorner=/l223502/l=ins:\urcorner
123503=123503==/l90001/l\llcorner=/l223503/l=ins:\llcorner
123504=123504==/l90001/l\lrcorner=/l223504/l=ins:\lrcorner

// 124000 - stmaryrd Delimiters
124001=124001==/l90001/l\Lbag=/l224001/l=ins:\Lbag
124002=124002==/l90001/l\llceil=/l224002/l=ins:\llceil
124003=124003==/l90001/l\llparenthesis=/l224003/l=ins:\llparenthesis
124004=124004==/l90001/l\Rbag=/l224004/l=ins:\Rbag
124005=124005==/l90001/l\rrceil=/l224005/l=ins:\rrceil
124006=124006==/l90001/l\rrparenthesis=/l224006/l=ins:\rrparenthesis
124007=124007==/l90001/l\lbag=/l224007/l=ins:\lbag
124008=124008==/l90001/l\llfloor=/l224008/l=ins:\llfloor
124009=124009==/l90001/l\rbag=/l224009/l=ins:\rbag
124010=124010==/l90001/l\rrfloor=/l224010/l=ins:\rrfloor

// 124500 - Variable-sized stmaryrd Delimiters
124501=124501==/l90001/l\llbracket=/l224501/l=ins:\llbracket
124502=124502==/l90001/l\rrbracket=/l224502/l=ins:\rrbracket

// 125000 - textcomp Text-Mode Delimiters
125001=125001==/l90001/l\textlangle=/l225001/l=ins:\textlangle
125002=125002==/l90001/l\textlbrackdbl=/l225002/l=ins:\textlbrackdbl
125003=125003==/l90001/l\textlquill=/l225003/l=ins:\textlquill
125004=125004==/l90001/l\textrangle=/l225004/l=ins:\textrangle
125005=125005==/l90001/l\textrbrackdbl=/l225005/l=ins:\textrbrackdbl
125006=125006==/l90001/l\textrquill=/l225006/l=ins:\textrquill

// 125500 - Math-Mode Accents
125501=125501==/l90001/l\acute{a}=/l225501/l=ins:\acute{a}
125502=125502==/l90001/l\bar{a}=/l225502/l=ins:\bar{a}
125503=125503==/l90001/l\breve{a}=/l225503/l=ins:\breve{a}
125504=125504==/l90001/l\check{a}=/l225504/l=ins:\check{a}
125505=125505==/l90001/l\ddot{a}=/l225505/l=ins:\ddot{a}
125506=125506==/l90001/l\dot{a}=/l225506/l=ins:\dot{a}
125507=125507==/l90001/l\grave{a}=/l225507/l=ins:\grave{a}
125508=125508==/l90001/l\hat{a}=/l225508/l=ins:\hat{a}
125509=125509==/l90001/l\tilde{a}=/l225509/l=ins:\tilde{a}
125510=125510==/l90001/l\vec{a}=/l225510/l=ins:\vec{a}

// 126000 - Some Other Constructions
126001=126001==/l90001/l\widetilde{abc}=/l226001/l=ins:\widetilde{abc}
126002=126002==/l90001/l\overleftarrow{abc}=/l226002/l=ins:\overleftarrow{abc}
126003=126003==/l90001/l\overline{abc}=/l226003/l=ins:\overline{abc}
126004=126004==/l90001/l\overbrace{abc}=/l226004/l=ins:\overbrace{abc}
126005=126005==/l90001/l\sqrt{abc}=/l226005/l=ins:\sqrt{abc}
126006=126006==/l90001/lf=/l226006/l=ins:f
126007=126007==/l90001/l\widehat{abc}=/l226007/l=ins:\widehat{abc}
126008=126008==/l90001/l\overrightarrow{abc}=/l226008/l=ins:\overrightarrow{abc}
126009=126009==/l90001/l\underline{abc}=/l226009/l=ins:\underline{abc}
126010=126010==/l90001/l\underbrace{abc}=/l226010/l=ins:\underbrace{abc}
126011=126011==/l90001/l\sqrt[n]{abc}=/l226011/l=ins:\sqrt[n]{abc}
126012=126012==/l90001/l\frac{abc}{xyz}=/l226012/l=ins:\frac{abc}{xyz}

// 126500 - AMS Extensible Arrow Accents
126501=126501==/l90001/l\overleftarrow{a}=/l226501/l=ins:\overleftarrow{a}
126502=126502==/l90001/l\underleftarrow{a}=/l226502/l=ins:\underleftarrow{a}
126503=126503==/l90001/l\overrightarrow{a}=/l226503/l=ins:\overrightarrow{a}
126504=126504==/l90001/l\underrightarrow{a}=/l226504/l=ins:\underrightarrow{a}
126505=126505==/l90001/l\overleftrightarrow{a}=/l226505/l=ins:\overleftrightarrow{a}
126506=126506==/l90001/l\underleftrightarrow{a}=/l226506/l=ins:\underleftrightarrow{a}

// 127000 - Punctuation Symbols (Math Mode)
127001=127001==/l90001/l,=/l227001/l=ins:,
127002=127002==/l90001/l;=/l227002/l=ins:;
127003=127003==/l90001/l\colon=/l227003/l=ins:\colon
127004=127004==/l90001/l\ldotp=/l227004/l=ins:\ldotp
127005=127005==/l90001/l\cdotp=/l227005/l=ins:\cdotp

// 127500 - Miscellaneous LaTeX2e Symbols
127501=127501==/l90001/l\aleph=/l227501/l=ins:\aleph
127502=127502==/l90001/l\angle=/l227502/l=ins:\angle
127503=127503==/l90001/l\backslash=/l227503/l=ins:\backslash
127504=127504==/l90001/l\bot=/l227504/l=ins:\bot
127505=127505==/l90001/l\Box=/l227505/l=ins:\Box
127506=127506==/l90001/l\cdots=/l227506/l=ins:\cdots
127507=127507==/l90001/l\clubsuit=/l227507/l=ins:\clubsuit
127508=127508==/l90001/l\ddots=/l227508/l=ins:\ddots
127509=127509==/l90001/l\Diamond=/l227509/l=ins:\Diamond
127510=127510==/l90001/l\diamondsuit=/l227510/l=ins:\diamondsuit
127511=127511==/l90001/l\ell=/l227511/l=ins:\ell
127512=127512==/l90001/l\emptyset=/l227512/l=ins:\emptyset
127513=127513==/l90001/l\exists=/l227513/l=ins:\exists
127514=127514==/l90001/l\flat=/l227514/l=ins:\flat
127515=127515==/l90001/l\forall=/l227515/l=ins:\forall
127516=127516==/l90001/l\hbar=/l227516/l=ins:\hbar
127517=127517==/l90001/l\heartsuit=/l227517/l=ins:\heartsuit
127518=127518==/l90001/l\Im=/l227518/l=ins:\Im
127519=127519==/l90001/l\imath=/l227519/l=ins:\imath
127520=127520==/l90001/l\infty=/l227520/l=ins:\infty
127521=127521==/l90001/l\jmath=/l227521/l=ins:\jmath
127522=127522==/l90001/l\ldots=/l227522/l=ins:\ldots
127523=127523==/l90001/l\mho=/l227523/l=ins:\mho
127524=127524==/l90001/l\nabla=/l227524/l=ins:\nabla
127525=127525==/l90001/l\natural=/l227525/l=ins:\natural
127526=127526==/l90001/l\neg=/l227526/l=ins:\neg
127527=127527==/l90001/l\partial=/l227527/l=ins:\partial
127528=127528==/l90001/l\prime=/l227528/l=ins:\prime
127529=127529==/l90001/l\Re=/l227529/l=ins:\Re
127530=127530==/l90001/l\sharp=/l227530/l=ins:\sharp
127531=127531==/l90001/l\spadesuit=/l227531/l=ins:\spadesuit
127532=127532==/l90001/l\surd=/l227532/l=ins:\surd
127533=127533==/l90001/l\top=/l227533/l=ins:\top
127534=127534==/l90001/l\triangle=/l227534/l=ins:\triangle
127535=127535==/l90001/l\vdots=/l227535/l=ins:\vdots
127536=127536==/l90001/l\wp=/l227536/l=ins:\wp

// 128000 - Miscellaneous AMS Symbols
128001=128001==/l90001/l\angle=/l228001/l=ins:\angle
128002=128002==/l90001/l\backprime=/l228002/l=ins:\backprime
128003=128003==/l90001/l\Bbbk=/l228003/l=ins:\Bbbk
128004=128004==/l90001/l\bigstar=/l228004/l=ins:\bigstar
128005=128005==/l90001/l\blacklozenge=/l228005/l=ins:\blacklozenge
128006=128006==/l90001/l\blacksquare=/l228006/l=ins:\blacksquare
128007=128007==/l90001/l\blacktriangle=/l228007/l=ins:\blacktriangle
128008=128008==/l90001/l\blacktriangledown=/l228008/l=ins:\blacktriangledown
128009=128009==/l90001/l\circledS=/l228009/l=ins:\circledS
128010=128010==/l90001/l\complement=/l228010/l=ins:\complement
128011=128011==/l90001/l\diagdown=/l228011/l=ins:\diagdown
128012=128012==/l90001/l\diagup=/l228012/l=ins:\diagup
128013=128013==/l90001/l\eth=/l228013/l=ins:\eth
128014=128014==/l90001/l\Finv=/l228014/l=ins:\Finv
128015=128015==/l90001/l\Game=/l228015/l=ins:\Game
128016=128016==/l90001/l\hbar=/l228016/l=ins:\hbar
128017=128017==/l90001/l\hslash=/l228017/l=ins:\hslash
128018=128018==/l90001/l\lozenge=/l228018/l=ins:\lozenge
128019=128019==/l90001/l\measuredangle=/l228019/l=ins:\measuredangle
128020=128020==/l90001/l\mho=/l228020/l=ins:\mho
128021=128021==/l90001/l\nexists=/l228021/l=ins:\nexists
128022=128022==/l90001/l\sphericalangle=/l228022/l=ins:\sphericalangle
128023=128023==/l90001/l\square=/l228023/l=ins:\square
128024=128024==/l90001/l\triangledown=/l228024/l=ins:\triangledown
128025=128025==/l90001/l\varnothing=/l228025/l=ins:\varnothing
128026=128026==/l90001/l\vartriangle=/l228026/l=ins:\vartriangle

// 128500 - AMS Commands Defined to Work in Both Math and Text Mode
128501=128501==/l90001/l\checkmark=/l228501/l=ins:\checkmark
128502=128502==/l90001/l\circledR=/l228502/l=ins:\circledR
128503=128503==/l90001/l\maltese=/l228503/l=ins:\maltese

// 129000 - stmaryrd Extensiton Characters
129001=129001==/l90001/l\Arrownot=/l229001/l=ins:\Arrownot
129002=129002==/l90001/l\arrownot=/l229002/l=ins:\arrownot
129003=129003==/l90001/l\Mapsfromchar=/l229003/l=ins:\Mapsfromchar
129004=129004==/l90001/l\mapsfromchar=/l229004/l=ins:\mapsfromchar
129005=129005==/l90001/l\Mapstochar=/l229005/l=ins:\Mapstochar

// 129500 - Other wasysym Math-Mode Symbols
129501=129501==/l90001/l\apprge=/l229501/l=ins:\apprge
129502=129502==/l90001/l\apprle=/l229502/l=ins:\apprle
129503=129503==/l90001/l\Box=/l229503/l=ins:\Box
129504=129504==/l90001/l\Diamond=/l229504/l=ins:\Diamond
129505=129505==/l90001/l\invneg=/l229505/l=ins:\invneg
129506=129506==/l90001/l\Join=/l229506/l=ins:\Join
129507=129507==/l90001/l\leadsto=/l229507/l=ins:\leadsto
129508=129508==/l90001/l\lhd=/l229508/l=ins:\lhd
129509=129509==/l90001/l\LHD=/l229509/l=ins:\LHD
129510=129510==/l90001/l\logof=/l229510/l=ins:\logof
129511=129511==/l90001/l\mho=/l229511/l=ins:\mho
129512=129512==/l90001/l\ocircle=/l229512/l=ins:\ocircle
129513=129513==/l90001/l\rhd=/l229513/l=ins:\rhd
129514=129514==/l90001/l\RHD=/l229514/l=ins:\RHD
129515=129515==/l90001/l\sqsubset=/l229515/l=ins:\sqsubset
129516=129516==/l90001/l\sqsupset=/l229516/l=ins:\sqsupset
129517=129517==/l90001/l\unlhd=/l229517/l=ins:\unlhd
129518=129518==/l90001/l\unrhd=/l229518/l=ins:\unrhd
129519=129519==/l90001/l\wasypropto=/l229519/l=ins:\wasypropto

// 130000 - Miscellaneous txfonts/pxfonts Symbols
130001=130001==/l90001/l\Diamondblack=/l230001/l=ins:\Diamondblack
130002=130002==/l90001/l\Diamonddot=/l230002/l=ins:\Diamonddot
130003=130003==/l90001/l\lambdabar=/l230003/l=ins:\lambdabar
130004=130004==/l90001/l\lambdaslash=/l230004/l=ins:\lambdaslash
130005=130005==/l90001/l\mathcent=/l230005/l=ins:\mathcent
130006=130006==/l90001/l\mathsterling=/l230006/l=ins:\mathsterling
130007=130007==/l90001/l\varclubsuit=/l230007/l=ins:\varclubsuit
130008=130008==/l90001/l\vardiamondsuit=/l230008/l=ins:\vardiamondsuit
130009=130009==/l90001/l\varheartsuit=/l230009/l=ins:\varheartsuit
130010=130010==/l90001/l\varspadesuit=/l230010/l=ins:\varspadesuit

// 130500 - textcomp Text-Mode Math and Science Symbols
130501=130501==/l90001/l\textcelsius=/l230501/l=ins:\textcelsius
130502=130502==/l90001/l\textdegree=/l230502/l=ins:\textdegree
130503=130503==/l90001/l\textdiv=/l230503/l=ins:\textdiv
130504=130504==/l90001/l\textdownarrow=/l230504/l=ins:\textdownarrow
130505=130505==/l90001/l\textfractionsolidus=/l230505/l=ins:\textfractionsolidus
130506=130506==/l90001/l\textleftarrow=/l230506/l=ins:\textleftarrow
130507=130507==/l90001/l\textlnot=/l230507/l=ins:\textlnot
130508=130508==/l90001/l\textmho=/l230508/l=ins:\textmho
130509=130509==/l90001/l\textminus=/l230509/l=ins:\textminus
130510=130510==/l90001/l\textmu=/l230510/l=ins:\textmu
130511=130511==/l90001/l\textohm=/l230511/l=ins:\textohm
130512=130512==/l90001/l\textonehalf=/l230512/l=ins:\textonehalf
130513=130513==/l90001/l\textonequarter=/l230513/l=ins:\textonequarter
130514=130514==/l90001/l\textonesuperior=/l230514/l=ins:\textonesuperior
130515=130515==/l90001/l\textpm=/l230515/l=ins:\textpm
130516=130516==/l90001/l\textrightarrow=/l230516/l=ins:\textrightarrow
130517=130517==/l90001/l\textsurd=/l230517/l=ins:\textsurd
130518=130518==/l90001/l\textthreequarters=/l230518/l=ins:\textthreequarters
130519=130519==/l90001/l\textthreesuperior=/l230519/l=ins:\textthreesuperior
130520=130520==/l90001/l\texttimes=/l230520/l=ins:\texttimes
130521=130521==/l90001/l\texttwosuperior=/l230521/l=ins:\texttwosuperior
130522=130522==/l90001/l\textuparrow=/l230522/l=ins:\textuparrow

// 131000 - marvosym Math Symbols
131001=131001==/l90001/l\MVZero=/l231001/l=ins:\MVZero
131002=131002==/l90001/l\MVOne=/l231002/l=ins:\MVOne
131003=131003==/l90001/l\MVTwo=/l231003/l=ins:\MVTwo
131004=131004==/l90001/l\MVThree=/l231004/l=ins:\MVThree
131005=131005==/l90001/l\MVFour=/l231005/l=ins:\MVFour
131006=131006==/l90001/l\MVFive=/l231006/l=ins:\MVFive
131007=131007==/l90001/l\MVSix=/l231007/l=ins:\MVSix
131008=131008==/l90001/l\MVSeven=/l231008/l=ins:\MVSeven
131009=131009==/l90001/l\MVEight=/l231009/l=ins:\MVEight
131010=131010==/l90001/l\MVNine=/l231010/l=ins:\MVNine
131011=131011==/l90001/l\Anglesign=/l231011/l=ins:\Anglesign
131012=131012==/l90001/l\Corresponds=/l231012/l=ins:\Corresponds
131013=131013==/l90001/l\Squaredot=/l231013/l=ins:\Squaredot
131014=131014==/l90001/l\Vectorarrow=/l231014/l=ins:\Vectorarrow
131015=131015==/l90001/l\Vectorarrowhigh=/l231015/l=ins:\Vectorarrowhigh

// 131500 - ar Aspect Ratio Symbol
131501=131501==/l90001/l\AR=/l231501/l=ins:\AR

// 132000 - ulsy Contradiction and Other Symbols
132001=132001==/l90001/l\blitza=/l232001/l=ins:\blitza
132002=132002==/l90001/l\blitzb=/l232002/l=ins:\blitzb
132003=132003==/l90001/l\blitzc=/l232003/l=ins:\blitzc
132004=132004==/l90001/l\blitzd=/l232004/l=ins:\blitzd
132005=132005==/l90001/l\blitze=/l232005/l=ins:\blitze
132006=132006==/l90001/l\odplus=/l232006/l=ins:\odplus

// 132500 - Math Alphabets
132501=132501==/l90001/l\mathrm{}=/l232501/l=ins:\mathrm{}
132502=132502==/l90001/l\mathit{}=/l232502/l=ins:\mathit{}
132503=132503==/l90001/l\mathnormal{}=/l232503/l=ins:\mathnormal{}
132504=132504==/l90001/l\mathcal{}=/l232504/l=ins:\mathcal{}
132505=132505==/l90001/l\mathscr{}=/l232505/l=ins:\mathscr{}
132506=132506==/l90001/l\mathcal{}=/l232506/l=ins:\mathcal{}
132507=132507==/l90001/l\mathpzc{}=/l232507/l=ins:\mathpzc{}
132508=132508==/l90001/l\mathbb{}=/l232508/l=ins:\mathbb{}
132509=132509==/l90001/l\varmathbb{}=/l232509/l=ins:\varmathbb{}
132510=132510==/l90001/l\mathbb{}=/l232510/l=ins:\mathbb{}
132511=132511==/l90001/l\mathbbm{}=/l232511/l=ins:\mathbbm{}
132512=132512==/l90001/l\mathbbmss{}=/l232512/l=ins:\mathbbmss{}
132513=132513==/l90001/l\mathbbmtt{}=/l232513/l=ins:\mathbbmtt{}
132514=132514==/l90001/l\mathds{}=/l232514/l=ins:\mathds{}
132515=132515==/l90001/l\mathds{}=/l232515/l=ins:\mathds{}
132516=132516==/l90001/l\mathfrak{}=/l232516/l=ins:\mathfrak{}
132517=132517==/l90001/l\textfrak{}=/l232517/l=ins:\textfrak{}
132518=132518==/l90001/l\textswab{}=/l232518/l=ins:\textswab{}

// 133000 - wasysym Electrical and Physical Symbols
133001=133001==/l90001/l\AC=/l233001/l=ins:\AC
133002=133002==/l90001/l\VHF=/l233002/l=ins:\VHF
133003=133003==/l90001/l\photon=/l233003/l=ins:\photon
133004=133004==/l90001/l\HF=/l233004/l=ins:\HF
133005=133005==/l90001/l\gluon=/l233005/l=ins:\gluon

// 133500 - ifsym Pulse Diagram Symbols
133501=133501==/l90001/l\FallingEdge=/l233501/l=ins:\FallingEdge
133502=133502==/l90001/l\LongPulseHigh=/l233502/l=ins:\LongPulseHigh
133503=133503==/l90001/l\LongPulseLow=/l233503/l=ins:\LongPulseLow
133504=133504==/l90001/l\PulseHigh=/l233504/l=ins:\PulseHigh
133505=133505==/l90001/l\PulseLow=/l233505/l=ins:\PulseLow
133506=133506==/l90001/l\RaisingEdge=/l233506/l=ins:\RaisingEdge
133507=133507==/l90001/l\ShortPulseHigh=/l233507/l=ins:\ShortPulseHigh
133508=133508==/l90001/l\ShortPulseLow=/l233508/l=ins:\ShortPulseLow

// 134000 - wasysym Astronomical Symbols
134001=134001==/l90001/l\ascnode=/l234001/l=ins:\ascnode
134002=134002==/l90001/l\astrosun=/l234002/l=ins:\astrosun
134003=134003==/l90001/l\descnode=/l234003/l=ins:\descnode
134004=134004==/l90001/l\earth=/l234004/l=ins:\earth
134005=134005==/l90001/l\fullmoon=/l234005/l=ins:\fullmoon
134006=134006==/l90001/l\jupiter=/l234006/l=ins:\jupiter
134007=134007==/l90001/l\leftmoon=/l234007/l=ins:\leftmoon
134008=134008==/l90001/l\mars=/l234008/l=ins:\mars
134009=134009==/l90001/l\mercury=/l234009/l=ins:\mercury
134010=134010==/l90001/l\neptune=/l234010/l=ins:\neptune
134011=134011==/l90001/l\newmoon=/l234011/l=ins:\newmoon
134012=134012==/l90001/l\pluto=/l234012/l=ins:\pluto
134013=134013==/l90001/l\rightmoon=/l234013/l=ins:\rightmoon
134014=134014==/l90001/l\saturn=/l234014/l=ins:\saturn
134015=134015==/l90001/l\uranus=/l234015/l=ins:\uranus
134016=134016==/l90001/l\venus=/l234016/l=ins:\venus
134017=134017==/l90001/l\vernal=/l234017/l=ins:\vernal

// 134500 - marvosym Astronomical Symbols
134501=134501==/l90001/l\Mercury=/l234501/l=ins:\Mercury
134502=134502==/l90001/l\Venus=/l234502/l=ins:\Venus
134503=134503==/l90001/l\Earth=/l234503/l=ins:\Earth
134504=134504==/l90001/l\Mars=/l234504/l=ins:\Mars
134505=134505==/l90001/l\Jupiter=/l234505/l=ins:\Jupiter
134506=134506==/l90001/l\Saturn=/l234506/l=ins:\Saturn
134507=134507==/l90001/l\Uranus=/l234507/l=ins:\Uranus
134508=134508==/l90001/l\Neptune=/l234508/l=ins:\Neptune
134509=134509==/l90001/l\Pluto=/l234509/l=ins:\Pluto
134510=134510==/l90001/l\Sun=/l234510/l=ins:\Sun
134511=134511==/l90001/l\Moon=/l234511/l=ins:\Moon

// 135000 - wasysym Astrological Symbols
135001=135001==/l90001/l\aries=/l235001/l=ins:\aries
135002=135002==/l90001/l\taurus=/l235002/l=ins:\taurus
135003=135003==/l90001/l\gemini=/l235003/l=ins:\gemini
135004=135004==/l90001/l\cancer=/l235004/l=ins:\cancer
135005=135005==/l90001/l\leo=/l235005/l=ins:\leo
135006=135006==/l90001/l\virgo=/l235006/l=ins:\virgo
135007=135007==/l90001/l\libra=/l235007/l=ins:\libra
135008=135008==/l90001/l\scorpio=/l235008/l=ins:\scorpio
135009=135009==/l90001/l\sagittarius=/l235009/l=ins:\sagittarius
135010=135010==/l90001/l\capricornus=/l235010/l=ins:\capricornus
135011=135011==/l90001/l\aquarius=/l235011/l=ins:\aquarius
135012=135012==/l90001/l\pisces=/l235012/l=ins:\pisces
135013=135013==/l90001/l\conjunction=/l235013/l=ins:\conjunction
135014=135014==/l90001/l\opposition=/l235014/l=ins:\opposition

// 135500 - marvosym Astrological Symbols
135501=135501==/l90001/l\Aries=/l235501/l=ins:\Aries
135502=135502==/l90001/l\Taurus=/l235502/l=ins:\Taurus
135503=135503==/l90001/l\Gemini=/l235503/l=ins:\Gemini
135504=135504==/l90001/l\Cancer=/l235504/l=ins:\Cancer
135505=135505==/l90001/l\Leo=/l235505/l=ins:\Leo
135506=135506==/l90001/l\Virgo=/l235506/l=ins:\Virgo
135507=135507==/l90001/l\Libra=/l235507/l=ins:\Libra
135508=135508==/l90001/l\Scorpio=/l235508/l=ins:\Scorpio
135509=135509==/l90001/l\Sagittarius=/l235509/l=ins:\Sagittarius
135510=135510==/l90001/l\Capricorn=/l235510/l=ins:\Capricorn
135511=135511==/l90001/l\Aquarius=/l235511/l=ins:\Aquarius
135512=135512==/l90001/l\Pisces=/l235512/l=ins:\Pisces

// 136000 - wasysym APL Symbols
136001=136001==/l90001/l\APLbox=/l236001/l=ins:\APLbox
136002=136002==/l90001/l\APLcomment=/l236002/l=ins:\APLcomment
136003=136003==/l90001/l\APLdown=/l236003/l=ins:\APLdown
136004=136004==/l90001/l\APLdownarrowbox=/l236004/l=ins:\APLdownarrowbox
136005=136005==/l90001/l\APLinput=/l236005/l=ins:\APLinput
136006=136006==/l90001/l\APLinv=/l236006/l=ins:\APLinv
136007=136007==/l90001/l\APLleftarrowbox=/l236007/l=ins:\APLleftarrowbox
136008=136008==/l90001/l\APLlog=/l236008/l=ins:\APLlog
136009=136009==/l90001/l\APLminus=/l236009/l=ins:\APLminus
136010=136010==/l90001/l\APLrightarrowbox=/l236010/l=ins:\APLrightarrowbox
136011=136011==/l90001/l\APLstar=/l236011/l=ins:\APLstar
136012=136012==/l90001/l\APLup=/l236012/l=ins:\APLup
136013=136013==/l90001/l\APLuparrowbox=/l236013/l=ins:\APLuparrowbox
136014=136014==/l90001/l\notbackslash=/l236014/l=ins:\notbackslash
136015=136015==/l90001/l\notslash=/l236015/l=ins:\notslash

// 136500 - wasysym APL Modifiers
136501=136501==/l90001/l\APLcirc{}=/l236501/l=ins:\APLcirc{}
136502=136502==/l90001/l\APLnot{}=/l236502/l=ins:\APLnot{}
136503=136503==/l90001/l\APLvert{}=/l236503/l=ins:\APLvert{}

// 137000 - marvosym Computer Hardware Symbols
137001=137001==/l90001/l\ComputerMouse=/l237001/l=ins:\ComputerMouse
137002=137002==/l90001/l\Keyboard=/l237002/l=ins:\Keyboard
137003=137003==/l90001/l\ParallelPort=/l237003/l=ins:\ParallelPort
137004=137004==/l90001/l\Printer=/l237004/l=ins:\Printer
137005=137005==/l90001/l\SerialInterface=/l237005/l=ins:\SerialInterface
137006=137006==/l90001/l\SerialPort=/l237006/l=ins:\SerialPort

// 137500 - ASCII COntrol Characters (IBM)
137501=137501==/l90001/l\SOH=/l237501/l=ins:\SOH
137502=137502==/l90001/l\STX=/l237502/l=ins:\STX
137503=137503==/l90001/l\ETX=/l237503/l=ins:\ETX
137504=137504==/l90001/l\EOT=/l237504/l=ins:\EOT
137505=137505==/l90001/l\ENQ=/l237505/l=ins:\ENQ
137506=137506==/l90001/l\ACK=/l237506/l=ins:\ACK
137507=137507==/l90001/l\BEL=/l237507/l=ins:\BEL
137508=137508==/l90001/l\BS=/l237508/l=ins:\BS
137509=137509==/l90001/l\HT=/l237509/l=ins:\HT
137510=137510==/l90001/l\LF=/l237510/l=ins:\LF
137511=137511==/l90001/l\VT=/l237511/l=ins:\VT
137512=137512==/l90001/l\FF=/l237512/l=ins:\FF
137513=137513==/l90001/l\CR=/l237513/l=ins:\CR
137514=137514==/l90001/l\SO=/l237514/l=ins:\SO
137515=137515==/l90001/l\SI=/l237515/l=ins:\SI
137516=137516==/l90001/l\DLE=/l237516/l=ins:\DLE
137517=137517==/l90001/l\DCa=/l237517/l=ins:\DCa
137518=137518==/l90001/l\DCb=/l237518/l=ins:\DCb
137519=137519==/l90001/l\DCc=/l237519/l=ins:\DCc
137520=137520==/l90001/l\DCd=/l237520/l=ins:\DCd
137521=137521==/l90001/l\NAK=/l237521/l=ins:\NAK
137522=137522==/l90001/l\SYN=/l237522/l=ins:\SYN
137523=137523==/l90001/l\ETB=/l237523/l=ins:\ETB
137524=137524==/l90001/l\CAN=/l237524/l=ins:\CAN
137525=137525==/l90001/l\EM=/l237525/l=ins:\EM
137526=137526==/l90001/l\SUB=/l237526/l=ins:\SUB
137527=137527==/l90001/l\ESC=/l237527/l=ins:\ESC
137528=137528==/l90001/l\FS=/l237528/l=ins:\FS
137529=137529==/l90001/l\GS=/l237529/l=ins:\GS
137530=137530==/l90001/l\RS=/l237530/l=ins:\RS
137531=137531==/l90001/l\US=/l237531/l=ins:\US
137532=137532==/l90001/l\splitvert=/l237532/l=ins:\splitvert
137533=137533==/l90001/l\DEL=/l237533/l=ins:\DEL

// 138000 - marvosym Communication Symbols
138001=138001==/l90001/l\Email=/l238001/l=ins:\Email
138002=138002==/l90001/l\Emailct=/l238002/l=ins:\Emailct
138003=138003==/l90001/l\fax=/l238003/l=ins:\fax
138004=138004==/l90001/l\FAX=/l238004/l=ins:\FAX
138005=138005==/l90001/l\Faxmachine=/l238005/l=ins:\Faxmachine
138006=138006==/l90001/l\Letter=/l238006/l=ins:\Letter
138007=138007==/l90001/l\Lightning=/l238007/l=ins:\Lightning
138008=138008==/l90001/l\Mobilefone=/l238008/l=ins:\Mobilefone
138009=138009==/l90001/l\Pickup=/l238009/l=ins:\Pickup
138010=138010==/l90001/l\Telefon=/l238010/l=ins:\Telefon

// 138500 - marvosym Engineering Symbols
138501=138501==/l90001/l\Beam=/l238501/l=ins:\Beam
138502=138502==/l90001/l\Bearing=/l238502/l=ins:\Bearing
138503=138503==/l90001/l\Circpipe=/l238503/l=ins:\Circpipe
138504=138504==/l90001/l\Circsteel=/l238504/l=ins:\Circsteel
138505=138505==/l90001/l\Fixedbearing=/l238505/l=ins:\Fixedbearing
138506=138506==/l90001/l\Flatsteel=/l238506/l=ins:\Flatsteel
138507=138507==/l90001/l\Force=/l238507/l=ins:\Force
138508=138508==/l90001/l\Hexasteel=/l238508/l=ins:\Hexasteel
138509=138509==/l90001/l\Lefttorque=/l238509/l=ins:\Lefttorque
138510=138510==/l90001/l\Lineload=/l238510/l=ins:\Lineload
138511=138511==/l90001/l\Loosebearing=/l238511/l=ins:\Loosebearing
138512=138512==/l90001/l\Lsteel=/l238512/l=ins:\Lsteel
138513=138513==/l90001/l\Octosteel=/l238513/l=ins:\Octosteel
138514=138514==/l90001/l\Rectpipe=/l238514/l=ins:\Rectpipe
138515=138515==/l90001/l\Rectsteel=/l238515/l=ins:\Rectsteel
138516=138516==/l90001/l\Righttorque=/l238516/l=ins:\Righttorque
138517=138517==/l90001/l\RoundedLsteel=/l238517/l=ins:\RoundedLsteel
138518=138518==/l90001/l\RoundedTsteel=/l238518/l=ins:\RoundedTsteel
138519=138519==/l90001/l\RoundedTTsteel=/l238519/l=ins:\RoundedTTsteel
138520=138520==/l90001/l\Squarepipe=/l238520/l=ins:\Squarepipe
138521=138521==/l90001/l\Squaresteel=/l238521/l=ins:\Squaresteel
138522=138522==/l90001/l\Tsteel=/l238522/l=ins:\Tsteel
138523=138523==/l90001/l\TTsteel=/l238523/l=ins:\TTsteel

// 139000 - marvosym Biological Symbols
139001=139001==/l90001/l\Female=/l239001/l=ins:\Female
139002=139002==/l90001/l\FEMALE=/l239002/l=ins:\FEMALE
139003=139003==/l90001/l\FemaleFemale=/l239003/l=ins:\FemaleFemale
139004=139004==/l90001/l\FemaleMale=/l239004/l=ins:\FemaleMale
139005=139005==/l90001/l\Hermaphrodite=/l239005/l=ins:\Hermaphrodite
139006=139006==/l90001/l\HERMAPHRODITE=/l239006/l=ins:\HERMAPHRODITE
139007=139007==/l90001/l\MALE=/l239007/l=ins:\MALE
139008=139008==/l90001/l\Male=/l239008/l=ins:\Male
139009=139009==/l90001/l\MaleMale=/l239009/l=ins:\MaleMale
139010=139010==/l90001/l\Neutral=/l239010/l=ins:\Neutral

// 139500 - marvosym Safety-Related Symbols
139501=139501==/l90001/l\Biohazard=/l239501/l=ins:\Biohazard
139502=139502==/l90001/l\BSEfree=/l239502/l=ins:\BSEfree
139503=139503==/l90001/l\CEsign=/l239503/l=ins:\CEsign
139504=139504==/l90001/l\Estatically=/l239504/l=ins:\Estatically
139505=139505==/l90001/l\Explosionsafe=/l239505/l=ins:\Explosionsafe
139506=139506==/l90001/l\Laserbeam=/l239506/l=ins:\Laserbeam
139507=139507==/l90001/l\Radioactivity=/l239507/l=ins:\Radioactivity
139508=139508==/l90001/l\Stopsign=/l239508/l=ins:\Stopsign

// 140000 - bbding Arrows
140001=140001==/l90001/l\ArrowBoldDownRight=/l240001/l=ins:\ArrowBoldDownRight
140002=140002==/l90001/l\ArrowBoldRightCircled=/l240002/l=ins:\ArrowBoldRightCircled
140003=140003==/l90001/l\ArrowBoldRightShort=/l240003/l=ins:\ArrowBoldRightShort
140004=140004==/l90001/l\ArrowBoldRightStrobe=/l240004/l=ins:\ArrowBoldRightStrobe
140005=140005==/l90001/l\ArrowBoldUpRight=/l240005/l=ins:\ArrowBoldUpRight

// 140500 - pifont Arrows
140501=140501==/l90001/l\ding{212}=/l240501/l=ins:\ding{212}
140502=140502==/l90001/l\ding{213}=/l240502/l=ins:\ding{213}
140503=140503==/l90001/l\ding{214}=/l240503/l=ins:\ding{214}
140504=140504==/l90001/l\ding{215}=/l240504/l=ins:\ding{215}
140505=140505==/l90001/l\ding{216}=/l240505/l=ins:\ding{216}
140506=140506==/l90001/l\ding{217}=/l240506/l=ins:\ding{217}
140507=140507==/l90001/l\ding{218}=/l240507/l=ins:\ding{218}
140508=140508==/l90001/l\ding{219}=/l240508/l=ins:\ding{219}
140509=140509==/l90001/l\ding{220}=/l240509/l=ins:\ding{220}
140510=140510==/l90001/l\ding{221}=/l240510/l=ins:\ding{221}
140511=140511==/l90001/l\ding{222}=/l240511/l=ins:\ding{222}
140512=140512==/l90001/l\ding{223}=/l240512/l=ins:\ding{223}
140513=140513==/l90001/l\ding{224}=/l240513/l=ins:\ding{224}
140514=140514==/l90001/l\ding{225}=/l240514/l=ins:\ding{225}
140515=140515==/l90001/l\ding{226}=/l240515/l=ins:\ding{226}
140516=140516==/l90001/l\ding{227}=/l240516/l=ins:\ding{227}
140517=140517==/l90001/l\ding{228}=/l240517/l=ins:\ding{228}
140518=140518==/l90001/l\ding{229}=/l240518/l=ins:\ding{229}
140519=140519==/l90001/l\ding{230}=/l240519/l=ins:\ding{230}
140520=140520==/l90001/l\ding{231}=/l240520/l=ins:\ding{231}
140521=140521==/l90001/l\ding{232}=/l240521/l=ins:\ding{232}
140522=140522==/l90001/l\ding{233}=/l240522/l=ins:\ding{233}
140523=140523==/l90001/l\ding{234}=/l240523/l=ins:\ding{234}
140524=140524==/l90001/l\ding{235}=/l240524/l=ins:\ding{235}
140525=140525==/l90001/l\ding{236}=/l240525/l=ins:\ding{236}
140526=140526==/l90001/l\ding{237}=/l240526/l=ins:\ding{237}
140527=140527==/l90001/l\ding{238}=/l240527/l=ins:\ding{238}
140528=140528==/l90001/l\ding{239}=/l240528/l=ins:\ding{239}
140529=140529==/l90001/l\ding{241}=/l240529/l=ins:\ding{241}
140530=140530==/l90001/l\ding{242}=/l240530/l=ins:\ding{242}
140531=140531==/l90001/l\ding{243}=/l240531/l=ins:\ding{243}
140532=140532==/l90001/l\ding{244}=/l240532/l=ins:\ding{244}
140533=140533==/l90001/l\ding{245}=/l240533/l=ins:\ding{245}
140534=140534==/l90001/l\ding{246}=/l240534/l=ins:\ding{246}
140535=140535==/l90001/l\ding{247}=/l240535/l=ins:\ding{247}
140536=140536==/l90001/l\ding{248}=/l240536/l=ins:\ding{248}
140537=140537==/l90001/l\ding{249}=/l240537/l=ins:\ding{249}
140538=140538==/l90001/l\ding{250}=/l240538/l=ins:\ding{250}
140539=140539==/l90001/l\ding{251}=/l240539/l=ins:\ding{251}
140540=140540==/l90001/l\ding{252}=/l240540/l=ins:\ding{252}
140541=140541==/l90001/l\ding{253}=/l240541/l=ins:\ding{253}
140542=140542==/l90001/l\ding{254}=/l240542/l=ins:\ding{254}

// 141000 - marvosym Scissors
141001=141001==/l90001/l\Cutleft=/l241001/l=ins:\Cutleft
141002=141002==/l90001/l\Cutline=/l241002/l=ins:\Cutline
141003=141003==/l90001/l\Cutright=/l241003/l=ins:\Cutright
141004=141004==/l90001/l\Kutline=/l241004/l=ins:\Kutline
141005=141005==/l90001/l\Leftscissors=/l241005/l=ins:\Leftscissors
141006=141006==/l90001/l\Rightscissors=/l241006/l=ins:\Rightscissors

// 141500 - bbding Scissors
141501=141501==/l90001/l\ScissorHollowLeft=/l241501/l=ins:\ScissorHollowLeft
141502=141502==/l90001/l\ScissorHollowRight=/l241502/l=ins:\ScissorHollowRight
141503=141503==/l90001/l\ScissorLeft=/l241503/l=ins:\ScissorLeft
141504=141504==/l90001/l\ScissorLeftBrokenBottom=/l241504/l=ins:\ScissorLeftBrokenBottom
141505=141505==/l90001/l\ScissorLeftBrokenTop=/l241505/l=ins:\ScissorLeftBrokenTop
141506=141506==/l90001/l\ScissorRight=/l241506/l=ins:\ScissorRight
141507=141507==/l90001/l\ScissorRightBrokenBottom=/l241507/l=ins:\ScissorRightBrokenBottom
141508=141508==/l90001/l\ScissorRightBrokenTop=/l241508/l=ins:\ScissorRightBrokenTop

// 142000 - pifont Scissors
142001=142001==/l90001/l\ding{33}=/l241501/l=ins:\ding{33}
142002=142002==/l90001/l\ding{34}=/l241502/l=ins:\ding{34}
142003=142003==/l90001/l\ding{35}=/l241503/l=ins:\ding{35}
142004=142004==/l90001/l\ding{36}=/l241504/l=ins:\ding{36}

// 142500 - dingbat Pencils
142501=142501==/l90001/l\largepencil=/l242501/l=ins:\largepencil
142502=142502==/l90001/l\smallpencil=/l242502/l=ins:\smallpencil

// 143000 - bbding Pencils and Nibs
143001=143001==/l90001/l\NibLeft=/l243001/l=ins:\NibLeft
143002=143002==/l90001/l\NibRight=/l243002/l=ins:\NibRight
143003=143003==/l90001/l\NibSolidLeft=/l243003/l=ins:\NibSolidLeft
143004=143004==/l90001/l\NibSolidRight=/l243004/l=ins:\NibSolidRight
143005=143005==/l90001/l\PencilLeft=/l243005/l=ins:\PencilLeft
143006=143006==/l90001/l\PencilLeftDown=/l243006/l=ins:\PencilLeftDown
143007=143007==/l90001/l\PencilLeftUp=/l243007/l=ins:\PencilLeftUp
143008=143008==/l90001/l\PencilRight=/l243008/l=ins:\PencilRight
143009=143009==/l90001/l\PencilRightDown=/l243009/l=ins:\PencilRightDown
143010=143010==/l90001/l\PencilRightUp=/l243010/l=ins:\PencilRightUp

// 143500 - pifont Pencils and Nibs
143501=143501==/l90001/l\ding{46}=/l243501/l=ins:\ding{46}
143502=143502==/l90001/l\ding{47}=/l243502/l=ins:\ding{47}
143503=143503==/l90001/l\ding{48}=/l243503/l=ins:\ding{48}
143504=143504==/l90001/l\ding{49}=/l243504/l=ins:\ding{49}
143505=143505==/l90001/l\ding{50}=/l243505/l=ins:\ding{50}

// 144000 - dingbat Hands
144001=144001==/l90001/l\leftpointright=/l244001/l=ins:\leftpointright
144002=144002==/l90001/l\leftthumbsdown=/l244002/l=ins:\leftthumbsdown
144003=144003==/l90001/l\leftthumbsup=/l244003/l=ins:\leftthumbsup
144004=144004==/l90001/l\rightpointleft=/l244004/l=ins:\rightpointleft
144005=144005==/l90001/l\rightthumbsdown=/l244005/l=ins:\rightthumbsdown
144006=144006==/l90001/l\rightthumbsup=/l244006/l=ins:\rightthumbsup
144007=144007==/l90001/l\rightpointright=/l244007/l=ins:\rightpointright

// 144500 - bbding Hands
144501=144501==/l90001/l\HandCuffLeft=/l244501/l=ins:\HandCuffLeft
144502=144502==/l90001/l\HandCuffLeftUp=/l244502/l=ins:\HandCuffLeftUp
144503=144503==/l90001/l\HandCuffRight=/l244503/l=ins:\HandCuffRight
144504=144504==/l90001/l\HandCuffRightUp=/l244504/l=ins:\HandCuffRightUp
144505=144505==/l90001/l\HandLeft=/l244505/l=ins:\HandLeft
144506=144506==/l90001/l\HandLeftUp=/l244506/l=ins:\HandLeftUp
144507=144507==/l90001/l\HandPencilLeft=/l244507/l=ins:\HandPencilLeft
144508=144508==/l90001/l\HandRight=/l244508/l=ins:\HandRight
144509=144509==/l90001/l\HandRightUp=/l244509/l=ins:\HandRightUp

// 145000 - pifont Hands
145001=145001==/l90001/l\ding{42}=/l245001/l=ins:\ding{42}
145002=145002==/l90001/l\ding{43}=/l245002/l=ins:\ding{43}
145003=145003==/l90001/l\ding{44}=/l245003/l=ins:\ding{44}
145004=145004==/l90001/l\ding{45}=/l245004/l=ins:\ding{45}

// 145500 - bbding Crosses and Plusses
145501=145501==/l90001/l\Cross=/l245501/l=ins:\Cross
145502=145502==/l90001/l\CrossBoldOutline=/l245502/l=ins:\CrossBoldOutline
145503=145503==/l90001/l\CrossClowerTips=/l245503/l=ins:\CrossClowerTips
145504=145504==/l90001/l\CrossMaltese=/l245504/l=ins:\CrossMaltese
145505=145505==/l90001/l\CrossOpenShadow=/l245505/l=ins:\CrossOpenShadow
145506=145506==/l90001/l\CrossOutline=/l245506/l=ins:\CrossOutline
145507=145507==/l90001/l\Plus=/l245507/l=ins:\Plus
145508=145508==/l90001/l\PlusCenterOpen=/l245508/l=ins:\PlusCenterOpen
145509=145509==/l90001/l\PlusOutline=/l245509/l=ins:\PlusOutline
145510=145510==/l90001/l\PlusThinCenterOpen=/l245510/l=ins:\PlusThinCenterOpen

// 146000 - pifont Crosses and Plusses
146001=146001==/l90001/l\ding{57}=/l246001/l=ins:\ding{57}
146002=146002==/l90001/l\ding{58}=/l246002/l=ins:\ding{58}
146003=146003==/l90001/l\ding{59}=/l246003/l=ins:\ding{59}
146004=146004==/l90001/l\ding{60}=/l246004/l=ins:\ding{60}
146005=146005==/l90001/l\ding{61}=/l246005/l=ins:\ding{61}
146006=146006==/l90001/l\ding{62}=/l246006/l=ins:\ding{62}
146007=146007==/l90001/l\ding{63}=/l246007/l=ins:\ding{63}
146008=146008==/l90001/l\ding{64}=/l246008/l=ins:\ding{64}

// 146500 - bbding Xs and Check Marks
146501=146501==/l90001/l\Checkmark=/l246501/l=ins:\Checkmark
146502=146502==/l90001/l\CheckmarkBold=/l246502/l=ins:\CheckmarkBold
146503=146503==/l90001/l\XSolid=/l246503/l=ins:\XSolid
146504=146504==/l90001/l\XSolidBold=/l246504/l=ins:\XSolidBold
146505=146505==/l90001/l\XSolidBrush=/l246505/l=ins:\XSolidBrush

// 147000 - pifont Xs and Check Marks
147001=147001==/l90001/l\ding{51}=/l247001/l=ins:\ding{51}
147002=147002==/l90001/l\ding{52}=/l247002/l=ins:\ding{52}
147003=147003==/l90001/l\ding{53}=/l247003/l=ins:\ding{53}
147004=147004==/l90001/l\ding{54}=/l247004/l=ins:\ding{54}
147005=147005==/l90001/l\ding{55}=/l247005/l=ins:\ding{55}
147006=147006==/l90001/l\ding{56}=/l247006/l=ins:\ding{56}

// 147500 - wasysym Xs and Check Marks
147501=147501==/l90001/l\CheckedBox=/l247501/l=ins:\CheckedBox
147502=147502==/l90001/l\Square=/l247502/l=ins:\Square
147503=147503==/l90001/l\XBox=/l247503/l=ins:\XBox

// 148000 - pifont Circled Numbers
148001=148001==/l90001/l\ding{172}=/l248001/l=ins:\ding{172}
148002=148002==/l90001/l\ding{173}=/l248002/l=ins:\ding{173}
148003=148003==/l90001/l\ding{174}=/l248003/l=ins:\ding{174}
148004=148004==/l90001/l\ding{175}=/l248004/l=ins:\ding{175}
148005=148005==/l90001/l\ding{176}=/l248005/l=ins:\ding{176}
148006=148006==/l90001/l\ding{177}=/l248006/l=ins:\ding{177}
148007=148007==/l90001/l\ding{178}=/l248007/l=ins:\ding{178}
148008=148008==/l90001/l\ding{179}=/l248008/l=ins:\ding{179}
148009=148009==/l90001/l\ding{180}=/l248009/l=ins:\ding{180}
148010=148010==/l90001/l\ding{181}=/l248010/l=ins:\ding{181}
148011=148011==/l90001/l\ding{182}=/l248011/l=ins:\ding{182}
148012=148012==/l90001/l\ding{183}=/l248012/l=ins:\ding{183}
148013=148013==/l90001/l\ding{184}=/l248013/l=ins:\ding{184}
148014=148014==/l90001/l\ding{185}=/l248014/l=ins:\ding{185}
148015=148015==/l90001/l\ding{186}=/l248015/l=ins:\ding{186}
148016=148016==/l90001/l\ding{187}=/l248016/l=ins:\ding{187}
148017=148017==/l90001/l\ding{188}=/l248017/l=ins:\ding{188}
148018=148018==/l90001/l\ding{189}=/l248018/l=ins:\ding{189}
148019=148019==/l90001/l\ding{190}=/l248019/l=ins:\ding{190}
148020=148020==/l90001/l\ding{191}=/l248020/l=ins:\ding{191}
148021=148021==/l90001/l\ding{192}=/l248021/l=ins:\ding{192}
148022=148022==/l90001/l\ding{193}=/l248022/l=ins:\ding{193}
148023=148023==/l90001/l\ding{194}=/l248023/l=ins:\ding{194}
148024=148024==/l90001/l\ding{195}=/l248024/l=ins:\ding{195}
148025=148025==/l90001/l\ding{196}=/l248025/l=ins:\ding{196}
148026=148026==/l90001/l\ding{197}=/l248026/l=ins:\ding{197}
148027=148027==/l90001/l\ding{198}=/l248027/l=ins:\ding{198}
148028=148028==/l90001/l\ding{199}=/l248028/l=ins:\ding{199}
148029=148029==/l90001/l\ding{200}=/l248029/l=ins:\ding{200}
148030=148030==/l90001/l\ding{201}=/l248030/l=ins:\ding{201}
148031=148031==/l90001/l\ding{202}=/l248031/l=ins:\ding{202}
148032=148032==/l90001/l\ding{203}=/l248032/l=ins:\ding{203}
148033=148033==/l90001/l\ding{204}=/l248033/l=ins:\ding{204}
148034=148034==/l90001/l\ding{205}=/l248034/l=ins:\ding{205}
148035=148035==/l90001/l\ding{206}=/l248035/l=ins:\ding{206}
148036=148036==/l90001/l\ding{207}=/l248036/l=ins:\ding{207}
148037=148037==/l90001/l\ding{208}=/l248037/l=ins:\ding{208}
148038=148038==/l90001/l\ding{209}=/l248038/l=ins:\ding{209}
148039=148039==/l90001/l\ding{210}=/l248039/l=ins:\ding{210}
148040=148040==/l90001/l\ding{211}=/l248040/l=ins:\ding{211}

// 148500 - wasysym Stars
148501=148501==/l90001/l\davidsstar=/l248501/l=ins:\davidsstar
148502=148502==/l90001/l\hexstar=/l248502/l=ins:\hexstar
148503=148503==/l90001/l\varhexstar=/l248503/l=ins:\varhexstar

// 149000 - bbding Stars, Flowers, and Similar Shapes
149001=149001==/l90001/l\Asterisk=/l249001/l=ins:\Asterisk
149002=149002==/l90001/l\AsteriskBold=/l249002/l=ins:\AsteriskBold
149003=149003==/l90001/l\AsteriskCenterOpen=/l249003/l=ins:\AsteriskCenterOpen
149004=149004==/l90001/l\AsteriskRoundedEnds=/l249004/l=ins:\AsteriskRoundedEnds
149005=149005==/l90001/l\AsteriskThin=/l249005/l=ins:\AsteriskThin
149006=149006==/l90001/l\AsteriskThinCenterOpen=/l249006/l=ins:\AsteriskThinCenterOpen
149007=149007==/l90001/l\DavidStar=/l249007/l=ins:\DavidStar
149008=149008==/l90001/l\DavidStarSolid=/l249008/l=ins:\DavidStarSolid
149009=149009==/l90001/l\EightAsterisk=/l249009/l=ins:\EightAsterisk
149010=149010==/l90001/l\EightFlowerPetal=/l249010/l=ins:\EightFlowerPetal
149011=149011==/l90001/l\EightFlowerPetalRemoved=/l249011/l=ins:\EightFlowerPetalRemoved
149012=149012==/l90001/l\EightStar=/l249012/l=ins:\EightStar
149013=149013==/l90001/l\EightStarBold=/l249013/l=ins:\EightStarBold
149014=149014==/l90001/l\EightStarConvex=/l249014/l=ins:\EightStarConvex
149015=149015==/l90001/l\EightStarTaper=/l249015/l=ins:\EightStarTaper
149016=149016==/l90001/l\FiveFlowerOpen=/l249016/l=ins:\FiveFlowerOpen
149017=149017==/l90001/l\FiveFlowerPetal=/l249017/l=ins:\FiveFlowerPetal
149018=149018==/l90001/l\FiveStar=/l249018/l=ins:\FiveStar
149019=149019==/l90001/l\FiveStarCenterOpen=/l249019/l=ins:\FiveStarCenterOpen
149020=149020==/l90001/l\FiveStarConvex=/l249020/l=ins:\FiveStarConvex
149021=149021==/l90001/l\FiveStarLines=/l249021/l=ins:\FiveStarLines
149022=149022==/l90001/l\FiveStarOpen=/l249022/l=ins:\FiveStarOpen
149023=149023==/l90001/l\FiveStarOpenCircled=/l249023/l=ins:\FiveStarOpenCircled
149024=149024==/l90001/l\FiveStarOpenDotted=/l249024/l=ins:\FiveStarOpenDotted
149025=149025==/l90001/l\FiveStarOutline=/l249025/l=ins:\FiveStarOutline
149026=149026==/l90001/l\FiveStarOutlineHeavy=/l249026/l=ins:\FiveStarOutlineHeavy
149027=149027==/l90001/l\FiveStarShadow=/l249027/l=ins:\FiveStarShadow
149028=149028==/l90001/l\FourAsterisk=/l249028/l=ins:\FourAsterisk
149029=149029==/l90001/l\FourClowerOpen=/l249029/l=ins:\FourClowerOpen
149030=149030==/l90001/l\FourClowerSolid=/l249030/l=ins:\FourClowerSolid
149031=149031==/l90001/l\FourStar=/l249031/l=ins:\FourStar
149032=149032==/l90001/l\FourStarOpen=/l249032/l=ins:\FourStarOpen
149033=149033==/l90001/l\JackStar=/l249033/l=ins:\JackStar
149034=149034==/l90001/l\JackStarBold=/l249034/l=ins:\JackStarBold
149035=149035==/l90001/l\SixFlowerAlternate=/l249035/l=ins:\SixFlowerAlternate
149036=149036==/l90001/l\SixFlowerAltPetal=/l249036/l=ins:\SixFlowerAltPetal
149037=149037==/l90001/l\SixFlowerOpenCenter=/l249037/l=ins:\SixFlowerOpenCenter
149038=149038==/l90001/l\SixFlowerPetalDotted=/l249038/l=ins:\SixFlowerPetalDotted
149039=149039==/l90001/l\SixFlowerPetalRemoved=/l249039/l=ins:\SixFlowerPetalRemoved
149040=149040==/l90001/l\SixFlowerRemovedOpenPetal=/l249040/l=ins:\SixFlowerRemovedOpenPetal
149041=149041==/l90001/l\SixStar=/l249041/l=ins:\SixStar
149042=149042==/l90001/l\SixteenStarLight=/l249042/l=ins:\SixteenStarLight
149043=149043==/l90001/l\Snowflake=/l249043/l=ins:\Snowflake
149044=149044==/l90001/l\SnowflakeChevron=/l249044/l=ins:\SnowflakeChevron
149045=149045==/l90001/l\SnowflakeChevronBold=/l249045/l=ins:\SnowflakeChevronBold
149046=149046==/l90001/l\Sparkle=/l249046/l=ins:\Sparkle
149047=149047==/l90001/l\SparkleBold=/l249047/l=ins:\SparkleBold
149048=149048==/l90001/l\TwelweStar=/l249048/l=ins:\TwelweStar

// 149500 - pifont Stars, Flowers, and Similar Shapes
149501=149501==/l90001/l\ding{65}=/l249501/l=ins:\ding{65}
149502=149502==/l90001/l\ding{66}=/l249502/l=ins:\ding{66}
149503=149503==/l90001/l\ding{67}=/l249503/l=ins:\ding{67}
149504=149504==/l90001/l\ding{68}=/l249504/l=ins:\ding{68}
149505=149505==/l90001/l\ding{69}=/l249505/l=ins:\ding{69}
149506=149506==/l90001/l\ding{70}=/l249506/l=ins:\ding{70}
149507=149507==/l90001/l\ding{71}=/l249507/l=ins:\ding{71}
149508=149508==/l90001/l\ding{72}=/l249508/l=ins:\ding{72}
149509=149509==/l90001/l\ding{73}=/l249509/l=ins:\ding{73}
149510=149510==/l90001/l\ding{74}=/l249510/l=ins:\ding{74}
149511=149511==/l90001/l\ding{75}=/l249511/l=ins:\ding{75}
149512=149512==/l90001/l\ding{76}=/l249512/l=ins:\ding{76}
149513=149513==/l90001/l\ding{77}=/l249513/l=ins:\ding{77}
149514=149514==/l90001/l\ding{78}=/l249514/l=ins:\ding{78}
149515=149515==/l90001/l\ding{79}=/l249515/l=ins:\ding{79}
149516=149516==/l90001/l\ding{80}=/l249516/l=ins:\ding{80}
149517=149517==/l90001/l\ding{81}=/l249517/l=ins:\ding{81}
149518=149518==/l90001/l\ding{82}=/l249518/l=ins:\ding{82}
149519=149519==/l90001/l\ding{83}=/l249519/l=ins:\ding{83}
149520=149520==/l90001/l\ding{84}=/l249520/l=ins:\ding{84}
149521=149521==/l90001/l\ding{85}=/l249521/l=ins:\ding{85}
149522=149522==/l90001/l\ding{86}=/l249522/l=ins:\ding{86}
149523=149523==/l90001/l\ding{87}=/l249523/l=ins:\ding{87}
149524=149524==/l90001/l\ding{88}=/l249524/l=ins:\ding{88}
149525=149525==/l90001/l\ding{89}=/l249525/l=ins:\ding{89}
149526=149526==/l90001/l\ding{90}=/l249526/l=ins:\ding{90}
149527=149527==/l90001/l\ding{91}=/l249527/l=ins:\ding{91}
149528=149528==/l90001/l\ding{92}=/l249528/l=ins:\ding{92}
149529=149529==/l90001/l\ding{93}=/l249529/l=ins:\ding{93}
149530=149530==/l90001/l\ding{94}=/l249530/l=ins:\ding{94}
149531=149531==/l90001/l\ding{95}=/l249531/l=ins:\ding{95}
149532=149532==/l90001/l\ding{96}=/l249532/l=ins:\ding{96}
149533=149533==/l90001/l\ding{97}=/l249533/l=ins:\ding{97}
149534=149534==/l90001/l\ding{98}=/l249534/l=ins:\ding{98}
149535=149535==/l90001/l\ding{99}=/l249535/l=ins:\ding{99}
149536=149536==/l90001/l\ding{100}=/l249536/l=ins:\ding{100}
149537=149537==/l90001/l\ding{101}=/l249537/l=ins:\ding{101}
149538=149538==/l90001/l\ding{102}=/l249538/l=ins:\ding{102}
149539=149539==/l90001/l\ding{103}=/l249539/l=ins:\ding{103}
149540=149540==/l90001/l\ding{104}=/l249540/l=ins:\ding{104}
149541=149541==/l90001/l\ding{105}=/l249541/l=ins:\ding{105}
149542=149542==/l90001/l\ding{106}=/l249542/l=ins:\ding{106}
149543=149543==/l90001/l\ding{107}=/l249543/l=ins:\ding{107}

// 150000 - wasysym Geometric Shapes
150001=150001==/l90001/l\hexagon=/l250001/l=ins:\hexagon
150002=150002==/l90001/l\octagon=/l250002/l=ins:\octagon
150003=150003==/l90001/l\pentagon=/l250003/l=ins:\pentagon
150004=150004==/l90001/l\varhexagon=/l250004/l=ins:\varhexagon

// 150500 - ifsym Geometric Shapes
150501=150501==/l90001/l\BigCircle=/l250501/l=ins:\BigCircle
150502=150502==/l90001/l\BigCross=/l250502/l=ins:\BigCross
150503=150503==/l90001/l\BigDiamondshape=/l250503/l=ins:\BigDiamondshape
150504=150504==/l90001/l\BigHBar=/l250504/l=ins:\BigHBar
150505=150505==/l90001/l\BigLowerDiamond=/l250505/l=ins:\BigLowerDiamond
150506=150506==/l90001/l\BigRightDiamond=/l250506/l=ins:\BigRightDiamond
150507=150507==/l90001/l\BigSquare=/l250507/l=ins:\BigSquare
150508=150508==/l90001/l\BigTriangleDown=/l250508/l=ins:\BigTriangleDown
150509=150509==/l90001/l\BigTriangleLeft=/l250509/l=ins:\BigTriangleLeft
150510=150510==/l90001/l\BigTriangleRight=/l250510/l=ins:\BigTriangleRight
150511=150511==/l90001/l\BigTriangleUp=/l250511/l=ins:\BigTriangleUp
150512=150512==/l90001/l\BigVBar=/l250512/l=ins:\BigVBar
150513=150513==/l90001/l\Circle=/l250513/l=ins:\Circle
150514=150514==/l90001/l\Cross=/l250514/l=ins:\Cross
150515=150515==/l90001/l\DiamondShadowA=/l250515/l=ins:\DiamondShadowA
150516=150516==/l90001/l\DiamondShadowB=/l250516/l=ins:\DiamondShadowB
150517=150517==/l90001/l\DiamondShadowC=/l250517/l=ins:\DiamondShadowC
150518=150518==/l90001/l\Diamondshape=/l250518/l=ins:\Diamondshape
150519=150519==/l90001/l\FilledBigCircle=/l250519/l=ins:\FilledBigCircle
150520=150520==/l90001/l\FilledBigDiamondshape=/l250520/l=ins:\FilledBigDiamondshape
150521=150521==/l90001/l\FilledBigSquare=/l250521/l=ins:\FilledBigSquare
150522=150522==/l90001/l\FilledBigTriangleDown=/l250522/l=ins:\FilledBigTriangleDown
150523=150523==/l90001/l\FilledBigTriangleLeft=/l250523/l=ins:\FilledBigTriangleLeft
150524=150524==/l90001/l\FilledBigTriangleRight=/l250524/l=ins:\FilledBigTriangleRight
150525=150525==/l90001/l\FilledBigTriangleUp=/l250525/l=ins:\FilledBigTriangleUp
150526=150526==/l90001/l\FilledCircle=/l250526/l=ins:\FilledCircle
150527=150527==/l90001/l\FilledDiamondShadowA=/l250527/l=ins:\FilledDiamondShadowA
150528=150528==/l90001/l\FilledDiamondShadowC=/l250528/l=ins:\FilledDiamondShadowC
150529=150529==/l90001/l\FilledDiamondshape=/l250529/l=ins:\FilledDiamondshape
150530=150530==/l90001/l\FilledSmallCircle=/l250530/l=ins:\FilledSmallCircle
150531=150531==/l90001/l\FilledSmallDiamondshape=/l250531/l=ins:\FilledSmallDiamondshape
150532=150532==/l90001/l\FilledSmallSquare=/l250532/l=ins:\FilledSmallSquare
150533=150533==/l90001/l\FilledSmallTriangleDown=/l250533/l=ins:\FilledSmallTriangleDown
150534=150534==/l90001/l\FilledSmallTriangleLeft=/l250534/l=ins:\FilledSmallTriangleLeft
150535=150535==/l90001/l\FilledSmallTriangleRight=/l250535/l=ins:\FilledSmallTriangleRight
150536=150536==/l90001/l\FilledSmallTriangleUp=/l250536/l=ins:\FilledSmallTriangleUp
150537=150537==/l90001/l\FilledSquare=/l250537/l=ins:\FilledSquare
150538=150538==/l90001/l\FilledSquareShadowA=/l250538/l=ins:\FilledSquareShadowA
150539=150539==/l90001/l\FilledSquareShadowC=/l250539/l=ins:\FilledSquareShadowC
150540=150540==/l90001/l\FilledTriangleDown=/l250540/l=ins:\FilledTriangleDown
150541=150541==/l90001/l\FilledTriangleLeft=/l250541/l=ins:\FilledTriangleLeft
150542=150542==/l90001/l\FilledTriangleRight=/l250542/l=ins:\FilledTriangleRight
150543=150543==/l90001/l\FilledTriangleUp=/l250543/l=ins:\FilledTriangleUp
150544=150544==/l90001/l\HBar=/l250544/l=ins:\HBar
150545=150545==/l90001/l\LowerDiamond=/l250545/l=ins:\LowerDiamond
150546=150546==/l90001/l\RightDiamond=/l250546/l=ins:\RightDiamond
150547=150547==/l90001/l\SmallCircle=/l250547/l=ins:\SmallCircle
150548=150548==/l90001/l\SmallCross=/l250548/l=ins:\SmallCross
150549=150549==/l90001/l\SmallDiamondshape=/l250549/l=ins:\SmallDiamondshape
150550=150550==/l90001/l\SmallHBar=/l250550/l=ins:\SmallHBar
150551=150551==/l90001/l\SmallLowerDiamond=/l250551/l=ins:\SmallLowerDiamond
150552=150552==/l90001/l\SmallRightDiamond=/l250552/l=ins:\SmallRightDiamond
150553=150553==/l90001/l\SmallSquare=/l250553/l=ins:\SmallSquare
150554=150554==/l90001/l\SmallTriangleDown=/l250554/l=ins:\SmallTriangleDown
150555=150555==/l90001/l\SmallTriangleLeft=/l250555/l=ins:\SmallTriangleLeft
150556=150556==/l90001/l\SmallTriangleRight=/l250556/l=ins:\SmallTriangleRight
150557=150557==/l90001/l\SmallTriangleUp=/l250557/l=ins:\SmallTriangleUp
150558=150558==/l90001/l\SmallVBar=/l250558/l=ins:\SmallVBar
150559=150559==/l90001/l\SpinDown=/l250559/l=ins:\SpinDown
150560=150560==/l90001/l\SpinUp=/l250560/l=ins:\SpinUp
150561=150561==/l90001/l\Square=/l250561/l=ins:\Square
150562=150562==/l90001/l\SquareShadowA=/l250562/l=ins:\SquareShadowA
150563=150563==/l90001/l\SquareShadowB=/l250563/l=ins:\SquareShadowB
150564=150564==/l90001/l\SquareShadowC=/l250564/l=ins:\SquareShadowC
150565=150565==/l90001/l\TriangleDown=/l250565/l=ins:\TriangleDown
150566=150566==/l90001/l\TriangleLeft=/l250566/l=ins:\TriangleLeft
150567=150567==/l90001/l\TriangleRight=/l250567/l=ins:\TriangleRight
150568=150568==/l90001/l\TriangleUp=/l250568/l=ins:\TriangleUp
150569=150569==/l90001/l\VBar=/l250569/l=ins:\VBar

// 151000 - bbding Geometric Shapes
151001=151001==/l90001/l\CircleShadow=/l251001/l=ins:\CircleShadow
151002=151002==/l90001/l\CircleSolid=/l251002/l=ins:\CircleSolid
151003=151003==/l90001/l\DiamondSolid=/l251003/l=ins:\DiamondSolid
151004=151004==/l90001/l\Ellipse=/l251004/l=ins:\Ellipse
151005=151005==/l90001/l\EllipseShadow=/l251005/l=ins:\EllipseShadow
151006=151006==/l90001/l\EllipseSolid=/l251006/l=ins:\EllipseSolid
151007=151007==/l90001/l\HalfCircleLeft=/l251007/l=ins:\HalfCircleLeft
151008=151008==/l90001/l\HalfCircleRight=/l251008/l=ins:\HalfCircleRight
151009=151009==/l90001/l\Rectangle=/l251009/l=ins:\Rectangle
151010=151010==/l90001/l\RectangleBold=/l251010/l=ins:\RectangleBold
151011=151011==/l90001/l\RectangleThin=/l251011/l=ins:\RectangleThin
151012=151012==/l90001/l\Square=/l251012/l=ins:\Square
151013=151013==/l90001/l\SquareCastShadowBottomRight=/l251013/l=ins:\SquareCastShadowBottomRight
151014=151014==/l90001/l\SquareCastShadowTopLeft=/l251014/l=ins:\SquareCastShadowTopLeft
151015=151015==/l90001/l\SquareCastShadowTopRight=/l251015/l=ins:\SquareCastShadowTopRight
151016=151016==/l90001/l\SquareShadowBottomRight=/l251016/l=ins:\SquareShadowBottomRight
151017=151017==/l90001/l\SquareShadowTopLeft=/l251017/l=ins:\SquareShadowTopLeft
151018=151018==/l90001/l\SquareShadowTopRight=/l251018/l=ins:\SquareShadowTopRight
151019=151019==/l90001/l\SquareSolid=/l251019/l=ins:\SquareSolid
151020=151020==/l90001/l\TriangleDown=/l251020/l=ins:\TriangleDown
151021=151021==/l90001/l\TriangleUp=/l251021/l=ins:\TriangleUp

// 151500 - pifont Geometric Shapes
151501=151501==/l90001/l\ding{108}=/l251501/l=ins:\ding{108}
151502=151502==/l90001/l\ding{109}=/l251502/l=ins:\ding{109}
151503=151503==/l90001/l\ding{110}=/l251503/l=ins:\ding{110}
151504=151504==/l90001/l\ding{111}=/l251504/l=ins:\ding{111}
151505=151505==/l90001/l\ding{112}=/l251505/l=ins:\ding{112}
151506=151506==/l90001/l\ding{113}=/l251506/l=ins:\ding{113}
151507=151507==/l90001/l\ding{114}=/l251507/l=ins:\ding{114}
151508=151508==/l90001/l\ding{115}=/l251508/l=ins:\ding{115}
151509=151509==/l90001/l\ding{116}=/l251509/l=ins:\ding{116}
151510=151510==/l90001/l\ding{117}=/l251510/l=ins:\ding{117}
151511=151511==/l90001/l\ding{119}=/l251511/l=ins:\ding{119}
151512=151512==/l90001/l\ding{120}=/l251512/l=ins:\ding{120}
151513=151513==/l90001/l\ding{121}=/l251513/l=ins:\ding{121}
151514=151514==/l90001/l\ding{122}=/l251514/l=ins:\ding{122}

// 152000 - manfnt Dangerous Bend Symbols
152001=152001==/l90001/l\dbend=/l252001/l=ins:\dbend
152002=152002==/l90001/l\lhdbend=/l252002/l=ins:\lhdbend
152003=152003==/l90001/l\reversedvideodbend=/l252003/l=ins:\reversedvideodbend

// 152500 - marvosym Information Symbols
152501=152501==/l90001/l\Bicycle=/l252501/l=ins:\Bicycle
152502=152502==/l90001/l\Checkedbox=/l252502/l=ins:\Checkedbox
152503=152503==/l90001/l\Clocklogo=/l252503/l=ins:\Clocklogo
152504=152504==/l90001/l\Coffeecup=/l252504/l=ins:\Coffeecup
152505=152505==/l90001/l\Crossedbox=/l252505/l=ins:\Crossedbox
152506=152506==/l90001/l\Football=/l252506/l=ins:\Football
152507=152507==/l90001/l\Gentsroom=/l252507/l=ins:\Gentsroom
152508=152508==/l90001/l\Industry=/l252508/l=ins:\Industry
152509=152509==/l90001/l\Info=/l252509/l=ins:\Info
152510=152510==/l90001/l\Ladiesroom=/l252510/l=ins:\Ladiesroom
152511=152511==/l90001/l\Pointinghand=/l252511/l=ins:\Pointinghand
152512=152512==/l90001/l\Wheelchair=/l252512/l=ins:\Wheelchair
152513=152513==/l90001/l\Writinghand=/l252513/l=ins:\Writinghand

// 153000 - Miscellaneous dingbat Dingbats
153001=153001==/l90001/l\anchor=/l253001/l=ins:\anchor
153002=153002==/l90001/l\carriagereturn=/l253002/l=ins:\carriagereturn
153003=153003==/l90001/l\checkmark=/l253003/l=ins:\checkmark
153004=153004==/l90001/l\eye=/l253004/l=ins:\eye
153005=153005==/l90001/l\filledsquarewithdots=/l253005/l=ins:\filledsquarewithdots
153006=153006==/l90001/l\satellitedish=/l253006/l=ins:\satellitedish
153007=153007==/l90001/l\Sborder=/l253007/l=ins:\Sborder
153008=153008==/l90001/l\squarewithdots=/l253008/l=ins:\squarewithdots
153009=153009==/l90001/l\Zborder=/l253009/l=ins:\Zborder

// 153500 - Miscellaneous bbding Dingbats
153501=153501==/l90001/l\Envelope=/l253501/l=ins:\Envelope
153502=153502==/l90001/l\OrnamentDiamondSolid=/l253502/l=ins:\OrnamentDiamondSolid
153503=153503==/l90001/l\Peace=/l253503/l=ins:\Peace
153504=153504==/l90001/l\Phone=/l253504/l=ins:\Phone
153505=153505==/l90001/l\PhoneHandset=/l253505/l=ins:\PhoneHandset
153506=153506==/l90001/l\Plane=/l253506/l=ins:\Plane
153507=153507==/l90001/l\SunshineOpenCircled=/l253507/l=ins:\SunshineOpenCircled
153508=153508==/l90001/l\Tape=/l253508/l=ins:\Tape

// 154000 - Miscellaneous pifont Dingbats
154001=154001==/l90001/l\ding{37}=/l254001/l=ins:\ding{37}
154002=154002==/l90001/l\ding{38}=/l254002/l=ins:\ding{38}
154003=154003==/l90001/l\ding{39}=/l254003/l=ins:\ding{39}
154004=154004==/l90001/l\ding{40}=/l254004/l=ins:\ding{40}
154005=154005==/l90001/l\ding{41}=/l254005/l=ins:\ding{41}
154006=154006==/l90001/l\ding{118}=/l254006/l=ins:\ding{118}
154007=154007==/l90001/l\ding{164}=/l254007/l=ins:\ding{164}
154008=154008==/l90001/l\ding{165}=/l254008/l=ins:\ding{165}
154009=154009==/l90001/l\ding{166}=/l254009/l=ins:\ding{166}
154010=154010==/l90001/l\ding{167}=/l254010/l=ins:\ding{167}
154011=154011==/l90001/l\ding{168}=/l254011/l=ins:\ding{168}
154012=154012==/l90001/l\ding{170}=/l254012/l=ins:\ding{170}
154013=154013==/l90001/l\ding{171}=/l254013/l=ins:\ding{171}
154014=154014==/l90001/l\ding{169}=/l254014/l=ins:\ding{169}

// 154500 - textcomp Genealogical Symbols
154501=154501==/l90001/l\textborn=/l254501/l=ins:\textborn
154502=154502==/l90001/l\textdied=/l254502/l=ins:\textdied
154503=154503==/l90001/l\textdivorced=/l254503/l=ins:\textdivorced
154504=154504==/l90001/l\textleaf=/l254504/l=ins:\textleaf
154505=154505==/l90001/l\textmarried=/l254505/l=ins:\textmarried

// 155000 - wasysym General Symbols
155001=155001==/l90001/l\agemO=/l255001/l=ins:\agemO
155002=155002==/l90001/l\ataribox=/l255002/l=ins:\ataribox
155003=155003==/l90001/l\bell=/l255003/l=ins:\bell
155004=155004==/l90001/l\blacksmiley=/l255004/l=ins:\blacksmiley
155005=155005==/l90001/l\Bowtie=/l255005/l=ins:\Bowtie
155006=155006==/l90001/l\brokenvert=/l255006/l=ins:\brokenvert
155007=155007==/l90001/l\cent=/l255007/l=ins:\cent
155008=155008==/l90001/l\checked=/l255008/l=ins:\checked
155009=155009==/l90001/l\clock=/l255009/l=ins:\clock
155010=155010==/l90001/l\currency=/l255010/l=ins:\currency
155011=155011==/l90001/l\diameter=/l255011/l=ins:\diameter
155012=155012==/l90001/l\DOWNarrow=/l255012/l=ins:\DOWNarrow
155013=155013==/l90001/l\female=/l255013/l=ins:\female
155014=155014==/l90001/l\frownie=/l255014/l=ins:\frownie
155015=155015==/l90001/l\invdiameter=/l255015/l=ins:\invdiameter
155016=155016==/l90001/l\kreuz=/l255016/l=ins:\kreuz
155017=155017==/l90001/l\LEFTarrow=/l255017/l=ins:\LEFTarrow
155018=155018==/l90001/l\lightning=/l255018/l=ins:\lightning
155019=155019==/l90001/l\male=/l255019/l=ins:\male
155020=155020==/l90001/l\permil=/l255020/l=ins:\permil
155021=155021==/l90001/l\phone=/l255021/l=ins:\phone
155022=155022==/l90001/l\pointer=/l255022/l=ins:\pointer
155023=155023==/l90001/l\recorder=/l255023/l=ins:\recorder
155024=155024==/l90001/l\RIGHTarrow=/l255024/l=ins:\RIGHTarrow
155025=155025==/l90001/l\smiley=/l255025/l=ins:\smiley
155026=155026==/l90001/l\sun=/l255026/l=ins:\sun
155027=155027==/l90001/l\UParrow=/l255027/l=ins:\UParrow
155028=155028==/l90001/l\varangle=/l255028/l=ins:\varangle
155029=155029==/l90001/l\wasylozenge=/l255029/l=ins:\wasylozenge
155030=155030==/l90001/l\wasytherefore=/l255030/l=ins:\wasytherefore

// 155500 - wasysym Musical Notes
155501=155501==/l90001/l\eighthnote=/l255501/l=ins:\eighthnote
155502=155502==/l90001/l\halfnote=/l255502/l=ins:\halfnote
155503=155503==/l90001/l\twonotes=/l255503/l=ins:\twonotes
155504=155504==/l90001/l\fullnote=/l255504/l=ins:\fullnote
155505=155505==/l90001/l\quarternote=/l255505/l=ins:\quarternote

// 156000 - wasysym Circles
156001=156001==/l90001/l\CIRCLE=/l256001/l=ins:\CIRCLE
156002=156002==/l90001/l\Circle=/l256002/l=ins:\Circle
156003=156003==/l90001/l\LEFTCIRCLE=/l256003/l=ins:\LEFTCIRCLE
156004=156004==/l90001/l\LEFTcircle=/l256004/l=ins:\LEFTcircle
156005=156005==/l90001/l\Leftcircle=/l256005/l=ins:\Leftcircle
156006=156006==/l90001/l\RIGHTCIRCLE=/l256006/l=ins:\RIGHTCIRCLE
156007=156007==/l90001/l\RIGHTcircle=/l256007/l=ins:\RIGHTcircle
156008=156008==/l90001/l\Rightcircle=/l256008/l=ins:\Rightcircle
156009=156009==/l90001/l\leftturn=/l256009/l=ins:\leftturn
156010=156010==/l90001/l\rightturn=/l256010/l=ins:\rightturn

// 156500 - Miscellaneous manfnt Symbols
156501=156501==/l90001/l\manboldkidney=/l256501/l=ins:\manboldkidney
156502=156502==/l90001/l\manconcentriccircles=/l256502/l=ins:\manconcentriccircles
156503=156503==/l90001/l\manconcentricdiamond=/l256503/l=ins:\manconcentricdiamond
156504=156504==/l90001/l\mancone=/l256504/l=ins:\mancone
156505=156505==/l90001/l\mancube=/l256505/l=ins:\mancube
156506=156506==/l90001/l\manerrarrow=/l256506/l=ins:\manerrarrow
156507=156507==/l90001/l\manfilledquartercircle=/l256507/l=ins:\manfilledquartercircle
156508=156508==/l90001/l\manhpennib=/l256508/l=ins:\manhpennib
156509=156509==/l90001/l\manimpossiblecube=/l256509/l=ins:\manimpossiblecube
156510=156510==/l90001/l\mankidney=/l256510/l=ins:\mankidney
156511=156511==/l90001/l\manlhpenkidney=/l256511/l=ins:\manlhpenkidney
156512=156512==/l90001/l\manpenkidney=/l256512/l=ins:\manpenkidney
156513=156513==/l90001/l\manquadrifolium=/l256513/l=ins:\manquadrifolium
156514=156514==/l90001/l\manquartercircle=/l256514/l=ins:\manquartercircle
156515=156515==/l90001/l\manrotatedquadrifolium=/l256515/l=ins:\manrotatedquadrifolium
156516=156516==/l90001/l\manrotatedquartercircle=/l256516/l=ins:\manrotatedquartercircle
156517=156517==/l90001/l\manstar=/l256517/l=ins:\manstar
156518=156518==/l90001/l\mantiltpennib=/l256518/l=ins:\mantiltpennib
156519=156519==/l90001/l\mantriangledown=/l256519/l=ins:\mantriangledown
156520=156520==/l90001/l\mantriangleright=/l256520/l=ins:\mantriangleright
156521=156521==/l90001/l\mantriangleup=/l256521/l=ins:\mantriangleup
156522=156522==/l90001/l\manvpennib=/l256522/l=ins:\manvpennib

// 157000 - marvosym Navigation Symbols
157001=157001==/l90001/l\Forward=/l257001/l=ins:\Forward
157002=157002==/l90001/l\ForwardToEnd=/l257002/l=ins:\ForwardToEnd
157003=157003==/l90001/l\ForwardToIndex=/l257003/l=ins:\ForwardToIndex
157004=157004==/l90001/l\MoveDown=/l257004/l=ins:\MoveDown
157005=157005==/l90001/l\MoveUp=/l257005/l=ins:\MoveUp
157006=157006==/l90001/l\Rewind=/l257006/l=ins:\Rewind
157007=157007==/l90001/l\RewindToIndex=/l257007/l=ins:\RewindToIndex
157008=157008==/l90001/l\RewindToStart=/l257008/l=ins:\RewindToStart
157009=157009==/l90001/l\ToBottom=/l257009/l=ins:\ToBottom
157010=157010==/l90001/l\ToTop=/l257010/l=ins:\ToTop

// 157500 - marvosym Laundry Symbols
157501=157501==/l90001/l\AtForty=/l257501/l=ins:\AtForty
157502=157502==/l90001/l\AtNinetyFive=/l257502/l=ins:\AtNinetyFive
157503=157503==/l90001/l\AtSixty=/l257503/l=ins:\AtSixty
157504=157504==/l90001/l\Bleech=/l257504/l=ins:\Bleech
157505=157505==/l90001/l\CleaningA=/l257505/l=ins:\CleaningA
157506=157506==/l90001/l\CleaningF=/l257506/l=ins:\CleaningF
157507=157507==/l90001/l\CleaningFF=/l257507/l=ins:\CleaningFF
157508=157508==/l90001/l\CleaningP=/l257508/l=ins:\CleaningP
157509=157509==/l90001/l\CleaningPP=/l257509/l=ins:\CleaningPP
157510=157510==/l90001/l\Dontwash=/l257510/l=ins:\Dontwash
157511=157511==/l90001/l\Handwash=/l257511/l=ins:\Handwash
157512=157512==/l90001/l\IroningI=/l257512/l=ins:\IroningI
157513=157513==/l90001/l\IroningII=/l257513/l=ins:\IroningII
157514=157514==/l90001/l\IroningIII=/l257514/l=ins:\IroningIII
157515=157515==/l90001/l\NoBleech=/l257515/l=ins:\NoBleech
157516=157516==/l90001/l\NoChemicalCleaning=/l257516/l=ins:\NoChemicalCleaning
157517=157517==/l90001/l\NoIroning=/l257517/l=ins:\NoIroning
157518=157518==/l90001/l\NoTumbler=/l257518/l=ins:\NoTumbler
157519=157519==/l90001/l\ShortFifty=/l257519/l=ins:\ShortFifty
157520=157520==/l90001/l\ShortForty=/l257520/l=ins:\ShortForty
157521=157521==/l90001/l\ShortNinetyFive=/l257521/l=ins:\ShortNinetyFive
157522=157522==/l90001/l\ShortSixty=/l257522/l=ins:\ShortSixty
157523=157523==/l90001/l\ShortThirty=/l257523/l=ins:\ShortThirty
157524=157524==/l90001/l\SpecialForty=/l257524/l=ins:\SpecialForty
157525=157525==/l90001/l\Tumbler=/l257525/l=ins:\Tumbler
157526=157526==/l90001/l\WashCotton=/l257526/l=ins:\WashCotton
157527=157527==/l90001/l\WashSynthetics=/l257527/l=ins:\WashSynthetics
157528=157528==/l90001/l\WashWool=/l257528/l=ins:\WashWool

// 158000 - Other marvosym Symbols
158001=158001==/l90001/l\Ankh=/l258001/l=ins:\Ankh
158002=158002==/l90001/l\Bat=/l258002/l=ins:\Bat
158003=158003==/l90001/l\Bouquet=/l258003/l=ins:\Bouquet
158004=158004==/l90001/l\Celtcross=/l258004/l=ins:\Celtcross
158005=158005==/l90001/l\CircledA=/l258005/l=ins:\CircledA
158006=158006==/l90001/l\Cross=/l258006/l=ins:\Cross
158007=158007==/l90001/l\FHBOlogo=/l258007/l=ins:\FHBOlogo
158008=158008==/l90001/l\FHBOLOGO=/l258008/l=ins:\FHBOLOGO
158009=158009==/l90001/l\Frowny=/l258009/l=ins:\Frowny
158010=158010==/l90001/l\FullFHBO=/l258010/l=ins:\FullFHBO
158011=158011==/l90001/l\Heart=/l258011/l=ins:\Heart
158012=158012==/l90001/l\MartinVogel=/l258012/l=ins:\MartinVogel
158013=158013==/l90001/l\Mundus=/l258013/l=ins:\Mundus
158014=158014==/l90001/l\MVAt=/l258014/l=ins:\MVAt
158015=158015==/l90001/l\Rightarrow=/l258015/l=ins:\Rightarrow
158016=158016==/l90001/l\Smiley=/l258016/l=ins:\Smiley
158017=158017==/l90001/l\Womanface=/l258017/l=ins:\Womanface
158018=158018==/l90001/l\Yinyang=/l258018/l=ins:\Yinyang

// 158500 - ifsym Weather Symbols
158501=158501==/l90001/l\Blitz=/l258501/l=ins:\Blitz
158502=158502==/l90001/l\Cloud=/l258502/l=ins:\Cloud
158503=158503==/l90001/l\FilledCloud=/l258503/l=ins:\FilledCloud
158504=158504==/l90001/l\FilledRainCloud=/l258504/l=ins:\FilledRainCloud
158505=158505==/l90001/l\FilledSnowCloud=/l258505/l=ins:\FilledSnowCloud
158506=158506==/l90001/l\FilledSunCloud=/l258506/l=ins:\FilledSunCloud
158507=158507==/l90001/l\FilledWeakRainCloud=/l258507/l=ins:\FilledWeakRainCloud
158508=158508==/l90001/l\Fog=/l258508/l=ins:\Fog
158509=158509==/l90001/l\Graupel=/l258509/l=ins:\Graupel
158510=158510==/l90001/l\Hagel=/l258510/l=ins:\Hagel
158511=158511==/l90001/l\HalfSun=/l258511/l=ins:\HalfSun
158512=158512==/l90001/l\NoSun=/l258512/l=ins:\NoSun
158513=158513==/l90001/l\Rain=/l258513/l=ins:\Rain
158514=158514==/l90001/l\RainCloud=/l258514/l=ins:\RainCloud
158515=158515==/l90001/l\Snow=/l258515/l=ins:\Snow
158516=158516==/l90001/l\SnowCloud=/l258516/l=ins:\SnowCloud
158517=158517==/l90001/l\Sun=/l258517/l=ins:\Sun
158518=158518==/l90001/l\SunCloud=/l258518/l=ins:\SunCloud
158519=158519==/l90001/l\ThinFog=/l258519/l=ins:\ThinFog
158520=158520==/l90001/l\WeakRain=/l258520/l=ins:\WeakRain
158521=158521==/l90001/l\WeakRainCloud=/l258521/l=ins:\WeakRainCloud
158522=158522==/l90001/l\Thermo{}=/l258522/l=ins:\Thermo{}

// 159000 - ifsym Alpine Symbols
159001=159001==/l90001/l\FilledHut=/l259001/l=ins:\FilledHut
159002=159002==/l90001/l\Flag=/l259002/l=ins:\Flag
159003=159003==/l90001/l\HalfFilledHut=/l259003/l=ins:\HalfFilledHut
159004=159004==/l90001/l\Hut=/l259004/l=ins:\Hut
159005=159005==/l90001/l\IceMountain=/l259005/l=ins:\IceMountain
159006=159006==/l90001/l\Joch=/l259006/l=ins:\Joch
159007=159007==/l90001/l\Mountain=/l259007/l=ins:\Mountain
159008=159008==/l90001/l\StoneMan=/l259008/l=ins:\StoneMan
159009=159009==/l90001/l\Summit=/l259009/l=ins:\Summit
159010=159010==/l90001/l\SummitSign=/l259010/l=ins:\SummitSign
159011=159011==/l90001/l\Tent=/l259011/l=ins:\Tent
159012=159012==/l90001/l\VarFlag=/l259012/l=ins:\VarFlag
159013=159013==/l90001/l\VarIceMountain=/l259013/l=ins:\VarIceMountain
159014=159014==/l90001/l\VarMountain=/l259014/l=ins:\VarMountain
159015=159015==/l90001/l\VarSummit=/l259015/l=ins:\VarSummit
159016=159016==/l90001/l\Vermessung=/l259016/l=ins:\Vermessung
159017=159017==/l90001/l\Village=/l259017/l=ins:\Village

// 159500 - ifsym Clocks
159501=159501==/l90001/l\Interval=/l259501/l=ins:\Interval
159502=159502==/l90001/l\StopWatchEnd=/l259502/l=ins:\StopWatchEnd
159503=159503==/l90001/l\StopWatchStart=/l259503/l=ins:\StopWatchStart
159504=159504==/l90001/l\Taschenuhr=/l259504/l=ins:\Taschenuhr
159505=159505==/l90001/l\VarClock=/l259505/l=ins:\VarClock
159506=159506==/l90001/l\VarTaschenuhr=/l259506/l=ins:\VarTaschenuhr
159507=159507==/l90001/l\Wecker=/l259507/l=ins:\Wecker
159508=159508==/l90001/l\showclock{}{}=/l259508/l=ins:\showclock{}{}

// 160000 - Other ifsym Symbols
160001=160001==/l90001/l\FilledSectioningDiamond=/l260001/l=ins:\FilledSectioningDiamond
160002=160002==/l90001/l\Fire=/l260002/l=ins:\Fire
160003=160003==/l90001/l\Irritant=/l260003/l=ins:\Irritant
160004=160004==/l90001/l\Letter=/l260004/l=ins:\Letter
160005=160005==/l90001/l\PaperLandscape=/l260005/l=ins:\PaperLandscape
160006=160006==/l90001/l\PaperPortrait=/l260006/l=ins:\PaperPortrait
160007=160007==/l90001/l\Radiation=/l260007/l=ins:\Radiation
160008=160008==/l90001/l\SectioningDiamond=/l260008/l=ins:\SectioningDiamond
160009=160009==/l90001/l\Telephone=/l260009/l=ins:\Telephone
160010=160010==/l90001/l\StrokeOne=/l260010/l=ins:\StrokeOne
160011=160011==/l90001/l\StrokeTwo=/l260011/l=ins:\StrokeTwo
160012=160012==/l90001/l\StrokeThree=/l260012/l=ins:\StrokeThree
160013=160013==/l90001/l\StrokeFour=/l260013/l=ins:\StrokeFour
160014=160014==/l90001/l\StrokeFive=/l260014/l=ins:\StrokeFive
160015=160015==/l90001/l\Cube{1}=/l260015/l=ins:\Cube{1}
160016=160016==/l90001/l\Cube{2}=/l260016/l=ins:\Cube{2}
160017=160017==/l90001/l\Cube{3}=/l260017/l=ins:\Cube{3}
160018=160018==/l90001/l\Cube{4}=/l260018/l=ins:\Cube{4}
160019=160019==/l90001/l\Cube{5}=/l260019/l=ins:\Cube{5}
160020=160020==/l90001/l\Cube{6}=/l260020/l=ins:\Cube{6}
