/*
 * Decompiled with CFR 0.152.
 */
package de.nm.string;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class XStringBuilder
implements Serializable,
CharSequence,
Appendable,
Iterable<Character> {
    private static final int INITSIZE = 16;
    private static final String lineSeparator = System.getProperty("line.separator", "\n");
    static final long serialVersionUID = 1L;
    private int count;
    private char[] value;

    public XStringBuilder() {
        this(16);
    }

    public XStringBuilder(int capacity) {
        this.value = new char[capacity];
    }

    public XStringBuilder(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public XStringBuilder(String str, int capacity) {
        this(capacity);
        this.append(str);
    }

    public XStringBuilder(StringBuffer str) {
        this(str.length() + 16);
        this.append(str);
    }

    public XStringBuilder(StringBuilder str) {
        this(str.length() + 16);
        this.append(str);
    }

    public XStringBuilder append(boolean b) {
        this.append(String.valueOf(b));
        return this;
    }

    public XStringBuilder append(boolean ... b) {
        boolean[] blArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bb = blArray[n2];
            this.append(bb);
            ++n2;
        }
        return this;
    }

    @Override
    public XStringBuilder append(char c) {
        this.checkCapacity(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public XStringBuilder append(char[] str) {
        int newCount = this.count + str.length;
        this.checkCapacity(newCount);
        System.arraycopy(str, 0, this.value, this.count, str.length);
        this.count = newCount;
        return this;
    }

    public XStringBuilder append(char[] str, int offset, int len) {
        int newCount = this.count + len;
        this.checkCapacity(newCount);
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newCount;
        return this;
    }

    @Override
    public XStringBuilder append(CharSequence csq) {
        return this.append(csq.toString());
    }

    @Override
    public XStringBuilder append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    public XStringBuilder append(double d) {
        return this.append(String.valueOf(d));
    }

    public XStringBuilder append(double ... d) {
        double[] dArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            double dd = dArray[n2];
            this.append(dd);
            ++n2;
        }
        return this;
    }

    public XStringBuilder append(float f) {
        return this.append(String.valueOf(f));
    }

    public XStringBuilder append(float ... f) {
        float[] fArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            float ff = fArray[n2];
            this.append(ff);
            ++n2;
        }
        return this;
    }

    public XStringBuilder append(int i) {
        return this.append(String.valueOf(i));
    }

    public XStringBuilder append(int ... i) {
        int[] nArray = i;
        int n = i.length;
        int n2 = 0;
        while (n2 < n) {
            int ii = nArray[n2];
            this.append(ii);
            ++n2;
        }
        return this;
    }

    public XStringBuilder append(long l) {
        return this.append(String.valueOf(l));
    }

    public XStringBuilder append(long ... l) {
        long[] lArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            long ll = lArray[n2];
            this.append(ll);
            ++n2;
        }
        return this;
    }

    public XStringBuilder append(Object ... obj) {
        Object[] objectArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.append(object);
            ++n2;
        }
        return this;
    }

    public XStringBuilder append(Object o) {
        return this.append(String.valueOf(o));
    }

    public XStringBuilder append(String ... str) {
        String[] stringArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.append(s);
            ++n2;
        }
        return this;
    }

    public XStringBuilder append(String str) {
        int len;
        String s = str;
        if (str == null) {
            s = "null";
        }
        if ((len = s.length()) == 0) {
            return this;
        }
        int newCount = this.count + len;
        this.checkCapacity(newCount);
        s.getChars(0, len, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public XStringBuilder append(String str, int offset, int len) {
        int slen;
        String s = str;
        if (str == null) {
            s = "null";
        }
        if ((slen = s.length()) == 0) {
            return this;
        }
        return this.append(str.toCharArray(), offset, len);
    }

    public int capacity() {
        return this.value.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    private void checkCapacity(int newCount) {
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
    }

    public void clear() {
        this.count = 0;
    }

    public void clearFill() {
        Arrays.fill(this.value, '\u0000');
        this.count = 0;
    }

    public int compareTo(String str) {
        return this.toString().compareTo(str);
    }

    public int compareTo(XStringBuilder str) {
        return this.toString().compareTo(str.toString());
    }

    public int compareToIgnoreCase(String str) {
        return this.toString().compareToIgnoreCase(str);
    }

    public int compareToIgnoreCase(XStringBuilder str) {
        return this.toString().compareToIgnoreCase(str.toString());
    }

    public boolean contains(CharSequence strsequence) {
        return this.indexOf(strsequence.toString()) > -1;
    }

    public XStringBuilder delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public XStringBuilder deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public XStringBuilder deleteFirstChar() {
        return this.deleteCharAt(0);
    }

    public XStringBuilder deleteLastChar() {
        if (this.count < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        --this.count;
        return this;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XStringBuilder)) {
            return false;
        }
        XStringBuilder xsb = (XStringBuilder)obj;
        if (this.count != xsb.count) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            if (this.value[i] != xsb.value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.count) {
            hash = 31 * hash + this.value[i];
            ++i;
        }
        return hash;
    }

    private int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        int i = sourceOffset + fromIndex;
        while (i <= max) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = targetOffset + 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return this.indexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public XStringBuilder insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public XStringBuilder insert(int offset, char c) {
        int newCount = this.count + 1;
        this.checkCapacity(newCount);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newCount;
        return this;
    }

    public XStringBuilder insert(int offset, char[] str) {
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        int len = str.length;
        int newCount = this.count + len;
        this.checkCapacity(newCount);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newCount;
        return this;
    }

    public XStringBuilder insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (offset < 0 || len < 0 || offset > str.length - len) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", len " + len + ", str.length " + str.length);
        }
        int newCount = this.count + len;
        this.checkCapacity(newCount);
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public XStringBuilder insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public XStringBuilder insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public XStringBuilder insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public XStringBuilder insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public XStringBuilder insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public XStringBuilder insert(int offset, String str) {
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        String s = str;
        if (str == null) {
            s = "null";
        }
        return this.insert(offset, s.toCharArray());
    }

    private int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.lastIndexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    @Override
    public int length() {
        return this.count;
    }

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public XStringBuilder newline() {
        this.append(lineSeparator);
        return this;
    }

    public void readFile(File file, String encoding) throws IOException {
        long len = file.length();
        if (len > Integer.MAX_VALUE) {
            throw new IOException("file is to big for a XStringBuilder!");
        }
        int ilen = (int)len;
        this.checkCapacity(ilen);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        this.count = in.read(this.value, 0, ilen);
        in.close();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.count = in.readInt();
        this.value = (char[])in.readObject();
    }

    public XStringBuilder replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            int i = 0;
            while (i < this.count) {
                if (this.value[i] == oldChar) {
                    this.value[i] = newChar;
                }
                ++i;
            }
        }
        return this;
    }

    public XStringBuilder replace(CharSequence target, CharSequence replacement) {
        String newstr = Pattern.compile(target.toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(replacement.toString()));
        this.clear();
        this.checkCapacity(newstr.length() + 16);
        this.append(newstr);
        return this;
    }

    public XStringBuilder replace(int start, int end, String str) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (end > this.count) {
            end = this.count;
        }
        int len = str.length();
        int newCount = this.count + len - (end - start);
        this.checkCapacity(newCount);
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        System.arraycopy(str.toCharArray(), 0, this.value, start, len);
        this.count = newCount;
        return this;
    }

    public XStringBuilder replaceAll(String regex, String replacement) {
        String newstr = Pattern.compile(regex).matcher(this).replaceAll(replacement);
        this.clear();
        this.checkCapacity(newstr.length() + 16);
        this.append(newstr);
        return this;
    }

    public XStringBuilder replaceFirst(String regex, String replacement) {
        String newstr = Pattern.compile(regex).matcher(this).replaceFirst(replacement);
        this.clear();
        this.checkCapacity(newstr.length() + 16);
        this.append(newstr);
        return this;
    }

    public XStringBuilder set(boolean val) {
        this.clear();
        return this.append(val);
    }

    public XStringBuilder set(char[] str) {
        this.clear();
        return this.append(str);
    }

    public XStringBuilder set(CharSequence val) {
        this.clear();
        return this.append(val);
    }

    public XStringBuilder set(double val) {
        this.clear();
        return this.append(val);
    }

    public XStringBuilder set(float val) {
        this.clear();
        return this.append(val);
    }

    public XStringBuilder set(int val) {
        this.clear();
        return this.append(val);
    }

    public XStringBuilder set(long val) {
        this.clear();
        return this.append(val);
    }

    public XStringBuilder set(Object val) {
        this.clear();
        return this.append(val);
    }

    public XStringBuilder set(String str) {
        this.clear();
        return this.append(str);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        if (this.count < newLength) {
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = newLength;
        }
    }

    public int size() {
        return this.count;
    }

    public String[] split(String regex) {
        return this.split(regex, 0);
    }

    public String[] split(String regex, int limit) {
        return Pattern.compile(regex).split(this, limit);
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int toffset) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        int idx1 = toffset;
        int len = prefix.length();
        if (len == 0) {
            return true;
        }
        int last = idx1 + len;
        if (last > this.count) {
            return false;
        }
        char[] chars = prefix.toCharArray();
        int idx2 = 0;
        while (idx1 < last) {
            if (this.value[idx1++] == chars[idx2++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value, start, end - start);
    }

    public char[] toCharArray() {
        char[] newValue = new char[this.count];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        return newValue;
    }

    public XStringBuilder toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public XStringBuilder toLowerCase(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("local is null!");
        }
        String newstr = this.toString().toLowerCase(locale);
        this.clear();
        this.checkCapacity(newstr.length() + 16);
        this.append(newstr);
        return this;
    }

    @Override
    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public StringBuilder toStringBuilder() {
        StringBuilder buf = new StringBuilder(this.count + 16);
        buf.append(this.value, 0, this.count);
        return buf;
    }

    public XStringBuilder toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public XStringBuilder toUpperCase(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("local is null!");
        }
        String newstr = this.toString().toUpperCase(locale);
        this.clear();
        this.checkCapacity(newstr.length() + 16);
        this.append(newstr);
        return this;
    }

    public XStringBuilder trim() {
        int start = 0;
        while (start < this.count && this.value[start] <= ' ') {
            ++start;
        }
        while (start < this.count && this.value[this.count - 1] <= ' ') {
            --this.count;
        }
        if (start > 0) {
            System.arraycopy(this.value, start, this.value, 0, this.count - start);
            this.count -= start;
        }
        return this;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    public void writeFile(File file, String encoding) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        out.write(this.value, 0, this.count);
        out.close();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.count);
        out.writeObject(this.value);
    }

    @Override
    public Iterator<Character> iterator() {
        return new Iterator<Character>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < XStringBuilder.this.count;
            }

            @Override
            public Character next() {
                return Character.valueOf(XStringBuilder.this.value[this.idx++]);
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }
        };
    }
}

