// This file is part of The New Aspell
// Copyright (C) 2001 by Kevin Atkinson under the GNU LGPL license
// version 2.0 or 2.1.  You should have received a copy of the LGPL
// license along with this library if you did not you can find
// it at http://www.gnu.org/.

//#include "settings.h"

//#include "iostream.hpp"

//#include "config.hpp"
//#include "fstream.hpp"
//#include "errors.hpp"
#include "parm_string.hpp"
#include "string_list.hpp"

#ifdef USE_FILE_LOCKS
#  include <fcntl.h>
#endif
 
// This needs to be <stdio.h> and not <cstdio>
#include <stdio.h>
#include <sys/stat.h>

#ifdef WIN32

#  include <windows.h>
#  include <winbase.h>

#else

#  include <unistd.h>
#  include <dirent.h>

#endif

#include "path_browse.h" //13-Sep-04

namespace acommon {

#ifdef WIN32PORT
  //Windows version
  PathBrowser::PathBrowser(const StringList & sl, const char * suf) 
  {
    els = sl.elements();
    suffix = suf;
	 dir_handle = INVALID_HANDLE_VALUE;
  }

  PathBrowser::~PathBrowser() 
  {
    delete els;
    if (INVALID_HANDLE_VALUE != dir_handle)
		 FindClose(dir_handle);
  }
  /*
   Get the next directory from the els list, and start reading from it.
  */
  bool PathBrowser::GetNextDir()
  {
		dir = els->next();
		if (dir) {
			if (INVALID_HANDLE_VALUE != dir_handle)
				FindClose(dir_handle);
			String pattern = dir; pattern += "\\*"; pattern += suffix;
			dir_handle = FindFirstFile(pattern.c_str(),&BrowseData);
			return true;
		}
		return false;
  }
  /*
   if we do not have a valid dir_handle we can not
	find files, return false so that we can step to the
	next directory and get fresh dir_handle.
	If we have a handle, get the next file.
	If we can not find anymore files, close the handle
	and set dir_handle to invalid.
	return true if we have valid data in BrowseData.
  */
  bool PathBrowser::GetNextFile()
  {
    if (INVALID_HANDLE_VALUE == dir_handle)
      return false; //invalid dir_handle
      bool ok = FindNextFile(dir_handle,&BrowseData);
		if (!ok) {
        FindClose(dir_handle);
	     dir_handle = INVALID_HANDLE_VALUE;
		}
		return ok;
  }

  /*
   This just gets the next file that matches the suffix.
  */
  const char * PathBrowser::next()
  {
	 bool first = false;
    do {
      if (INVALID_HANDLE_VALUE == dir_handle) {
		  if (! GetNextDir())
		 	 return 0; //no more directories
		  first = INVALID_HANDLE_VALUE != dir_handle; //FindFirstFile fills BrowseData.
		}
		while (first || GetNextFile()) {
			first = false;
			ParmString name = BrowseData.cFileName;
			if ( "."  == name || ".." == name )
				 continue; //special directories
			path = dir;
			if (path.back() != '/') path += '/';
			path += name;
			return path.c_str();

		 } ;
	 } while (true);
  }
#else
//Unix version
  PathBrowser::PathBrowser(const StringList & sl, const char * suf)
    : dir_handle(0)
  {
    els = sl.elements();
    suffix = suf;
  }

  PathBrowser::~PathBrowser() 
  {
    delete els;
    if (dir_handle) closedir((DIR *)dir_handle);
  }

  const char * PathBrowser::next()
  {
    if (dir_handle == 0) goto get_next_dir;
  begin: {
      struct dirent * entry = readdir((DIR *)dir_handle);
      if (entry == 0) goto try_again;
      const char * name = entry->d_name;
      unsigned name_len = strlen(name);
      if (suffix.size() != 0 && 
          !(name_len > suffix.size() 
            && memcmp(name + name_len - suffix.size(), suffix.str(), suffix.size()) == 0))
        goto begin;
      path = dir;
      if (path.back() != '/') path += '/';
      path += name;
    }
    return path.c_str();
  try_again:
    closedir((DIR *)dir_handle);
    dir_handle = 0;
  get_next_dir:
    dir = els->next();
    if (!dir) return 0;
    dir_handle = opendir(dir);
    if (dir_handle == 0) goto try_again;
    goto begin;
  }
#endif
}