{ This include file contains all the helper dialogs of wbibpatt }

type
  PSelectTypesDlg = ^TSelectTypesDlg;
  TSelectTypesDlg = object(TBasicDialog)
    FieldList:  PString;
    Negate:     PBoolean;
    constructor init(AParent: PWindowsObject; AFieldList: PString;
                     ANegate: PBoolean);
    procedure   SetupWindow; virtual;
    procedure   AllBtn(var Msg: TMessage);   virtual id_first+dl_SelectionListAll;
    procedure   ClearBtn(var Msg: TMessage); virtual id_first+dl_SelectionListClear;
    procedure   ok(var Msg: TMessage);       virtual id_first+id_ok;
  end;

  PTaggedDlg = ^TTaggedDlg;
  TTaggedDlg = object(TBasicDialog)
    Negate: PBoolean;
    constructor init(AParent: PWindowsObject; ANegate: PBoolean);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_First+id_ok;
  end;

  PLogOperDlg = ^TLogOperDlg;
  TLogOperDlg = object(TBasicDialog)
    op: Pinteger;
    Negate: PBoolean;
    constructor init(AParent: PWindowsObject; Aop: Pinteger; Anegate: Pboolean);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PEditPattFieldDlg = ^TEditPattFieldDlg;
  TEditPattFieldDlg = object(TResizableDialog)
    EBox: PEditNoCr;
    Regexp, CaseSen, Negate: PBoolean;
    SFields,Pfield: PString;
    fields: PattFieldStr;
    constructor init(AParent: PWindowsObject; ARegexp,ACasesen,ANegate: PBoolean;
                ASFields,Afld: PString);
    procedure   FixControlPos; virtual;
    procedure   SetupWindow;   virtual;
    procedure   BibEnterIdle(var Msg: TMessage);virtual wm_first+bib_EnterIdle;
    procedure   ChangeField(var Msg: TMessage); virtual id_First+dl_EditPattFieldChange;
    procedure   SaveRegs(var Msg: TMessage);    virtual id_first+dl_EditFieldSav;
    procedure   LoadRegs(var Msg: TMessage);    virtual id_first+dl_EditFieldRcl;
    procedure   CutBtn(var Msg: TMessage);      virtual id_first+dl_EditFieldCutBtn;
    procedure   CopyBtn(var Msg: TMessage);     virtual id_first+dl_EditFieldCopyBtn;
    procedure   PasteBtn(var Msg: TMessage);    virtual id_first+dl_EditFieldPasteBtn;
    procedure   UndoBtn(var Msg: TMessage);     virtual id_first+dl_EditFieldUndoBtn;
    function    CanClose: boolean; virtual;
    procedure   ok(var Msg: TMessage);          virtual id_first+id_ok;
  end;


{ TSelectTypes methods }

constructor TSelectTypesDlg.init(AParent: PWindowsObject; AFieldList: PString;
                                 ANegate: PBoolean);
begin
  TBasicDialog.Init(AParent,PChar(rc_SelectTypesDlg));
  FieldList:=AFieldList;
  Negate:=ANegate;
end;

procedure TSelectTypesDlg.SetupWindow;
var
  i: integer;
  F: array[0..255] of char;
begin
  TBasicDialog.SetupWindow;
  for i:=1 to NumberOfTypes+1 do
  begin
    StrPCopy(F,TypeEntry^[i]);
    SendDlgItemMsg(dl_SelectionListLBox,lb_AddString,0,longint(@F));
    if Pos(Chr(i),FieldList^)>0 then
      SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),i-1);
  end;
  if Negate^ then CheckDlgButton(HWindow,dl_SelectTypesInv,bf_Checked)
  else CheckDlgButton(HWindow,dl_SelectTypesInv,bf_Unchecked);
  InitPos;
end;

procedure TSelectTypesDlg.AllBtn(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),-1);
end;

procedure TSelectTypesDlg.ClearBtn(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(false),-1);
end;

procedure TSelectTypesDlg.ok(var Msg: TMessage);
var
  SelectionBuf: array[1..MaxField+1] of integer;
  Nselected,i: integer;
begin
  if not CanClose then Exit;
  FillChar(SelectionBuf,sizeof(SelectionBuf),0);
  NSelected:=SendDlgItemMsg(dl_SelectionListLBox,lb_GetSelItems,NumberOfTypes+1,
    Longint(@SelectionBuf));
  if (NSelected=lb_err) or (NSelected=0) then
    EndDlg(id_Cancel)
  else begin
    FieldList^:='';
    for i:=1 to NSelected do FieldList^:=FieldList^+Chr(ord(SelectionBuf[i]+1));
    Negate^:=IsDlgButtonChecked(HWindow,dl_SelectTypesInv)=bf_Checked;
    EndDlg(id_ok);
  end;
end;                       { TSelectFieldsDlg.ok }

{ TTaggedDlg methods }

constructor TTaggedDlg.init(AParent: PWindowsObject; ANegate: PBoolean);
begin
  TBasicDialog.init(AParent,Pchar(rc_TaggedDlg));
  Negate:=ANegate;
end;

procedure TTaggedDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow;
  if Negate^ then
  begin
    CheckDlgButton(HWindow,dl_TagDlgUnTagged,bf_Checked);
    CheckDlgButton(HWindow,dl_TagDlgTagged,bf_UnChecked);
  end else
  begin
    CheckDlgButton(HWindow,dl_TagDlgUnTagged,bf_UnChecked);
    CheckDlgButton(HWindow,dl_TagDlgTagged,bf_Checked);
  end;
end;

procedure TTaggedDlg.ok(var Msg: TMessage);
begin
  if not CanClose then Exit;
  Negate^:=IsDlgButtonChecked(HWindow,dl_TagDlgUnTagged)=bf_Checked;
  EndDlg(id_ok);
end;

{ TLogOperDlg methods }

constructor TLogOperDlg.init(AParent: PWindowsObject; Aop: Pinteger;
                             Anegate: Pboolean);
begin
  TBasicDialog.init(AParent,PChar(rc_PattLogOperDlg));
  Negate:=ANegate;
  op:=Aop;
end;

procedure TLogOperDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow;
  if op^=Patt_AND then
  begin
    CheckDlgButton(HWindow,dl_PattLogOperAND,bf_Checked);
    CheckDlgButton(HWindow,dl_PattLogOperOR,bf_UnChecked);
  end else
  begin
    CheckDlgButton(HWindow,dl_PattLogOperAND,bf_UnChecked);
    CheckDlgButton(HWindow,dl_PattLogOperOR,bf_Checked);
  end;
  if Negate^ then CheckDlgButton(HWindow,dl_PattLogOperInv,bf_Checked)
  else CheckDlgButton(HWindow,dl_PattLogOperInv,bf_Unchecked);
  InitPos;
end;

procedure TLogOperDlg.ok(var Msg: TMessage);
begin
  if not CanClose then Exit;
  if IsDlgButtonChecked(HWindow,dl_PattLogOperAND)=bf_Checked then
    op^:=Patt_AND
  else
    op^:=Patt_OR;
  Negate^:=IsDlgButtonChecked(HWindow,dl_PattLogOperInv)=bf_Checked;
  EndDlg(id_ok);
end;

{ TEditPattFieldDlg methods }

constructor TEditPattFieldDlg.init(AParent: PWindowsObject;
            ARegexp,ACasesen,ANegate: PBoolean; ASFields,Afld: PString);
begin
  TResizableDialog.init(AParent,PChar(rc_EditPattFieldDlg),@PattFieldSize);

  New(EBox,InitResource(@Self,dl_EditFieldEBox,256,[]));
  Regexp:=ARegexp; CaseSen:=ACaseSen; Negate:=ANegate;
  SFields:=ASFields;
  Fields:=SFields^;
  PField:=Afld;
end;                       { TEditPattFieldDlg.init }

procedure TEditPattFieldDlg.BibEnterIdle(var Msg: TMessage);
var
  CurSelection: Longint;
  IsSelected: boolean;
begin
  CurSelection:=SendDlgItemMsg(dl_EditFieldEBox,em_GetSel,0,0);
  IsSelected:=LoWord(CurSelection)<>HiWord(CurSelection);
  EnableWindow(GetItemHandle(dl_EditFieldCutBtn),IsSelected);
  EnableWindow(GetItemHandle(dl_EditFieldCopyBtn),IsSelected);
  EnableWindow(GetItemHandle(dl_EditFieldUndoBtn),EBox^.CanUndo);
  EnableWindow(GetItemHandle(dl_EditFieldPasteBtn),
                           IsClipboardFormatAvailable(cf_Text));
end;

procedure TEditPattFieldDlg.FixControlPos;
begin
  NewControl(dl_EditFieldCutBtn,  RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldCopyBtn, RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldPasteBtn,RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldUndoBtn, RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldCapBtn,  RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldSav,     RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldRcl,     RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_Cancel,           RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_ok,               RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);

  NewControl(dl_EditFieldCase,    RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldRegExp,  RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditPattFieldInv, RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);

  NewControl(dl_EditPattFieldChange,RelTo_Right,RelTo_Size, RelTo_Top,RelTo_Size);
  NewControl(dl_EditPattFieldFields,RelTo_Left, RelTo_Right,RelTo_Top,RelTo_Size);
  NewControl(dl_EditFieldEBox,      RelTo_Left, RelTo_Right,RelTo_Top,RelTo_Bottom);
end;                         { TEditPattField.FixControlPos }

procedure TEditPattFieldDlg.SetupWindow;
var
  F: array[0..255] of char;
begin
  TResizableDialog.SetupWindow;
  DisableSysMinimize;
  InitPos;

  with Fonts^[FieldEditFont] do
  begin
    if not Initialized then
    begin
      Font:=CreateFontIndirect(Logfont);
      Initialized:=true;
    end;
    SendMessage(EBox^.HWindow,wm_SetFont,Font,1);
  end;

  StrPCopy(F,PField^); SetWindowText(EBox^.HWindow,F);
  SendDlgItemMsg(dl_EditFieldEBox,em_LimitText,255,0);
  if RegExp^ then CheckDlgButton(HWindow,dl_EditFieldRegExp,bf_Checked)
  else CheckDlgButton(HWindow,dl_EditFieldRegExp,bf_Unchecked);
  if CaseSen^ then CheckDlgButton(HWindow,dl_EditFieldCase,bf_Checked)
  else CheckDlgButton(HWindow,dl_EditFieldCase,bf_Unchecked);
  if Negate^ then CheckDlgButton(HWindow,dl_EditPattFieldInv,bf_Checked)
  else CheckDlgButton(HWindow,dl_EditPattFieldInv,bf_Unchecked);
  UploadFieldList(Fields,GetItemHandle(dl_EditPattFieldFields),Nil);
end;                        { TEditPattFieldDlg.SetupWindow }

procedure TEditPattFieldDlg.ChangeField(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PSearchFieldsDlg,
            Init(@Self,@Fields)))=id_ok then
              UploadFieldList(Fields,GetItemHandle(dl_EditPattFieldFields),Nil);
end;                           { TEditPattFieldDlg.ChangeField }

procedure TEditPattFieldDlg.SaveRegs(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PRegistersDlg,init(@Self,true,EBox)));
  SetFocus(EBox^.HWindow);
end;

procedure TEditPattFieldDlg.LoadRegs(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PRegistersDlg,init(@Self,false,EBox)));
  SetFocus(EBox^.HWindow);
end;

procedure TEditPattFieldDlg.CutBtn(var Msg: TMessage);
begin
  EBox^.Cut; SetFocus(EBox^.HWindow);
end;

procedure TEditPattFieldDlg.CopyBtn(var Msg: TMessage);
begin
  EBox^.Copy; SetFocus(EBox^.HWindow);
end;

procedure TEditPattFieldDlg.PasteBtn(var Msg: TMessage);
begin
  EBox^.paste; SetFocus(EBox^.HWindow);
end;

procedure TEditPattFieldDlg.UndoBtn(var Msg: TMessage);
begin
  EBox^.Undo; SetFocus(EBox^.HWindow);
end;

function TEditPattFieldDlg.CanClose: boolean;
var
  F: array[0..255] of char;
  icode: integer;
begin
  if TResizableDialog.CanClose then
  begin
    if IsDlgButtonChecked(HWindow,dl_EditFieldRegexp)=bf_Checked then
    begin
      GetDlgItemText(HWindow,dl_EditFieldEBox,F,255);
      if not Is_Valid_Regexp(StrPas(F), icode) then
      begin
        case icode of
              PATTERN_ESC   : ErrorMessageRC(Str_RegexpErrorESC,'');
              PATTERN_RANGE : ErrorMessageRC(Str_RegexpErrorRange,'');
              PATTERN_CLOSE : ErrorMessageRC(Str_RegexpErrorClose,'');
              PATTERN_EMPTY : ErrorMessageRC(Str_RegexpErrorEmpty,'');
        end;
        CanClose:=false;
      end else CanClose:=true;
    end else CanClose:=true;
  end else CanClose:=false;
end;                           { TEditPattFieldDlg.CanClose }

procedure TEditPattFieldDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
  AuthorAll: boolean;
  i: integer;
begin
  if not CanClose then Exit;
  GetWindowText(EBox^.HWindow,F,255);
  PField^:=StrPas(F);
  RegExp^:=IsDlgButtonChecked(HWindow,dl_EditFieldRegexp)=bf_Checked;
  CaseSen^:=IsDlgButtonChecked(HWindow,dl_EditFieldCase)=bf_Checked;
  Negate^:=IsDlgButtonChecked(HWindow,dl_EditPattFieldInv)=bf_Checked;
  SFields^:=Fields;
  AuthorAll:=true;
  for i:=1 to length(Fields) do
  begin
    if (fields[i]<>#0) and (Ord(fields[i])<=fieldlast) then
            AuthorAll:=AuthorAll and FieldParams^[Ord(fields[i])].Authorlike
    else if (fields[i]<>#0) and (Ord(fields[i])=StringIndex) then
            AuthorAll:=false;
  end;
  if Prog7bit then SConv27Bit(PField^,AuthorAll)
  else if Prog8bit then SConv28Bit(PField^,AuthorAll);
  EndDlg(id_OK);
end;                          { TEditPattFieldDlg.ok }
