/*
 * Created on Mar 19, 2003
 *
 * @author henkel@cs.colorado.edu
 * 
 */
package bibtex.parser;

import java.io.IOException;
import java.io.Reader;

/**
 * initial implementation - inefficient!
 * 
 * @author henkel
 */
final class LookAheadReader {

	public LookAheadReader(Reader input) throws IOException{
		this.input = input;
		this.currentChar = input.read();
		this.eof = false;
		this.line = 1; this.column=0;
	}

	private final Reader input;
	private boolean eof;
	private int currentChar;
	private int line, column;

	public void step() throws IOException{
		if(this.eof) return;
		currentChar=input.read();
		if(currentChar=='\n'){
			line++;column=0;
		} else {
			column++;
		}
		if(currentChar==-1){
			input.close();
			this.eof=true;
		}
	}

	public char getCurrent(){
		// assert(currentChar>=0);
		return (char)currentChar;
	}
	
	
	public boolean eof(){
		return this.eof;
	}
	
	public int getLine(){
		return line;
	}
	public int getColumn(){
		return column;
	}

}
