import java.io.*; import java.sql.*;

/*
 * InstallConnection.java
 *
 */

/**
 *
 * Basicly this class is a "light-version" of the SlideConnection.java.
 * It provides access/connection to the data base engine during installation
 * and setup. Some irritating error warnings using the standard SlideConnection
 * make this class necessary. Maybe some more OOP praxis knowledge would have 
 * led to some more elegant construct avoiding some redundant code in
 * these two classes.
 *
 * @author  Olle Nebendahl
 */


public class InstallConnection
{
    static Connection cn;
    static Statement    ust;
    static Statement    qst;
    
    static boolean gotConnection=false;
    
    static PreparedStatement prepStInt(PreparedStatement pst,int i)
    {
        try
        {
            pst.setInt(1,i);     
        }
        catch(SQLException e)
        { 
            System.out.println(e); 
            System.out.println("PreparedStatement prepStIntInt("+pst+","+i+")");
        }
        return pst;
    }
    
    
    static PreparedStatement prepStIntInt(PreparedStatement pst,int i, int j)
    {
        try
        {
            pst.setInt(1,i);     
            pst.setInt(2,j);
        }
        catch(SQLException e)
        { 
            System.out.println(e); 
            System.out.println("PreparedStatement prepStIntInt("+pst+","+i+","+j+")");
        }
        return pst;
    }

    static PreparedStatement prepStStrInt(PreparedStatement pst,String s,int i)
    {
        try
        {
            pst.setString(1,s);     
            pst.setInt(2,i);
        }
        catch(SQLException e)
        { 
            System.out.println(e); 
            System.out.println("PreparedStatement prepStStringInt("+pst+","+s+","+i+")");
        }
        return pst;
    }
    
    static void doSqlUpdate(PreparedStatement pst)
    {
        try 
        {
            pst.executeUpdate();
        } 
        catch( SQLException ex )
        {  System.out.println( ex ); System.out.println("static void soSqlUpdate(PreparedStatement "+pst+")");  }
    }
    
    
    static InstallConnection tryConnection(String DBDriverName, String DBURL, String DBUser, String DBUserPwd)
    {
        InstallConnection testConnection=new InstallConnection(DBDriverName, DBURL, DBUser, DBUserPwd);
        if(!testConnection.gotConnection)return null;
        return testConnection;
    }
 
 
    InstallConnection(String DBDriverName, String DBURL, String DBUser, String DBUserPwd)
    {
        try
        {
           Class.forName( DBDriverName ).newInstance();
           cn = DriverManager.getConnection( DBURL, DBUser, DBUserPwd );
           gotConnection=true;
           prepareStatements();
        }
        catch(Exception e){ System.out.println(e); System.out.println("InstallConnection()");System.exit(1);};
    }
  
    private static void prepareStatements() throws SQLException
    {
        ust = cn.createStatement();
        qst = cn.createStatement();
    }
      
    protected void finalize() throws Throwable {
    try {
            qst.close();
            ust.close();
            cn.close();
        } finally {
        super.finalize();
        }
    } 


   
   static ResultSet doSqlQuery(String statementString) throws SQLException
   {
                 ResultSet  rs = qst.executeQuery( statementString );
                 return rs;
   }
   
   static ResultSet doSqlQuery(PreparedStatement pst) throws SQLException
   {
                 ResultSet  rs = pst.executeQuery();
                 return rs;
   }
   
   
   static String[] getSqlQuery1stCol(PreparedStatement pst)
   {
     OLL liste=new OLL();
     String s;
     try
     {
         ResultSet rs = doSqlQuery(pst);
         ResultSetMetaData rsmd = rs.getMetaData();
         while( rs.next() )
         {
                  s=rs.getString(1);
                  if(Constants.DBG)System.out.println(s);
                  liste.add(s);
         }
         rs.close();
     }
     catch( SQLException ex )
     {   
         System.out.println( ex );   
         System.out.println("getSqlQuery1stCol(String statementString)");
     }
     return liste.asStringArray();   
   }
   
   static int[] getSqlQuery1stColAsInt(PreparedStatement pst)
   {
     ILL liste= new ILL();
     int s;
     try
     {
         ResultSet rs = doSqlQuery(pst);
         ResultSetMetaData rsmd = rs.getMetaData();
         while( rs.next() )
         {
                  s=rs.getInt(1);
                  liste.add(s);
         }
         rs.close();
     }
     catch( SQLException ex )
     {   
         System.out.println( ex );   
         System.out.println("getSqlQuery1stColAsInt(PreparedStatement pst)");
     }
     return liste.asArray(Help.HEAD_FIRST);   
   }

   static int[] getSqlQuery1stColAsInt(String statementString)
   {
     ILL liste=null;
     int s;
     try
     {
         ResultSet rs = doSqlQuery(statementString);
         ResultSetMetaData rsmd = rs.getMetaData();
         while( rs.next() )
         {
                  s=rs.getInt(1);
                  liste.add(s);
         }
         rs.close();
     }
     catch( SQLException ex )
     {   
         System.out.println( ex );   
         System.out.println("getSqlQuery1stCol(String statementString)");
     }
     return liste.asArray(Help.HEAD_FIRST);   
   }
   
   
   static String[] getSqlQuery1stCol(String statementString)
   {
     OLL liste=null;
     String s;
     try
     {
         ResultSet rs = doSqlQuery(statementString);
         ResultSetMetaData rsmd = rs.getMetaData();
         while( rs.next() )
         {
                  s=rs.getString(1);
                  liste.add(s);
         }
         rs.close();
     }
     catch( SQLException ex )
     {   
         System.out.println( ex );   
         System.out.println("getSqlQuery1stCol(String statementString)");
     }
        
     return liste.asStringArray();   
       
   }
   
   static Object[] getSqlQuery1stRow(String statementString)
   {
     return (Object[])getSqlQuery(statementString,true).getFirst();
   }
   
   static Object[] getSqlQuery1stRow(PreparedStatement pst)
   {
     return (Object[])getSqlQuery(pst,true).getFirst();
   }
   

   static OLL getSqlQuery(String statementString)
   {
     return getSqlQuery(statementString,false);
   }
   
   static OLL  getSqlQuery(PreparedStatement pst,boolean specialTask)
   {
     OLL objectList=new OLL();
     try
     {
         ResultSet rs = doSqlQuery(pst);
         rs2OLL(rs,objectList,specialTask);
     }
     catch( SQLException ex )
     {  System.out.println( ex ); System.out.println( "getSqlQuery(PreparedStatement pst,boolean specialTask)"+(3/(2-2)) ); System.exit(2);  }//
        
     return objectList;   
   }
   
   
   static OLL  getSqlQuery(String statementString,boolean specialTask)
   {
     OLL objectList=new OLL();
     try
     {
         ResultSet rs = doSqlQuery(statementString);
         rs2OLL(rs,objectList,specialTask);
     }
     catch( SQLException ex )
     {  System.out.println( ex ); System.out.println( "getSqlQuery(String statementString,boolean specialTask)"+(3/(2-2)) ); System.exit(3);  }//
        
     return objectList;   
   }
   
     
   static void rs2OLL(ResultSet rs, OLL oL, boolean specialTask)throws SQLException
   {
         ResultSetMetaData rsmd = rs.getMetaData();
         int n,t;
                 
         int nmax = rsmd.getColumnCount();
         if(Constants.DBG)System.out.println(nmax);
         
         Object[] result;

         while( rs.next() )
         {
            if(Constants.DBG)System.out.println("*");
            result = new Object[nmax];
            for( n=1 ; n<=nmax ; n++ )
            { 
              t=rsmd.getColumnType(n);
              switch(t)
              {
                case java.sql.Types.DATE:
                //case java.sql.Types.TIMESTAMP:
                case java.sql.Types.TIME:
                  result[n-1]=rs.getDate(n);
                  break;
                case java.sql.Types.TINYINT:
                case java.sql.Types.SMALLINT:
                case java.sql.Types.INTEGER:
                  result[n-1]=new Integer(rs.getInt(n));
                  break;
                case java.sql.Types.BIGINT:  
                  result[n-1]=new Long(rs.getLong(n));
                  break;
                case java.sql.Types.CHAR:
                case java.sql.Types.VARCHAR:
                case java.sql.Types.LONGVARCHAR:
                default:
                  result[n-1]=rs.getString(n);
                  //System.out.print(n);
                  //System.out.println(result[n-1]);
              }
            }
            oL.add(result);
            if(specialTask)break;
         }
         rs.close();
   }
   

   
   
   static void doSqlUpdate(String statementString)
   {
        String[] statements=statementString.trim().split(";");
        int i=0;
             try 
             { 
                 while(i<statements.length)
                   ust.executeUpdate( statements[i++]);
             }
             catch( SQLException ex )
             {  System.out.println( ex );  System.out.println("doSqlUpdate(String statementString)"); System.exit(3);}
   }
   
   
   
}
