import java.util.*;
import java.io.*;
import javax.swing.*;
/*
 * PackagePaths.java
 *
 * Created on 15. Dezember 2005, 8:43
 */

/**
 *
 * This classed is used as a static instance providing the paths
 * which are preferred to search for packages.
 *
 * @author  Olle Nebendahl
 */

class PackagePaths 
{

    static final String INITFILENAME = "PackagePaths.ini";

    
    static
    {
        loadThem();
    }
    
    
    private static DefaultListModel packagePaths;
    
    public static DefaultListModel getThem() { return packagePaths; }
    
    
    public static synchronized void update(DefaultListModel updateList)
    {
        packagePaths = updateList;
        saveThem();
    }
    
    
    private static synchronized void loadThem()
    {
        try
        {
            File file=new File(INITFILENAME);
            packagePaths = new DefaultListModel();
            if(file.exists())
            {
                BufferedReader in = new BufferedReader(new FileReader(INITFILENAME));
            
                StringBuffer result=new StringBuffer();
    
                String zeile;
                zeile=in.readLine();
                zeile=in.readLine();
                
                while(zeile!=null)
                {
                    file=new File(zeile);
                    if(file.exists())packagePaths.addElement(file);
                    zeile=in.readLine();
                }
                in.close();
            }else saveThem();
        }
        catch(java.io.IOException e)
        { 
            Logger.logSevere("PackagePaths.loadThem:" + e);
        };
    }

    static synchronized void saveThem()
    {
        try
        {
            BufferedWriter out = new BufferedWriter(new FileWriter(INITFILENAME));
            out.write("It is unwise to alter this file unless You know, what You do.");
            out.newLine();
            String zeile;
        
            int packagePathsSize=packagePaths.getSize();
            int i = 0;
            while(i<packagePathsSize)
            {
                zeile=((File)packagePaths.get(i++)).toString();
                out.write(zeile,0,zeile.length());
                out.newLine();
            }
            out.close();
        }
        catch(java.io.IOException e)
        {
            Logger.logSevere("PackagePaths.saveThem: "+e);
        };
    }
    
    static String search(String s)
    {
        if((new File(s)).isFile())return s;
        
        int packagePathsSize=packagePaths.getSize();
        int i = 0;
        File file;
        while(i<packagePathsSize)
        {
            file=new File((File)packagePaths.get(i++),s);
            if(file.isFile())return file.toString();
        }
        return null;
    }

    public static void main(String args[]) 
    {
        System.out.println(search(args[0]));
    }
    
    
}
