#!/bin/bash
# copac-clean.sh
# version 0.8
# 28.08.2015
# Copyright (C) Guido Milanese guido.milanese@unicatt.it
# requires copac-clean.sno
# requires xclip: xclip copies to the clipboard
# checks if xclip and snobol4 are installed
  if ! type xclip > /dev/null 2>&1; then
	echo "xclip is not installed. Exiting.";
    exit;
  elif ! type snobol4 > /dev/null 2>&1; then
	echo "snobol4 is not installed. Exiting.";
    exit;
  fi 
	rm -f copactmpfile # if the case
	CCDIR=$(dirname $(which copac-clean.sh))
	cd $CCDIR 			# important for desktop launcher!	
	snobol4 -b $CCDIR/copac-clean.sno  >copactmpfile
	cat copactmpfile | xclip -selection c -i
	rm -f copactmpfile
