/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.multiunpacker;

import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.XPackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.core.io.FileSpanningInputStream;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Logger;

public class MultiVolumeFileUnpacker
extends FileUnpacker {
    private final FileSpanningInputStream volumes;
    private static final Logger logger = Logger.getLogger(MultiVolumeFileUnpacker.class.getName());

    public MultiVolumeFileUnpacker(FileSpanningInputStream volumes, Cancellable cancellable, FileQueue queue) {
        super(cancellable, queue);
        this.volumes = volumes;
    }

    @Override
    public void unpack(PackFile file, ObjectInputStream packInputStream, File target) throws IOException, InstallerException {
        long position = ((XPackFile)file).getArchiveFilePosition();
        if (this.volumes.getFilePointer() < position) {
            logger.fine("Skipping bytes to get to file " + target.getName() + " (" + this.volumes.getFilePointer() + "<" + position + ") target is: " + (position - this.volumes.getFilePointer()));
            this.skip(position - this.volumes.getFilePointer());
        }
        if (this.volumes.getFilePointer() > position) {
            throw new IOException("Error, can't access file in pack.");
        }
        this.copy(file, this.volumes, target);
    }

    protected void skip(long bytes) throws IOException {
        long skipped = this.volumes.skip(bytes);
        if (skipped != bytes) {
            throw new IOException("Expected to skip: " + bytes + " in stream but skipped: " + skipped);
        }
    }
}

