/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.path.PathInputPanel;
import com.izforge.izpack.panels.target.TargetPanelAutomation;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import java.io.File;

public class TargetPanel
extends PathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;

    public TargetPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, resources, log);
    }

    @Override
    public void panelActivate() {
        String path = TargetPanelHelper.getPath(this.installData);
        if (path != null) {
            this.pathSelectionPanel.setPath(path);
        }
        super.panelActivate();
    }

    @Override
    public void saveData() {
        String path = this.pathSelectionPanel.getPath();
        this.installData.setInstallPath(path);
    }

    @Override
    public boolean isValidated() {
        boolean result = false;
        File targetPathFile = new File(this.getPath());
        if (TargetPanelHelper.isIncompatibleInstallation(this.getPath(), this.installData.getInfo().isReadInstallationInformation())) {
            this.emitError(this.getString("installer.error"), this.getString("TargetPanel.incompatibleInstallation"));
        } else {
            if (targetPathFile.isFile()) {
                this.emitError(this.getString("installer.error"), this.getString(this.getI18nStringForClass("isfile", "PathInputPanel")));
                return false;
            }
            if (super.isValidated()) {
                String path = this.getPath();
                this.installData.setInstallPath(path);
                result = true;
            }
        }
        return result;
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        new TargetPanelAutomation().createInstallationRecord(this.installData, panelRoot);
    }

    @Override
    public String getSummaryBody() {
        return this.installData.getInstallPath();
    }
}

