FALSE=0
TRUE=-1


import ConfigParser, os, string, sys, gettext

import utils

gettext.bindtextdomain('gtex-letter', '/usr/share/locale')
gettext.textdomain('gtex-letter')
_ = gettext.gettext

from main import GTEX_LETTER_VERSION

advertisestr = "%%" + _("This file was generated by gtex-letter version") + " " + GTEX_LETTER_VERSION + ".\n"

class gtex_letter_config:
	def __init__ (self, rc_file, nogui=FALSE, noshow=FALSE, \
	              splash=TRUE, printit=FALSE, guilevel=FALSE, \
		      guessformat='', guesspath='', quite_latex=None, prg_dir=''):

		self.prg_dir = prg_dir
		self.rc_filename = rc_file
		self.init_config()
		
		self.mycountry = utils.rc_set('MAIN', "mycountry", self.rc)
		self.myeditor = utils.rc_set('MAIN', "myeditor", self.rc)
		self.mylatex = utils.rc_set('MAIN', "mylatex", self.rc)
		self.myxdvi = utils.rc_set('MAIN', "myxdvi", self.rc)
		self.mydvips = utils.rc_set('MAIN', "mydvips", self.rc)
		self.mydvipdf = utils.rc_set('MAIN', "mydvipdf", self.rc)
		self.myprintcommand = utils.rc_set('MAIN', "myprintcommand", self.rc)
		self.dateformat = utils.rc_set('MAIN', "dateformat", self.rc)

		self.lettertype = utils.rc_set('MAIN', 'lettertype', self.rc)
		self.init_advertise()

		self.filename_guess_format = guessformat
		if not self.filename_guess_format: 
			self.filename_guess_format = utils.rc_set('MAIN', 'filename_guess_format', self.rc)
		self.filename_guess_path = guesspath
		if not self.filename_guess_path: 
			self.filename_guess_path = utils.rc_set('MAIN', "filename_guess_path", self.rc)
		if self.filename_guess_path[0] == '~':
			self.filename_guess_path = os.environ['HOME'] + self.filename_guess_path[1:]


		if quite_latex==None:
			quite_latex = utils.rc_set('MAIN', "quite_latex", self.rc)
		self.init_latex_output(quite_latex)

		self.texcommands=[]
		self.init_mult_liners(self.texcommands, 'texcommands', 'COMMANDS')

		self.addressformats=[]
		self.init_mult_liners(self.addressformats, 'addressformat', 'ADDRESSFORMAT')

		self.addressbooks = []
		self.init_addressbooks('addressbook', self.addressbooks)
		
		
		self.addressbook_columns = utils.rc_set('MAIN', \
					"addressbook_columns", self.rc)
		self.addressbook_column_widths = utils.rc_set('MAIN', \
					"addressbook_column_widths", self.rc)
		
		self.headerdefaults = []
		self.init_default_texts('header_defaults', self.headerdefaults)
		self.check_headerdefaults()
						
		self.openingdefaults = []
		self.init_default_texts('opening_defaults', self.openingdefaults)
		
		self.closingdefaults = []
		self.init_default_texts('closing_defaults' ,self.closingdefaults)
		

		self.init_guilevel(guilevel)
		
		self.nogui = nogui
		self.noshow = noshow
		self.printit = printit
		self.splash = splash
		
			
	def init_config(self):
		self.rc=ConfigParser.ConfigParser()
		file = utils.get_path(self.rc_filename, os.environ['HOME'], self.prg_dir)
		if not os.path.isfile(file):
			print _("Error: Could not find rc-file:"), self.rc_filename
		self.rc.read(file)
	
	def init_addressbooks(self, rc_key, texts):
		def_str = utils.rc_set('MAIN', rc_key, self.rc)
		if def_str:
			num = 1
			while num >0:
				num = string.find(def_str, ";")
				if num >0:
					tmpstr=utils.stripmarks(string.strip(def_str[0:num]))
					texts.append (tmpstr)
					def_str= def_str[num+2:]
				else:
					tmpstr=utils.stripmarks(string.strip(def_str))
					texts.append(tmpstr)

	def init_mult_liners(self, arg, key, section):
		i=0
		while 1:
			nkey = key + "." + str(i)
			if nkey in self.rc.options(section):
				arg.append(utils.rc_set(section, nkey, self.rc))
				i = i + 1
			else:
				break
		if arg == []:
			print _("Error: Could not retrieve '%s' from rc-file.") % key
			sys.exit()

	def init_advertise(self):
		text = utils.rc_set('MAIN', 'advertise', self.rc)
		text = utils.switch_yesno(text, default = TRUE)
		if text:
			self.advertisestr = advertisestr
		else:
			self.advertisestr = ""

	def init_latex_output(self, quite_latex):
		quite_latex = utils.switch_yesno(quite_latex, default = FALSE)
		if quite_latex:
			self.latex_output = '>/dev/null'
		else:
			self.latex_output = ''

	def init_default_texts(self, rc_key, texts):
		def_str = utils.rc_set('MAIN', rc_key, self.rc)
		def stripmarks(str):
			if str[0] == "'" or str[0] == "\"":
				str = str [1:]
			if str[-1] == "'" or str[-1] == "\"":
				str = str [:-1]
			return str
		if def_str:
			num = 1
			while num >0:
				num = string.find(def_str, ";")
				if num >0:
					tmpstr=stripmarks(string.strip(def_str[0:num]))
					texts.append (tmpstr)
					def_str= def_str[num+2:]
				else:
					tmpstr=stripmarks(string.strip(def_str))
					texts.append(tmpstr)

	def check_headerdefaults(self):
		for file in self.headerdefaults:
			if file[:4] <> '.tex': 
				file = file + '.tex' 
			file = utils.get_path(file, self.prg_dir)
			if file:
				if not os.path.isfile(file):
					print _('Error: Could not find header defaultfile:'), file
					sys.exit()

	def init_guilevel(self, guilevel):
		if not guilevel:
			guilevel = utils.rc_set('MAIN', "guilevel", self.rc)
		else:
			guilevel = string.lower(guilevel)
		self.guilevel = utils.set_guilevel(guilevel)
