import os, string

import utils, error, gettext

gettext.bindtextdomain('gtex-letter', '/usr/share/locale')
gettext.textdomain('gtex-letter')
_ = gettext.gettext

FALSE = 0
TRUE = -1

def appropriate_wd(cwd, newd):
	if cwd and newd and ( cwd <> newd ):
		if os.path.isdir(newd):
			os.chdir(newd)

def write_file (letter, rc):
	def mkup_text(text, letter=letter, rc=rc, address_counter = 0):
		while 1:
			start = string.find(text, "__")
			end = string.find(text, "__", start + 1)
			if start == -1:
				break
			key = text[start+2:end]
			if key == 'lettertype':
				text = string.replace(text, '__' + key + '__', rc.lettertype)
			if key == 'letter_address':
				text = string.replace(text, '__' + key + '__', letter.addresses[address_counter])
			if key == 'letter_opening':
				if letter.opening:
					text = string.replace(text, '__' + key + '__', utils.general_mkup_text(letter, letter.opening, rc, address_counter))
				else:
					text = ''
			if key == 'letter_subject':
				if letter.subject:
					text = string.replace(text, '__' + key + '__', letter.subject)
				else:
					text = ''
			if key == 'letter_contents':
				if letter.contents:
					text = string.replace(text, '__' + key + '__', letter.contents)
				else:
					text = ''
			if key == 'letter_closing':
				if letter.closing:
					text = string.replace(text, '__' + key + '__', utils.general_mkup_text(letter, letter.closing, rc))
				else:
					text = ''
			if key == 'letter_header':
				if letter.header:
					text = string.replace(text, '__' + key + '__', letter.header)
				else:
					text = ''
			else:
				break
		return text
		
	try:
		if letter.filename:
			try:
				if not os.path.exists(letter.path) and not letter.path == '':
					raise error.PathNotFound, letter.path
			except error.PathNotFound, path:
				print _("The provided path '%s' does not exist.") + " " + _("File not written.") % path
				raise error.LetterNotWritten, letter.filename

			olddir = os.getcwd()
			appropriate_wd(olddir, letter.path)
			try:
				file = open (utils.file_strip_path(letter.filename), 'w')
				if file:
					if rc.advertisestr:
						file.write(rc.advertisestr)

					def divide (text):
						adrs = []
						while 1:
							hit = string.find(text , '\n\\\\\n')
							if hit == -1:
								adrs.append(text)
								break	
							adrs.append(text[:hit+1])
							text = text[hit+4:]
						return adrs
					letter.addresses = divide(letter.address_slashes)

					loop = FALSE
					addr_counter = 0
					i = 0

					while 1:
						line = rc.texcommands[i]
						file.write( mkup_text(line, address_counter = addr_counter)+ '\n')
						if line[:14] == '\\begin{letter}':
							loop = i
						if line[:12] == '\end{letter}':
							addr_counter = addr_counter + 1
							if addr_counter >= len(letter.addresses):
								loop = FALSE
							else:
								i = loop - 1
						i = i + 1
						if i > len(rc.texcommands)-1:
							break

					file.close ()	
				else:
					raise IOError, None, 'Unknown reason'
			except IOError, (no, name):
				print "Could not write file '%s'. %s." % (letter.filename, name)
				raise error.LetterNotWritten, letter.filename
		
			appropriate_wd(letter.path, olddir)

			return 0
		
		else:
			try:
				raise IOError, None, 'Filename not set.'
			except IOError, (no, name):
				print "'%s'. File not written." % name
				raise error.LetterNotWritten, letter.filename

	except error.LetterNotWritten, file:
		print "Letter '%s' not written." % file
		return 1

def rm_latex_files(letter):
	def rm_ifsuffix (file, suffix):
		filename = file + "." + suffix
		if os.path.isfile(filename):
			os.remove(filename)
	olddir = os.getcwd()
	appropriate_wd(olddir, letter.path)
	if utils.file_strip_suffix(letter.filename):
		rm_ifsuffix(utils.file_strip_suffix(letter.filename), "log")
		rm_ifsuffix(utils.file_strip_suffix(letter.filename), "aux")
	appropriate_wd(letter.path, olddir)
	
def tex_latex(letter, rc):
	olddir = os.getcwd()
	appropriate_wd(olddir, letter.path)
	rm_latex_files(letter)
	os.system(utils.general_mkup_text(letter, rc.mylatex, rc) + " " + rc.latex_output)
	appropriate_wd(letter.path, olddir)
	
def tex_xdvi(letter, rc):
	olddir = os.getcwd()
	appropriate_wd(olddir, letter.path)
	os.system(utils.general_mkup_text(letter, rc.myxdvi, rc) \
		+ " " + rc.latex_output)
	appropriate_wd(letter.path, olddir)

def tex_pdf(letter, rc, event=None, data=None):
	olddir = os.getcwd()
	appropriate_wd(olddir, letter.path)
	os.system(utils.general_mkup_text(letter, rc.mydvipdf, rc) \
		+ " " + rc.latex_output)
	appropriate_wd(letter.path, olddir)

def tex_print(letter, rc, event=None, data=None):
	olddir = os.getcwd()
	appropriate_wd(olddir, letter.path)
	os.system(utils.general_mkup_text(letter, rc.mydvips, rc) \
		+ " " + rc.latex_output)
	os.system(utils.general_mkup_text(letter, rc.myprintcommand, rc))
	appropriate_wd(letter.path, olddir)

def tex_postscript(letter, rc, event=None, data=None):
	olddir = os.getcwd()
	appropriate_wd(olddir, letter.path)
	os.system(utils.general_mkup_text(letter, rc.mydvips, rc) \
		+ " " + rc.latex_output)
	appropriate_wd(letter.path, olddir)

def continue_editor(letter, rc, event=None, data=None):
	olddir = os.getcwd()
	appropriate_wd(olddir, letter.path)
	os.system(utils.general_mkup_text(letter, rc.myeditor, rc))
	appropriate_wd(letter.path, olddir)


