/* Environment.C
 *
 * The environment is the current set up of the page in terms of font type,
 * page number, and many other general numbers to keep track of.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include "Environment.h"
#include "Counter.h"
#include "Document.h"
#include "Font.h"
#include "Justify.h"
#include "Length.h"

Environment::Environment()
{
   // Same order as enumerator ParamTypes
   params[PCounter] = new Counter();
   params[PDocument] = new Document();
   params[PFont] = new Font();
   params[PJustify] = new Justify();
   params[PLength] = new Length();
}

Environment::~Environment()
{
   for(int x=0; x < LastType; x++)
      delete params[x];
}

Environment::Environment(Environment *e)
{
   for(int paramtype=0; paramtype < LastType; paramtype++)
      params[paramtype] = e->get_param(paramtype)->copy();
}

void Environment::revert(Environment *from)
{
   for(int paramtype=0; paramtype < LastType; paramtype++)
      params[paramtype]->revert(from->get_param(paramtype));
}

void Environment::set(int paramtype, int subtype, float value, char *replacestr)
{
   params[paramtype]->set(subtype, value, replacestr);
}

float Environment::get(int paramtype, int subtype, char *comparestr)
{
   return params[paramtype]->get(subtype, comparestr);
}

Param* Environment::get_param(int paramtype)
{
   return params[paramtype];
}
