/******************************/
/*                            */
/* midi.h                     */
/*                            */
/* Definition der Midi-Events */
/*                            */
/******************************/


/***************************/
/* Channel Voice Messages. */
/***************************/

#define MIDI_NOTE_OFF		(0x80)
#define MIDI_NOTE_ON		(0x90)
#define MIDI_POLY_AFTERTOUCH	(0xA0)
#define	MIDI_CTRL_CHANGE	(0xB0)
#define MIDI_PROG_CHANGE	(0xC0)
#define MIDI_CHNL_AFTERTOUCH	(0xD0)
#define MIDI_PITCH_BEND		(0xE0)

/********************/
/* System Messages. */
/********************/

#define MIDI_SYSTEM_MSG		(0xF0)

#define MIDI_SYSTEM_EXCLUSIVE	(0xF0)
#define MIDI_SONG_POSITION_PTR	(0xF2)
#define MIDI_SONG_SELECT	(0xF3)
#define MIDI_TUNE_REQUEST	(0xF6)
#define MIDI_EOX		(0xF7)
#define MIDI_FILE_META_EVENT    (0xFF)

/******************************/
/* System Real-Time Messages. */
/******************************/

#define MIDI_TIMING_CLOCK	(0xF8)
#define MIDI_START		(0xFA)
#define MIDI_CONTINUE		(0xFB)
#define MIDI_STOP		(0xFC)
#define MIDI_ACTIVE_SENSING	(0xFE)
#define MIDI_SYSTEM_RESET	(0xFF)

/*******************************/
/* MIDI file format constants. */
/*******************************/

#define MIDI_FILE_HEADER	"MThd"
#define MIDI_TRACK_HEADER	"MTrk"

/**************************/
/* MIDI file Meta-Events. */
/**************************/

#define MIDI_SEQUENCE_NUMBER	(0x00)
#define MIDI_TEXT_EVENT		(0x01)
#define MIDI_CHANNEL_PREFIX	(0x20)
#define MIDI_END_OF_TRACK	(0x2F)
#define MIDI_SET_TEMPO		(0x51)
#define MIDI_SMPTE_OFFSET	(0x54)
#define MIDI_TIME_SIGNATURE	(0x58)
#define MIDI_KEY_SIGNATURE	(0x59)
#define MIDI_SEQUENCER_SPECIFIC	(0x7F)

/******************************/
/* Specific Text Meta-Events. */
/******************************/

#define MIDI_COPYRIGHT_NOTICE	(0x02)
#define MIDI_TRACK_NAME		(0x03)
#define MIDI_INSTRUMENT_NAME	(0x04)
#define MIDI_LYRIC		(0x05)
#define MIDI_TEXT_MARKER	(0x06)
#define MIDI_CUE_POINT		(0x07)

#define MAJOR 0
#define MINOR 1

typedef struct header_struct {
	char MThd[5];
	unsigned int chunk_length;
	short int format, tracks, per_quarter;
} Header;

typedef struct track_str {
	char MTrk[5];
	int chunk_length;
} Track_Header;
