/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : slope.cc
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/

#include <stdlib.h>            // atoi
#include "beam.h"
#include "duration.h"
#include "notename.h"
#include "slope.h"
#include "init.h"
#include "staff.h"
#include "mpp.h"

/****************************************************************************
  class Slope
--*/

Slope::Slope( const char* name ) :
    Macro( name, "",  1 )
{
    ;// monitor << "Slope::Slope";
} 

Slope::~Slope()
{
    ;// monitor << "~Slope";
}

void Slope::execute( StringList& parameters, Staff& )
{
    ;// monitor << "Slope::execute" << flush;

    substitute = "";

    int slope = atoi( (const char*)parameters.top() );
#if 0
    InitiateBeam::slopeFactor = slope;
#else
    InitiateBeam::noteSkipFactor = slope;
#endif

    ;// monitor << slope << endl;
}
//-- class Slope //


/****************************************************************************
  class StemLength
--*/

StemLength::StemLength( const char* name ) :
    Macro( name, "",  1 )
{
    ;// monitor << "StemLength::StemLength";
} 

StemLength::~StemLength()
{
    ;// monitor << "~StemLength";
}

void StemLength::execute( StringList& parameters, Staff& )
{
    ;// monitor << "StemLength::execute" << flush;

    substitute = "";
    int stem = atoi( (const char*)parameters.top() );
    if ( stem )
        InitiateBeam::minimumStem = stem;
    else
        InitiateBeam::minimumStem = 4; //BEAM_NORMALSTEM;
    ;// monitor << stem << endl;
}
//-- class StemLength //


/****************************************************************************
  class Octavate
--*/
                               // why not merged with class Octave ?

Octavate::Octavate( const char* name ) :
    Macro( name, "",  1 )
{
    ;// monitor << "Octavate::Octavate";
} 

Octavate::~Octavate()
{
    ;// monitor << "~Octavate";
}

void Octavate::execute( StringList& parameters, Staff& staff )
{
    ;// monitor << "Octavate::execute" << flush;

//    int slope = atoi( (const char*)parameters.top() );
    Octave octave( char2istream( parameters.top() ) );
    staff.octavate = octave - Octave::central;
}

/****************************************************************************
  class MusicStyle
--*/

MusicStyle::MusicStyle( const char* name, const char* substitute, NESTED_IN(Note)Style s ) :
    Macro( name, substitute, 0 ),
    style( s )
{
    ;// monitor << "MusicStyle::MusicStyle";
} 

MusicStyle::~MusicStyle()
{
    ;// monitor << "~MusicStyle";
}

void MusicStyle::execute( StringList&, Staff& staff )
{
    ;// monitor << "MusicStyle::execute" << flush;

    staff.style = style;
}

//-- class MusicStyle //
