% Copyright 2012-2022, Alexander Shibakov
% This file is part of SPLinT
%
% SPLinT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% SPLinT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.

@**Lexer tables. This is the main table output code. 
Its core comes from the Flex Kit(ten?) (\.{fk.w}) 
which will be included as soon as this paragraph is
over. Feel free to
interpret the acronym as something easier to remember.

@<Table names@>=
  @<Scanner table names@>@;

@ @<Local variable and type declarations@>=
  @<Variables and types local to the scanner driver@>@;

@ @<Establish defaults@>=
  @<Compute exotic scanner constants@>@;

@ @<Output action switch, if any@>=
  @<Output scanner actions@>@;

@ @<Constant names@>=
  @<Scanner constants@>@;

@ @<Output constants@>=
  @<Output exotic scanner constants@>@;

@ @<\Cee\ preamble@>=
  @<Common code for \Cee\ preamble@>@;
  @<Scanner variables and types for \Cee\ preamble@>@;

@ @<Output modes@>=
  @<Scanner specific output modes@>@;

@ @<Various output modes@>=
  @<Handle scanner output modes@>@;

@ @<Cases affecting the whole program@>=
  @<Handle scanner output options@>@;

@ @<Options with shortcuts@>=
  @<Scanner specific options with shortcuts@>@;

@ @<Options without shortcuts@>=
  @<Scanner specific options without shortcuts@>@;

@ @<Short option list@>=
  @<Shortcuts for command line options affecting scanner output@>@;

@i common.w
@i fk.w

@*1 Lexer dependent settings. 
This is it for the core table output functions. 
To make all this into a working code in this
case, no function declarations are supplied.
@<Auxiliary function declarations@>=

@ @<Auxiliary function definitions@>=

@ @<\Cee\ preamble@>=
  void define_all_states( void );

@ The lexer takes no parameters in this case but if one reuses a
lexer written for a different purpose, the situation may be different.
%\let\B\oldB % \Cee\ mode mixes all up

@d YYPARSE_PARAMETERS
@d YY_USER_INIT        define_all_states();
@d yyterminate()       TeX_( "/yyterminate" ); return YY_NULL

@c

@<\Cee\ preamble@>@;
typedef int YYSTYPE;
#define YY_BREAK return 0;
#define YY_USER_ACTION  fprintf( tables_out, "%s\n", "      \\YYRULESETUP" );

#include LEXER_FILE

@<\Cee\ postamble@>@;

@** Index (for {\tt \jobname}).
%\def\readcontents{%
%  {%
%    \acrofalse
%    \def\jobname{bparser}\input bparser.toc 
%  }%
%  \input \contentsfile
%}