/*
    main function of xetal,
    Copyright (C) 1991 Raphael Cerf (e-mail: cerf@ens.ens.fr)

    This file is part of xetal.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "proto.h"

/*
 * main
 */

main(argc, argv)
int argc;
char **argv;
{
	extern char *optarg;
	extern int optind;

	int i, j, c;
	/* option flags */
	int Aflg, aflg, bflg, Cflg, cflg, dflg;
	int eflg, Eflg, errflg, Fflg, fflg, gflg, hflg;
	int iflg, jflg, Mflg, mflg, Nflg, nflg;
	int oflg, pflg, rflg, Sflg, sflg, tflg;
	int uflg, wflg, zflg;
	char *nN, *el;
	char i_name[W_LGTH];


#ifdef MALDEBUG
	malloc_debug(2);
#endif

	if ((devnull=fopen("/dev/null", "w"))==(FILE *)NULL) {
		fprintf(stderr, "Can't open /dev/null\n");
		exit(2);
	}

/*
 * default options
 */

	d_accent=0;
	d_bl=1;
	d_bls=1;
	d_comment=0;
	d_command=0;
	d_error=1;
	d_fname=1;
	d_macrodef=0;
	d_math=0;
	d_mot=1;
	d_nl=1;
	d_operator=1;
	d_punct=1;
	d_report=0;
	d_slashed=1;
	d_special=1;
	d_text=1;
	d_unknown=0;
	d_warning=1;
	do_fill=1;
	do_fill_acco=0;
	do_fill_slash=0;
	do_incl=1;
	c_fill=' ';
	s_accent=(char)0;
	n_nl=0;N=0;

/*
 * options handling
 */

	Aflg=aflg=bflg=Cflg=cflg=dflg=eflg=Eflg=errflg=0;
	Fflg=fflg=gflg=hflg=iflg=jflg=Mflg=mflg=Nflg=0;
	nflg=oflg=pflg=rflg=Sflg=sflg=tflg=uflg=wflg=0;
	zflg=0;
while ((c = getopt(argc, argv, "a:AbcCde:Ef:FghijmMn:oNpsSrtuwz")) != -1)
	switch (c) {
		case 'A':
			Aflg=1;
			break;
		case 'a':
			aflg=1;
			s_accent = optarg[0];
			break;
		case 'b':
			bflg=1;
			break;
		case 'C':
			Cflg=1;
			break;
		case 'c':
			cflg=1;
			break;
		case 'd':
			dflg=1;
			break;
		case 'e':
			eflg=1;
			el=strdup(optarg);
			break;
		case 'E':
			Eflg=1;
			break;
		case 'F':
			Fflg=1;
			break;
		case 'f':
			fflg=1;
			c_fill = optarg[0];
			break;
		case 'g':
			gflg=1;
			break;
		case 'h':
			hflg=1;
			break;
		case 'i':
			iflg=1;
			break;
		case 'j':
			jflg=1;
			break;
		case 'M':
			Mflg=1;
			break;
		case 'm':
			mflg=1;
			break;
		case 'N':
			Nflg=1;
			break;
		case 'n':
			nflg=1;
			nN = optarg;
			break;
		case 'o':
			oflg=1;
			break;
		case 'p':
			pflg=1;
			break;
		case 'r':
			rflg=1;
			break;
		case 'S':
			Sflg=1;
			break;
		case 's':
			sflg=1;
			break;
		case 't':
			tflg=1;
			break;
		case 'u':
			uflg=1;
			break;
		case 'w':
			wflg=1;
			break;
		case 'z':
			zflg=1;
			break;
		case '?':
			errflg++;
	}
	if (hflg) {
		fprintf(stderr, "usage:");
		fprintf(stderr,
	"xetal \-\[a:AbcCde:Ef:FghijmMn:oNpsSrtuwz\] \[file1\] \[file2\] ...\n");
		exit (2);
	}

	/* test for .tex suffix */
	for (i=optind; i < argc; i++) {
		strcpy(i_name, argv[i]);strcat(i_name, ".tex");
		if (access(argv[i], R_OK) && access(i_name, R_OK)) {
		fprintf(stderr,"Can't access file: %s\n", argv[i]);
			exit(2);
		}
	}

	if (Aflg) { d_accent=!d_accent; s_accent=(char)NULL; }
	if (aflg) d_accent=!d_accent;
	if (bflg) d_bls=!d_bls;
	if (cflg) d_command=!d_command;
	if (Cflg) d_comment=!d_comment;
	if (Eflg) d_error=!d_error;
	if (Fflg) do_fill=0;
	if (gflg) do_fill_acco=1;
	if (iflg) do_incl=0;
	if (jflg);
	if (mflg) d_math=!d_math;
	if (Nflg) d_fname=-1;
	if (nflg) { N=atoi(nN); n_nl=1; if (N==0) n_nl=0; }
	if (oflg) d_macrodef=!d_macrodef;
	if (pflg) d_punct=!d_punct;
	if (rflg) d_report=!d_report;
	if (sflg) d_special=!d_special;
	if (tflg) d_text=!d_text;
	if (uflg) d_unknown=1;
	if (wflg) d_warning=0;
	if (zflg) d_anything=!d_anything;

	if (eflg) {
		char *p=el;
		if ((envrt[n_envrt++]=strtok(p, ","))!=(char *)NULL) {
			p=(char *)NULL;
			while ((envrt[n_envrt++]=strtok(p, ","))!=(char *)NULL);
			n_envrt--;
		}
	}
	if (Sflg) {
		d_text=d_command=d_comment=d_accent=0;
		d_punct=d_special=d_slashed=d_math=0;
		d_operator=d_bl=d_nl=d_mot=d_punct=0;
		d_bls=do_fill=n_nl=0;
	}

/*
 * initialization of lexical analyzer
 */
	init_lex();

/*
 * initialization of symbol list
 */

	init_symbol(envrt, n_envrt);

/*
 * begining of program
 */

	if (dflg) 
#ifdef YYDEBUG
	yydebug=1;
#else
	{
fprintf(stderr, "You little joker ! The manual said don't try -d ...\n");
	exit(2);
	}
#endif

#ifdef MALDEBUG
	if (Mflg) { fprintf(stderr, "mallocmap\n");mallocmap(); }
#else
	if (Mflg) { fprintf(stderr, "Sorry, mallocmap not available\n"); }
#endif

	if (optind==argc) {
		/* only one file name in argument line */
		fich_t n_fich;
		n_fich.name="";
		n_fich.fd=stdin;
		n_fich.line=0L;
		n_fich.last_string=(char *)NULL;
		n_fich.last_char=(char)NULL;
		f_push(&n_fich);

		*f_in=stdin;	
		f_name="";
		lineno=0L;

		if (dflg) fprintf(stderr, "yyparse()==%d\n",yyparse());
		else yyparse();

		for (j=0; j<n_ionly; j++) {
			str_destroy(if_name[j]);
		}
		n_ionly=-1;
	} else {

	/* several file names in argument line */
	for (i=optind; i < argc; i++) {
		strcpy(i_name, argv[i]);strcat(i_name, ".tex");
		if ((*f_in=fopen(argv[i], "r"))==(FILE *)NULL) {
			if ((*f_in=fopen(i_name, "r"))==(FILE *)NULL) {
		if (d_warning)
		fprintf(stderr, "\nCan't open file: %s\n", argv[i]);
			}
		}
		if (*f_in!=(FILE *)NULL) {
		fich_t n_fich;

		n_fich.name=strdup(argv[i]);
		n_fich.fd=*f_in;
		n_fich.line=lineno;
		n_fich.last_string=(char *)NULL;
		n_fich.last_char=(char)NULL;
		f_push(&n_fich);

		f_name=n_fich.name;
		lineno=0L;

		init_lex();
		if (dflg) fprintf(stderr, "yyparse()==%d\n",yyparse());
		else yyparse();

		}
		for (j=0; j<n_ionly; j++) {
			str_destroy(if_name[j]);
		}
		n_ionly=-1;
	} /* for */

	} /* else */

	for (i=0; i<n_adsymbol; i++) {
		str_destroy(adsymbol[i].name);
	}

#ifdef MALDEBUG
	if (Mflg) { fprintf(stderr, "mallocmap\n");mallocmap(); }
#else
	if (Mflg) { fprintf(stderr, "Sorry, mallocmap not available\n"); }
#endif

	if (d_report) {
	fprintf(stderr, "*** xetal report ***\n");
	fprintf(stderr, "%d lines, %d characters\n", total_lines, charpos);
	fprintf(stderr, "%d formulas\n", n_formule);
	fprintf(stderr, "%d charaters skipped\n", c_skipped);
	}
	
	fclose(devnull);
}
