# main menu for xtem_TeXMenu
#
# called from shell script xtem: 
# exec $wishcall $XTEMPATH/xtem.tcl -n xtem $wishcall $XTEMPATH $language $*
# (instead of "#!/usr/local/bin/wishx -f" at the beginning of this file!)
#
# Copyright (C) 2000  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
###################################################################

set copyright "Copyright 2000  G. Lamprecht, W. Lotz, R. Weibezahn; "
set copyright "${copyright}LRW/IWD, Bremen University"
set email     "e-mail: weibezahn@iwd.uni-bremen.de"
set www       "WWW:    http://www.iwd.uni-bremen.de/xtem/xtem_texmenu.html"

set wishcall "[lindex $argv 0]"
set tclcall "[lindex $argv 1]"
set xtem_path "[lindex $argv 2]"; set XTEMPATH $xtem_path
set language "[lindex $argv 3]"
set testPut 0
while {[lsearch $argv "__Test_Put"]>=0} {
  incr argc -1
  set p [lsearch $argv "__Test_Put"]; set argv [lreplace $argv $p $p]
  set testPut 1
}
set fln "[lindex $argv 4]"

if {($argc<4)||($argc>5)} {set wrongargs 1} else {set wrongargs 0}
if {($wrongargs==1)&&([info tclversion]!=8.2)} {
  puts stdout "call:  xtem \[ -l language \] \[ filename\[.tex\] \]"
  if ![file exists $xtem_path/xtem.tcl] \
	{puts stdout "if call is OK: check shell-script \"xtem\" (new version; see README)!"}
  exit
}

if ![file exists $xtem_path/xtem.tcl] \
	{puts stdout "check shell-script \"xtem\" (new version; see README)!"; exit}

set bell_level 3; source $xtem_path/ut.tcl; source $xtem_path/xV.tcl;# read xtem version
TestPut 4 "<$argc><$argv>"

set HOME $env(HOME); TestPut 4 "HOME=<$HOME>"

set auto_path "$xtem_path $auto_path"

set texsuffix ".tex";  set esuff  ".tex"; set vstReadSkipSuff 0

set v ""; set n ""
set l [string length $fln]; set p [string last . [file tail $fln]]
if {($p>=0)&&("$fln"!=[file tail $fln])} {set p [string last . $fln]}
TestPut 4 "<$fln><[file tail $fln]><$l><$p>"
if {$fln==""} {
  set main_file ""; set efile ""; set texsuffix .tex; set esuff .tex
} elseif {$p<0} {
  set main_file "$fln"; set efile "$fln"
  foreach s [vst2list texsuffix.vst 0 "" "" ""] \
	{if [file exist $fln$s] {set texsuffix $s; set esuff $s; set vstReadSkipSuff 3}}
} elseif {$p==[expr [string length $fln]-1]} {
  set main_file [string trimright $fln .]; set efile $main_file
  set texsuffix .tex; set esuff .tex
  set vstReadSkipSuff 3
} else {
  if {$p==0} {set b ""; set e $fln} \
  else {set b [string range $fln 0 [expr $p-1]]; set e [string range $fln $p end]}
  if {($e==".tex")||($e==".ltx")} {# file name given as input includes "standard suffix"
    set main_file $b;   set efile $b;   set texsuffix $e; set esuff $e
    if [file exists $main_file$texsuffix] {set vstReadSkipSuff 3}
  } else {# file name includes suffix, but "suffix" not .tex or .ltx
    if {[lsearch [vst2list texsuffix.vst 0 "" "" dummy] $e]>=0} {# suffix is allowed
      set main_file $b;   set efile $b;   set texsuffix $e; set esuff $e
      if [file exists $main_file$texsuffix] {set vstReadSkipSuff 3}
    } else {# no valid suffix
      set main_file $fln; set efile $fln; set texsuffix ""; set esuff ""
      set vstReadSkipSuff 3
    }
  }
}
TestPut 4 "<$main_file><$texsuffix>  <$efile><$esuff>  <$vstReadSkipSuff>"

set InstDir "$xtem_path/locals_$language"
if [info exists env(XTEMVSTDIR)] {set InstDir "$env(XTEMVSTDIR):$InstDir"}

set hlp_dir "$xtem_path/help_$language/"
set f [open "${hlp_dir}button.texts" r]
while {[gets $f z]>=0} {
	set z "[string trim $z] "; set p [string first " " $z]
	set vv([string range $z 0 [expr $p-1]]) [string trim [string range $z $p end]]
}
close $f

proc xtem_hlptext {} {
 global  vv copyright email www version patchlevel tk_version xtem_path
 global  tk_patchLevel InstDir OpSystem mkcommand
 HTxtFile "" xt_xtem .d.tt
 set cprt "$copyright\n$email\n$www\n\n"
 set cprt "${cprt}xtem:$version Tcl:$patchlevel Tk:$tk_patchLevel "
 set cprt "${cprt}$mkcommand\n"
 set cprt "${cprt}     $OpSystem\n"
 set cprt "${cprt}InstDir: $InstDir\n"
 set cprt "${cprt}$vv(xtcprt3): $xtem_path/Installation.tex\n"
 if {([lsearch $OpSystem Linux]>=0)&&[file exists /usr/doc/packages]} \
	{set cprt "${cprt}$vv(xtcprt4)\n"}
 set cprt "${cprt}\n$vv(xtcprt1)\n$vv(xtcprt2)"
 if {[info exists vv(xtdlm1)]&&($vv(xtdlm1)!="")} {set cprt "${cprt}\n\n$vv(xtdlm1)"}
 if {[info exists vv(xtdlm2)]&&($vv(xtdlm2)!="")} {set cprt "${cprt}\n$vv(xtdlm2)"}
 writescr .d.tt $cprt
}

proc xtemWb2ln {} {
 global sub xtem_path language localnews
 lock;  set sub 1
 if [file exists "$xtem_path/../xtem_locals_$language/local.news"] \
      {set localnews "$xtem_path/../xtem_locals_$language/local.news"} \
 else {set localnews "$xtem_path/locals_$language.LRW/local.news"}
 newsfile .d.tt austext; writescr .d.tt "$austext"
 unlock_list
}


set SetMenuCalled 0
set tssk(1) yes; set tssk(2) icon; set tssk(3) no; set edsyntaxchg 0

####### set your variables in the files  locals_*/*.vst --- not here
####### the follwoing settings are  only for "security" (initialization of all variables)!!!
set filNotExdsp "0 -"
set mdatsort 0; set mdispmain 1; set mdispmainv 1; set edatsort 0
set button2end 2; set fsmenucols 2
set fshistory 10
set efilesearch 0; set efilesearcht ""
set vlerg ""
set widthl   41
set widthr   45
set sizeds   100x10
set maxprintcops 1
set xtermcall xterm
set edsyntaxhelp $tssk(3)
set prtfilperm permanent
set prtreversed ""
set b_quick 1; set b_spell 1; set b_syntax 1; set b_index 1; set b_bibliography 1
set b_additional 1; set b_logfile 1; set b_letters 0
set texedit ""; set texmax 1
set whichcheck yes
set tlOverfull 0.0
set tlHBadness 500
set tlMaxLines 500
set tlDirIgnore /usr/local/texmf/
set Wtl .erroredit
set tlLastFile ""
set texloganalyze 1; set texlogwarning 0
set texopts ""; set texopttext ""
set quickfile XtemQuick
set exallowset 0
set textxscroll 0
set unlockbutt 0
set shortbutts 0; set shortbuttsFNT ""
set prtcmdmax 4; for {set c 1} {$c<=$prtcmdmax} {incr c} {set prtcmd($c) ""}
set prtnumpag 1; set prtlistsort 0
set texpostbib 0; set texpostind 1; set texpostps 1; set texposttex 1
set texautostrt 1; set texautostrtv 0; set RunTexAutoActive 0
set mousebutts 3; set syntaxmark 1
set quicknonstop 1; set quickmultprv 1; set quickdelfile 0
set quickprev "standard_preview"; set quickprevstd "xdvi -hold"; set quickprsstd .dvi
set gesliste [list	.a.1.e  .a.1.h  .a.1.l  .a.1.g .a.2.m \
			.b.1.va .b.1.vs .b.1.vl .b.2.ln \
			.c.1.fs .c.1.ed .c.1.qd .c.1.la .c.1.pr .c.1.as .c.1.au \
			.c.2.re .c.2.sy .c.2.in .c.2.bi .c.2.so .c.2.fl .c.2.le]
set unlockliste $gesliste; set UnLock 1
 set urlcallexec(1) "netscape -remote openURL(will_be_replaced_on_the_fly_by_URL)"
 set urlcallexec(2) "netscape will_be_replaced_on_the_fly_by_URL &"
#set urlcallexec(3) "Mosaic will_be_replaced_on_the_fly_by_URL &"
#set urlcallexec(4) "grail will_be_replaced_on_the_fly_by_URL &"
#set urlcallexec(5) "xmosaic will_be_replaced_on_the_fly_by_URL &"

set bindAltMeta 1; set bindkeysenab 1
if {$testPut>0} {set bindkeys(.a.1.e) "Alt-Key-z ~z"}; # end button
set bindkeys(.b.2.ts) "Alt-Key-h ~h"; # TeX syntax help
set bindkeys(fs) "Alt-Key-f ~f"; # file selection
set bindkeys(ed) "Alt-Key-e ~e"; # edit
set bindkeys(qd) "Alt-Key-q ~q"; # quick&dirty
set bindkeys(la) "Alt-Key-x ~x"; # TeX
set bindkeys(pr) "Alt-Key-v ~v"; # view -- preview
set bindkeys(as) "Alt-Key-p ~p"; # print
set bindkeys(au) "Alt-Key-c ~c"; # clean up
set bindkeys(re) "Alt-Key-o ~o"; # orthography -- spell check
set bindkeys(sy) "Alt-Key-s ~s"; # syntax check
set bindkeys(in) "Alt-Key-i ~i"; # index
set bindkeys(bi) "Alt-Key-b ~b"; # bibliography
set bindkeys(so) "Alt-Key-u ~u"; # utility
set bindkeys(fl) "Alt-Key-l ~l"; # logfile
set bindkeys(le) "Alt-Key-m ~m"; # mail=letters

installLesen
################# Beginn: "Test" fuer Key-Bindings ######################################@@@@@
#set KW "Control-Key-";	# getestet mit: Tcl7.5/Tk4.1: +  Tcl7.6/Tk4.2: +
#set KW "Alt-Key-";	# getestet mit: Tcl7.5/Tk4.1: +  Tcl7.6/Tk4.2: +, Tk_Patch p2 erf.
#set KW "Mod1-Key-";	# getestet mit: Tcl7.5/Tk4.1: +  Tcl7.6/Tk4.2: +, Tk_Patch p2 erf.
#set KW "Meta-Key-";	# getestet mit: Tcl7.5/Tk4.1: -  Tcl7.6/Tk4.2: -
#set KW "Any-Key-";	# getestet mit: Tcl7.5/Tk4.1: +  Tcl7.6/Tk4.2: +, Tk_Patch p2 erf.
# set bindkeys(fs) "${KW}f"; set bindkeys(ed) "${KW}e"; set bindkeys(qd) "${KW}q"
# set bindkeys(la) "${KW}x"; set bindkeys(pr) "${KW}v"; set bindkeys(as) "${KW}p"
# set bindkeys(au) "${KW}c"; set bindkeys(re) "${KW}o"; set bindkeys(sy) "${KW}s"
# set bindkeys(in) "${KW}i"; set bindkeys(bi) "${KW}b"; set bindkeys(so) "${KW}u"
# set bindkeys(fl) "${KW}l"; set bindkeys(le) "${KW}m"
################# Ende:   "Test" fuer Key-Bindings ######################################@@@@@

set Wa .xtemak; set Wb .xtembv
set Wdm .xtemdm; set Wds .printpresel; set Wdv .xtemdv
set We .xtemev; set Wf .xtemfs; set Wh .syntaxhelp; set Wi .xtemiv; set Wqv .xtemqd
set Wl .xtemlv; set Wp .xtempv; set Wq .xtemq
set Wr .xtemrv; set Ws .xtemsv; set Wt .xtemtv
set Wo .xtemso; set Wx .xtemx; set Wbm .xtemtsxbm
set Wle .xtemlet1; set Wm .xtemlet2; set Wleed .xtemletedit

set stt ""; setTclVersions; set p_mkCmd 1; # setting of the version and consequences
set version "${version}$status$patches$vlerg"; set version_vst "${version}"
set tlOfull $tlOverfull; set tlHBad  $tlHBadness; set tlMaxL  $tlMaxLines

set sub 0; set edsubback 0;set prsubback 0;set logsubback 0;set qdsubback 0;set letsubback 0
set anl0 0
set pid ""; set xtAbbruch 0; set RequestActive 0; set TeXRunActive 0

set editor vi; set edxterm xterm; set edoptions ""
set printer ""; set lpcmd lp; set olsep @; set lpopt "$olsep $olsep "
set prtdriver dvips; set prtoptions "" ;set prtsuf .ps
set prtpresel "* * * * * * * * * * * * * * * * * * * *"
set spcmd spell; set sptext ""; set splang english; set spcorr ""
set spselect ""; set spoptions ""
set bibtex bibtex; set bitext ""; set bioptions ""
set index makeindex; set intext ""; set inoptions ""; set syntax ""
set sytext ""; set syoptions ""
set preview ghostview&; set prtext ""; set prsuffix .ps; set proptions ""
set prvfmtli ""; set prtfmtli ""
set opsep @; set prpreopt ""
set texfmt latex; set texfmtt ""; set texmem ""; set texmtext ""
set quickenable 0; set quickverbatim ""; set quickprereq ""; set quickpreform ""
set quicksuffix ""; set quickpreamble ""; set quickendpre ""; set quickenddoc ""
set mainfilgrep ""
set logform cat; set logxterm ""; set logoptions ""; set logtext ""
set aufmax 20;
set aufsuff          "*~ *.aux *.bak *.bbl *.blg *.dvi *.idx *.ilg *.ind *.lof"
set aufsuff "$aufsuff *.log *.lot *.ps *.toc *.wb-erg"
set auftoggle " 1 1 1 0 1 0 1 1 0 1 1 1 0 1 1"
set mkcommand mkcommand.9
set hlp_bmsuppr 0
set prformat A4_portrait; set prtformat ""
set prtselstr ""; set pgMaxim 9999; set pg_start 1; set pg_end $pgMaxim
set prmtext ""; set prmsel ""; set prmrelabs "r"
set isuffe .idx; set isuffa .ind; set bsuff .aux
set edback ""; set edliste ""; set edtext ""
set prback ""; set prliste ""; set logliste ""; set qdliste "";
set tsuff ""; set psuff ""; set lsuff ".log"; set asuff ""; set spsuff ""; set ssuff ""
set hyphentext T1; set texposthyph 1; set hyphenprog hyphen_show; set hyphenopts "-c T1"
set hyphenchk "\$mainfile.hck"
set tlaOutLstAct 0
set leEditCFN ".xtemtmp"
set letter ""; set lettext ""; set letoptions ""; set xtemlettersdemo xtemlettersdemo
set letliste ""; set letback 0; set letbackalw 0

set vst_ret [vstRead "" start.vst]

if {($SetMenuCalled==0)&&($mkcommand!="mkcommand.9")} {
  if {("$version_vst"=="0.00")||("$version_vst"=="$version")} {
    set stt "${stt} $vv(xtq01)\n $vv(xtq01)\n $vv(xtq02)\n"
    set stt "${stt} $vv(xtq6)\n $vv(xtq7)\n $vv(xtq8)\n $vv(xtq9)\n $vv(xtq10)\n"
    set stt "${stt} $vv(xtq02)\n $vv(xtq01)\n $vv(xtq01)\n"
  }
}
if {$vst_ret!=0} {
  set stt "${stt} $vv(xtq01)\n $vv(xtq01)\n $vv(xtq02)\n"
  set stt "${stt} $vv(xtq17)\n $vv(xtq18)\n $vv(xtq19)\n $vv(xtq20)\n"
  set stt "${stt} $vv(xtq02)\n $vv(xtq01)\n $vv(xtq01)\n"
  set stt "${stt}\n $vst_ret ---> $vst_ret.bak\n\n"
  mybell 2
  set vst_ret [vstRead "" .xtem_$language.vst]
  if {$vst_ret!=0} {
    set stt "${stt}\n $vst_ret ---> $vst_ret.bak\n\n"
    vstRead "" default.vst
  }
}

if {$mdispmain==0} {set mdispmainv 0}

set dir [pwd]

set fshistory [lindex $fshistory 0]
if {$fshistory>0} \
    {getFsHist; if {$main_file!=""} {insFsHist $main_file$texsuffix $efile$esuff}}

####################################################################;#####@@@@@Testweise
if {[tk appname]!="xtem"} {tk appname xtem1}; set appnm [tk appname];#####@@@@@Testweise!
####################################################################;#####@@@@@Testweise
if [info exists fontbl]   	    {option add ${appnm}*Button.Font          $fontbl
				     option add ${appnm}*Label.Font           $fontbl
				     option add ${appnm}*Checkbutton.Font     $fontbl
				     option add ${appnm}.font.normal.font     $fontbl}
if [info exists fontdli]	    {option add ${appnm}*Listbox.Font         $fontdli}
if [info exists fontsli]	    {option add ${appnm}$Wds*Listbox.Font     $fontsli
				     option add ${appnm}$Wds*selected.font    $fontsli
				     option add ${appnm}$Wds*Radiobutton.Font $fontsli}
if [info exists fontstdout]	    {option add ${appnm}*d.tt.font            $fontstdout}
if [info exists fonterr]	    {option add ${appnm}.font.error.font      $fonterr}
if [info exists fonterrtag]	    {option add ${appnm}*errortag.font        $fonterrtag}
if [info exists fonted] 	    {option add ${appnm}$Wtl.c.t.font         $fonted}
if [info exists errbgrd] 	    {option add ${appnm}$Wtl.error.background $errbgrd}
if [info exists errfgrd] 	    {option add ${appnm}$Wtl.error.foreground $errfgrd}
option add ${appnm}*Radiobutton.Pad 0
option add ${appnm}*Pad 1
option add *insertOffTime 0
if [info exists hlp_font(normal)]   {option add ${appnm}$Wh.normal.font   $hlp_font(normal)}
if [info exists hlp_font(tag)]      {option add ${appnm}$Wh.tag.font      $hlp_font(tag)}
if [info exists hlp_font(italic)]   {option add ${appnm}$Wh.italic.font   $hlp_font(italic)}
if [info exists hlp_font(bold)]     {option add ${appnm}$Wh.bold.font     $hlp_font(bold)}
if [info exists hlp_font(boldlrge)] {option add ${appnm}$Wh.boldlrge.font $hlp_font(boldlrge)}
if [info exists hlp_font(title)]    {option add ${appnm}$Wh.title.font    $hlp_font(title)}
if [info exists hlp_font(teletype)] {option add ${appnm}$Wh.teletype.font $hlp_font(teletype)}
if [info exists hlp_font(telelrge)] {option add ${appnm}$Wh.telelrge.font $hlp_font(telelrge)}
if [info exists hlp_font(telesmll)] {option add ${appnm}$Wh.telesmll.font $hlp_font(telesmll)}

if [info exists env(XTEMXDEFAULTS)] {
  set f "$env(XTEMXDEFAULTS)"; if {[string first "/" "$f"]<0} {set f "$env(HOME)/$f"}
} elseif [file exists $env(HOME)/.Xdefaults] {
  set f "$env(HOME)/.Xdefaults"
} else {
  set f ""
}
if {$f!=""} {
  set ret [catch "option readfile $f" mes]
  TestPut 3 "option readfile <$f> <$ret><$mes>"
  set xdf "$vv(xt27) $f\n"
  if {$ret!=0} {set xdf "${xdf}$vv(warn) $vv(xt23) `$f':\n\t$mes\n"; mybell 2}
} else {
  set xdf ""
}


TestPut 4 "bindkeysenab=$bindkeysenab <[array names bindkeys]>"
set keyListOther ".a.1.e .b.2.ts"
set bindKeyLExec ""; # bindings to keys .c.1.* and .c.2.* (exec buttons)
set bindKeyLOther ""
foreach k [array names bindkeys] {
  set bke [lindex $bindkeys($k) 0]; set bkk [lindex $bindkeys($k) 1]
  foreach n "1 2" \
	{if {[string first .c.$n.$k $gesliste]>=0} {lappend bindKeyLExec "$bke $bkk $n $k"}}
  if {[string first $k $keyListOther]>=0} {lappend bindKeyLOther "$bke $bkk $k"}
}
foreach bk $bindKeyLExec {# BK will be used for dynamic update of buttons in proc knoepfe
  if {$bindkeysenab==1} {set BK([lindex $bk 3]) "[lindex $bk 1] "} {set BK([lindex $bk 3]) ""}
}
if {$bindkeysenab==1} {
 foreach bk $bindKeyLExec  {BindInvoke CmdXKB [lindex $bk 0] .c.[lindex $bk 2].[lindex $bk 3]}
 foreach bk $bindKeyLOther {BindInvoke CmdXKB [lindex $bk 0] [lindex $bk 2]}
}
bind CmdXNo <Key-Left>		"[bind Text <Key-Left>]"
bind CmdXNo <Key-Right>		"[bind Text <Key-Right>]"
bind CmdXNo <Key-Up>		"[bind Text <Key-Up>]"
bind CmdXNo <Key-Down>		"[bind Text <Key-Down>]"
bind CmdXNo <Key-Prior>		"[bind Text <Key-Prior>]"
bind CmdXNo <Shift-Key-Prior>	"[bind Text <Control-Key-Home>]"
bind CmdXNo <Key-Next>		"[bind Text <Key-Next>]"
bind CmdXNo <Shift-Key-Next>	"[bind Text <Control-Key-End>]"
bind CmdXNo <Key-Home>		"[bind Text <Control-Key-Home>]"
bind CmdXNo <Key-End>		"[bind Text <Control-Key-End>]"
bind CmdXNo <Button-1>		"[bind Text <Button-1>]"
bind CmdXNo <B1-Motion>		"[bind Text <B1-Motion>]"

##################### procedures for Button-Clicks ###########################################
proc ClickFilesel {modifier} {TestPut 4 "File select button clicked ($modifier)"
 global vv BK sub fsHist widthl fontbl shortbutts fsWMenu
 if {$modifier==""} {
   lock; set sub 1; fileselect
 } else {
   TestPut 4 "$fsHist"
   set fsWMenu .c.1.fs.cascade
   if [winfo exist $fsWMenu] {destroy $fsWMenu}
   if {$shortbutts} {set te "$vv(xtc1FS)"} {set te "$BK(fs)$vv(xtc1fs)"}
   menubutton $fsWMenu -text "$te" -width $widthl -font $fontbl -menu $fsWMenu.menu -anchor w
   pack $fsWMenu -anchor w
   set m [menu $fsWMenu.menu -tearoff 0]
   foreach fs [lsort $fsHist] {
     $m add command -command "selFsHist $fs" \
	-label "[fillString2Length [lindex $fs 0] 20]  [lindex $fs 1]"
   }
   $fsWMenu.menu post [winfo pointerx $fsWMenu.menu] [winfo pointery $fsWMenu.menu]
 }
}

proc ClickEdit {modifier} {TestPut 4 "Edit button clicked ($modifier)"
 proc RunTexAuto {} {
  global efile esuff main_file tsuff EFStamp TeXRunActive RunTexAutoActive texautostrtv
  global edliste
  TestPut 4 "<$TeXRunActive|[.c.1.la configure -state]>"
  set procEdActive [llength $edliste]; # put this here (synchronization problems!)
  if {$RunTexAutoActive==0} {
    if ![file exists $efile$esuff]	{exec touch $efile$esuff}
    if ![file exists $main_file$tsuff]	{exec touch $main_file$tsuff}
    while {(![file exists $efile$esuff])||(![file exists $main_file$tsuff])} {after 100}
    TouchEFStamp
  }
  set RunTexAutoActive 1
  #TestPut 4 "+++ [file mtime $main_file$tsuff] [file mtime $efile$esuff] $EFStamp"
  if {![file exists  $efile$esuff]} {return}; # put this here (because of "cd" (letter e.g.))
  if {($procEdActive>0)&&($texautostrtv>0)} {
    if {(([file mtime $efile$esuff]>$EFStamp)||([file mtime $main_file$tsuff]>$EFStamp))
      &&([lsearch [.c.1.la configure -state] "disabled"]<0)} {TouchEFStamp; .c.1.la invoke} 
    after 2000 RunTexAuto
  } else {set RunTexAutoActive 0}
  #TestPut 4 "*********************************************************"
 }; #### end proc RunTexAuto ####
 global vv sub pid edliste edback edsubback RunTexAutoActive texautostrtv
 global EFStamp efile esuff main_file tsuff edsyntaxhelp edBack texfmt
 if {($efile=="")||($main_file=="")} {writescr0 .d.tt "\n$vv(ea1)"; mybell 2; return}
 if {$texautostrtv>0} {# put this here (synchronization problems!)
   if ![file exists $efile$esuff]	{exec touch $efile$esuff}
   if ![file exists $main_file$tsuff]	{exec touch $main_file$tsuff}
   while {(![file exists $efile$esuff])||(![file exists $main_file$tsuff])} {after 100}
   TouchEFStamp
 }
 lock;  set sub 1
 if {$edback=="&"} {delFromUnlockListe .c.1.ed; set edsubback 1}
 set pid 0;  editor .d.tt austext;  writescr .d.tt "$austext"
 if {($edback=="&")&&([TestNumGE0 $pid]>0)} {set edsubback $pid;set edliste "$edliste $pid"} \
 else {setInUnlockListe .c.1.ed}
 if {$edsubback==0} {setInUnlockListe .c.1.ed}
 TestPut 4 "$edsubback"
 unlock_list; Focus .
 if { ($edsyntaxhelp!="no") && ($edBack=="&") } {writescr .d.tt [TeX_syntax_help $texfmt 0]}
 TestPut 4 "$edsubback<$texautostrtv|$RunTexAutoActive> <$edback|$edsubback|$efile>"
 if {($texautostrtv>0)&&($RunTexAutoActive==0)} {
   if {($edback=="&")&&($edsubback>0)} {RunTexAuto}
   if {($edback=="")&&($efile!="")&&([file mtime $efile$esuff]>$EFStamp)} {.c.1.la invoke}
 }
 unlock_list; # put this here too (unlocking at editor end in case of RunTexAuto)
}

proc ClickQuick {what} {TestPut 4 "Quick&Dirty button clicked ($what)"
 global vv sub pid qdsubback qdliste mouse_grab quickenable efile esuff main_file
 if {$what=="mouse-grab"} {
	set retval [catch "selection get -selection PRIMARY" mouse_grab]
 } elseif {$what=="efile"} {
	if {$efile==""} {set retval 1} \
	elseif {"$efile"=="$main_file"} {set retval 2} \
	elseif ![file exist $efile$esuff] {set retval 3} \
	else {set retval 0}
 }
 if {!$quickenable} {writescr0 .d.tt "\n$vv(xtc1qd) $vv(disabl) $vv(qd15)\n"; mybell 2} \
 elseif {($retval==1)&&($what=="mouse-grab")} {writescr0 .d.tt "\n$vv(xt38)\n"; mybell 2} \
 elseif {($retval==1)&&($what=="efile")} {writescr0 .d.tt "\n$vv(bad1)\n"; mybell 2} \
 elseif {($retval==2)&&($what=="efile")} {writescr0 .d.tt "\n$vv(xt39)\n"; mybell 2} \
 elseif {($retval==3)&&($what=="efile")} \
		{writescr0 .d.tt "\n$vv(fs12) $efile$esuff --- $vv(fnf)\n"; mybell 2} \
 else {
   lock; set sub 1; set pid 0; quick .d.tt austext $what; writescr .d.tt "$austext"
   if {[TestNumGE0 $pid]>0} {set qdsubback $pid; set qdliste "$qdliste $pid"}
   unlock_list; Focus .
 }
}

proc ClickTeX {modifier} {TestPut 4 "TeX button clicked"
 global vv Wq main_file tsuff
 unlock_list; # Updating, falls zuletzt Editor verlassen!
 if {(![file exists $main_file$tsuff])||("$main_file"=="")} {
   if [winfo exists $Wq] {destror $Wq}; toplevel $Wq
   if {$main_file==""} {set frage "$vv(ea1)"} \
   else {set frage "TeX $vv(xt29) $main_file$tsuff   $vv(ea4)"}
   proc ReqTeXRYes {} {global Wq; destror $Wq; RunTeXFile}
   proc ReqTeXRNo  {} {global Wq; destror $Wq; unlock_list}
   Request $Wq "$frage" "" "$vv(xt30)" ReqTeXRYes "$vv(xt31)" ReqTeXRNo te_datei "" y
 } elseif {![file writable [pwd]]} {
   writescr0 .d.tt "\n$vv(xt43)\n$vv(xt44)\n\n  xtem [pwd]/$main_file\n\n$vv(xt45)\n"
   writescr  .d.tt "$vv(xt46) $main_file.*\n$vv(xt47)\n"
   mybell 3
 } else {RunTeXFile}
 if {("$modifier"=="Shift")&&[file exists ${main_file}.dvi]} {.c.1.pr invoke}
 TestPut 3 "****** Ende ClickTeX"
}
proc RunTeXFile {} {TestPut 4 "TeX run(s) start ..." 
 global vv sub texmax texrun tlFileCheck TeXRunActive texpostind texonemorerun chksum_idx
 global tlaOutLstAct
 lock; set sub 1; set TeXRunActive 1
 set texonemorerun 0
 if {$texpostind==1} {set chksum_idx [checksum .idx]} else {set chksum_idx 0}
 if {"$texmax">1} {set prs_alt [checksum .aux]}
 set texrun 1; set tlaOutLstAct 0
 set texerg [tex  .d.tt austext]; writescr .d.tt "$austext"
 if {$texerg!=1} {
   if {"$texmax">1} {
     while {"$texrun"<"$texmax"} {
	set prs_neu [checksum .aux]
	writescr .d.tt "$vv(xt10)=$prs_alt, $vv(xt11)=$prs_neu\n"
	if {"$prs_neu"!="$prs_alt"} \
	   {incr texrun; tex .d.tt austext; writescr .d.tt "$austext"; set prs_alt $prs_neu} \
	else {writescr .d.tt "\n$vv(xt12)\n(\".aux\" $vv(xt13)\n";  break}
     }
     if {"$texrun"=="$texmax"} {
	set prs_neu [checksum .aux]
	if {"$prs_neu"!="$prs_alt"} \
	  {writescr .d.tt "\n\n***** $vv(xt14)\n(\".aux\" $vv(xt15)\n";  mybell 2}
     }
   }
   lock; set sub 1
   tex_post .d.tt austext; writescr .d.tt "$austext"
 }
 set TeXRunActive 0
 unlock_list; focus .d.tt
}

proc ClickPreview {modifier} {
 global sub pid prsubback prliste prback
 lock; set sub 1
 if {$prback=="&"} {delFromUnlockListe .c.1.pr; set prsubback 1}
 set pid 0;  preview .d.tt austext;  writescr .d.tt "$austext"
 TestPut 4 "$prliste"
 if {($prback=="&")&&([TestNumGE0 $pid]>0)} {set prsubback $pid;set prliste "$prliste $pid"} \
 else {setInUnlockListe .c.1.pr}
 TestPut 4 "$prliste"
 if {$prsubback==0} {setInUnlockListe .c.1.pr}
 unlock_list
}

proc ClickCleanup {modifier} {global sub; lock; set sub 1; clear .d.tt}

proc ClickSpell {modifier} {
 global vv sub anl0 spcorr edsubback spselect Wq
 unlock_list; # Updating, falls zuletzt Editor verlassen!
 if {($spcorr=="K")&&($edsubback!=0)} {set frage "$vv(xt20) $vv(xt200)"} else {set frage ""}
 lock; set sub 1
 if {$frage==""} {
   if {"$spselect"=="S"} rs
   spellcheck .d.tt austext; writescr .d.tt "$austext"
   unlock_list
 } else {
   if [winfo exists $Wq] {destror $Wq}; toplevel $Wq; set anl0 0
   proc ReqSpellYes {} {global Wq spselect
     destror $Wq
     if {"$spselect"=="S"} rs
     spellcheck .d.tt austext; writescr .d.tt "$austext"
     unlock_list
   }
   proc ReqSpellNo  {} {global Wq; destror $Wq; update idletasks; unlock_list}
   Request $Wq "$frage" "" "$vv(xt21)" ReqSpellYes "$vv(dmaa)" ReqSpellNo re_konflikt "" n
 }
 Focus .
}

proc ClickSyntax {modifier} {
 global sub
 lock;  set sub 1;  syntax .d.tt austext; writescr .d.tt "$austext";  unlock_list; Focus .
}

proc ClickIndex {modifier} {
 global sub
 lock; set sub 1
 writescr0 .d.tt ""; index .d.tt austext; writescr .d.tt "$austext"
 unlock_list; Focus .
}

proc ClickBibtex {modifier} {
 global sub
 lock; set sub 1
 writescr0 .d.tt ""; bibliogr .d.tt austext; writescr .d.tt "$austext"
 unlock_list; Focus .
}

proc ClickUtility {modifier} {
 global vv sub Wo Wq anl0 edsubback
 if {$edsubback!=0} {set frage "$vv(xt20) $vv(xt201)"} else {set frage ""}
 lock;  set sub 1
 if {$frage==""} {
   if [winfo exists $Wo] {raise $Wo} else {so}
 } else {
   if [winfo exists $Wq] {destror $Wq}; toplevel $Wq; set anl0 0
   proc ReqUtilYes {} {global Wq Wo;	destror $Wq; if [winfo exists $Wo] {raise $Wo} {so}}
   proc ReqUtilNo  {} {global Wq;	destror $Wq; update idletasks; unlock_list}
   Request $Wq "$frage" "" "$vv(xt24)" ReqUtilYes "$vv(dmaa)" ReqUtilNo so_konflikt "" n
 }
}

proc ClickLogfile {modifier} {
 global vv sub pid logback logsubback logliste main_file lsuff logform tlFileCheck
 if {$main_file==""} {writescr0 .d.tt "***** $vv(ea1)\n"
 } else {
   lock;  set sub 1;  set pid 0
   if {$logform=="tla"} {
     writescr0 .d.tt ""
     if [file exists $main_file.log] {catFile $main_file.log .d.tt}
     if {$lsuff!=".log"} {writescr .d.tt "$vv(lv8) $main_file.log"} 
     writescr .d.tt "\n$vv(xt36) ...\n"; update
     set tlFileCheck 0;  tlDriver .d.tt austext;  writescr .d.tt "$austext"
   } else {
     logfile .d.tt austext;  writescr .d.tt "$austext"
   }
   if {($logback=="&")&&([TestNumGE0 $pid]>0)} \
		{set logsubback $pid; set logliste [linsert $logliste 1 $pid]}
   unlock_list; Focus .
 }
}
proc tlDriver {w austext} {
  global vv main_file tlA tlLog
  upvar 1 $austext a
  set a ""; set tlA ""; set tlLog $main_file.log
  if ![file exists $tlLog] {set a "${a}\n$vv(tlmlf): $tlLog\n"; mybell 2; return}
  tla $w; set a "$tlA"
}

proc ClickLetters {modifier} {
 global vv Wq edliste
 unlock_list; # Updating, falls zuletzt Editor verlassen!
 if {[llength $edliste]!=0} {
   if {[winfo exists $Wq]==1} {destror $Wq}; toplevel $Wq  
   set frage1 "$vv(xt34)";	set frage2 "$vv(xt35) $vv(xt352)"
   proc leReqKflYes {} {global Wq; destror $Wq; RunLetter}
   proc leReqKflNo  {} {global Wq; destror $Wq; unlock_list; Focus .}
   Request $Wq "$frage1" "$frage2" "$vv(yes)" leReqKflYes $vv(no) leReqKflNo le_konflikt "" n
 } else {RunLetter}
}
proc RunLetter {} {
 global sub pid main_file letsubback letliste letback leUnlockEtc lePreDir UnLock
 lock; set sub 1
 if {$letback==1} {delFromUnlockListe .c.2.le; set letsubback 1}
 set lePreDir [pwd]; set leUnlockEtc 1
 set pid 0;  letter .d.tt austext;  writescr .d.tt "$austext"
 if {($letback)&&([TestNumGE0 $pid]>0)} {set letsubback $pid; set letliste "$letliste $pid"} \
 else {setInUnlockListe .c.2.le}
 TestPut 4 "<$letsubback><$letback><$leUnlockEtc>"
 if {$letsubback==0} {setInUnlockListe .c.2.le}
 if {($letback==0)&&($leUnlockEtc==1)} {cd $lePreDir; unlock_list; Focus .}
}
##############################################################################################


set pys 0; # pady-value

wm iconname . "xtem";  wm title . "xtem";  wm minsize . 0 0
if [info exists geom(xtem)] {wm geometry . $geom(xtem)}

# Bereich a fuer erste Buttons

frame .a; pack configure .a -side top -anchor w -fill x

frame .a.1;  pack configure .a.1  -side left -anchor w -pady 8
frame .a.11; pack configure .a.11 -side left -anchor c -expand 1
frame .a.2;  pack configure .a.2  -side right -anchor e

								### Ende
button .a.1.e -text "$vv(ae)" -command {
  if {$mkcommand!="mkcommand.9"} {
    set vf "$env(HOME)/.xtem_$language.vst";
    if {[file exists $vf]} {vstGetValues "" $vf}
    if {[file writable $vf]||![file exists $vf]} {vstWriteFile $vf}
    set vf "${main_file}_$language.vst";
    if {[file exists $vf]&&[file writable $vf]} {vstGetValues "" $vf; vstWriteFile $vf}
  }
  if {$p_mkCmd>1} {
      killprocess $p_mkCmd; mybell 2; writescr0 .d.tt "***** $vv(xt2)\n      $vv(xt3)\n\n\n"
      DestroyAfterKillEtc "$prliste $qdliste $logliste"; # no return
  } else {DestroyAfterKillEtc "$prliste $qdliste $logliste"; # no return}
}
if {$testPut>0} {
  Bind3HTFK .a.1 e xt_quit .d.tt
  .a.1.e configure -text "[lindex $bindkeys(.a.1.e) 1] $vv(ae)"
} else {
  Bind3HF .a.1.e xt_quit .d.tt
}


button .a.1.h -text "$vv(ah)" -command {xtem_hlptext};			### Hilfen


button .a.1.l -text "$vv(al)" -command {writescr0 .d.tt ""};		### Lschen Text-Feld
Bind3HF .a.1.l z_loeschetf .d.tt


button .a.1.g -text "$vv(ag)" -command {				### Grundstellung
  set oldsuff $texsuffix;  set oldesuff $esuff
  set vstReadSkipSuff 0; vstRead .d.tt default.vst
  if {$oldsuff!=$texsuffix} {set main_file ""}
  if {$oldesuff!=$esuff} {set efile $main_file; set esuff $texsuffix}
  MkcmdSource;  knoepfe
}
Bind3HF .a.1.g xt_grund .d.tt

pack configure .a.1.e .a.1.h .a.1.l .a.1.g -side left -padx 3 -pady 3


if {$unlockbutt==1} {							### Entriegeln
 button .a.11.r -text "$vv(xta11r)" -command \
     {set ULOld $UnLock; set UnLock 1; unlock $gesliste; set UnLock $ULOld}
 Bind3HF .a.11.r xt_entrieg .d.tt
 pack configure .a.11.r -side left -padx 3 -pady 3
}


button .a.2.m -text "$vv(xta2m)" -command {CallSetMenu xv};		### exec-Modus
Bind2P .a.2.m 0 LeftMouseOnly .d.tt
Bind3HF .a.2.m xt_mkcmd .d.tt
pack configure .a.2.m -side bottom -padx 3 -pady 3


# Bereich b fuer eigene Voreinstellungen, TeX-Syntaxhilfen und lokale News

frame .b; pack configure .b -side top -anchor nw -fill x

frame .b.1; pack configure .b.1 -side left -anchor nw
frame .b.2; pack configure .b.2 -side right -anchor nw -pady 6

if {$shortbutts==0} {set bvDVbvdv "$vv(bvdv)"} else {set bvDVbvdv "$vv(bvDV)"}
label  .b.1.dv -text "$bvDVbvdv" -anchor w
button .b.1.va -command {writescr0 .d.tt "$vv(aus0)\n\n"; disp_prefs2 .d.tt}
button .b.1.vs -command {vstWrite .d.tt}
button .b.1.vl -command {vstReadDriver}
pack configure .b.1.dv .b.1.va .b.1.vs .b.1.vl -side left -padx 3 -pady 3
ButText .b.1.va "$vv(bvva)" "[string trimright "$vv(bvva) $vv(bvdv)" :]" "$vv(bvva)"
ButText .b.1.vs "$vv(xtb1va)" "[string trimright "$vv(xtb1va) $vv(bvdv)" :]" "$vv(xtb1va)"
ButText .b.1.vl "$vv(xtb1vl)" "[string trimright "$vv(xtb1vl) $vv(bvdv)" :]" "$vv(xtb1vl)"
Bind3HF .b.1.dv xt_voreinst3 .d.tt
Bind3HF .b.1.va xt_voreinst3 .d.tt
Bind3HF .b.1.vs xt_voreinst3 .d.tt
Bind3HF .b.1.vl xt_voreinst3 .d.tt

button .b.2.ln -text "$vv(xtb2ln)" -command {xtemWb2ln}
pack configure .b.2.ln -side right -padx 3 -pady 3
Bind3HF .b.2.ln xt_localnews .d.tt

button .b.2.ts -text "$vv(xtb2ts)" -command {TeX_syntax_help $texfmt 1}
pack configure .b.2.ts -side right -padx 3 -pady 3
if {$bindkeysenab==1} {.b.2.ts configure -text "[lindex $bindkeys(.b.2.ts) 1] $vv(xtb2ts)"}
Bind3HTFK .b.2 ts xt_syntxhlp .d.tt
Bind3HF .a.1.h xt_help .d.tt


# Button-Bereich c fuer Aktionen und Bindungen

frame .c; pack configure .c -pady 0 -anchor w -fill x -expand yes


# Button-Bereich .c.1 fuer Aktionen und Bindungen

frame .c.1; frame .c.2
pack configure .c.1 .c.2 -side left -padx 5 -anchor ne -fill x -expand yes

button .c.1.fs -anchor w -width $widthl -command {ClickFilesel ""};      ### Dateiauswahl
if {$fshistory>0} {BindS1P .c.1.fs 0 ClickFilesel history}
Bind2P .c.1.fs 0 LeftMouseOnly .d.tt
Bind3HTFK .c.1 fs xt_filesel .d.tt

button .c.1.ed -anchor w -width $widthl -command {ClickEdit ""};         ### Editoraufruf
Bind2P .c.1.ed $exallowset CallSetMenu ev
Bind3HTFK .c.1 ed xt_editor .d.tt

button .c.1.qd -anchor w -width $widthl -command {ClickQuick mouse-grab};### QuickDirty
BindS1P .c.1.qd $exallowset {ClickQuick efile}
Bind2P .c.1.qd 0 CallSetMenu qv
Bind3HTFK .c.1 qd xt_quick .d.tt

button .c.1.la -anchor w -width $widthl -command {ClickTeX ""};          ### TeX-Aufruf
BindS1P .c.1.la $exallowset {ClickTeX Shift}
Bind2P .c.1.la $exallowset CallSetMenu tv
Bind3HTFK .c.1 la xt_tex .d.tt

button .c.1.pr -anchor w -width $widthl -command {ClickPreview ""};      ### Preview-Aufruf
Bind2P .c.1.pr $exallowset CallSetMenu pv
Bind3HTFK .c.1 pr xt_preview .d.tt

button .c.1.as -anchor w -width $widthl -command {ClickDvi2Printer ""};  ### Dvi2Printer
BindS1P .c.1.as $exallowset {ClickDvi2Printer Shift}
Bind2P .c.1.as $exallowset CallSetMenu dv
Bind3HTFK .c.1 as xt_drucker .d.tt

button .c.1.au -anchor w -width $widthl -command {ClickCleanup ""};      ### Aufrumen
Bind2P .c.1.au 0 LeftMouseOnly .d.tt
Bind3HTFK .c.1 au xt_delauxs .d.tt


pack configure .c.1.fs .c.1.ed -pady $pys -fill x -expand yes
if {($b_quick==1)} {pack configure .c.1.qd -pady $pys -fill x -expand yes}
pack configure .c.1.la .c.1.pr .c.1.as .c.1.au -pady $pys -fill x -expand yes



# Button-Bereich .c.2 fuer Aktionen und Bindungen

button .c.2.re -anchor w -width $widthr -command {ClickSpell ""};        ### Rechtschreibprfg.
Bind2P .c.2.re $exallowset CallSetMenu rv
Bind3HTFK .c.2 re xt_recht .d.tt

button .c.2.sy -anchor w -width $widthr -command {ClickSyntax ""};       ### Syntaxprfung
Bind2P .c.2.sy $exallowset CallSetMenu sv
Bind3HTFK .c.2 sy xt_syntax .d.tt

button .c.2.in -anchor w -width $widthr -command {ClickIndex ""};        ### Indexaufbereitung
Bind2P .c.2.in $exallowset CallSetMenu iv
Bind3HTFK .c.2 in xt_index .d.tt

button .c.2.bi -anchor w -width $widthr -command {ClickBibtex ""};       ### Bibliographieauf.
Bind2P .c.2.bi $exallowset CallSetMenu bv
Bind3HTFK .c.2 bi xt_bibtex .d.tt

button .c.2.so -anchor w -width $widthr -command {ClickUtility ""};      ### utility programs
Bind2P .c.2.so 0 LeftMouseOnly .d.tt
Bind3HTFK .c.2 so xt_sonstige .d.tt

button .c.2.fl -anchor w -width $widthr -command {ClickLogfile ""};      ### display logfile
Bind2P .c.2.fl $exallowset CallSetMenu lv
Bind3HTFK .c.2 fl xt_seelogs .d.tt


button .c.2.le -anchor w -width $widthr -command {ClickLetters ""};      ### letters/reports
Bind2P .c.2.le $exallowset CallSetMenu mv
Bind3HTFK .c.2 le xt_letters .d.tt


if {$b_spell} {pack configure .c.2.re -pady $pys -fill x -expand yes}
if {$b_syntax} {pack configure .c.2.sy -pady $pys -fill x -expand yes}
if {$b_index} {pack configure .c.2.in -pady $pys -fill x -expand yes}
if {$b_bibliography} {pack configure .c.2.bi -pady $pys -fill x -expand yes}
if {$b_additional} {pack configure .c.2.so -pady $pys -fill x -expand yes}
if {$b_logfile} {pack configure .c.2.fl -pady $pys -fill x -expand yes}
if [string range $b_letters 0 0] {pack configure .c.2.le -pady $pys -fill x -expand yes}


dirMainFile;  knoepfe

if {!$quickenable} {delFromUnlockListe .c.1.qd; lock; unlock_list}


if {$shortbutts} {
 label .buttontext -anchor nw -relief ridge -borderwidth 1 -text ""
 pack configure .buttontext -fill x -anchor n -pady 5
 Bind3HF .buttontext xt_shortbutts .d.tt
}

knoepfe; update

set xtemTyh 30
InsertTextFrame "" $xtemTyh "" "" ""
frame .font; label .font.error; label .font.errortag; label .font.normal
.d.tt tag configure err -font [option get .font.error font text]
.d.tt tag configure end -relief ridge -borderwidth 1 -background white

set hrest [expr [winfo height .]-[winfo height .a]-[winfo height .b]-[winfo height .c]]
set hreq [winfo reqheight .d.tt]
if {$hreq<$hrest} \
  {set xtemTyh [expr $xtemTyh*$hrest/$hreq]; destroy .d; InsertTextFrame "" $xtemTyh "" "" ""}
update

# final checks

if {[regexp {mkcommand.[1237]} $mkcommand]&&([info commands infox]=="")} \
								{set mkcommand "mkcommand.6"}
MkcmdSource
if {$mkcommand=="mkcommand.9"} {
  mybell 3
  set stt "${stt} $vv(xtq01)\n $vv(xtq01)\n $vv(xtq02)\n"
  set stt "${stt} $vv(xtq1)\n $vv(xtq2)\n $vv(xtq3)\n $vv(xtq4)\n"
  set stt "${stt} $vv(xtq02)\n $vv(xtq01)\n $vv(xtq01)\n"
  set stt "${stt}\n"
}

if {$stt!=""} {writescr0 .d.tt $stt; mybell 3}

set OpSystem "[array get tcl_platform]"
TestPut 4 "xtem started with test output:\n\t\
    xtem:$version Tcl:$patchlevel Tk:$tk_patchLevel $mkcommand\n\t\
    $OpSystem\n\tInstDir: $InstDir\n\t${xdf}\n\t$vv(xt28) $vstdat\n<$stt>\n"
if {$testPut==1} {set bell_level 0}

if {($main_file=="")||([testfilename $main_file .d.tt $texsuffix])} \
	{writescr .d.tt "\n$vv(xt26)\n"}
writescr .d.tt "\n${xdf}$vv(xt28) $vstdat\n"
if [file exists  "$xtem_path/../xtem_locals_$language/xtemstart.news"] \
	{set sfl "$xtem_path/../xtem_locals_$language/xtemstart.news"} \
else    {set sfl "$xtem_path/locals_$language.LRW/xtemstart.news"}
if [file exists $sfl] {writescr .d.tt "\n"; catFile $sfl .d.tt}; .d.tt yview 0
if {[winfo exists $Wq]} {raise $Wq}
