# menu: setting of default lanugage for xtem_TeXMenu
#
# called from shell script xtem: 
# $wishcall $XTEMPATH/setdeflang.tcl -n "xtem Language Selection" $defaultlanguage
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
###################################################################



wm minsize . 400 300

set HOME $env(HOME)

set langlist "english german"

set deflang "[string trim [lindex $argv  0]]"
if {[lsearch $langlist $deflang]<0} {set deflang [lindex $langlist 0]}


frame .text; pack configure .text -side top -anchor w -fill x -padx 5 -pady 2
frame .languages; pack configure .languages -side top -anchor w -fill x
frame .selection; pack configure .selection -side top -anchor w -fill x


label .text.erlaeuterung1 -wraplength 4i -justify left -text "xtem_TeXMenu is developed by  Gnther Lamprecht, Wolfhard Lotz and Roland Weibezahn; IWD, Bremen University/Germany."
pack  .text.erlaeuterung1 -side top  -anchor w

label .text.erlaeuterung2 -wraplength 4i -justify left -text "As xtem is bilingual (german or english) you now can select the default language by clicking at the corresponding radiobutton, then \"OK\"."
pack  .text.erlaeuterung2 -side top  -anchor w

label .text.erlaeuterung3 -wraplength 4i -justify left -text "You can call xtem, specifying the language explicitely by:"
pack  .text.erlaeuterung3 -side top  -anchor w

label .text.erlaeuterung4 -wraplength 4i -justify left -text "    xtem -l english"
pack  .text.erlaeuterung4 -side top  -anchor w

label .text.erlaeuterung5 -wraplength 4i -justify left -text "If you want to modify the default language for xtem, you simply have to remove the file(s) .xtem_deflang=* in your HOME directory, e.g.:"
pack  .text.erlaeuterung5 -side top  -anchor w

label .text.erlaeuterung6 -wraplength 4i -justify left -text "    rm $HOME/.xtem_deflang=*"
pack  .text.erlaeuterung6 -side top  -anchor w

label .text.erlaeuterung7 -wraplength 4i -justify left -text "xtem_TeXMenu uses a lot of settings, which you can modify in setting menus; as these settings are language specific, you will of course get new ones when you change the (default) language!"
pack  .text.erlaeuterung7 -side top  -anchor w

#label .text.erlaeuterung -wraplength 4i -justify left -text ""
#pack  .text.erlaeuterung -side top  -anchor w


foreach lang $langlist {
    radiobutton .languages.$lang -text "$lang" -variable deflang -value $lang
    pack configure .languages.$lang -side top -padx 20 -pady 2
}

button .selection.ok -text "OK" -command {
    foreach lang $langlist {
	if {[file exists $HOME/.xtem_deflang=$lang]} {file delete $HOME/.xtem_deflang=$lang}
    }
    exec touch $HOME/.xtem_deflang=$deflang
    destroy .
}
button .selection.cancel -text "cancel" -command {destroy .}
pack configure .selection.ok  -side left -padx 32 -pady 20
pack configure .selection.cancel -side right -padx 20 -pady 20
