# call of the printer driver dvilj with the file $main_file, output into $prt_file
#
# Copyright (C) 1999  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc prt_dvilj {f austext} {

  upvar 1 $austext a

  global vv main_file prtoptions pg_start pg_end prmsel prt_file opsep printcops dirprefix
  global prtcmd prtcmdmax prtsuf asuff

  set a ""
  writescr $f "[datime] $vv(dta1) \"[lindex [info level [info level]] 0].tcl\" $vv(dta2)\n"
  TestPut 4 "<$prmsel> <$main_file><$pg_start><$pg_end> <$prtoptions><$opsep><$printcops>"

  if {$dirprefix==""} {set mainfile $main_file} else {set mainfile [fileName $main_file]} 
  if {![file exists $mainfile$asuff]&&[file exists $main_file$asuff]} \
		      {set mainfile $main_file}

  set opt1 "[lindex [split $prtoptions $opsep] 1]";# set driver options (except format)
  if {$printcops!="1"} {set opt1 "$opt1 -c$printcops"};# add number of copies to options
  set opt2 "[lindex [split $prtoptions $opsep] 2]";# set format dependent driver options

  if { $prmsel == "vstcommands" } {# list of commands from setting file prt_*.vst

    TestPut 4 "via vstcommands ($prtcmdmax): <$prtoptions> <$opt1><$opt2>"
    for {set c 1} {($c<=$prtcmdmax)&&($prtcmd($c)!="")} {incr c} {
      TestPut 4 "\tprtcmd($c)=<$prtcmd($c)>"
      set cmd [lindex $prtcmd($c) 0]
      #set opt "[eval list [lrange $prtcmd($c) 1 end]]"; #does not work with dvidvi: "(...)"
      set opt "[lrange $prtcmd($c) 1 end]"
      set opt [prtRegsub "$opt" $mainfile "$opt1" "$opt2" "$startpage" "$endpage"]
      writescr $f "\n[datime]: $cmd $opt"; update
      eval mkCmd_wait $f $cmd [list "$opt"]
    }

  } elseif {$prmsel=="abs" || $prmsel=="odd_abs" || $prmsel=="even_abs"} {

    if {$pg_start=="$vv(dmstart)"} {set startpage ""} else {set startpage $pg_start}
    if {$pg_end  =="$vv(dmend)"}   {set endpage  ""}  else {set endpage  $pg_end}

    set incr ""
    if {$prmsel=="odd_abs"}  {set incr "-D1"}
    if {$prmsel=="even_abs"} {set incr "-D2"}

    set opt_seiten "$incr"  
    if {$startpage!=""} {set opt_seiten "${opt_seiten} -f$startpage"}
    if {$endpage!=""}   {set opt_seiten "${opt_seiten} -t$endpage"}

    eval mkCmd_wait $f dvilj [list "$opt1 $opt2 $opt_seiten $mainfile -e$prt_file"]

  } else {       # error: unexpected value of $prmsel      

    set a "${a}*** $vv(aerr) (prt_dvilj.tcl): $vv(dt1) $prmsel\n"
    set a "${a}    $vv(adm)\n\n"
    mybell 3; return 1

  }
  
  return 0

}
