#******************************************************************************
#***
#*** This file is part of XTeXShell; see file xtexsh for details
#*** Version 0.91 (21.2.94)
#***
#******************************************************************************

proc FileSelBox {Mode {startdir "."}} {

#***
#*** Displays a File Selector Box
#***
#*** Input Value (optional)
#***     Mode = (OPEN / CREATE / OPENCREATE / DIR / CD)
#***     Start directory ("." is default)
#***
#*** Return Values:
#***     "" if operation was canceled
#***     Full File Name if operation was completed successfully
#***

#*** Variables and Definitions
      
        global      fsbfname fsbfmode

        set         fsbfname [expr {[cequal $startdir "."] ? [eval pwd] : $startdir}]

        switch $Mode {
                "OPEN"       { set title "OPEN existing File" }
                "CREATE"     { set title "CREATE a new File" }  
                "OPENCREATE" { set title "OPEN / CREATE a File" }
                "DIR"        { set title "View Directory" }
                "CD"         { set title "Change Directory" }
        }       
        set         fsbfmode $Mode

#*** Generate Window

        global      fsbwin  fsbwin_name  fsbwin_geo
        global      fixbold_font bold_font

        set         fsbwin  [CreateTopWin fsbwin "CREATE"]

        wm title    $fsbwin $title
        wm iconname $fsbwin "File Selector Box"
        wm minsize  $fsbwin 5 5

        entry       $fsbwin.mask   -relief sunken -textvariable fsbfname -font $bold_font -exportselection 0
        frame       $fsbwin.but    -relief raised -borderwidth 1
        scrollbar   $fsbwin.scroll -command "$fsbwin.list yview"
        listbox     $fsbwin.list   -yscroll "$fsbwin.scroll set" -relief flat -geometry 20x20 \
                                   -setgrid yes -font $fixbold_font -exportselection 0

        pack        $fsbwin.mask   -side top     -fill x -padx 3m -pady 1m -fill  x
        pack        $fsbwin.but    -side bottom  -fill x
        pack        $fsbwin.scroll -side right   -fill y
        pack        $fsbwin.list   -side left    -fill both -expand yes

#*** Generate Buttons

        button      $fsbwin.but.ok     -text "OK"      -command {fsbcheck OK 0}
        button      $fsbwin.but.cancel -text "Cancel"  -command {fsbcheck CANCEL 0}
        button      $fsbwin.but.form   -text "Format"  -command {lvarpush fsboptions [lvarpop fsboptions 0] "end+1"; fsbgetlist}
        button      $fsbwin.but.help   -text "Help"    -command { }    
        pack        $fsbwin.but.ok $fsbwin.but.cancel $fsbwin.but.form $fsbwin.but.help -side left -padx 3m -pady 1m -ipadx 0.6m

#*** Set Input focus and Keyboard events

        bind        $fsbwin.mask <Return>               {fsbcheck RETURN 0}
        bind        $fsbwin.list <Control-q>            {fsbcheck CANCEL 0}
        bind        $fsbwin.list <Control-c>            {fsbcheck CANCEL 0}
#       bind        $fsbwin.list <Button-1>             { }
#       bind        $fsbwin.list <Any-ButtonPress>      { }
#       bind        $fsbwin.list <Any-ButtonRelease>    { }
#       bind        $fsbwin.list <Any-Motion>           { } 
        bind        $fsbwin.list <Double-Button-1>      {fsbcheck BUT1 %y}


#*** Read File List

        fsbgetlist 

#*** Wait for OK or cancel 

        tkwait  window $fsbwin
        return  $fsbfname
}

#*******************************************************************************
#*** functions to handle user input and read directories ***********************
#*******************************************************************************

proc fsbcheck {Mode {ypos 0}} {

#*** This function is called after input from user
#*** Action depends on Mode

        global fsbwin fsbfname fsbfmode
        global boldl_font

#*** User requested CANCEL. 

        if {[cequal $Mode "CANCEL"]} {
                set fsbfname ""
                destroy $fsbwin
                return
        }

#*** User pushed Double Button 1                                
                
        if {[cequal $Mode "BUT1"]} {
		if {![file isdirectory $fsbfname]} {
			DisplayInfo "Can't concatenate filename because mask is not a valid directory name" $boldl_font
			return
		} 
 
                set str [$fsbwin.list get [$fsbwin.list nearest $ypos]]                 
                set str [lvarpop str end]

                if {[cequal $str "."]} {        
                        fsbgetlist
                        return
                }       

                if {[cequal $fsbfname  "."]} {   
                        set fsbfname $str
                } else {
			if {[cequal "/" [cindex $fsbfname end]]} {
				set fsbfname "$fsbfname$str"
			} else {
				set fsbfname "$fsbfname/$str"
			}
                }
                set Mode "RETURN"
        }

#*** User requested RETURN.

        if {[cequal $Mode "RETURN"]} {
                if {[file isdirectory $fsbfname]} {
                        fsbgetlist 
                        return
                }
        }

#*** OK, user has selected a filename which is in fsbfname. 

        switch $fsbfmode {
                "OPENCREATE" {
                        destroy $fsbwin
                }
                "OPEN" {
                        if {[file exists $fsbfname]} {
                                destroy $fsbwin
                                return
                        }
                        DisplayInfo "Warning!!!\n\nThe file you selected:\n$fsbfname\nis not a valid file\nPlease choose a new one" "$boldl_font"
                } 
                "CREATE" {              
                        if {[file exists $fsbfname]} {
                                set retval [DisplayQuest "Warning!!!\n\nFile:\n$fsbfname\n already exists!\nOverwrite?"\
                                            "$boldl_font" "Overwrite" "Select New File"]                
                                if {$retval==1} {
                                        destroy $fsbwin
                                        return
                                }
                        } else {
                                destroy $fsbwin
                                return
                        }                               
                }
                "DIR" {
                        set fsbfname ""
                        destroy $fsbwin
                        return
                }
                "CD"  {
                        if {[file isdirectory $fsbfname]} {
                                destroy $fsbwin
                                return
                        }
                        DisplayInfo "Error!!!\n\nThe path you selected:\nis not a valid directory\nPlease chose a new directory" "$boldl_font"
                }
        }
}               

proc fsbgetlist {} {
        
#*** Clear Listbox. Then fill Listbox with directory entries

        global  fsbfname fsboptions fsbwin

        $fsbwin.list delete 0 10000

        set filelist [exec ls [lindex $fsboptions 0] $fsbfname]
        foreach i [split $filelist "\n"] {
              $fsbwin.list insert end $i
        }

	if {![cequal "/" [cindex $fsbfname end]]} {
		set fsbfname "$fsbfname/"
	}

        focus       $fsbwin.mask
} 
