#******************************************************************************
#***
#*** This file is part of XTeXShell; see file xtexsh for details
#*** Version 0.91 (21.2.94)
#***
#******************************************************************************

#******************************************************************************
#*** Load Setup and Shortcuts file ********************************************
#******************************************************************************

set  setup0fname "$xtexsh_path/setup.orig"
set  setup1fname "$xtexsh_path/setup"
set  setup2fname "$home_dir/.xtexsh.setup"
set  setup3fname "./.xtexsh.setup"

set  short0fname "$xtexsh_path/shortcuts.orig"
set  short1fname "$xtexsh_path/shortcuts"
set  short2fname "$home_dir/.xtexsh.shortcuts"
set  short3fname "./.xtexsh.shortcuts"

proc loadsetup {} {

#*** Load setup file. 

        uplevel 1 {
                if {[file exists "$setup1fname"]} {
                        source "$setup1fname"
                } else {
                        source "$setup0fname"
                }
                if {[file exists "$setup2fname"]} {source "$setup2fname"} 
                if {[file exists "$setup3fname"]} {source "$setup3fname"} 
        }
}


proc writesetup {mode} {

#*** Update setup file mode=0: local, mode=1: global
#***    local:  If setup-file doesn't exist, copy global, setup, setup.orig
#***    global: If setup-file doesn't exist, copy setup, setup.orig 

        global wrtsmode boldl_font
        global goto_command     
        
        set wrtsmode $mode 

        DisplayMsg "Writing Configuration file.\n Press any key to continue..." $boldl_font

        uplevel 1 {
                if {$wrtsmode==0} {
                        set setupfname "$setup3fname"
                } else {
                        set setupfname "$setup2fname"
                }

#*** Does setup-file exist?  If not, copy setup or setup.orig

                if {![file exists "$setupfname"]} {
                        if {[file exists "$setup1fname"]} {
                                exec cp "$setup1fname" "$setupfname"
                        } else {
                                exec cp "$setup0fname" "$setupfname"
                        }
                }               

#*** Generate list with variables to save in setup file

                set setuplist ""
                lvarpush setuplist "editor"     
                lvarpush setuplist "editmode"  
                lvarpush setuplist "editwrap"   
                lvarpush setuplist "edittrans" 
                lvarpush setuplist "editmode"  

#*** Create a copy of the setup file and open files for read and write

                exec cp "$setupfname" "$setupfname.temp"
                set infile  [open $setupfname.temp "r"]
                set outfile [open $setupfname "w"]

#*** Read old setup file line by line and copy to new setup file
#*** if line does not contain any words of setuplist

                while {![eof $infile]} {
                        gets $infile inline
                        set flag 1
                        if {[string first "set" $inline] >= 0} {
                                foreach key $setuplist {
                                        if {[string first " $key " $inline] >= 0} {
                                                set flag 0
                                        }
                                } 
                        }
                        if {$flag} {
                                puts $outfile $inline
                        }
                }
        
#*** Now write values of variables in setuplist to setup-file

                while {![lempty $setuplist]} {
                        set var [lvarpop setuplist]
                        eval set val \"\$$var\"
                        puts $outfile [format "set\t%-10s\t\"%s\"" $var $val] 
                }       

#*** Close files

                close $infile
                close $outfile
                unlink -nocomplain "$setupfname.temp"
        } 

        eval $goto_command
        set  goto_command ""
}


proc loadshortcuts {} {

#*** Load shortcuts file

        uplevel 1 {
                if {[file exists "$short1fname"]} {
                        ReadShortCuts "$short1fname"
                } else {
                        ReadShortCuts "$short0fname"
                }               

                if {[file exists "$short2fname"]} {ReadShortCuts "$short2fname"}
                if {[file exists "$short3fname"]} {ReadShortCuts "$short3fname"} 
        }
}


proc ReadShortCuts {fname} {

#*** Read the shortcuts from file fname and generate menu buttons

        global .menu.cuts.m
        global textbuf

#*** Delete old entries

        .menu.cuts.m delete 0 last
        
#*** Open shortcuts file

        set fd [open "$fname" "r"]

#*** Read line by line and check for :end and :endentry commands.
 
        for {set mode 0} {[gets $fd line] != -1} {} {
                if {[cequal ":entry" [lindex $line 0]]} {
                        set buf ""
                        set mode 1
                        lvarpop line 0
                        set entryname [string trim $line ""]
                        continue
                }
                if {[cequal ":endentry" [lindex $line 0]]} {
                        .menu.cuts.m add command -label "$entryname" -command "InsertEditor \{$buf\} "
                        set mode 0
                        continue
                }
                if {[cequal ":separator" [lindex $line 0]]} {
                        .menu.cuts.m add separator
                        continue
                }
                if {$mode} {
                        set buf "$buf\n$line"
                }
        }
        close $fd
}