## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "RemoteTclShell.tcl"
 #                                    created: 1/10/97 {5:54:23 pm} 
 #                                last update: 04/15/1999 {17:36:59 PM} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1997-1998  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 #  Description: 
 # 
 #  History
 # 
 #  modified by  rev reason
 #  -------- --- --- -----------
 #  1/10/97  VMD 1.0 original
 # ###################################################################
 ##

# mode declaration
alpha::extension RemoteTclShell 0.2.0 {
    alpha::package require -loose Alpha 7.1.9
    menu::replaceWith Utils "<S/Y<Oshell" items "<S/Y<Oshell" "<S/Y<O<IremoteTclShell" 
} maintainer {
    {Vince Darley} <darley@fas.harvard.edu> <http://www.fas.harvard.edu/~darley/>
} uninstall {this-file} help {Use Alpha as a console for a remote Wish shell}

#  Remote Tcl Shell routines  #


namespace eval tcltk {}

proc tcltk::Prompt {} {
    global tcltk::_prompt tcl_platform Shel::startPrompt Shel::endPrompt
    return "${Shel::startPrompt}${tcltk::_prompt}${Shel::endPrompt} " 
}


proc remoteTclShell {} {
    global tcltk::_prompt tclshSig tclshSigs tcl_platform
    if {$tcl_platform(platform) == "macintosh"} {
	app::launchElseTryThese $tclshSigs tclshSig "Please locate the remote Tcl application"
	set tcltk::_prompt [file tail [nameFromAppl $tclshSig]]
    } else {
	global tclshInterp
	tcltk::findTclshInterp
	set tcltk::_prompt $tclshInterp
    }
    Shel::start "tcltk" "* Tcl remote shell *" "Welcome to Alpha's remote Tcl shell\r"
}


