;
; (c) Rainer Schnitker 95,96
;

        .386p
        .387

L_FLAG_DLL              = 0001H                 ; Executable is a DLL
LAYOUT_TABLE    STRUC
L_TEXT_BASE     DD      ?
L_TEXT_END      DD      ?
L_DATA_BASE     DD      ?
L_DATA_END      DD      ?
L_BSS_BASE      DD      ?
L_BSS_END       DD      ?
L_HEAP_BASE     DD      ?
L_HEAP_END      DD      ?
L_HEAP_BRK      DD      ?
L_HEAP_OFF      DD      ?
L_OS2_DLL       DD      ?
L_STACK_BASE    DD      ?
L_STACK_END     DD      ?
L_FLAGS         DD      ?
L_RESERVED      DD      2 DUP (?)
L_OPTIONS       DB      64 DUP (?)
LAYOUT_TABLE    ENDS

        extrn _get_argv_env             :near
        extrn _cpy_argv_env             :near
        extrn _init_process_test_fork   :near
        extrn _init_process_fork        :near
        extrn _init_rte                 :near
        extrn _sys_call                 :near

        .data

        .code

;; The arguments and the environment are passed on the stack:
;;
;;        (high end of stack)
;;        environment and argument strings; use envp[] and argv[] for accessing
;;        argv[], NULL terminated
;; ESP->  envp[], NULL terminated


;; CAUTION do not use registers ebp, esi, edi, ebx

public RSXNT_Init
RSXNT_Init PROC
        finit
        cld

        pop     edx                 ;; return address
        pop     eax                 ;; _data line

        push    edx
        push    eax
        call    _init_process_test_fork
        mov     ecx, eax
        pop     eax
        pop     edx

        or      ecx, ecx            ;; test fork
        jz      init2
        mov     esp, ecx
        push    esp
        call    _init_process_fork
        pop     eax
        popad                       ;; return from father fork()
        popfd
        ret

init2:
        push    edx
        push    eax
        call    _init_rte
        pop     eax
        pop     edx

        test    [eax].l_flags, l_flag_dll
        jnz     return_to_app       ;; called by dll startup code

                                    ;; block:    <- ecx
        mov     ecx, esp            ;; -1 space
        sub     esp, 6*4            ;; -2 envc
        mov     eax, esp            ;; -3 argc
                                    ;; -4 env
                                    ;; -5 argv
                                    ;; -6 esp    <- eax
        push    ecx
        push    edx
        push    eax
        call    _get_argv_env
        pop     eax
        pop     edx
        pop     ecx

        sub     esp, [ecx-1*4]
        mov     [ecx-6*4], esp

        push    edx
        push    eax
        call    _cpy_argv_env
        pop     eax
        pop     edx

return_to_app:
        jmp     edx
        ret
RSXNT_Init endp

public RSXNT_Call
RSXNT_Call PROC
        pushfd
        pushad
        push    esp
        call    _sys_call
        pop     eax
        popad
        popfd
        ret
RSXNT_Call endp

      end
