/* rename.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __rename(const char *oldname, const char *newname)
{
    char old_fname[512];
    char new_fname[512];

    _rsxnt_truncate_name (old_fname, oldname);
    _rsxnt_truncate_name (new_fname, newname);

    if (_rsxnt_get_process_ptr()->bConsoleApp) {
        OemToChar(old_fname, old_fname);
        OemToChar(new_fname, new_fname);
    }

    if (MoveFile(old_fname, new_fname) == FALSE)
        return _rsxnt_get_last_errno();
    else
        return 0;
}
