/* vctype.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

#if defined (IF_WIN32)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

void v_ctype (int start, int end)
{
  if ((unsigned)start < 0x20 && (unsigned)end < 0x20)
    {
#if defined (IF_WIN32)
      IF_WIN32
        {
          CONSOLE_CURSOR_INFO cci;
          GetConsoleCursorInfo(GetStdHandle(STD_OUTPUT_HANDLE), &cci);
          // cci.dwSize = (((end - start) & 0x1f) + 1) * 100 / 0x20;
          cci.bVisible = TRUE;
          SetConsoleCursorInfo(GetStdHandle(STD_OUTPUT_HANDLE), &cci);
        }
#endif
#if defined (IF_DOS)
      IF_DOS
        {
          union REGS r;

          r.h.ah = 0x01;
          r.h.cl = end;
          r.h.ch = start;
          _int86 (0x10, &r, &r);
        }
#endif
    }
}
