/*
** Test of:
** EnumFonts, EnumFontFamilies, EnumWindows, EnumChildWindows,
**
** Use of:
** STR2LONG, FAR2PTR	(32bit <-> 16bit)
*/

#include <windows.h>
#include <stdio.h>
#include "\rsxwdk\include\sys\port.h"
#include "enumw.h"

#define WM_USER_ENUMFONTS	WM_USER+1
#define WM_USER_ENUMFONTFAM	WM_USER+2
#define WM_USER_ENUMWINDOWS	WM_USER+3

static OLDFONTENUMPROC lpfnEnumFonts;
static WNDENUMPROC lpfnEnumWindows;
static FONTENUMPROC lpfnEnumFontFam;

static char szAppname[]="enumw";
static HWND hWindow, hListWnd;
static HINSTANCE hInstance;

INT _export CALLBACK EnumFontsProc (
    const LOGFONT FAR *lpFont,
    const TEXTMETRIC FAR* lpTM,
    INT style,
    LPARAM str)
{
    LOGFONT FAR *lp32Font;  /* 32bit flat ptr */

    lp32Font = FAR2PTR(lpFont);

    /* reconvert to far ptr, next proc uses lpFont without conversions */
    SendMessage(hListWnd, LB_ADDSTRING, NULL, STR2LONG(lp32Font->lfFaceName));

    return 1;
}

INT _export CALLBACK EnumFontFamProc (
    const ENUMLOGFONT FAR *lpFont,
    const NEWTEXTMETRIC FAR* lpTM,
    INT type,
    LPARAM str)
{
    if (type & TRUETYPE_FONTTYPE)
	SendMessage(hListWnd, LB_ADDSTRING, NULL, (LPARAM)lpFont->elfFullName);

    return 1;
}

void display_window(HWND hWnd, int level)
{
    static char text[256];
    static char class[256];
    RECT r;
    char *buf;
    int i;

    buf = text;

    for (i=0; i<(int)level; i++) {
	*buf++ = ' ';
	*buf++ = ' ';
	*buf++ = ' ';
	*buf++ = ' ';
    }
    sprintf(buf, "%04X    ", hWnd);
    buf = text + strlen(text);

    if (GetClassName(hWnd, class, 256)) {
	sprintf(buf, "[%s]    ", class);
	buf = text + strlen(text);
    }
    GetWindowRect(hWnd, &r);
    sprintf(buf, "(%d,%d,%d,%d)    ", r.left, r.top, r.right, r.bottom);
    buf = text + strlen(text);
    if (GetWindowText(hWnd, class, 256)) {
	sprintf(buf, "<%s>", class);
	buf = text + strlen(text);
    }
    if (level == 0)
    {
	HANDLE hInst = GetWindowWord(hWnd, GWW_HINSTANCE);
	if (GetModuleFileName(hInst, class, 256))
	    sprintf(buf,"    %s", class);
    }

    /* we must convert 32bit flat pointer to 16bit far pointer */
    SendMessage(hListWnd, LB_ADDSTRING, NULL, STR2LONG(text));
}

BOOL _export CALLBACK EnumWindowsProc(HWND hWnd, LPARAM level)
{
    static HWND seen[1024] = {0};
    HWND *ps;
    int i;
    static int num_wnd = 0;

    /* cheap check for duplicates */
    for (i=0, ps=seen; i<num_wnd; i++, ps++)
	if (hWnd == *ps)
	    return 1;
    if (num_wnd < 1024)
	seen[num_wnd++] = hWnd;

    display_window(hWnd, level);
    EnumChildWindows(hWnd, lpfnEnumWindows, level+1);
    return 1;	/* keep going */
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    HDC hdc;

    switch (message)
    {
	case WM_USER_ENUMFONTS:
	    SendMessage(hListWnd,LB_RESETCONTENT,NULL,NULL);
	    SendMessage(hListWnd,WM_SETREDRAW,0,NULL);
	    hdc = GetDC(hwnd);
	    if (! EnumFonts(hdc, NULL, lpfnEnumFonts, NULL))
		MessageBox(hwnd, "EnumFonts failed", NULL, MB_OK);
	    ReleaseDC(hwnd, hdc);

	    InvalidateRect(hListWnd,NULL,TRUE);
	    SendMessage(hListWnd,WM_SETREDRAW,1,NULL);
	    UpdateWindow(hListWnd);
	    break;

	case WM_USER_ENUMFONTFAM:
	    SendMessage(hListWnd,LB_RESETCONTENT,NULL,NULL);
	    SendMessage(hListWnd,WM_SETREDRAW,0,NULL);
	    hdc = GetDC(hwnd);
	    if (! EnumFontFamilies(hdc, NULL, lpfnEnumFontFam, NULL))
		MessageBox(hwnd, "EnumFontFam failed", NULL, MB_OK);
	    ReleaseDC(hwnd, hdc);

	    InvalidateRect(hListWnd,NULL,TRUE);
	    SendMessage(hListWnd,WM_SETREDRAW,1,NULL);
	    UpdateWindow(hListWnd);
	    break;

	case WM_USER_ENUMWINDOWS:
	    SendMessage(hListWnd,LB_RESETCONTENT,NULL,NULL);
	    SendMessage(hListWnd,WM_SETREDRAW,0,NULL);
	    if (! EnumWindows(lpfnEnumWindows, 0))
		MessageBox(hwnd, "EnumWindows failed", NULL, MB_OK);
	    InvalidateRect(hListWnd,NULL,TRUE);
	    SendMessage(hListWnd,WM_SETREDRAW,1,NULL);
	    UpdateWindow(hListWnd);
	    break;

	case WM_SIZE:
	    MoveWindow(hListWnd,0, 0,LOWORD(lParam),HIWORD(lParam),TRUE);
	    break;

	case WM_CREATE:
	    lpfnEnumFonts = (OLDFONTENUMPROC)
		    MakeProcInstance((FARPROC) EnumFontsProc, hInstance);
	    lpfnEnumFontFam = (FONTENUMPROC)
		    MakeProcInstance((FARPROC) EnumFontFamProc, hInstance);
	    lpfnEnumWindows = (WNDENUMPROC)
		    MakeProcInstance((FARPROC) EnumWindowsProc, hInstance);
	    break;

	case WM_DESTROY:
	    SendMessage(hListWnd,LB_RESETCONTENT,NULL,NULL);
	    FreeProcInstance((FARPROC)lpfnEnumFonts);
	    FreeProcInstance((FARPROC)lpfnEnumFontFam);
	    FreeProcInstance((FARPROC)lpfnEnumWindows);
	    PostQuitMessage(0);
	    break;

	case WM_COMMAND:
	    switch (wParam) {
		case IDM_FONTS:
		    SendMessage(hwnd, WM_USER_ENUMFONTS ,0 , 0L);
		    break;
		case IDM_FONTFAM:
		    SendMessage(hwnd, WM_USER_ENUMFONTFAM ,0 , 0L);
		    break;
		case IDM_WINDOWS:
		    SendMessage(hwnd, WM_USER_ENUMWINDOWS ,0 , 0L);
		    break;
		case IDM_ABOUT:
		    MessageBox(hwnd, "EnumW 1.0", szAppname, MB_OK);
		    break;
	    }

	default:
	    return DefWindowProc(hwnd, message, wParam, lParam);
    }
    return 0;
}

BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS wc;

    wc.style = NULL;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, szAppname);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  szAppname;
    wc.lpszClassName = szAppname;

    return RegisterClass(&wc);
}

BOOL InitInstance(HINSTANCE hInstance, INT nCmdShow)
{
    RECT Rect;
    HANDLE hFont;

    hWindow = CreateWindow(
	szAppname,
	"ENUM TEST",
	WS_OVERLAPPEDWINDOW,
	CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
	NULL, NULL,
	hInstance,
	NULL);

    if (!hWindow)
	return (NULL);

    hListWnd = CreateWindow(
	"Listbox",
	NULL ,
	(LBS_STANDARD & ~LBS_SORT) | LBS_HASSTRINGS | LBS_NOREDRAW |
	WS_VISIBLE | WS_BORDER | WS_VSCROLL | WS_CHILD,
	0, 0, Rect.right-Rect.left, Rect.bottom-Rect.top,
	hWindow, NULL,
	hInstance,
	NULL);

    if (!hListWnd) {
	DestroyWindow(hWindow);
	return (NULL);
    }

    ShowWindow(hWindow, nCmdShow);
    UpdateWindow(hWindow);

    hFont=GetStockObject(SYSTEM_FIXED_FONT);
    SendMessage(hListWnd, WM_SETFONT, hFont, TRUE);

    return TRUE;
}

INT PASCAL _export WinMain (
    HINSTANCE hInst,
    HINSTANCE hPrevInst,
    LPSTR lpszCmdParam,
    INT nCmdShow)
{
    MSG msg;

    hInstance = hInst;
    if (!InitApplication(hInstance)) {
	MessageBox(NULL,"register class",NULL,MB_OK);
	return (FALSE);
    }
    if (!InitInstance(hInstance, nCmdShow)) {
	MessageBox(NULL,"create window",NULL,MB_OK);
	return (FALSE);
    }

    while (GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return msg.wParam;
}
