#include <errno.h>
#include <sys/doscalls.h>


/*
** AH = 0x2D
** CX = hour/min
** DX = sec/hsec
*/
int dos_settime(struct dos_time * dt)
{
    struct REGPACK r;

    r.eax = 0x2D00;
    r.ecx = ((unsigned short) dt->dtime_hour << 8) | dt->dtime_minutes;
    r.edx = ((unsigned short) dt->dtime_seconds << 8) | dt->dtime_hsec;

    _intr(0x21, &r);

    if ((r.eax & 0xFF) == 0xFF)
	return -1;
    else
	return 0;
}
