#define STRICT
#define NOKERNEL
#define NOGDI
#include <windows.h>
#include <sys/rsxw32.h>

/* -------- USER SECTION ------------------------------------- */

short MessageBox(HWND hWnd, LPCSTR text, LPCSTR title, UINT flags)
{
    STACKWORDS(1+2+2+1);

    PUSH_WORD(hWnd);
    PUSH_LPSTR(text);
    PUSH_LPSTR(title);
    PUSH_WORD(flags);
    return WINCALL(1,USER);
}

void PostQuitMessage(short exit_value)
{
    STACKWORDS(1);

    PUSH_WORD(exit_value);
    WINCALL(6,USER);
}

DWORD GetTickCount (void)
{
    NOSTACK;
    return WINCALL( 13,USER);
}

HWND SetCapture(HWND hWnd)
{
    STACKWORDS(1);

    PUSH_WORD(hWnd);
    return WINCALL( 18,USER);
}

void ReleaseCapture(void)
{
    NOSTACK;
    WINCALL( 19,USER);
}

void GetClientRect(HWND hWnd, RECT FAR *lpRect)
{
    STACKWORDS(1+2);

    PUSH_WORD(hWnd);
    PUSH_LPSTR(lpRect);
    WINCALL( 33,USER);
}

BOOL EnableWindow(HWND hWnd,BOOL b)
{
    STACKWORDS(1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(b);
    return WINCALL( 34,USER);
}

void SetWindowText (HWND hWnd, LPCSTR lpString)
{
    STACKWORDS(1+2);
    PUSH_WORD(hWnd);
    PUSH_LPSTR(lpString);
    WINCALL( 37,USER);
}

HDC BeginPaint(HWND hWnd,PAINTSTRUCT FAR *lpPaint)
{
    STACKWORDS(1+2);

    PUSH_WORD(hWnd);
    PUSH_LPSTR(lpPaint);
    return WINCALL(39,USER);
}

void EndPaint(HWND hWnd, const PAINTSTRUCT FAR *lpPaint)
{
    STACKWORDS(1+2);

    PUSH_WORD(hWnd);
    PUSH_LPSTR(lpPaint);
    WINCALL(40,USER);
}

/*
** in syscall.c
** CreateWindow()
** WINCALL(41,USER)
*/

BOOL ShowWindow(HWND hWnd, short att)
{
    STACKWORDS(1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(att);
    return WINCALL(42,USER);
}

BOOL DestroyWindow (HWND hWnd)
{
    STACKWORDS(1);
    PUSH_WORD(hWnd);
    return WINCALL( 53,USER);
}

BOOL EnumChildWindows(HWND hWnd, WNDENUMPROC callback_32, LONG lParam)
{
    STACKWORDS(1+2+2);
    ULONG cb16 = SV_CALL(M_LOAD_ENUMCHILDPROC, (ULONG)callback_32);

    PUSH_WORD(hWnd);
    PUSH_LONG(cb16);
    PUSH_LONG(lParam);
    return WINCALL( 55,USER);
}

BOOL MoveWindow (HWND hWnd, short x1, short y1, short x2, short y2, BOOL b)
{
    STACKWORDS(1+1+1+1+1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(x1);
    PUSH_WORD(y1);
    PUSH_WORD(x2);
    PUSH_WORD(y2);
    PUSH_WORD(b);
    return WINCALL( 56,USER);
}

/*
** in syscall.c
** RegisterClass()
** WINCALL(57,USER)
*/

short GetClassName(HWND hWnd, LPSTR string, short len)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(hWnd);
    PUSH_LPSTR(string);
    PUSH_WORD(len);
    return WINCALL( 58,USER);
}

HWND GetActiveWindow(void)
{
    NOSTACK;
    return WINCALL(60,USER);
}

void ScrollWindow (HWND hWnd, short x, short y, const RECT FAR *lpRect, const RECT FAR *lpClipRect)
{
    STACKWORDS(1+1+1+2+2);

    PUSH_WORD(hWnd);
    PUSH_WORD(x);
    PUSH_WORD(y);
    PUSH_LPSTR(lpRect);
    PUSH_LPSTR(lpClipRect);
    WINCALL( 61,USER);
}

short SetScrollPos (HWND hWnd, short nBar, short nPos, BOOL bRedraw)
{
    STACKWORDS(1+1+1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(nBar);
    PUSH_WORD(nPos);
    PUSH_WORD(bRedraw);
    return WINCALL( 62,USER);
}

void SetScrollRange (HWND hWnd, short nBar, short nMin, short nMax, BOOL bRedraw)
{
    STACKWORDS(1+1+1+1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(nBar);
    PUSH_WORD(nMin);
    PUSH_WORD(nMax);
    PUSH_WORD(bRedraw);
    WINCALL( 64,USER);
}

HDC GetDC(HWND hWnd)
{
    STACKWORDS(1);

    PUSH_WORD(hWnd);
    return WINCALL(66,USER);
}

short ReleaseDC(HWND hWnd, HDC hdc)
{
    STACKWORDS(1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(hdc);
    return WINCALL(68,USER);
}

HCURSOR SetCursor(HCURSOR hcur)
{
    STACKWORDS(1);

    PUSH_WORD(hcur);
    return WINCALL( 69,USER);
}

void CopyRect (RECT FAR *lpDestRect, const RECT FAR *lpSourceRect)
{
    STACKWORDS(2+2);

    PUSH_LPSTR(lpDestRect);
    PUSH_LPSTR(lpSourceRect);
    WINCALL( 74,USER);
}

short GetClipBox (HDC par1, RECT FAR * par2)
{
    STACKWORDS(1+2);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    return WINCALL( 77,GDI);
}

short DrawText (HDC par1, LPCSTR par2, short par3, RECT FAR * par4, UINT par5)
{
    STACKWORDS(1+2+1+2+1);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    PUSH_WORD(par3);
    PUSH_LPSTR(par4);
    PUSH_WORD(par5);
    return WINCALL( 85,USER);
}

short DialogBox(HINSTANCE hInst, LPCSTR name, HWND hWnd, DLGPROC thunk)
{
    STACKWORDS(1+2+1+2);

    SV_CALL(M_LOAD_WNDFNCT, (ULONG)thunk);

    PUSH_WORD(hInst);
    if ((ULONG)name <= INT_RESOURCE)
	PUSH_LONG((ULONG)name);
    else
	PUSH_LPSTR(name);
    PUSH_WORD(hWnd);
    PUSH_LONG(_rsxw32_callback);
    return WINCALL(87,USER);
}

void EndDialog(HWND hWnd, short ret)
{
    STACKWORDS(1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(ret);
    WINCALL(88,USER);
}

HWND CreateDialog(HINSTANCE hInst, LPCSTR name, HWND hParent, DLGPROC lpDlgProc)
{
    STACKWORDS(1+2+1+2);

    SV_CALL(M_LOAD_WNDFNCT, (ULONG)lpDlgProc);

    PUSH_WORD(hInst);
    if ((ULONG)name <= INT_RESOURCE)
	PUSH_LONG((ULONG)name);
    else
	PUSH_LPSTR(name);
    PUSH_WORD(hParent);
    PUSH_LONG(_rsxw32_callback);
    return WINCALL( 89,USER);
}

HWND GetDlgItem(HWND hWnd, short id)
{
    STACKWORDS(1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(id);
    return WINCALL(91,USER);
}

void SetDlgItemText(HWND hWnd, short id, LPCSTR text)
{
    STACKWORDS(1+1+2);

    PUSH_WORD(hWnd);
    PUSH_WORD(id);
    PUSH_LPSTR(text);
    WINCALL( 92,USER);
}

short GetDlgItemText(HWND hWnd, short id, LPSTR text, short len)
{
    STACKWORDS(1+1+2+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(id);
    PUSH_LPSTR(text);
    PUSH_WORD(len);
    return WINCALL( 93,USER);
}

void CheckRadioButton(HWND hWnd, short id1, short id2, short id3)
{
    STACKWORDS(1+1+1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(id1);
    PUSH_WORD(id2);
    PUSH_WORD(id3);
    WINCALL( 96,USER);
}

void CheckDlgButton(HWND hDlg, short nID, UINT wCheck)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(hDlg);
    PUSH_WORD(nID);
    PUSH_WORD(wCheck);
    WINCALL( 97,USER);
}

BOOL  DlgDirSelect(HWND hWnd, LPSTR name, short id)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(hWnd);
    PUSH_LPSTR(name);
    PUSH_WORD(id);
    return WINCALL(99,USER);
}

short DlgDirList(HWND hWnd, LPSTR name, short idbox, short id, UINT attr)
{
    STACKWORDS(1+2+1+1+1);

    PUSH_WORD(hWnd);
    PUSH_LPSTR(name);
    PUSH_WORD(idbox);
    PUSH_WORD(id);
    PUSH_WORD(attr);
    return WINCALL(100,USER);
}

LONG SendDlgItemMessage(HWND hWnd, short id, UINT msg, WPARAM wp, LPARAM lp)
{
    STACKWORDS(1+1+1+1+2);

    PUSH_WORD(hWnd);
    PUSH_WORD(id);
    PUSH_WORD(msg);
    PUSH_WORD(wp);
    PUSH_LONG(lp);
    return WINCALL(101,USER);
}

void MessageBeep(UINT sound)
{
    STACKWORDS(1);

    PUSH_WORD(sound);
    WINCALL(104,USER);
}

LONG DefWindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    STACKWORDS(1+1+1+2);

    PUSH_WORD(hWnd);
    PUSH_WORD(msg);
    PUSH_WORD(wParam);
    PUSH_LONG(lParam);
    return WINCALL(107,USER);
}

BOOL GetMessage(MSG FAR *msg, HWND hWnd, UINT max, UINT min)
{
    STACKWORDS(2+1+1+1);

    PUSH_LPSTR(msg);
    PUSH_WORD(hWnd);
    PUSH_WORD(max);
    PUSH_WORD(min);
    return WINCALL(108,USER);
}

BOOL PeekMessage(MSG FAR *msg, HWND hWnd, UINT max, UINT min, UINT remove)
{
    STACKWORDS(2+1+1+1+1);

    PUSH_LPSTR(msg);
    PUSH_WORD(hWnd);
    PUSH_WORD(max);
    PUSH_WORD(min);
    PUSH_WORD(remove);
    return WINCALL(109,USER);
}

BOOL PostMessage(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
    STACKWORDS(1+1+1+2);

    PUSH_WORD(hWnd);
    PUSH_WORD(msg);
    PUSH_WORD(wp);
    PUSH_LONG(lp);
    return WINCALL(110,USER);
}

/*
** in syscall.c
** SendMessage()
** WINCALL(111,USER)
*/

BOOL TranslateMessage(const MSG FAR *msg)
{
    STACKWORDS(2);

    PUSH_LPSTR(msg);
    return WINCALL(113,USER);
}

LONG DispatchMessage(const MSG FAR *msg)
{
    STACKWORDS(2);

    PUSH_LPSTR(msg);
    return WINCALL(114,USER);
}

void UpdateWindow(HWND hWnd)
{
    STACKWORDS(1);

    PUSH_WORD(hWnd);
    WINCALL(124,USER);
}

void InvalidateRect(HWND hWnd, const RECT FAR *lpRect, BOOL b)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(hWnd);
    PUSH_LPSTR(lpRect);
    PUSH_WORD(b);
    WINCALL(125,USER);
}

WORD GetWindowWord (HWND par1, short par2)
{
    STACKWORDS(1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(133,USER);
}

WORD SetWindowWord (HWND par1, short par2, WORD par3)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    return WINCALL(134,USER);
}

LONG GetWindowLong (HWND par1, short par2)
{
    STACKWORDS(1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(135,USER);
}

LONG SetWindowLong (HWND par1, short par2, LONG par3)
{
    STACKWORDS(1+1+2);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_LONG(par3);
    return WINCALL(136,USER);
}

BOOL OpenClipboard (HWND par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL(137,USER);
}

BOOL CloseClipboard (void)
{
    NOSTACK;

    return WINCALL(138,USER);
}

BOOL EmptyClipboard (void)
{
    NOSTACK;

    return WINCALL(139,USER);
}

HWND GetClipboardOwner (void)
{
    NOSTACK;

    return WINCALL(140,USER);
}

HANDLE SetClipboardData (UINT par1, HANDLE par2)
{
    STACKWORDS(1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(141,USER);
}

HANDLE GetClipboardData (UINT par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL(142,USER);
}

short CountClipboardFormats (void)
{
    NOSTACK;

    return WINCALL(143,USER);
}

UINT EnumClipboardFormats (UINT par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL(144,USER);
}

UINT RegisterClipboardFormat (LPCSTR par1)
{
    STACKWORDS(2);

    PUSH_LPSTR(par1);
    return WINCALL(145,USER);
}

short GetClipboardFormatName (UINT par1, LPSTR par2, short par3)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    PUSH_WORD(par3);
    return WINCALL(146,USER);
}

HWND SetClipboardViewer (HWND par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL(147,USER);
}

HWND GetClipboardViewer (void)
{
    NOSTACK;

    return WINCALL(148,USER);
}

BOOL ChangeClipboardChain (HWND par1, HWND par2)
{
    STACKWORDS(1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(149,USER);
}

HMENU LoadMenu(HINSTANCE hInstance, LPCSTR name)
{
    STACKWORDS(1+2);

    PUSH_WORD(hInstance);
/*  if ((ULONG)name <= INT_RESOURCE)
	PUSH_LONG((ULONG)name);
    else */
	PUSH_LPSTR(name);
    return WINCALL(150,USER);
}

HMENU CreateMenu(void)
{
    NOSTACK;
    return WINCALL(151,USER);
}

BOOL DestroyMenu(HWND hWnd)
{
    STACKWORDS(1);

    PUSH_WORD(hWnd);
    return WINCALL(152,USER);
}

BOOL CheckMenuItem(HMENU hMenu, UINT menuitem, UINT check)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(hMenu);
    PUSH_WORD(menuitem);
    PUSH_WORD(check);
    return WINCALL(154,USER);
}

BOOL EnableMenuItem(HMENU hmenu, UINT id, UINT att)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(hmenu);
    PUSH_WORD(id);
    PUSH_WORD(att);
    return WINCALL(155,USER);
}

HMENU GetMenu(HWND hWnd)
{
    STACKWORDS(1);

    PUSH_WORD(hWnd);
    return WINCALL(157,USER);
}

BOOL SetMenu(HWND hWnd, HMENU hmenu)
{
    STACKWORDS(1+1);

    PUSH_WORD(hWnd);
    PUSH_WORD(hmenu);
    return WINCALL(158,USER);
}

void DrawMenuBar(HWND hWnd)
{
    STACKWORDS(1);

    PUSH_WORD(hWnd);
    WINCALL(160,USER);
}

void CreateCaret (HWND par1, HBITMAP par2, short par3, short par4)
{
    STACKWORDS(1+1+1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    PUSH_WORD(par4);
    WINCALL(163,USER);
}

void DestroyCaret(void)
{
    NOSTACK;

    WINCALL(164,USER);
}

void SetCaretPos (short par1, short par2)
{
    STACKWORDS(1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    WINCALL(165,USER);
}

void HideCaret (HWND par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    WINCALL(166,USER);
}

void ShowCaret (HWND par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    WINCALL(167,USER);
}

void SetCaretBlinkTime (UINT par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    WINCALL(168,USER);
}

UINT GetCaretBlinkTime(void)
{
    NOSTACK;

    return WINCALL(169,USER);
}

void GetCaretPos (POINT FAR* par1)
{
    STACKWORDS(2);

    PUSH_LPSTR(par1);
    WINCALL(183,USER);
}

HCURSOR LoadCursor(HINSTANCE hInst, LPCSTR name)
{
    STACKWORDS(1+2);

    PUSH_WORD(hInst);
/*  if ((ULONG)name <= INT_RESOURCE)
	PUSH_LONG((ULONG)name);
    else */
	PUSH_LPSTR(name);
    return WINCALL(173,USER);
}

HICON LoadIcon(HINSTANCE hInst, LPCSTR name)
{
    STACKWORDS(1+2);

    PUSH_WORD(hInst);
/*  if ((ULONG)name <= INT_RESOURCE)
	PUSH_LONG((ULONG)name);
    else */
	PUSH_LPSTR(name);
    return WINCALL(174,USER);
}

short GetSystemMetrics (short par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL(179,USER);
}

BOOL InSendMessage(void)
{
    NOSTACK;

    return WINCALL(192,USER);
}

BOOL IsClipboardFormatAvailable (UINT par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL(193,USER);
}

short DialogBoxParam(HINSTANCE hInst, LPCSTR name, HWND hWnd, DLGPROC thunk, LPARAM lParam)
{
    STACKWORDS(1+2+1+2+2);

    SV_CALL(M_LOAD_WNDFNCT, (ULONG)thunk);

    PUSH_WORD(hInst);
    if ((ULONG)name <= INT_RESOURCE)
	PUSH_LONG((ULONG)name);
    else
	PUSH_LPSTR(name);
    PUSH_WORD(hWnd);
    PUSH_LONG(_rsxw32_callback);
    PUSH_LONG(lParam);
    return WINCALL(239,USER);
}

HWND CreateDialogParam(HINSTANCE hInst, LPCSTR name, HWND hParent, DLGPROC lpDlgProc, LPARAM lParam)
{
    STACKWORDS(1+2+1+2+2);

    SV_CALL(M_LOAD_WNDFNCT, (ULONG)lpDlgProc);

    PUSH_WORD(hInst);
    if ((ULONG)name <= INT_RESOURCE)
	PUSH_LONG((ULONG)name);
    else
	PUSH_LPSTR(name);
    PUSH_WORD(hParent);
    PUSH_LONG(_rsxw32_callback);
    PUSH_LONG(lParam);
    return WINCALL(241,USER);
}

HWND GetOpenClipboardWindow (void)
{
    NOSTACK;

    return WINCALL(248,USER);
}

HWND GetDesktopWindow (void)
{
    NOSTACK;
    return WINCALL(286,USER);
}

short GetPriorityClipboardFormat (UINT FAR * par1, short par2)
{
    STACKWORDS(2+1);

    PUSH_LPSTR(par1);
    PUSH_WORD(par2);
    return WINCALL(402,USER);
}

BOOL AppendMenu(HMENU hmenu, UINT mf, UINT id, LPCSTR title)
{
    STACKWORDS(1+1+1+2);

    PUSH_WORD(hmenu);
    PUSH_WORD(mf);
    PUSH_WORD(id);
    PUSH_LPSTR(title);
    return WINCALL(411,USER);
}

HMENU CreatePopupMenu(void)
{
    NOSTACK;

    return WINCALL(415,USER);
}

LPSTR AnsiUpper (LPSTR string)
{
    STACKWORDS(2);
    ULONG ret;

    if ((ULONG) string <= INT_RESOURCE)
	PUSH_LONG((ULONG)string);
    else
	PUSH_LPSTR(string);

    ret = (ULONG) WINCALL(431,USER);

    if ((ULONG)string <= INT_RESOURCE)
	return (LPSTR) ret;
    else
	return string;
}

LPSTR AnsiNext(LPSTR charpos)
{
    STACKWORDS(2);

    PUSH_LPSTR(charpos);

    return _rsx_16to32( WINCALL(472,USER) );
}

LPSTR AnsiPrev(LPCSTR begin,LPCSTR charpos)
{
    STACKWORDS(2+2);

    PUSH_LPSTR(begin);
    PUSH_LPSTR(charpos);

    return _rsx_16to32( WINCALL(473,USER) );
}

/* --------not tested ------------*/
/* --------not tested ------------*/
/* --------not tested ------------*/
/* --------not tested ------------*/

LRESULT DefFrameProc (HWND par1, HWND par2, UINT par3, UINT par4, LPARAM par5)
{
    STACKWORDS(1+1+1+1+2);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    PUSH_WORD(par4);
    PUSH_LONG(par5);
    return WINCALL(445,USER);
}
LRESULT DefMDIChildProc (HWND par1, UINT par2, UINT par3, LPARAM par4)
{
    STACKWORDS(1+1+1+2);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    PUSH_LONG(par4);
    return WINCALL(447,USER);
}
short FillRect (HDC par1, const RECT FAR *par2, HBRUSH par3)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    PUSH_WORD(par3);
    return WINCALL( 81,USER);
}
short FrameRect (HDC par1, const RECT FAR *par2, HBRUSH par3)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    PUSH_WORD(par3);
    return WINCALL( 83,USER);
}
UINT GetDlgItemInt (HWND par1, short par2, BOOL FAR *par3, BOOL par4)
{
    STACKWORDS(1+1+2+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_LPSTR(par3);
    PUSH_WORD(par4);
    return WINCALL( 95,USER);
}
HWND GetParent (HWND par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL( 46,USER);
}
HMENU GetSubMenu (HMENU par1, short par2)
{
    STACKWORDS(1+1);
    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(159,USER);
}
DWORD GetSysColor (short par1)
{
    STACKWORDS(1);
    PUSH_WORD(par1);
    return WINCALL(180,USER);
}
HMENU GetSystemMenu (HWND par1, BOOL par2)
{
    STACKWORDS(1+1);
    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(156,USER);
}
HWND GetWindow (HWND par1, WORD par2)
{
    STACKWORDS(1+1);
    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(262,USER);
}
void GetWindowRect (HWND par1, RECT FAR *par2)
{
    STACKWORDS(1+2);
    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    WINCALL( 32,USER);
}
void InflateRect (RECT FAR *par1, short par2, short par3)
{
    STACKWORDS(2+1+1);

    PUSH_LPSTR(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    WINCALL( 78,USER);
}
BOOL IntersectRect(RECT FAR *par1, const RECT FAR *par2, const RECT FAR *par3)
{
    STACKWORDS(2+2+2);

    PUSH_LPSTR(par1);
    PUSH_LPSTR(par2);
    PUSH_LPSTR(par3);
    return WINCALL( 79,USER);
}
BOOL IsDialogMessage (HWND par1, MSG FAR *par2)
{
    STACKWORDS(1+2);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    return WINCALL( 90,USER);
}
UINT IsDlgButtonChecked (HWND par1, short par2)
{
    STACKWORDS(1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL( 98,USER);
}
HACCEL LoadAccelerators (HINSTANCE par1, LPCSTR par2)
{
    STACKWORDS(1+2);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    return WINCALL(177,USER);
}
short LoadString (HINSTANCE par1, UINT par2, LPSTR par3, short par4)
{
    STACKWORDS(1+1+2+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_LPSTR(par3);
    PUSH_WORD(par4);
    return WINCALL(176,USER);
}
void SetDlgItemInt (HWND par1, short par2, UINT par3, BOOL par4)
{
    STACKWORDS(1+1+1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    PUSH_WORD(par4);
    WINCALL( 94,USER);
}
HWND SetFocus (HWND par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL( 22,USER);
}

BOOL SetWindowPos (HWND par1, HWND par2, short par3, short par4, short par5, short par6, UINT par7)
{
    STACKWORDS(1+1+1+1+1+1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    PUSH_WORD(par4);
    PUSH_WORD(par5);
    PUSH_WORD(par6);
    PUSH_WORD(par7);
    return WINCALL(232,USER);
}
short TranslateAccelerator (HWND par1, HACCEL par2, MSG FAR *par3)
{
    STACKWORDS(1+1+2);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_LPSTR(par3);
    return WINCALL(178,USER);
}
BOOL TranslateMDISysAccel (HWND par1, MSG FAR *par2)
{
    STACKWORDS(1+2);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    return WINCALL(451,USER);
}
