/* tell.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <sys/doscalls.h>
#include <stdio.h>
#include <io.h>
#include <errno.h>
#include "djio.h"

long tell (int handle)
{
  long n;

  if (handle < 0 || handle >= _nfiles)
    {
      errno = EBADF;
      return (-1L);
    }
  n = dos_lseek (handle, 0L, SEEK_CUR);
  if (n == -1)
    return (n);
  if (_lookahead[handle] >= 0)
    --n;
  return (n);
}
