/*
 * SOURCE:  applic.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef APPLIC_H
#define APPLIC_H

    // page options
#define PAGE_ODD  (1L<<0)
#define PAGE_EVEN (1L<<1)
#define PAGE_ALL  (1L<<2)
#define PAGE_BACK (1L<<3)
#define PAGE_PREVIEW (1L<<4)    // use page options for preview

    // print flags
#define PRINT_XONXOFF   (1L<<0)
#define PRINT_HIGHQUAL  (1L<<1)
#define PRINT_DESCJET   (1L<<2)
#define PRINT_INITPRINT (1L<<3)
#define PRINT_JOBOFFSET (1L<<4)
#define PRINT_KYOCERA   (1L<<5)
#define PRINT_MANUAL    (1L<<6) /* Manual Feed */

    // preview flags
#define PREVIEW_WHITEONBLACK (1L<<0)
#define PREVIEW_RULER        (1L<<1)
#define PREVIEW_NOSTATUS     (1L<<2)

    // tex flags
#define TEX_CLEAR7      (1L<<0)
#define TEX_8BITIN      (1L<<1)
#define TEX_8BITOUT     (1L<<2)
#define TEX_BATCHMODE   (1L<<3)
#define TEX_NOEMS       (1L<<4)
#define TEX_ERRSTOPMODE (1L<<5)
#define TEX_INITEX      (1L<<6)
#define TEX_NONSTOPMODE (1L<<7)
#define TEX_CTRLCHARS   (1L<<8)
#define TEX_SCROLLMODE  (1L<<9)
#define TEX_PLAIN       (1L<<10)
#define TEX_GERMAN      (1L<<11)

    // flag for viewerrors()
#define VIEW_NEXT 1     // get next error message
#define VIEW_TEXT 2     // display info about error
#define VIEW_CLEAR 3    // clear file buffer

    // custom menu flags
#define CM_CHECKDIR 0x00000001L // check cd against project directroy
#define CM_RETURN   0x00000002L // request on return
#define CM_SECTION  0x00000004L // menu section

    // flags for putdriveropts()
#define PDO_PRINT    1
#define PDO_PREVIEW  2
#define PDO_OTHER    3

void exe_tex( void );
void opt_tex( void );
void opt_driver( void );
void opt_pages( void );
void exe_preview( void );
void opt_preview( void );
void exe_print( void );
void opt_print( void );
void exe_pscript( void );
void opt_pscript( void );

char *getpd( char *, int );
int chkdir( BOOL );

void dos_command( void );
int strlow( char *cp ); // converts a string to lower case, returns length
                        // of string
int strupper( char *cp );

void customizemenu( void );
void swapmem( char *, char *, int );
int putdriveropts( int, int );

void exe_custom( int );

#endif
