/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/cmd.c"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#define __CMD_C__

#include "common.h"

#include "global.h"
#include "fn.h"
#include "cmd.h"
#include "main.h"
#include "msg.h"
#include "str.h"
#include "debug.h"


PSZ szMaskd = NULL;
PSZ szMaskp = NULL;
PSZ szMaskb = NULL;
PSZ szMaske = NULL;
PSZ szMaskf = NULL;

void CMD_make_masks(void)
{
char delim[2] = "/";
    
  if (*szCNFdrive) STR_copy_string(&szMaskd, szCNFdrive);
  else FN_GetDrv(&szMaskd, szCLFileName);
  if (*szCNFpath) STR_copy_string(&szMaskp, szCNFpath);
  else FN_GetPath2(&szMaskp, szCLFileName);
  if (*szCNFname) STR_copy_string(&szMaskb, szCNFname);
  else FN_GetBase(&szMaskb, szCLFileName);
  if (*szCNFext) STR_copy_string(&szMaske, szCNFext);
  else FN_GetExt(&szMaske, szCLFileName);

  delim[0]=(!(*szCNFdelim))?DEF_OS_PATHDELIM:(*szCNFdelim);

  FN_SetPathDelim(szMaskp, (!(*szCNFdelim))?DEF_OS_PATHDELIM:(*szCNFdelim) );
  STR_copy_string(&szMaskf,szMaskd);
  STR_concat_string(&szMaskf,szMaskp);
  STR_concat_string(&szMaskf,delim);
  STR_concat_string(&szMaskf,szMaskb);
  STR_concat_string(&szMaskf,szMaske);
  DBG2("CMD_make_masks : szMaskd = >%s<\n", szMaskd );
  DBG2("               : szMaskp = >%s<\n", szMaskp );
  DBG2("               : szMaskb = >%s<\n", szMaskb );
  DBG2("               : szMaske = >%s<\n", szMaske );
  DBG2("               : szMaskf = >%s<\n", szMaskf );
}

void CMD_delete_masks(void)
{
  STR_delete_string(&szMaskd);
  STR_delete_string(&szMaskp);
  STR_delete_string(&szMaskb);
  STR_delete_string(&szMaske);
  STR_delete_string(&szMaskf);
}

/*----------------------------------------------------------------------------
  int CMD_expand_filemask(char **p)

  given: address of pointer to mask in cnf_cmd

  expand a (filemode) mask in cmd-line. addes the expansion to cmdline.
  moves to pointer into cnf_cmd behind the mask-string.
*/

int CMD_expand_filemask(char **p)
{
PSZ szTmp = NULL;
int retcode = 1;
int addtmp  = 0;

  switch (**p)
    { /* single chars */
      case '%'  : (*p)++; STR_concat_string(&szCmdLine, "%");        break;
      case '\'' : (*p)++; STR_concat_string(&szCmdLine, "'");        break;
      case '"'  : (*p)++; STR_concat_string(&szCmdLine, "\"");       break;
      case '`'  : (*p)++; STR_concat_string(&szCmdLine, "`");        break;
      /* original file */
      case 'F'  : (*p)++; STR_concat_string(&szCmdLine, szCLFileName);   break;
      case 'D'  : (*p)++; FN_GetDrv(&szTmp,   szCLFileName);  addtmp = 1; break;
      case 'P'  : (*p)++; FN_GetPath2(&szTmp, szCLFileName);  addtmp = 1; break;
      case 'B'  : (*p)++; FN_GetBase(&szTmp,  szCLFileName);  addtmp = 1; break;
      case 'E'  : (*p)++; FN_GetExt(&szTmp,   szCLFileName);  addtmp = 1; break;
      /* new file */
      case 'f'  : (*p)++; STR_concat_string(&szCmdLine, szMaskf);  break;
      case 'd'  : (*p)++; STR_concat_string(&szCmdLine, szMaskd);  break;
      case 'p'  : (*p)++; STR_concat_string(&szCmdLine, szMaskp);  break;
      case 'b'  : (*p)++; STR_concat_string(&szCmdLine, szMaskb);  break;
      case 'e'  : (*p)++; STR_concat_string(&szCmdLine, szMaske);  break;
      default   : retcode = 0;
    }
  if (addtmp) STR_concat_string(&szCmdLine, szTmp);
  STR_delete_string(&szTmp);
  return retcode;
}

/*----------------------------------------------------------------------------
  int CMD_expand_keymask(char **p)

  given: address of pointer to mask in cnf_cmd

  expand a (keywordmode) mask in cmd-line. addes the expansion to cmdline.
  moves to pointer into cnf_cmd behind the mask-string.

*/

int CMD_expand_keymask(char **p)
{
PSZ szTmp = NULL;
int retcode = 1;

  switch (**p)
    { /* single chars */
      case '%'  : (*p)++; STR_concat_string(&szCmdLine, "%");        break;
      case '\'' : (*p)++; STR_concat_string(&szCmdLine, "'");        break;
      case '"'  : (*p)++; STR_concat_string(&szCmdLine, "\"");       break;
      case '`'  : (*p)++; STR_concat_string(&szCmdLine, "`");        break;
      /* original keyword */
      case 'K'  : (*p)++; STR_concat_string(&szCmdLine, szCLKeyWord); break;
      /* keyword with leading backslash stripped (if any) */
      case 'k'  : (*p)++; szTmp = szCLKeyWord;
                          if (*szTmp=='\\') szTmp++;
                          STR_concat_string(&szCmdLine, szTmp);       break;
      default   : retcode = 0;
    }
  return retcode;
}


/*-----------------------------------------------------------------------------
  int CMD_make_cmd(void)
  build commandline to execute from given cmd-string in cnf-file.
  expands masks
*/

int CMD_make_cmd(void)
{
PCH p0;
PCH p1;
int gotmask;

  /* check for command */

  if (!szCNFcmd)     { MSG_msg_n(MSG_NOCMD); return 0; }
  if (!(*szCNFcmd))  { MSG_msg_n(MSG_NOCMD); return 0; }

  STR_copy_string(&szCmdLine,"");
  if (!OPT_mode_keyword) CMD_make_masks();
  
  for (p0=p1=szCNFcmd; *p0; )
    {
                                                        /* any more masks ? */
      p1 = strchr(p0, '%');
      if (!p1)
        {
          STR_concat_string(&szCmdLine, p0);     /* no, copy remaining line */
          break;                                 /* and exit                */
        }
      else
        {
          *p1 = 0;
          STR_concat_string(&szCmdLine, p0);      /* copy up to mask char */
          p1++;
          if (!OPT_mode_keyword)
            gotmask = CMD_expand_filemask(&p1);
          else
            gotmask = CMD_expand_keymask(&p1);
          if (!gotmask)
            {
              MSG_msg_n(MSG_INVMASK);
              STR_delete_string(&szCmdLine);
              if (!OPT_mode_keyword) CMD_delete_masks();
              return 0;
            } 
                                     /* (p1 changed by expand_mask) */
          p0 = p1;                   /* point to next char behind mask */
        }
    }
  if (!OPT_mode_keyword) CMD_delete_masks();
  return 1;  
}

/*----------------------------------------------------------------------------
  int CMD_invoke_cmd(void)
  execute commandline
*/ 

int CMD_invoke_cmd(void)
{
int retcode  = 0;

  if (!OPT_mode_keyword)
    if (strcmp(szStartUpDir, szCLFileDir))
      {
        MSG_msg_n(MSG_ENTERDIR);
        MSG_msg(szCLFileDir);
        MSG_msg_n(MSG_RBRACE);
        FN_SetAbsWD(szCLFileDir);
      }

  MSG_msg_n(MSG_CALLSYS);
  MSG_msg(szCmdLine);
  MSG_msg_n(MSG_RBRACE);
  retcode = system(szCmdLine);

  if (!OPT_mode_keyword)
    if (strcmp(szStartUpDir, szCLFileDir))
      {
        MSG_msg_n(MSG_REENTDIR);
        MSG_msg(szStartUpDir);
        MSG_msg_n(MSG_RBRACE);
        FN_SetAbsWD(szStartUpDir);
      }
        
  return retcode;
}


/*------------------------------------------------------------------------- */
