/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import java.io.Serializable;
import java.util.Vector;
import nts.noad.Noad;
import nts.noad.NoadEnum;
import nts.noad.NoadList;
import nts.noad.NodeNoad;
import nts.node.Node;
import nts.node.NodeEnum;

public class NoadList
implements Serializable {
    public static final NoadList NULL;
    public static final NoadList EMPTY;
    public static final NoadEnum EMPTY_ENUM;
    protected Vector data;

    public final int length() {
        return this.data.size();
    }

    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    protected void clear() {
        this.data.clear();
    }

    public final Noad noadAt(int idx) {
        return (Noad)this.data.elementAt(idx);
    }

    public NoadList append(Noad noad) {
        this.data.addElement(noad);
        return this;
    }

    public NoadList append(Noad[] noads, int offset, int count) {
        this.data.ensureCapacity(this.data.size() + count);
        while (count-- > 0) {
            this.append(noads[offset++]);
        }
        return this;
    }

    public NoadList append(Noad[] noads) {
        return this.append(noads, 0, noads.length);
    }

    public NoadList append(NoadEnum noads) {
        while (noads.hasMoreNoads()) {
            this.append(noads.nextNoad());
        }
        return this;
    }

    public NoadList append(NoadList list) {
        return this.append(list.noads());
    }

    public Noad lastNoad() {
        return this.length() > 0 ? this.noadAt(this.length() - 1) : null;
    }

    public void removeLastNoad() {
        if (this.length() > 0) {
            this.data.removeElementAt(this.length() - 1);
        }
    }

    public void replaceLastNoad(Noad noad) {
        if (this.length() > 0) {
            this.data.set(this.length() - 1, noad);
        }
    }

    public Noad[] toArray() {
        Noad[] noads = new Noad[this.data.size()];
        return this.data.toArray(noads);
    }

    public NoadEnum noads() {
        NoadList noadList = this;
        if (noadList == null) {
            throw null;
        }
        return noadList.new Enum(0, this.length());
    }

    public NoadEnum noads(int start) {
        NoadList noadList = this;
        if (noadList == null) {
            throw null;
        }
        return noadList.new Enum(start, this.length());
    }

    public NoadEnum noads(int start, int end) {
        NoadList noadList = this;
        if (noadList == null) {
            throw null;
        }
        return noadList.new Enum(start, end);
    }

    public static NoadEnum noads(Noad noad) {
        return new NoadEnum(noad){
            private boolean fresh;
            private final /* synthetic */ Noad val$noad;

            public Noad nextNoad() {
                this.fresh = false;
                return this.val$noad;
            }

            public boolean hasMoreNoads() {
                return this.fresh;
            }
            {
                this.val$noad = val$noad;
                this.fresh = true;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        NoadEnum noads = this.noads();
        while (noads.hasMoreNoads()) {
            buf.append(noads.nextNoad()).append(", ");
        }
        return buf.toString();
    }

    public NoadList append(Node node) {
        this.append(new NodeNoad(node));
        return this;
    }

    public NoadList append(NodeEnum nodes) {
        while (nodes.hasMoreNodes()) {
            this.append(nodes.nextNode());
        }
        return this;
    }

    public Node lastNode() {
        Noad last = this.lastNoad();
        return last != null && last.isNode() ? last.getNode() : null;
    }

    public void removeLastNode() {
        Noad last = this.lastNoad();
        if (last != null && last.isNode()) {
            this.removeLastNoad();
        }
    }

    public Node lastSpecialNode() {
        return this.lastNode();
    }

    protected NoadList(Vector data) {
        this.data = data;
    }

    public NoadList() {
        this.data = new Vector();
    }

    public NoadList(int initCap) {
        this.data = new Vector(initCap);
    }

    public NoadList(int initCap, int capIncrement) {
        this.data = new Vector(initCap, capIncrement);
    }

    public NoadList(Noad noad) {
        this(1);
        this.append(noad);
    }

    public NoadList(NoadEnum noads) {
        this();
        this.append(noads);
    }

    public NoadList(Noad[] noads) {
        this(noads.length);
        this.append(noads);
    }

    public NoadList(Noad[] noads, int offset, int count) {
        this(count);
        this.append(noads, offset, count);
    }

    static {
        EMPTY = new NoadList();
        EMPTY_ENUM = new 1();
    }

    private class Enum
    extends NoadEnum {
        private int idx;
        private final int end;

        public Noad nextNoad() {
            return NoadList.this.noadAt(this.idx++);
        }

        public boolean hasMoreNoads() {
            return this.idx < this.end;
        }

        public Enum(int idx, int end) {
            this.idx = idx;
            this.end = end;
        }
    }
}

