/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.io.Serializable;
import nts.base.Dimen;
import nts.base.Glue;
import nts.io.CntxLog;
import nts.io.Log;
import nts.node.Leaders;
import nts.node.Node;
import nts.node.SettingContext;
import nts.node.TypeSetter;

public abstract class BoxLeaders
implements Leaders {
    public static final Mover NULL_MOVER;
    private static final Dimen compensation;
    protected final Node node;
    protected final Mover mover;

    public Dimen getHeight() {
        return this.node.getHeight();
    }

    public Dimen getWidth() {
        return this.node.getWidth();
    }

    public Dimen getDepth() {
        return this.node.getDepth();
    }

    public Dimen getLeftX() {
        return this.node.getLeftX();
    }

    public void addOn(Log log, CntxLog cntx, Glue skip) {
        log.addEsc(this.getDesc()).add(' ').add(skip.toString());
        cntx.addOn(log, this.node);
    }

    public void typeSet(TypeSetter setter, Dimen size, SettingContext sctx) {
        Dimen nodeSize;
        if (size.moreThan(0) && (nodeSize = this.mover.size(this.node)).moreThan(0)) {
            this.typeSet(setter, sctx.allowingIO(false), size.plus(compensation), nodeSize);
        }
    }

    protected void typeSet(TypeSetter setter, SettingContext sctx, int count, Dimen start, Dimen gap) {
        this.mover.move(setter, start);
        while (count-- > 0) {
            this.mover.movePrev(setter, this.node);
            this.node.typeSet(setter, sctx);
            this.mover.movePast(setter, this.node);
            this.mover.move(setter, gap);
        }
    }

    protected abstract void typeSet(TypeSetter var1, SettingContext var2, Dimen var3, Dimen var4);

    protected abstract String getDesc();

    public BoxLeaders(Node node, Mover mover) {
        this.node = node;
        this.mover = mover;
    }

    static {
        compensation = Dimen.valueOf(10, 65536);
    }

    public static interface Mover
    extends Serializable {
        public Dimen offset(TypeSetter.Mark var1);

        public Dimen size(Node var1);

        public void move(TypeSetter var1, Dimen var2);

        public void movePrev(TypeSetter var1, Node var2);

        public void movePast(TypeSetter var1, Node var2);
    }
}

