/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.io.Serializable;
import java.util.Vector;
import nts.io.Log;
import nts.node.FontMetric;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;

public class NodeList
implements Serializable {
    public static final NodeList NULL;
    public static final NodeList EMPTY;
    public static final NodeEnum EMPTY_ENUM;
    protected Vector data;

    public final int length() {
        return this.data.size();
    }

    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    protected void clear() {
        this.data.clear();
    }

    public final Node nodeAt(int idx) {
        return (Node)this.data.elementAt(idx);
    }

    public NodeList append(Node node) {
        this.data.addElement(node);
        return this;
    }

    public NodeList append(Node[] nodes, int offset, int count) {
        this.data.ensureCapacity(this.data.size() + count);
        while (count-- > 0) {
            this.append(nodes[offset++]);
        }
        return this;
    }

    public NodeList append(Node[] nodes) {
        return this.append(nodes, 0, nodes.length);
    }

    public NodeList append(NodeEnum nodes) {
        while (nodes.hasMoreNodes()) {
            this.append(nodes.nextNode());
        }
        return this;
    }

    public NodeList append(NodeList list) {
        return this.append(list.nodes());
    }

    public Node lastNode() {
        return this.length() > 0 ? this.nodeAt(this.length() - 1) : null;
    }

    public void removeLastNode() {
        if (this.length() > 0) {
            this.data.removeElementAt(this.length() - 1);
        }
    }

    public Node lastSpecialNode() {
        return this.lastNode();
    }

    public Node[] toArray() {
        Node[] nodes = new Node[this.data.size()];
        return this.data.toArray(nodes);
    }

    public NodeEnum nodes() {
        NodeList nodeList = this;
        if (nodeList == null) {
            throw null;
        }
        return nodeList.new Enum(0, this.length());
    }

    public NodeEnum nodes(int start) {
        NodeList nodeList = this;
        if (nodeList == null) {
            throw null;
        }
        return nodeList.new Enum(start, this.length());
    }

    public NodeEnum nodes(int start, int end) {
        NodeList nodeList = this;
        if (nodeList == null) {
            throw null;
        }
        return nodeList.new Enum(start, end);
    }

    public static NodeEnum nodes(Node node) {
        return new NodeEnum(node){
            private boolean fresh;
            private final /* synthetic */ Node val$node;

            public Node nextNode() {
                this.fresh = false;
                return this.val$node;
            }

            public boolean hasMoreNodes() {
                return this.fresh;
            }
            {
                this.val$node = val$node;
                this.fresh = true;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public NodeList extractedMigrations() {
        int cnt = 0;
        int i = 0;
        while (i < this.length()) {
            if (!this.nodeAt(i++).isMigrating()) continue;
            ++cnt;
        }
        if (cnt > 0) {
            NodeList list = new NodeList();
            i = 0;
            while (i < this.length()) {
                Node node = this.nodeAt(i);
                if (node.isMigrating()) {
                    list.append(node.getMigration());
                    this.data.remove(i);
                    continue;
                }
                ++i;
            }
            return list;
        }
        return EMPTY;
    }

    public FontMetric addShortlyOn(Log log, FontMetric metric) {
        NodeEnum nodes = this.nodes();
        while (nodes.hasMoreNodes()) {
            metric = nodes.nextNode().addShortlyOn(log, metric);
        }
        return metric;
    }

    public FontMetric addShortlyOn(Log log) {
        return this.addShortlyOn(log, null);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        NodeEnum nodes = this.nodes();
        if (nodes.hasMoreNodes()) {
            buf.append(nodes.nextNode());
            while (nodes.hasMoreNodes()) {
                buf.append(", ").append(nodes.nextNode());
            }
        }
        return buf.toString();
    }

    protected NodeList(Vector data) {
        this.data = data;
    }

    public NodeList() {
        this.data = new Vector();
    }

    public NodeList(int initCap) {
        this.data = new Vector(initCap);
    }

    public NodeList(int initCap, int capIncrement) {
        this.data = new Vector(initCap, capIncrement);
    }

    public NodeList(Node node) {
        this(1);
        this.append(node);
    }

    public NodeList(NodeEnum nodes) {
        this();
        this.append(nodes);
    }

    public NodeList(Node[] nodes) {
        this(nodes.length);
        this.append(nodes);
    }

    public NodeList(Node[] nodes, int offset, int count) {
        this(count);
        this.append(nodes, offset, count);
    }

    static {
        EMPTY = new NodeList();
        EMPTY_ENUM = new 1();
    }

    private class Enum
    extends NodeEnum {
        private int idx;
        private final int end;

        public Node nextNode() {
            return NodeList.this.nodeAt(this.idx++);
        }

        public boolean hasMoreNodes() {
            return this.idx < this.end;
        }

        public Enum(int idx, int end) {
            this.idx = idx;
            this.end = end;
        }
    }
}

