/* REXX */
/*
   File makevlatex.cmd  2003-10-09  (WaS)
   Creating the eLaTeX2e format file for VTeX/2 8.31+
*/
call setlocal

/* Load REXXUTIL */
ret = RxFuncAdd("SysLoadFuncs", "REXXUTIL", "SysLoadFuncs")
call SysLoadFuncs

/* determine full path of VTeX program */
vtexprog = SysSearchPath("PATH", "vtex.exe")

if vtexprog = "" then
   /* stop here, if the VTeX program does not exist */
   say "I cannot find the VTeX program."
else do

   /* the formats directory: */
   fmtdir = filespec("D", vtexprog) || "\vtex\fmt"

   /* execute this script in the formats directory */
   call directory(fmtdir)

   /* delete possibly obsolete texsys.aux */
   call SysFileDelete("texsys.aux")   
   
   /* run IniTeX */
   "vtex -i -2 latex.fid"
   
end

exit

