<?php
lt_include(PLOG_CLASS_PATH.'class/action/admin/adminaction.class.php');
lt_include( PLOG_CLASS_PATH.'plugins/addcommentnotify/class/view/pluginaddcommentnotifyconfigview.class.php');

class PluginAddCommentNotifyUpdateConfigAction extends AdminAction
{
    var $_pluginEnabled;
    var $_notifyTrackback;
    var $_useMSNClass;
    var $_msnClassFile;
    var $_msnUser;
    var $_msnPassword;
    var $_msnbot_spool;
    var $_tolist;

    function PluginAddCommentNotifyUpdateConfigAction($actionInfo, $request)
    {
        $this->AdminAction($actionInfo, $request);
        return;
    }

    function validate()
    {
        $this->_pluginEnabled = $this->_request->getValue('pluginEnabled');
        $this->_pluginEnabled = ($this->_pluginEnabled != '');

        $this->_notifyTrackback = $this->_request->getValue('notifyTrackback');
        $this->_notifyTrackback = ($this->_notifyTrackback != '');

        $this->_useMSNClass = $this->_request->getValue('useMSNClass');
        $this->_useMSNClass = ($this->_useMSNClass != '');

        $this->_msnClassFile = trim($this->_request->getValue('msnClassFile'));
        $this->_msnUser = trim($this->_request->getValue('msnUser'));
        $this->_msnPassword = trim($this->_request->getValue('msnPassword'));
        $this->_msnbot_spool = rtrim(trim($this->_request->getValue('msnbotSpool')), '/');
        $this->_tolist = trim($this->_request->getValue('toList'));

        if (($this->_useMSNClass && ($this->_msnClassFile === '' || $this->_msnUser === '' || $this->_msnPassword === '')) ||
            (!$this->_useMSNClass && ($this->_msnbot_spool === '')) || 
            $this->_tolist === '') {
            $this->_view = new PluginAddCommentNotifyConfigView($this->_blogInfo);
            $this->_view->setErrorMessage($this->_locale->tr('error_required_missing'));
            $this->setCommonData();
            return false;
        }

        if ($this->_useMSNClass) {
            if (!is_file($this->_msnClassFile)) {
                $this->_view = new PluginAddCommentNotifyConfigView($this->_blogInfo);
                $this->_view->setErrorMessage($this->_locale->tr('error_addcommentnotify_msnclass_file'));
                $this->setCommonData();
                return false;
            }
            @list($name, $domain, $network) = @explode('@', $this->_msnUser);
            if ($domain == null || $network != null) {
                $this->_view = new PluginAddCommentNotifyConfigView($this->_blogInfo);
                $this->_view->setErrorMessage($this->_locale->tr('error_addcommentnotify_msn_user'));
                $this->setCommonData();
                return false;
            }
        }
        else {
            if (!is_dir($this->_msnbot_spool)) {
                $this->_view = new PluginAddCommentNotifyConfigView($this->_blogInfo);
                $this->_view->setErrorMessage($this->_locale->tr('error_addcommentnotify_msnbot_spool'));
                $this->setCommonData();
                return false;
            }
        }

        $to_list_error = false;
        $aList = @explode(',', $this->_tolist);
        if (count($aList) == 0)
            $to_list_error = true;
        else {
            foreach ($aList as $to) {
                @list($name, $domain, $network) = @explode('@', $to);
                if ($network != NULL && $network != 1 && $network != 32) {
                    $to_list_error = true;
                    break;
                }
                if ($domain == NULL) {
                    $to_list_error = true;
                    break;
                }
            }
        }

        if ($to_list_error) {
            $this->_view = new PluginAddCommentNotifyConfigView($this->_blogInfo);
            $this->_view->setErrorMessage($this->_locale->tr('error_addcommentnotify_tolist'));
            $this->setCommonData();
            return false;
        }
        return true;
    }

    function perform()
    {
        // Get the blog settings
        $blogSettings = $this->_blogInfo->getSettings();

        // Update the relevant values with the form inputs
        $blogSettings->setValue('plugin_addcommentnotify_enabled', $this->_pluginEnabled);
        $blogSettings->setValue('plugin_addcommentnotify_notifytrackback', $this->_notifyTrackback);
        $blogSettings->setValue('addcommentnotify_usemsnclass', $this->_useMSNClass);
        $blogSettings->setValue('addcommentnotify_msnclass_file', $this->_msnClassFile);
        $blogSettings->setValue('addcommentnotify_msn_user', $this->_msnUser);
        $blogSettings->setValue('addcommentnotify_msn_password', $this->_msnPassword);
        $blogSettings->setValue('addcommentnotify_msnbot_spool', $this->_msnbot_spool);
        $blogSettings->setValue('addcommentnotify_tolist', $this->_tolist);

        // Set and save the new blog settings
        $this->_blogInfo->setSettings($blogSettings);
        $blogs = new Blogs();

        // Display an error message if there was a problem with the update
        if( !$blogs->updateBlog($this->_blogInfo)) {
            $this->_view = new PluginAddCommentNotifyConfigView($this->_blogInfo);
            $this->_view->setErrorMessage($this->_locale->tr('error_updating_settings'));
            $this->setCommonData();
            return false;
        }

        // If things went well, save the session...
        $this->_blogInfo->setSettings($blogSettings);
        $this->_session->setValue('blogInfo', $this->_blogInfo);
        $this->saveSession();

        // and show the success message
        $this->_view = new PluginAddCommentNotifyConfigView($this->_blogInfo);
        $this->_view->setSuccessMessage($this->_locale->tr('gallery_settings_saved_ok'));
        $this->setCommonData();

        // clear the cache
        CacheControl::resetBlogCache($this->_blogInfo->getId());
        return true;
    }
}
?>
