<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/security/pipelinefilter.class.php" );

    
    $akismetError = false;

    // custom error code that will be returned to the pipeline whenever an
    // error is found... Be careful so as to not to have two different modules
    // use the same code!!
    define( "AKISMET_SPAM", 800 );

	class AkismetFilter extends PipelineFilter 
	{

    	function AkismetFilter( $pipelineRequest )
        {
        	$this->PipelineFilter( $pipelineRequest );
        }

        function filter()
        {
           global $akismetError;
           
           $akismetError = false;

        	// get some info
            $blogInfo = $this->_pipelineRequest->getBlogInfo();
            $request  = $this->_pipelineRequest->getHttpRequest();

        	// check if this section has been enabled or disabled
            $blogSettings = $blogInfo->getSettings();
		    $pluginEnabled = $blogSettings->getValue( "plugin_akismet_enabled" );
            if( !$pluginEnabled) {
            	// if not, nothing to do here...
                //_debug("ip address filter not enabled! quitting...<br/>");
            	return new PipelineResult();
            }

            // we only have to filter the contents if the user is posting a comment
            // so there's no point in doing anything else if that's not the case
            if(( $request->getValue( "op" ) != "AddComment" ) && ( $request->getValue( "op" ) != "AddTrackback" )) {
            	$result = new PipelineResult();
                return $result;
            }

            // if this is already rejected, there is no reason to do anything here
            if ( $this->_pipelineRequest->getRejectedState() )
                return new PipelineResult();
                
            // text and topic of the comment/trackback
            $isTrackback = ($request->getValue( "op" ) == "AddTrackback");
            if( $isTrackback ) {
                $commentText = $request->getValue( "excerpt" );
                $commentTopic = $request->getValue( "title" );
                $articleId = $request->getValue( "id" );
                // that's all we can get from a trackback...
                $userName = "";
                $userUrl = $request->getValue( "url" );
                $userEmail = "";
                $commentType = "trackback";
            }
            else {
                // or else let's assume that we're dealing with a comment
                $commentText = $request->getValue( "commentText" );
                $commentTopic = $request->getValue( "commentTopic" );
                $userName = $request->getValue( "userName" );
                $userEmail = $request->getValue( "userEmail" );
                $userUrl = $request->getValue( "userUrl" );
                $articleId = $request->getValue( "articleId" );
                $commentType = "comment";

            }
 
            $rg = $blogInfo->getBlogRequestGenerator();
 
            lt_include( PLOG_CLASS_PATH."plugins/akismet/class/security/Akismet.class.php" );
            
            $apiKey = $blogSettings->getValue( "plugin_akismet_api_key" );

            set_error_handler('_akismetFilterErrorHandler');

            $akismet = new Akismet($rg->blogLink(), $apiKey);
            
            
            if ( $akismetError == true ) {
            
                restore_error_handler();

                // Some error happened.  Don't block this message
                // Most likely this is becuase the api key is wrong.
                $result = new PipelineResult( true );
            
                return $result;
            }

            if ( $userName != "" )
                $akismet->setAuthor($userName);

            if ( $userEmail != "" )
                $akismet->setAuthorEmail($userEmail);
            $akismet->setAuthorURL($userUrl);
            $akismet->setContent($commentText);
            $akismet->setType($commentType);
 
            lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php");
 
            // articles object
            $articles = new Articles;
            $article = $articles->getArticle( $articleId );

            $akismet->setPermalink( $rg->postPermalink($article) );
 
            if($akismet->isSpam()) {
                restore_error_handler();

               $locale = $blogInfo->getLocale();
               $result = new PipelineResult( false, AKISMET_SPAM, $locale->tr("error_comment_spam_throw_away") );
               return $result;            
            }

            restore_error_handler();

            // if everything went fine, we can say so by returning
            // a positive PipelineResult object
            $result = new PipelineResult( true );
            
            return $result;
        }

    }
    
        /**
	 * This error handler temporarily overloads the LifeType one
	 * occurs.
	 */
	function _akismetFilterErrorHandler( $errorCode, $errorString )
	{
	   global $akismetError;
	   
	   $akismetError = true;
	}

?>
