<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

	class PluginAkismet extends PluginBase
	{
		var $pluginEnabled;
		
		function PluginAkismet( $source = "" )
		{
			$this->PluginBase( $source );

			$this->id      = "akismet";
			$this->desc    = "Akismet checks your comments against the Akismet web serivce to see if they look like spam or not.";
			$this->author  = "Paul Westbrook (Akismet php library provided by <a href=\"http://miphp.net/blog/view/php4_akismet_class\">Bret Kuhns</a>)";
			$this->locales = Array( "en_UK" );
            $this->version = "20070731";

			if( $source == "admin" )
				$this->initAdmin();
			else
				$this->init();
		}

        function init()
        {
            lt_include( PLOG_CLASS_PATH."plugins/akismet/class/security/akismetfilter.class.php" );
            //register the filter
            $this->registerFilter( "AkismetFilter" );
        }
        
		function initAdmin()
		{
            $this->init();

            $this->registerNotification( EVENT_PROCESS_BLOG_ADMIN_TEMPLATE_OUTPUT );
            
            $this->registerAdminAction( "akismetSubmitComment", "PluginAkismetSubmitCommentAction" );
           
            $this->registerAdminAction( "akismet", "PluginAkismetConfigAction" );
			$this->registerAdminAction( "updateAkismetConfig", "PluginAkismetUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageAntiSpamPlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageAntiSpamPlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageAntiSpamPlugins", "akismet", "?op=akismet", "" );            
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_akismet_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    
	    function process($event, $params){
                // only process our expected event
            if($event != EVENT_PROCESS_BLOG_ADMIN_TEMPLATE_OUTPUT)
                return;
                    
                // only process the editcomments and edittrackbacks template
            if($params["template"] == "editcomments")
                $action = "akismetSubmitComment";
            else
                return;

                // load the current contents of the template
            $content = $params["content"];
            $regexp = "/<div class=\"list_action_button\">.*?<\/div>/s";
            preg_match_all($regexp, $content, $matches, PREG_SET_ORDER);

                // now process each one of the matches and do the replacements
            foreach($matches as $match){
                if($action == "akismetSubmitComment"){
                        // fetch the comment id
                    $res = preg_match(
                        "/<a href=\"\?op=deleteComment&amp;commentId=([0-9]+)&amp;/i",
                        $match[0], $result);
                }
                

                if($res){
                        // regenerate the block, adding the new markup
                    $artId = $result[1];
                    $toAdd = "<a href='?op=$action&amp;commentId={$artId}'>".
                        "<img src='imgs/admin/icon_mail-16.png' " .
                        "alt='{\$locale->tr('edit')}' /></a></div>";
                    $newStr = str_replace( "</div>", $toAdd, $match[0] );
                        // and now replace the old block with the new one in the global $content variable
                    $content = str_replace( $match[0], $newStr, $content );
                }
                else{
                    print "couldn't find id";
                }
            }
            
            $params["content"] = $content;
        }
        
	    
	    function getPluginConfigurationKeys()
		{
			lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
			
			return( Array(
				Array( "name" => "plugin_akismet_enabled", "type" => "boolean" ),
				Array( "name" => "plugin_akismet_api_key", "validator" => new StringValidator(), "type" => "string", "allowEmpty" => true ),
			));
		}

	}
?>